/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.staff.service;

import jakarta.persistence.PersistenceException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.staff.domain.Staff;
import org.apache.fineract.organisation.staff.domain.StaffRepository;
import org.apache.fineract.organisation.staff.exception.StaffNotFoundException;
import org.apache.fineract.organisation.staff.serialization.StaffCommandFromApiJsonDeserializer;
import org.apache.fineract.organisation.staff.service.StaffWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class StaffWritePlatformServiceJpaRepositoryImpl
implements StaffWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffWritePlatformServiceJpaRepositoryImpl.class);
    private final StaffCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final StaffRepository staffRepository;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;

    @Transactional
    public CommandProcessingResult createStaff(JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            Long officeId = command.longValueOfParameterNamed("officeId");
            Office staffOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            Staff staff = Staff.fromJson((Office)staffOffice, (JsonCommand)command);
            this.staffRepository.saveAndFlush((Object)staff);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)staff.getId()).withOfficeId(officeId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleStaffDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleStaffDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateStaff(Long staffId, JsonCommand command) {
        try {
            this.fromApiJsonDeserializer.validateForUpdate(command.json(), staffId);
            Staff staffForUpdate = (Staff)this.staffRepository.findById((Object)staffId).orElseThrow(() -> new StaffNotFoundException(staffId));
            Map changesOnly = staffForUpdate.update(command);
            if (changesOnly.containsKey("officeId")) {
                Long officeId = (Long)changesOnly.get("officeId");
                Office newOffice = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
                staffForUpdate.changeOffice(newOffice);
            }
            if (!changesOnly.isEmpty()) {
                this.staffRepository.saveAndFlush((Object)staffForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(staffId).withOfficeId(staffForUpdate.officeId()).with(changesOnly).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleStaffDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleStaffDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    private void handleStaffDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("external_id")) {
            String externalId = command.stringValueOfParameterNamed("externalId");
            throw new PlatformDataIntegrityException("error.msg.staff.duplicate.externalId", "Staff with externalId `" + externalId + "` already exists", "externalId", new Object[]{externalId});
        }
        if (realCause.getMessage().contains("display_name")) {
            String lastname = command.stringValueOfParameterNamed("lastname");
            Object displayName = lastname;
            if (!StringUtils.isBlank((CharSequence)displayName)) {
                String firstname = command.stringValueOfParameterNamed("firstname");
                displayName = lastname + ", " + firstname;
            }
            throw new PlatformDataIntegrityException("error.msg.staff.duplicate.displayName", "A staff with the given display name '" + (String)displayName + "' already exists", "displayName", new Object[]{displayName});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.staff.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    @Generated
    public StaffWritePlatformServiceJpaRepositoryImpl(StaffCommandFromApiJsonDeserializer fromApiJsonDeserializer, StaffRepository staffRepository, OfficeRepositoryWrapper officeRepositoryWrapper) {
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.staffRepository = staffRepository;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
    }
}

