/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.account.data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;

public class AccountTransferDTO {
    private final LocalDate transactionDate;
    private final BigDecimal transactionAmount;
    private final PortfolioAccountType fromAccountType;
    private final PortfolioAccountType toAccountType;
    private final Long fromAccountId;
    private final Long toAccountId;
    private final String description;
    private final Locale locale;
    private final DateTimeFormatter fmt;
    private final PaymentDetail paymentDetail;
    private final Integer fromTransferType;
    private final Integer toTransferType;
    private final Long chargeId;
    private final Integer loanInstallmentNumber;
    private final Integer transferType;
    private final AccountTransferDetails accountTransferDetails;
    private final String noteText;
    private final ExternalId txnExternalId;
    private final Loan loan;
    private final Loan fromLoan;
    private final Loan toLoan;
    private final SavingsAccount toSavingsAccount;
    private final SavingsAccount fromSavingsAccount;
    private final Boolean isRegularTransaction;
    private final Boolean isExceptionForBalanceCheck;

    public AccountTransferDTO(LocalDate transactionDate, BigDecimal transactionAmount, PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType, Long fromAccountId, Long toAccountId, String description, Locale locale, DateTimeFormatter fmt, PaymentDetail paymentDetail, Integer fromTransferType, Integer toTransferType, Long chargeId, Integer loanInstallmentNumber, Integer transferType, AccountTransferDetails accountTransferDetails, String noteText, ExternalId txnExternalId, Loan loan, SavingsAccount toSavingsAccount, SavingsAccount fromSavingsAccount, Boolean isRegularTransaction, Boolean isExceptionForBalanceCheck) {
        this.transactionDate = transactionDate;
        this.transactionAmount = transactionAmount;
        this.fromAccountType = fromAccountType;
        this.toAccountType = toAccountType;
        this.fromAccountId = fromAccountId;
        this.toAccountId = toAccountId;
        this.description = description;
        this.locale = locale;
        this.fmt = fmt;
        this.paymentDetail = paymentDetail;
        this.fromTransferType = fromTransferType;
        this.toTransferType = toTransferType;
        this.chargeId = chargeId;
        this.loanInstallmentNumber = loanInstallmentNumber;
        this.transferType = transferType;
        this.accountTransferDetails = accountTransferDetails;
        this.noteText = noteText;
        this.txnExternalId = txnExternalId;
        this.loan = loan;
        this.fromLoan = null;
        this.toLoan = null;
        this.toSavingsAccount = toSavingsAccount;
        this.fromSavingsAccount = fromSavingsAccount;
        this.isRegularTransaction = isRegularTransaction;
        this.isExceptionForBalanceCheck = isExceptionForBalanceCheck;
    }

    public AccountTransferDTO(LocalDate transactionDate, BigDecimal transactionAmount, PortfolioAccountType fromAccountType, PortfolioAccountType toAccountType, Long fromAccountId, Long toAccountId, String description, Locale locale, DateTimeFormatter fmt, Integer fromTransferType, Integer toTransferType, ExternalId txnExternalId, Loan fromLoan, Loan toLoan) {
        this.transactionDate = transactionDate;
        this.transactionAmount = transactionAmount;
        this.fromAccountType = fromAccountType;
        this.toAccountType = toAccountType;
        this.fromAccountId = fromAccountId;
        this.toAccountId = toAccountId;
        this.description = description;
        this.locale = locale;
        this.fmt = fmt;
        this.paymentDetail = null;
        this.fromTransferType = fromTransferType;
        this.toTransferType = toTransferType;
        this.chargeId = null;
        this.loanInstallmentNumber = null;
        this.transferType = null;
        this.accountTransferDetails = null;
        this.noteText = null;
        this.txnExternalId = txnExternalId;
        this.fromLoan = fromLoan;
        this.toLoan = toLoan;
        this.loan = null;
        this.toSavingsAccount = null;
        this.fromSavingsAccount = null;
        this.isRegularTransaction = null;
        this.isExceptionForBalanceCheck = null;
    }

    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    public BigDecimal getTransactionAmount() {
        return this.transactionAmount;
    }

    public PortfolioAccountType getFromAccountType() {
        return this.fromAccountType;
    }

    public PortfolioAccountType getToAccountType() {
        return this.toAccountType;
    }

    public Long getFromAccountId() {
        return this.fromAccountId;
    }

    public Long getToAccountId() {
        return this.toAccountId;
    }

    public String getDescription() {
        return this.description;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DateTimeFormatter getFmt() {
        return this.fmt;
    }

    public PaymentDetail getPaymentDetail() {
        return this.paymentDetail;
    }

    public Integer getFromTransferType() {
        return this.fromTransferType;
    }

    public Integer getToTransferType() {
        return this.toTransferType;
    }

    public Long getChargeId() {
        return this.chargeId;
    }

    public Integer getLoanInstallmentNumber() {
        return this.loanInstallmentNumber;
    }

    public Integer getTransferType() {
        return this.transferType;
    }

    public AccountTransferDetails getAccountTransferDetails() {
        return this.accountTransferDetails;
    }

    public String getNoteText() {
        return this.noteText;
    }

    public ExternalId getTxnExternalId() {
        return this.txnExternalId;
    }

    public Loan getLoan() {
        return this.loan;
    }

    public Loan getFromLoan() {
        return this.fromLoan;
    }

    public Loan getToLoan() {
        return this.toLoan;
    }

    public SavingsAccount getToSavingsAccount() {
        return this.toSavingsAccount;
    }

    public SavingsAccount getFromSavingsAccount() {
        return this.fromSavingsAccount;
    }

    public Boolean isRegularTransaction() {
        return this.isRegularTransaction;
    }

    public Boolean isExceptionForBalanceCheck() {
        return this.isExceptionForBalanceCheck;
    }
}

