/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.service.ConfigurationReadPlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.client.data.ClientApiCollectionConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class ClientDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private final ConfigurationReadPlatformService configurationReadPlatformService;

    @Autowired
    public ClientDataValidator(FromJsonHelper fromApiJsonHelper, ConfigurationReadPlatformService configurationReadPlatformService) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.configurationReadPlatformService = configurationReadPlatformService;
    }

    public void validateForCreate(String json) {
        Boolean active;
        String clientNonPersonJson;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.CLIENT_CREATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("clientNonPersonDetails", element) && (clientNonPersonJson = this.fromApiJsonHelper.toJson(element.getAsJsonObject().get("clientNonPersonDetails"))) != null) {
            this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, clientNonPersonJson, (Collection)ClientApiCollectionConstants.CLIENT_NON_PERSON_CREATE_REQUEST_DATA_PARAMETERS);
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", element);
        baseDataValidator.reset().parameter("officeId").value((Object)officeId).notNull().integerGreaterThanZero();
        if (this.fromApiJsonHelper.parameterExists("groupId", element)) {
            Long groupId = this.fromApiJsonHelper.extractLongNamed("groupId", element);
            baseDataValidator.reset().parameter("groupId").value((Object)groupId).notNull().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).ignoreIfNull().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
            String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
            baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
        }
        if (this.fromApiJsonHelper.parameterExists("savingsProductId", element)) {
            Long savingsProductId = this.fromApiJsonHelper.extractLongNamed("savingsProductId", element);
            baseDataValidator.reset().parameter("savingsProductId").value((Object)savingsProductId).ignoreIfNull().longGreaterThanZero();
        }
        if (this.isFullnameProvided(element) || this.isIndividualNameProvided(element)) {
            if (this.isFullnameProvided(element) && !this.isIndividualNameProvided(element)) {
                this.fullnameCannotBeBlank(element, baseDataValidator);
            }
            if (this.isIndividualNameProvided(element) && !this.isFullnameProvided(element)) {
                this.validateRequiredIndividualNamePartsExist(element, baseDataValidator);
            }
            if (this.isFullnameProvided(element) && this.isIndividualNameProvided(element)) {
                this.validateIndividualNamePartsCannotBeUsedWithFullname(element, baseDataValidator);
            }
        } else if (this.isFullnameParameterPassed(element) || this.isIndividualNamePartParameterPassed(element)) {
            if (this.isFullnameParameterPassed(element) && !this.isIndividualNamePartParameterPassed(element)) {
                this.fullnameCannotBeBlank(element, baseDataValidator);
            }
            if (this.isIndividualNamePartParameterPassed(element) && !this.isFullnameParameterPassed(element)) {
                this.validateRequiredIndividualNamePartsExist(element, baseDataValidator);
            }
            if (this.isFullnameParameterPassed(element) && this.isIndividualNamePartParameterPassed(element)) {
                baseDataValidator.reset().parameter("id").failWithCode(".no.name.details.passed", new Object[0]);
            }
        } else {
            baseDataValidator.reset().parameter("id").failWithCode(".no.name.details.passed", new Object[0]);
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("mobileNo", element)) {
            String mobileNo = this.fromApiJsonHelper.extractStringNamed("mobileNo", element);
            baseDataValidator.reset().parameter("mobileNo").value((Object)mobileNo).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null) {
            if (active.booleanValue()) {
                LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
                baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull();
            }
        } else {
            baseDataValidator.reset().parameter("active").value((Object)active).trueOrFalseRequired((Object)false);
        }
        LocalDate submittedOnDate = null;
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            submittedOnDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedOnDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("dateOfBirth", element)) {
            LocalDate dateOfBirth = this.fromApiJsonHelper.extractLocalDateNamed("dateOfBirth", element);
            baseDataValidator.reset().parameter("dateOfBirth").value((Object)dateOfBirth).notNull().validateDateBefore(DateUtils.getBusinessLocalDate()).validateDateBefore(submittedOnDate);
        }
        if (this.fromApiJsonHelper.parameterExists("genderId", element)) {
            Integer genderId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("genderId", element);
            baseDataValidator.reset().parameter("genderId").value((Object)genderId).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("clientTypeId", element)) {
            Integer clientType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("clientTypeId", element);
            baseDataValidator.reset().parameter("clientTypeId").value((Object)clientType).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("clientClassificationId", element)) {
            Integer clientClassification = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("clientClassificationId", element);
            baseDataValidator.reset().parameter("clientClassificationId").value((Object)clientClassification).integerGreaterThanZero();
        }
        Integer legalFormId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("legalFormId", element);
        baseDataValidator.reset().parameter("legalFormId").value((Object)legalFormId).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        if (this.fromApiJsonHelper.parameterExists("datatables", element)) {
            JsonArray datatables = this.fromApiJsonHelper.extractJsonArrayNamed("datatables", element);
            baseDataValidator.reset().parameter("datatables").value((Object)datatables).notNull().jsonArrayNotEmpty();
        }
        if (this.fromApiJsonHelper.parameterExists("isStaff", element)) {
            Boolean isStaffFlag = this.fromApiJsonHelper.extractBooleanNamed("isStaff", element);
            baseDataValidator.reset().parameter("isStaff").value((Object)isStaffFlag).notNull();
        }
        if (this.configurationReadPlatformService.retrieveGlobalConfiguration("enable-address").isEnabled()) {
            JsonArray address = this.fromApiJsonHelper.extractJsonArrayNamed("address", element);
            baseDataValidator.reset().parameter("address").value((Object)address).ignoreIfNull().jsonArrayNotEmpty();
        }
        List dataValidationErrorsForClientNonPerson = this.getDataValidationErrorsForCreateOnClientNonPerson(element.getAsJsonObject().get("clientNonPersonDetails"));
        dataValidationErrors.addAll(dataValidationErrorsForClientNonPerson);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    List<ApiParameterError> getDataValidationErrorsForCreateOnClientNonPerson(JsonElement element) {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        if (this.fromApiJsonHelper.parameterExists("incorpNumber", element)) {
            String incorpNumber = this.fromApiJsonHelper.extractStringNamed("incorpNumber", element);
            baseDataValidator.reset().parameter("incorpNumber").value((Object)incorpNumber).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists("remarks", element)) {
            String remarks = this.fromApiJsonHelper.extractStringNamed("remarks", element);
            baseDataValidator.reset().parameter("remarks").value((Object)remarks).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(150));
        }
        if (this.fromApiJsonHelper.parameterExists("incorpValidityTillDate", element)) {
            LocalDate incorpValidityTill = this.fromApiJsonHelper.extractLocalDateNamed("incorpValidityTillDate", element);
            baseDataValidator.reset().parameter("incorpValidityTillDate").value((Object)incorpValidityTill).ignoreIfNull();
        }
        if (this.fromApiJsonHelper.parameterExists("constitutionId", element)) {
            Integer constitution = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("constitutionId", element);
            baseDataValidator.reset().parameter("constitutionId").value((Object)constitution).integerGreaterThanZero().notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("mainBusinessLineId", element)) {
            Integer mainBusinessLine = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("mainBusinessLineId", element);
            baseDataValidator.reset().parameter("mainBusinessLineId").value((Object)mainBusinessLine).integerGreaterThanZero();
        }
        return dataValidationErrors;
    }

    private void validateIndividualNamePartsCannotBeUsedWithFullname(JsonElement element, DataValidatorBuilder baseDataValidator) {
        String lastnameParamName;
        String middlenameParam;
        String firstnameParam = this.fromApiJsonHelper.extractStringNamed("firstname", element);
        if (StringUtils.isNotBlank((CharSequence)firstnameParam)) {
            String fullnameParam = this.fromApiJsonHelper.extractStringNamed("fullname", element);
            baseDataValidator.reset().parameter("fullname").value((Object)fullnameParam).mustBeBlankWhenParameterProvided("firstname", (Object)firstnameParam);
        }
        if (StringUtils.isNotBlank((CharSequence)(middlenameParam = this.fromApiJsonHelper.extractStringNamed("middlename", element)))) {
            String fullnameParam = this.fromApiJsonHelper.extractStringNamed("fullname", element);
            baseDataValidator.reset().parameter("fullname").value((Object)fullnameParam).mustBeBlankWhenParameterProvided("middlename", (Object)middlenameParam);
        }
        if (StringUtils.isNotBlank((CharSequence)(lastnameParamName = this.fromApiJsonHelper.extractStringNamed("lastname", element)))) {
            String fullnameParam = this.fromApiJsonHelper.extractStringNamed("fullname", element);
            baseDataValidator.reset().parameter("fullname").value((Object)fullnameParam).mustBeBlankWhenParameterProvided("lastname", (Object)lastnameParamName);
        }
    }

    private void validateRequiredIndividualNamePartsExist(JsonElement element, DataValidatorBuilder baseDataValidator) {
        String firstnameParam = this.fromApiJsonHelper.extractStringNamed("firstname", element);
        baseDataValidator.reset().parameter("firstname").value((Object)firstnameParam).notBlank().notExceedingLengthOf(Integer.valueOf(50));
        String middlenameParam = this.fromApiJsonHelper.extractStringNamed("middlename", element);
        baseDataValidator.reset().parameter("middlename").value((Object)middlenameParam).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        String lastnameParamName = this.fromApiJsonHelper.extractStringNamed("lastname", element);
        baseDataValidator.reset().parameter("lastname").value((Object)lastnameParamName).notBlank().notExceedingLengthOf(Integer.valueOf(50));
    }

    private void fullnameCannotBeBlank(JsonElement element, DataValidatorBuilder baseDataValidator) {
        String fullnameParam = this.fromApiJsonHelper.extractStringNamed("fullname", element);
        baseDataValidator.reset().parameter("fullname").value((Object)fullnameParam).notBlank().notExceedingLengthOf(Integer.valueOf(160));
    }

    private boolean isIndividualNamePartParameterPassed(JsonElement element) {
        return this.fromApiJsonHelper.parameterExists("firstname", element) || this.fromApiJsonHelper.parameterExists("middlename", element) || this.fromApiJsonHelper.parameterExists("lastname", element);
    }

    private boolean isFullnameParameterPassed(JsonElement element) {
        return this.fromApiJsonHelper.parameterExists("fullname", element);
    }

    private boolean isIndividualNameProvided(JsonElement element) {
        String firstname = this.fromApiJsonHelper.extractStringNamed("firstname", element);
        String middlename = this.fromApiJsonHelper.extractStringNamed("middlename", element);
        String lastname = this.fromApiJsonHelper.extractStringNamed("lastname", element);
        return StringUtils.isNotBlank((CharSequence)firstname) || StringUtils.isNotBlank((CharSequence)middlename) || StringUtils.isNotBlank((CharSequence)lastname);
    }

    private boolean isFullnameProvided(JsonElement element) {
        String fullname = this.fromApiJsonHelper.extractStringNamed("fullname", element);
        return StringUtils.isNotBlank((CharSequence)fullname);
    }

    public void validateForUpdate(String json) {
        Boolean active;
        String clientNonPersonJson;
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.CLIENT_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        if (this.fromApiJsonHelper.parameterExists("clientNonPersonDetails", element) && (clientNonPersonJson = this.fromApiJsonHelper.toJson(element.getAsJsonObject().get("clientNonPersonDetails"))) != null) {
            this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, clientNonPersonJson, (Collection)ClientApiCollectionConstants.CLIENT_NON_PERSON_UPDATE_REQUEST_DATA_PARAMETERS);
        }
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        boolean atLeastOneParameterPassedForUpdate = false;
        if (this.fromApiJsonHelper.parameterExists("accountNo", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String accountNo = this.fromApiJsonHelper.extractStringNamed("accountNo", element);
            baseDataValidator.reset().parameter("accountNo").value((Object)accountNo).notBlank().notExceedingLengthOf(Integer.valueOf(20));
        }
        if (this.isFullnameProvided(element) || this.isIndividualNameProvided(element)) {
            if (this.isFullnameProvided(element) && !this.isIndividualNameProvided(element)) {
                this.fullnameCannotBeBlank(element, baseDataValidator);
            }
            if (this.isIndividualNameProvided(element) && !this.isFullnameProvided(element)) {
                this.validateRequiredIndividualNamePartsExist(element, baseDataValidator);
            }
            if (this.isFullnameProvided(element) && this.isIndividualNameProvided(element)) {
                this.validateIndividualNamePartsCannotBeUsedWithFullname(element, baseDataValidator);
            }
        } else if (this.isFullnameParameterPassed(element) || this.isIndividualNamePartParameterPassed(element)) {
            if (this.isFullnameParameterPassed(element) && !this.isIndividualNamePartParameterPassed(element)) {
                this.fullnameCannotBeBlank(element, baseDataValidator);
            }
            if (this.isIndividualNamePartParameterPassed(element) && !this.isFullnameParameterPassed(element)) {
                this.validateRequiredIndividualNamePartsExist(element, baseDataValidator);
            }
            if (this.isFullnameParameterPassed(element) && this.isIndividualNamePartParameterPassed(element)) {
                baseDataValidator.reset().parameter("id").failWithCode(".no.name.details.passed", new Object[0]);
            }
        }
        if (this.fromApiJsonHelper.parameterExists("fullname", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("lastname", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("middlename", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("firstname", element)) {
            atLeastOneParameterPassedForUpdate = true;
        }
        if (this.fromApiJsonHelper.parameterExists("externalId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String externalId = this.fromApiJsonHelper.extractStringNamed("externalId", element);
            baseDataValidator.reset().parameter("externalId").value((Object)externalId).notExceedingLengthOf(Integer.valueOf(100));
        }
        if (this.fromApiJsonHelper.parameterExists("mobileNo", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String mobileNo = this.fromApiJsonHelper.extractStringNamed("mobileNo", element);
            baseDataValidator.reset().parameter("mobileNo").value((Object)mobileNo).notExceedingLengthOf(Integer.valueOf(50));
        }
        if ((active = this.fromApiJsonHelper.extractBooleanNamed("active", element)) != null) {
            atLeastOneParameterPassedForUpdate = true;
            if (active.booleanValue()) {
                LocalDate joinedDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
                baseDataValidator.reset().parameter("activationDate").value((Object)joinedDate).notNull();
            }
        }
        if (this.fromApiJsonHelper.parameterExists("staffId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
            baseDataValidator.reset().parameter("staffId").value((Object)staffId).ignoreIfNull().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("savingsProductId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Long savingsProductId = this.fromApiJsonHelper.extractLongNamed("savingsProductId", element);
            baseDataValidator.reset().parameter("savingsProductId").value((Object)savingsProductId).ignoreIfNull().longGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("genderId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer genderId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("genderId", element);
            baseDataValidator.reset().parameter("genderId").value((Object)genderId).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("clientTypeId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer clientType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("clientTypeId", element);
            baseDataValidator.reset().parameter("clientTypeId").value((Object)clientType).integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.parameterExists("clientClassificationId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer clientClassification = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("clientClassificationId", element);
            baseDataValidator.reset().parameter("clientClassificationId").value((Object)clientClassification).integerGreaterThanZero();
        }
        LocalDate submittedDate = null;
        if (this.fromApiJsonHelper.parameterExists("submittedOnDate", element)) {
            atLeastOneParameterPassedForUpdate = true;
            submittedDate = this.fromApiJsonHelper.extractLocalDateNamed("submittedOnDate", element);
            baseDataValidator.reset().parameter("submittedOnDate").value((Object)submittedDate).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("dateOfBirth", element)) {
            atLeastOneParameterPassedForUpdate = true;
            LocalDate dateOfBirth = this.fromApiJsonHelper.extractLocalDateNamed("dateOfBirth", element);
            baseDataValidator.reset().parameter("dateOfBirth").value((Object)dateOfBirth).notNull().validateDateBefore(DateUtils.getBusinessLocalDate()).validateDateBefore(submittedDate);
        }
        if (this.fromApiJsonHelper.parameterExists("legalFormId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer legalFormId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("legalFormId", element);
            baseDataValidator.reset().parameter("legalFormId").value((Object)legalFormId).notNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(2));
        }
        if (this.fromApiJsonHelper.parameterExists("isStaff", element)) {
            Boolean isStaffFlag = this.fromApiJsonHelper.extractBooleanNamed("isStaff", element);
            baseDataValidator.reset().parameter("isStaff").value((Object)isStaffFlag).notNull();
        }
        Map parameterUpdateStatusDetails = this.getParameterUpdateStatusAndDataValidationErrorsForUpdateOnClientNonPerson(element.getAsJsonObject().get("clientNonPersonDetails"));
        boolean atLeastOneParameterPassedForClientNonPersonUpdate = (Boolean)parameterUpdateStatusDetails.get("parameterUpdateStatus");
        if (!atLeastOneParameterPassedForUpdate && !atLeastOneParameterPassedForClientNonPersonUpdate) {
            Object forceError = null;
            baseDataValidator.reset().anyOfNotNull(new Object[]{forceError});
        }
        List dataValidationErrorsForClientNonPerson = (List)parameterUpdateStatusDetails.get("dataValidationErrors");
        dataValidationErrors.addAll(dataValidationErrorsForClientNonPerson);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    Map<String, Object> getParameterUpdateStatusAndDataValidationErrorsForUpdateOnClientNonPerson(JsonElement element) {
        boolean atLeastOneParameterPassedForUpdate = false;
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        if (this.fromApiJsonHelper.parameterExists("incorpNumber", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String incorpNo = this.fromApiJsonHelper.extractStringNamed("incorpNumber", element);
            baseDataValidator.reset().parameter("incorpNumber").value((Object)incorpNo).ignoreIfNull().notExceedingLengthOf(Integer.valueOf(50));
        }
        if (this.fromApiJsonHelper.parameterExists("remarks", element)) {
            atLeastOneParameterPassedForUpdate = true;
            String remarks = this.fromApiJsonHelper.extractStringNamed("remarks", element);
            baseDataValidator.reset().parameter("remarks").value((Object)remarks).notExceedingLengthOf(Integer.valueOf(150));
        }
        if (this.fromApiJsonHelper.parameterExists("incorpValidityTillDate", element)) {
            atLeastOneParameterPassedForUpdate = true;
            LocalDate incorpValidityTill = this.fromApiJsonHelper.extractLocalDateNamed("incorpValidityTillDate", element);
            baseDataValidator.reset().parameter("incorpValidityTillDate").value((Object)incorpValidityTill);
        }
        if (this.fromApiJsonHelper.parameterExists("constitutionId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer constitutionId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("constitutionId", element);
            baseDataValidator.reset().parameter("constitutionId").value((Object)constitutionId).integerGreaterThanZero().notBlank();
        }
        if (this.fromApiJsonHelper.parameterExists("mainBusinessLineId", element)) {
            atLeastOneParameterPassedForUpdate = true;
            Integer mainBusinessLineId = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("mainBusinessLineId", element);
            baseDataValidator.reset().parameter("mainBusinessLineId").value((Object)mainBusinessLineId).integerGreaterThanZero();
        }
        HashMap<String, Object> parameterUpdateStatusDetails = new HashMap<String, Object>();
        parameterUpdateStatusDetails.put("parameterUpdateStatus", atLeastOneParameterPassedForUpdate);
        parameterUpdateStatusDetails.put("dataValidationErrors", dataValidationErrors);
        return parameterUpdateStatusDetails;
    }

    public void validateActivation(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.ACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate activationDate = this.fromApiJsonHelper.extractLocalDateNamed("activationDate", element);
        baseDataValidator.reset().parameter("activationDate").value((Object)activationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForUnassignStaff(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParametersUnassignStaff = new HashSet<String>(Arrays.asList("staffId"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParametersUnassignStaff);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        String staffIdParameterName = "staffId";
        Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateForAssignStaff(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParametersUnassignStaff = new HashSet<String>(Arrays.asList("staffId"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParametersUnassignStaff);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        String staffIdParameterName = "staffId";
        Long staffId = this.fromApiJsonHelper.extractLongNamed("staffId", element);
        baseDataValidator.reset().parameter("staffId").value((Object)staffId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateClose(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.CLIENT_CLOSE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate closureDate = this.fromApiJsonHelper.extractLocalDateNamed("closureDate", element);
        baseDataValidator.reset().parameter("closureDate").value((Object)closureDate).notNull();
        Long closureReasonId = this.fromApiJsonHelper.extractLongNamed("closureReasonId", element);
        baseDataValidator.reset().parameter("closureReasonId").value((Object)closureReasonId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForSavingsAccount(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashSet<String> supportedParameters = new HashSet<String>(Arrays.asList("savingsAccountId"));
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, supportedParameters);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        String savingsIdParameterName = "savingsAccountId";
        Long savingsId = this.fromApiJsonHelper.extractLongNamed("savingsAccountId", element);
        baseDataValidator.reset().parameter("savingsAccountId").value((Object)savingsId).notNull().longGreaterThanZero();
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    public void validateRejection(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.CLIENT_REJECT_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate rejectionDate = this.fromApiJsonHelper.extractLocalDateNamed("rejectionDate", element);
        baseDataValidator.reset().parameter("rejectionDate").value((Object)rejectionDate).notNull();
        Long rejectionReasonId = this.fromApiJsonHelper.extractLongNamed("rejectionReasonId", element);
        baseDataValidator.reset().parameter("rejectionReasonId").value((Object)rejectionReasonId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateWithdrawn(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.CLIENT_WITHDRAW_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate withdrawalDate = this.fromApiJsonHelper.extractLocalDateNamed("withdrawalDate", element);
        baseDataValidator.reset().parameter("withdrawalDate").value((Object)withdrawalDate).notNull();
        Long withdrawalReasonId = this.fromApiJsonHelper.extractLongNamed("withdrawalReasonId", element);
        baseDataValidator.reset().parameter("withdrawalReasonId").value((Object)withdrawalReasonId).notNull().longGreaterThanZero();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateReactivate(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.REACTIVATION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate reactivationDate = this.fromApiJsonHelper.extractLocalDateNamed("reactivationDate", element);
        baseDataValidator.reset().parameter("reactivationDate").value((Object)reactivationDate).notNull();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateUndoRejection(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.UNDOREJECTION_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate undoRejectionDate = this.fromApiJsonHelper.extractLocalDateNamed("reopenedDate", element);
        baseDataValidator.reset().parameter("reopenedDate").value((Object)undoRejectionDate).notNull().validateDateBeforeOrEqual(DateUtils.getBusinessLocalDate());
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateUndoWithDrawn(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)ClientApiCollectionConstants.UNDOWITHDRAWN_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("client");
        JsonElement element = command.parsedJson();
        LocalDate undoWithdrawnDate = this.fromApiJsonHelper.extractLocalDateNamed("reopenedDate", element);
        baseDataValidator.reset().parameter("reopenedDate").value((Object)undoWithdrawnDate).notNull().validateDateBeforeOrEqual(DateUtils.getBusinessLocalDate());
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }
}

