/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.xml.bind.annotation.XmlTransient;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.client.domain.Client;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;

@Entity
@Table(name="m_client_non_person")
public class ClientNonPerson
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedChangeTracking {
    @OneToOne(optional=false)
    @JoinColumn(name="client_id", referencedColumnName="id", nullable=false, unique=true)
    private Client client;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="constitution_cv_id", nullable=false)
    private CodeValue constitution;
    @Column(name="incorp_no", length=50, nullable=true)
    private String incorpNumber;
    @Column(name="incorp_validity_till", nullable=true)
    private LocalDate incorpValidityTill;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="main_business_line_cv_id", nullable=true)
    private CodeValue mainBusinessLine;
    @Column(name="remarks", length=150, nullable=true)
    private String remarks;
    static final long serialVersionUID = -3182198709246923011L;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_constitution_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_mainBusinessLine_vh;

    public static ClientNonPerson createNew(Client client, CodeValue constitution, CodeValue mainBusinessLine, String incorpNumber, LocalDate incorpValidityTill, String remarks) {
        return new ClientNonPerson(client, constitution, mainBusinessLine, incorpNumber, incorpValidityTill, remarks);
    }

    protected ClientNonPerson() {
    }

    private ClientNonPerson(Client client, CodeValue constitution, CodeValue mainBusinessLine, String incorpNumber, LocalDate incorpValidityTill, String remarks) {
        if (client != null) {
            this.client = client;
        }
        if (constitution != null) {
            this.constitution = constitution;
        }
        if (mainBusinessLine != null) {
            this.mainBusinessLine = mainBusinessLine;
        }
        if (StringUtils.isNotBlank((CharSequence)incorpNumber)) {
            this.incorpNumber = incorpNumber.trim();
        }
        this.incorpValidityTill = incorpValidityTill;
        if (StringUtils.isNotBlank((CharSequence)remarks)) {
            this.remarks = remarks.trim();
        }
        this.validate(client);
    }

    private void validate(Client client) {
        ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
        this.validateIncorpValidityTillDate(client, dataValidationErrors);
        if (this._persistence_get_constitution() == null) {
            dataValidationErrors.add(ApiParameterError.parameterError((String)"error.msg.clients.constitutionid.is.null", (String)"Constitution ID may not be null", (String)"constitutionId", (Object[])new Object[0]));
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }

    private void validateIncorpValidityTillDate(Client client, List<ApiParameterError> dataValidationErrors) {
        if (this.getIncorpValidityTillLocalDate() != null && client.dateOfBirthLocalDate() != null && DateUtils.isAfter((LocalDate)client.dateOfBirthLocalDate(), (LocalDate)this.getIncorpValidityTillLocalDate())) {
            String defaultUserMessage = "incorpvaliditytill date cannot be after the incorporation date";
            ApiParameterError error = ApiParameterError.parameterError((String)"error.msg.clients.incorpValidityTill.after.incorp.date", (String)"incorpvaliditytill date cannot be after the incorporation date", (String)"incorpValidityTillDate", (Object[])new Object[]{this._persistence_get_incorpValidityTill()});
            dataValidationErrors.add(error);
        }
    }

    public LocalDate getIncorpValidityTillLocalDate() {
        return this._persistence_get_incorpValidityTill();
    }

    public Long constitutionId() {
        Long constitutionId = null;
        if (this._persistence_get_constitution() != null) {
            constitutionId = (Long)this._persistence_get_constitution().getId();
        }
        return constitutionId;
    }

    public Long mainBusinessLineId() {
        Long mainBusinessLineId = null;
        if (this._persistence_get_mainBusinessLine() != null) {
            mainBusinessLineId = (Long)this._persistence_get_mainBusinessLine().getId();
        }
        return mainBusinessLineId;
    }

    public void updateConstitution(CodeValue constitution) {
        this._persistence_set_constitution(constitution);
    }

    public void updateMainBusinessLine(CodeValue mainBusinessLine) {
        this._persistence_set_mainBusinessLine(mainBusinessLine);
    }

    public Map<String, Object> update(JsonCommand command) {
        Long newValue;
        String newValue2;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        if (command.isChangeInStringParameterNamed("incorpNumber", this._persistence_get_incorpNumber())) {
            newValue2 = command.stringValueOfParameterNamed("incorpNumber");
            actualChanges.put("incorpNumber", newValue2);
            this._persistence_set_incorpNumber((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
        }
        if (command.isChangeInStringParameterNamed("remarks", this._persistence_get_remarks())) {
            newValue2 = command.stringValueOfParameterNamed("remarks");
            actualChanges.put("remarks", newValue2);
            this._persistence_set_remarks((String)StringUtils.defaultIfEmpty((CharSequence)newValue2, null));
        }
        String dateFormatAsInput = command.dateFormat();
        String localeAsInput = command.locale();
        if (command.isChangeInLocalDateParameterNamed("incorpValidityTillDate", this.getIncorpValidityTillLocalDate())) {
            String valueAsInput = command.stringValueOfParameterNamed("incorpValidityTillDate");
            actualChanges.put("incorpValidityTillDate", valueAsInput);
            actualChanges.put("dateFormat", dateFormatAsInput);
            actualChanges.put("locale", localeAsInput);
            this._persistence_set_incorpValidityTill(command.localDateValueOfParameterNamed("incorpValidityTillDate"));
        }
        if (command.isChangeInLongParameterNamed("constitutionId", this.constitutionId())) {
            newValue = command.longValueOfParameterNamed("constitutionId");
            actualChanges.put("constitutionId", newValue);
        }
        if (command.isChangeInLongParameterNamed("mainBusinessLineId", this.mainBusinessLineId())) {
            newValue = command.longValueOfParameterNamed("mainBusinessLineId");
            actualChanges.put("mainBusinessLineId", newValue);
        }
        return actualChanges;
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        if (this._persistence_constitution_vh != null) {
            this._persistence_constitution_vh = (WeavedAttributeValueHolderInterface)this._persistence_constitution_vh.clone();
        }
        if (this._persistence_mainBusinessLine_vh != null) {
            this._persistence_mainBusinessLine_vh = (WeavedAttributeValueHolderInterface)this._persistence_mainBusinessLine_vh.clone();
        }
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ClientNonPerson(persistenceObject);
    }

    public ClientNonPerson(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "constitution") {
            return this.constitution;
        }
        if (string == "incorpValidityTill") {
            return this.incorpValidityTill;
        }
        if (string == "client") {
            return this.client;
        }
        if (string == "incorpNumber") {
            return this.incorpNumber;
        }
        if (string == "mainBusinessLine") {
            return this.mainBusinessLine;
        }
        if (string == "remarks") {
            return this.remarks;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "constitution") {
            this.constitution = (CodeValue)object;
            return;
        }
        if (string == "incorpValidityTill") {
            this.incorpValidityTill = (LocalDate)object;
            return;
        }
        if (string == "client") {
            this.client = (Client)object;
            return;
        }
        if (string == "incorpNumber") {
            this.incorpNumber = (String)object;
            return;
        }
        if (string == "mainBusinessLine") {
            this.mainBusinessLine = (CodeValue)object;
            return;
        }
        if (string == "remarks") {
            this.remarks = (String)object;
            return;
        }
        super._persistence_set(string, object);
    }

    protected void _persistence_initialize_constitution_vh() {
        if (this._persistence_constitution_vh == null) {
            this._persistence_constitution_vh = new ValueHolder((Object)this.constitution);
            this._persistence_constitution_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_constitution_vh() {
        CodeValue codeValue;
        this._persistence_initialize_constitution_vh();
        if ((this._persistence_constitution_vh.isCoordinatedWithProperty() || this._persistence_constitution_vh.isNewlyWeavedValueHolder()) && (codeValue = this._persistence_get_constitution()) != this._persistence_constitution_vh.getValue()) {
            this._persistence_set_constitution(codeValue);
        }
        return this._persistence_constitution_vh;
    }

    public void _persistence_set_constitution_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_constitution_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CodeValue codeValue = this._persistence_get_constitution();
            if (codeValue != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_constitution((CodeValue)object);
            }
        } else {
            this.constitution = null;
        }
    }

    public CodeValue _persistence_get_constitution() {
        this._persistence_checkFetched("constitution");
        this._persistence_initialize_constitution_vh();
        this.constitution = (CodeValue)this._persistence_constitution_vh.getValue();
        return this.constitution;
    }

    public void _persistence_set_constitution(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("constitution");
        this._persistence_initialize_constitution_vh();
        this.constitution = (CodeValue)this._persistence_constitution_vh.getValue();
        this._persistence_propertyChange("constitution", (Object)this.constitution, (Object)codeValue);
        this.constitution = codeValue;
        this._persistence_constitution_vh.setValue((Object)codeValue);
    }

    public LocalDate _persistence_get_incorpValidityTill() {
        this._persistence_checkFetched("incorpValidityTill");
        return this.incorpValidityTill;
    }

    public void _persistence_set_incorpValidityTill(LocalDate localDate) {
        this._persistence_checkFetchedForSet("incorpValidityTill");
        this._persistence_propertyChange("incorpValidityTill", (Object)this.incorpValidityTill, (Object)localDate);
        this.incorpValidityTill = localDate;
    }

    public Client _persistence_get_client() {
        this._persistence_checkFetched("client");
        return this.client;
    }

    public void _persistence_set_client(Client client) {
        this._persistence_checkFetchedForSet("client");
        this._persistence_propertyChange("client", (Object)this.client, (Object)client);
        this.client = client;
    }

    public String _persistence_get_incorpNumber() {
        this._persistence_checkFetched("incorpNumber");
        return this.incorpNumber;
    }

    public void _persistence_set_incorpNumber(String string) {
        this._persistence_checkFetchedForSet("incorpNumber");
        this._persistence_propertyChange("incorpNumber", (Object)this.incorpNumber, (Object)string);
        this.incorpNumber = string;
    }

    protected void _persistence_initialize_mainBusinessLine_vh() {
        if (this._persistence_mainBusinessLine_vh == null) {
            this._persistence_mainBusinessLine_vh = new ValueHolder((Object)this.mainBusinessLine);
            this._persistence_mainBusinessLine_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_mainBusinessLine_vh() {
        CodeValue codeValue;
        this._persistence_initialize_mainBusinessLine_vh();
        if ((this._persistence_mainBusinessLine_vh.isCoordinatedWithProperty() || this._persistence_mainBusinessLine_vh.isNewlyWeavedValueHolder()) && (codeValue = this._persistence_get_mainBusinessLine()) != this._persistence_mainBusinessLine_vh.getValue()) {
            this._persistence_set_mainBusinessLine(codeValue);
        }
        return this._persistence_mainBusinessLine_vh;
    }

    public void _persistence_set_mainBusinessLine_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_mainBusinessLine_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            CodeValue codeValue = this._persistence_get_mainBusinessLine();
            if (codeValue != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_mainBusinessLine((CodeValue)object);
            }
        } else {
            this.mainBusinessLine = null;
        }
    }

    public CodeValue _persistence_get_mainBusinessLine() {
        this._persistence_checkFetched("mainBusinessLine");
        this._persistence_initialize_mainBusinessLine_vh();
        this.mainBusinessLine = (CodeValue)this._persistence_mainBusinessLine_vh.getValue();
        return this.mainBusinessLine;
    }

    public void _persistence_set_mainBusinessLine(CodeValue codeValue) {
        this._persistence_checkFetchedForSet("mainBusinessLine");
        this._persistence_initialize_mainBusinessLine_vh();
        this.mainBusinessLine = (CodeValue)this._persistence_mainBusinessLine_vh.getValue();
        this._persistence_propertyChange("mainBusinessLine", (Object)this.mainBusinessLine, (Object)codeValue);
        this.mainBusinessLine = codeValue;
        this._persistence_mainBusinessLine_vh.setValue((Object)codeValue);
    }

    public String _persistence_get_remarks() {
        this._persistence_checkFetched("remarks");
        return this.remarks;
    }

    public void _persistence_set_remarks(String string) {
        this._persistence_checkFetchedForSet("remarks");
        this._persistence_propertyChange("remarks", (Object)this.remarks, (Object)string);
        this.remarks = string;
    }
}

