/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.client.mapper;

import org.apache.fineract.infrastructure.codes.data.CodeValueData;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.core.config.MapstructMapperConfig;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.data.ClientTimelineData;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientEnumerations;
import org.apache.fineract.useradministration.domain.AppUser;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;

@Mapper(config=MapstructMapperConfig.class)
public interface ClientMapper {
    @Mappings(value={@Mapping(target="accountNo", source="source.accountNumber"), @Mapping(target="status", source="source", qualifiedByName={"clientStatusEnum"}), @Mapping(target="subStatus", source="source", qualifiedByName={"clientSubStatusCode"}), @Mapping(target="officeId", source="source.office.id"), @Mapping(target="officeName", source="source.office.name"), @Mapping(target="transferToOfficeId", source="source.transferToOffice.id"), @Mapping(target="transferToOfficeName", source="source.transferToOffice.name"), @Mapping(target="externalId", source="source.externalId"), @Mapping(target="gender", source="source", qualifiedByName={"clientGenderCode"}), @Mapping(target="imageId", source="source.image.id"), @Mapping(target="staffId", source="source.staff.id"), @Mapping(target="staffName", source="source.staff.displayName"), @Mapping(target="timeline", source="source", qualifiedByName={"clientTimelineData"}), @Mapping(target="savingsProductId", source="source.savingsProductId"), @Mapping(target="savingsProductName", source="source.id"), @Mapping(target="savingsAccountId", source="source.savingsAccountId"), @Mapping(target="clientType", source="source", qualifiedByName={"clientTypeCode"}), @Mapping(target="clientClassification", source="source", qualifiedByName={"clientClassificationCode"}), @Mapping(target="legalForm", source="source", qualifiedByName={"clientLegalFormEnum"}), @Mapping(target="isStaff", source="source", qualifiedByName={"clientIsStaff"}), @Mapping(target="imagePresent", ignore=true), @Mapping(target="officeOptions", ignore=true), @Mapping(target="staffOptions", ignore=true), @Mapping(target="narrations", ignore=true), @Mapping(target="savingProductOptions", ignore=true), @Mapping(target="savingAccountOptions", ignore=true), @Mapping(target="genderOptions", ignore=true), @Mapping(target="clientTypeOptions", ignore=true), @Mapping(target="clientClassificationOptions", ignore=true), @Mapping(target="clientNonPersonConstitutionOptions", ignore=true), @Mapping(target="clientNonPersonMainBusinessLineOptions", ignore=true), @Mapping(target="clientLegalFormOptions", ignore=true), @Mapping(target="familyMemberOptions", ignore=true), @Mapping(target="clientNonPersonDetails", ignore=true), @Mapping(target="address", ignore=true), @Mapping(target="isAddressEnabled", ignore=true), @Mapping(target="datatables", ignore=true), @Mapping(target="rowIndex", ignore=true), @Mapping(target="dateFormat", ignore=true), @Mapping(target="locale", ignore=true), @Mapping(target="clientTypeId", ignore=true), @Mapping(target="genderId", ignore=true), @Mapping(target="clientClassificationId", ignore=true), @Mapping(target="legalFormId", ignore=true), @Mapping(target="clientCollateralManagements", ignore=true), @Mapping(target="groups", ignore=true)})
    public ClientData map(Client var1);

    @Named(value="clientTypeCode")
    default public CodeValueData clientTypeCode(Client client) {
        CodeValue code = client.getClientType();
        if (code == null) {
            return null;
        }
        return CodeValueData.instance((Long)((Long)code.getId()), (String)code.getLabel());
    }

    @Named(value="clientClassificationCode")
    default public CodeValueData clientClassificationCode(Client client) {
        CodeValue code = client.getClientClassification();
        if (code == null) {
            return null;
        }
        return CodeValueData.instance((Long)((Long)code.getId()), (String)code.getLabel());
    }

    @Named(value="clientSubStatusCode")
    default public CodeValueData clientSubStatusCode(Client client) {
        CodeValue code = client.getSubStatus();
        if (code == null) {
            return null;
        }
        return CodeValueData.instance((Long)((Long)code.getId()), (String)code.getLabel());
    }

    @Named(value="clientGenderCode")
    default public CodeValueData clientGenderCode(Client client) {
        CodeValue code = client.getGender();
        if (code == null) {
            return null;
        }
        return CodeValueData.instance((Long)((Long)code.getId()), (String)code.getLabel());
    }

    @Named(value="clientLegalFormEnum")
    default public EnumOptionData clientLegalFormEnum(Client client) {
        return ClientEnumerations.legalForm((Integer)client.getLegalForm());
    }

    @Named(value="clientStatusEnum")
    default public EnumOptionData clientStatusEnum(Client client) {
        return ClientEnumerations.status((Integer)client.getStatus());
    }

    @Named(value="clientTimelineData")
    default public ClientTimelineData clientTimelineData(Client client) {
        if (client.isClosed()) {
            AppUser activatedBy = client.getActivatedBy();
            if (activatedBy != null) {
                return new ClientTimelineData(client.getSubmittedOnDate(), null, null, null, client.getActivationDate(), activatedBy.getUsername(), activatedBy.getFirstname(), activatedBy.getLastname(), client.getClosureDate(), client.getClosedBy().getUsername(), client.getClosedBy().getFirstname(), client.getClosedBy().getLastname());
            }
            return new ClientTimelineData(client.getSubmittedOnDate(), null, null, null, client.getActivationDate(), null, null, null, client.getClosureDate(), client.getClosedBy().getUsername(), client.getClosedBy().getFirstname(), client.getClosedBy().getLastname());
        }
        if (client.isActive()) {
            return new ClientTimelineData(client.getSubmittedOnDate(), null, null, null, client.getActivationDate(), client.getActivatedBy().getUsername(), client.getActivatedBy().getFirstname(), client.getActivatedBy().getLastname(), null, null, null, null);
        }
        return new ClientTimelineData(client.getSubmittedOnDate(), null, null, null, null, null, null, null, null, null, null, null);
    }

    @Named(value="clientIsStaff")
    default public Boolean clientIsStaff(Client client) {
        return client.isStaff();
    }
}

