/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateralmanagement.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.collateralmanagement.data.ClientCollateralManagementData;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagement;
import org.apache.fineract.portfolio.collateralmanagement.domain.ClientCollateralManagementRepository;
import org.apache.fineract.portfolio.collateralmanagement.exception.ClientCollateralNotFoundException;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductRepository;
import org.apache.fineract.portfolio.loanproduct.exception.LoanProductNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClientCollateralManagementRepositoryWrapper {
    private final ClientCollateralManagementRepository clientCollateralManagementRepository;
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final LoanProductRepository loanProductRepository;

    @Autowired
    public ClientCollateralManagementRepositoryWrapper(ClientCollateralManagementRepository clientCollateralManagementRepository, ClientRepositoryWrapper clientRepositoryWrapper, LoanProductRepository loanProductRepository) {
        this.clientCollateralManagementRepository = clientCollateralManagementRepository;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.loanProductRepository = loanProductRepository;
    }

    public List<ClientCollateralManagement> getCollateralsPerClient(Long clientId) {
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        return this.clientCollateralManagementRepository.findByClientId(client);
    }

    public List<ClientCollateralManagementData> getClientCollateralData(Long clientId, Long prodId) {
        Client client = this.clientRepositoryWrapper.findOneWithNotFoundDetection(clientId);
        String currency = null;
        if (prodId != null) {
            LoanProduct loanProduct = (LoanProduct)this.loanProductRepository.findById((Object)prodId).orElseThrow(() -> new LoanProductNotFoundException(prodId));
            currency = loanProduct.getCurrency().getCode();
        }
        List clientCollateralManagements = this.clientCollateralManagementRepository.findByClientId(client);
        ArrayList<ClientCollateralManagementData> clientCollateralManagementDataSet = new ArrayList<ClientCollateralManagementData>();
        for (ClientCollateralManagement clientCollateralManagement : clientCollateralManagements) {
            BigDecimal quantity = clientCollateralManagement.getQuantity();
            BigDecimal total = clientCollateralManagement.getTotal();
            BigDecimal totalCollateralValue = clientCollateralManagement.getTotalCollateral(total);
            if (prodId == null || !clientCollateralManagement.getCollaterals().getCurrency().getCode().equals(currency)) continue;
            clientCollateralManagementDataSet.add(ClientCollateralManagementData.instance((String)clientCollateralManagement.getCollaterals().getName(), (BigDecimal)quantity, (BigDecimal)total, (BigDecimal)totalCollateralValue, (Long)clientId, null, (Long)((Long)clientCollateralManagement.getId())));
        }
        return clientCollateralManagementDataSet;
    }

    public ClientCollateralManagement getCollateral(Long collateralId) {
        return (ClientCollateralManagement)this.clientCollateralManagementRepository.findById((Object)collateralId).orElseThrow(() -> new ClientCollateralNotFoundException(collateralId));
    }

    public ClientCollateralManagement updateClientCollateralProduct(ClientCollateralManagement clientCollateralManagement) {
        return (ClientCollateralManagement)this.clientCollateralManagementRepository.saveAndFlush((Object)clientCollateralManagement);
    }

    public void deleteClientCollateralProduct(Long collateralId) {
        this.clientCollateralManagementRepository.deleteById((Object)collateralId);
    }

    public void save(ClientCollateralManagement clientCollateralManagement) {
        this.clientCollateralManagementRepository.save((Object)clientCollateralManagement);
    }

    public void saveAndFlush(ClientCollateralManagement clientCollateralManagement) {
        this.clientCollateralManagementRepository.saveAndFlush((Object)clientCollateralManagement);
    }
}

