/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApplyOverdueChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanBalanceChangedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanAddChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanDeleteChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanUpdateChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanWaiveChargeBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.charge.LoanWaiveChargeUndoBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanAccrualTransactionCreatedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeAdjustmentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeAdjustmentPreBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanChargeRefundBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.organisation.monetary.exception.InvalidCurrencyException;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.portfolio.account.PortfolioAccountType;
import org.apache.fineract.portfolio.account.data.AccountTransferDTO;
import org.apache.fineract.portfolio.account.data.PortfolioAccountData;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetailRepository;
import org.apache.fineract.portfolio.account.domain.AccountTransferDetails;
import org.apache.fineract.portfolio.account.domain.AccountTransferTransaction;
import org.apache.fineract.portfolio.account.domain.AccountTransferType;
import org.apache.fineract.portfolio.account.exception.AccountTransferNotFoundException;
import org.apache.fineract.portfolio.account.service.AccountAssociationsReadPlatformService;
import org.apache.fineract.portfolio.account.service.AccountTransfersWritePlatformService;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.charge.domain.ChargeRepositoryWrapper;
import org.apache.fineract.portfolio.charge.domain.ChargeTimeType;
import org.apache.fineract.portfolio.charge.exception.ChargeCannotBeAppliedToException;
import org.apache.fineract.portfolio.charge.exception.ChargeCannotBeUpdatedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeCannotBeAddedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeCannotBeDeletedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeCannotBePayedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeCannotBeUpdatedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeCannotBeWaivedException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeNotFoundException;
import org.apache.fineract.portfolio.charge.exception.LoanChargeWaiveCannotBeReversedException;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.client.exception.ClientNotActiveException;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.exception.GroupNotActiveException;
import org.apache.fineract.portfolio.loanaccount.data.LoanChargePaidByData;
import org.apache.fineract.portfolio.loanaccount.data.ScheduleGeneratorDTO;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountDomainService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanAccountService;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargePaidBy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanDisbursementDetails;
import org.apache.fineract.portfolio.loanaccount.domain.LoanEvent;
import org.apache.fineract.portfolio.loanaccount.domain.LoanInstallmentCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanLifecycleStateMachine;
import org.apache.fineract.portfolio.loanaccount.domain.LoanOverdueInstallmentCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleProcessingWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleTransactionProcessorFactory;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTrancheDisbursementCharge;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelation;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRelationTypeEnum;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionRepository;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransactionType;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.LoanRepaymentScheduleTransactionProcessor;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.MoneyHolder;
import org.apache.fineract.portfolio.loanaccount.domain.transactionprocessor.TransactionCtx;
import org.apache.fineract.portfolio.loanaccount.exception.InstallmentNotFoundException;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTransactionTypeException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanChargeAdjustmentException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanChargeDeactivationException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanChargeRefundException;
import org.apache.fineract.portfolio.loanaccount.exception.LoanTransactionNotFoundException;
import org.apache.fineract.portfolio.loanaccount.loanschedule.data.OverdueLoanScheduleData;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.DefaultScheduledDateGenerator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeApiJsonValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanChargeValidator;
import org.apache.fineract.portfolio.loanaccount.serialization.LoanDownPaymentTransactionValidator;
import org.apache.fineract.portfolio.loanaccount.service.LoanAccrualsProcessingService;
import org.apache.fineract.portfolio.loanaccount.service.LoanAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeReadPlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.LoanChargeWritePlatformServiceImpl;
import org.apache.fineract.portfolio.loanaccount.service.LoanJournalEntryPoster;
import org.apache.fineract.portfolio.loanaccount.service.LoanScheduleService;
import org.apache.fineract.portfolio.loanaccount.service.LoanUtilService;
import org.apache.fineract.portfolio.loanaccount.service.LoanWritePlatformService;
import org.apache.fineract.portfolio.loanaccount.service.ReprocessLoanTransactionsService;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentParameter;
import org.apache.fineract.portfolio.loanaccount.service.adjustment.LoanAdjustmentService;
import org.apache.fineract.portfolio.loanproduct.data.LoanOverdueDTO;
import org.apache.fineract.portfolio.loanproduct.exception.LinkedAccountRequiredException;
import org.apache.fineract.portfolio.note.domain.Note;
import org.apache.fineract.portfolio.note.domain.NoteRepository;
import org.apache.fineract.portfolio.paymentdetail.domain.PaymentDetail;
import org.apache.fineract.portfolio.paymentdetail.service.PaymentDetailWritePlatformService;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoanChargeWritePlatformServiceImpl
implements LoanChargeWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanChargeWritePlatformServiceImpl.class);
    private static final String AMOUNT = "amount";
    private final LoanChargeApiJsonValidator loanChargeApiJsonValidator;
    private final LoanAssembler loanAssembler;
    private final ChargeRepositoryWrapper chargeRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final LoanTransactionRepository loanTransactionRepository;
    private final AccountTransfersWritePlatformService accountTransfersWritePlatformService;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final LoanAccountDomainService loanAccountDomainService;
    private final LoanChargeRepository loanChargeRepository;
    private final LoanWritePlatformService loanWritePlatformService;
    private final LoanUtilService loanUtilService;
    private final LoanChargeReadPlatformService loanChargeReadPlatformService;
    private final LoanLifecycleStateMachine loanLifecycleStateMachine;
    private final AccountAssociationsReadPlatformService accountAssociationsReadPlatformService;
    private final FromJsonHelper fromApiJsonHelper;
    private final ConfigurationDomainService configurationDomainService;
    private final LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory;
    private final ExternalIdFactory externalIdFactory;
    private final AccountTransferDetailRepository accountTransferDetailRepository;
    private final LoanChargeAssembler loanChargeAssembler;
    private final PaymentDetailWritePlatformService paymentDetailWritePlatformService;
    private final NoteRepository noteRepository;
    private final LoanAccrualsProcessingService loanAccrualsProcessingService;
    private final LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator;
    private final LoanChargeValidator loanChargeValidator;
    private final LoanScheduleService loanScheduleService;
    private final ReprocessLoanTransactionsService reprocessLoanTransactionsService;
    private final LoanAccountService loanAccountService;
    private final LoanAdjustmentService loanAdjustmentService;
    private final LoanChargeService loanChargeService;
    private final LoanJournalEntryPoster loanJournalEntryPoster;

    private static boolean isPartOfThisInstallment(LoanCharge loanCharge, LoanRepaymentScheduleInstallment e) {
        return DateUtils.isAfter((LocalDate)loanCharge.getDueDate(), (LocalDate)e.getFromDate()) && !DateUtils.isAfter((LocalDate)loanCharge.getDueDate(), (LocalDate)e.getDueDate());
    }

    @Transactional
    public CommandProcessingResult addLoanCharge(Long loanId, JsonCommand command) {
        Optional lastPaymentTransactionDate;
        boolean overpaidReprocess;
        this.loanChargeApiJsonValidator.validateAddLoanCharge(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (loan.isChargedOff()) {
            throw new GeneralPlatformDomainRuleException("error.msg.loan.is.charged.off", "Adding charge to Loan: " + loanId + " is not allowed. Loan Account is Charged-off", new Object[]{loanId});
        }
        List loanDisburseDetails = loan.getDisbursementDetails();
        Long chargeDefinitionId = command.longValueOfParameterNamed("chargeId");
        Charge chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(chargeDefinitionId);
        if (loan.isDisbursed() && chargeDefinition.isDisbursementCharge()) {
            this.validateAddingNewChargeAllowed(loanDisburseDetails);
        }
        boolean isAppliedOnBackDate = false;
        LoanCharge loanCharge = null;
        LocalDate recalculateFrom = loan.fetchInterestRecalculateFromDate();
        LocalDate transactionDate = null;
        if (chargeDefinition.isPercentageOfDisbursementAmount()) {
            ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
            boolean isFirst = true;
            for (LoanDisbursementDetails disbursementDetail : loanDisburseDetails) {
                if (disbursementDetail.actualDisbursementDate() != null) continue;
                if (!isFirst) {
                    externalId = this.externalIdFactory.create();
                }
                LocalDate dueDate = disbursementDetail.expectedDisbursementDateAsLocalDate();
                loanCharge = this.loanChargeAssembler.createNewWithoutLoan(chargeDefinition, disbursementDetail.principal(), null, null, null, dueDate, null, null, externalId);
                LoanTrancheDisbursementCharge loanTrancheDisbursementCharge = new LoanTrancheDisbursementCharge(loanCharge, disbursementDetail);
                loanCharge.updateLoanTrancheDisbursementCharge(loanTrancheDisbursementCharge);
                this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanAddChargeBusinessEvent(loanCharge));
                this.validateAddLoanCharge(loan, chargeDefinition, loanCharge);
                this.addCharge(loan, chargeDefinition, loanCharge);
                isAppliedOnBackDate = true;
                if (DateUtils.isAfter((LocalDate)recalculateFrom, (LocalDate)dueDate)) {
                    recalculateFrom = dueDate;
                }
                if (isFirst) {
                    transactionDate = loanCharge.getEffectiveDueDate();
                }
                isFirst = false;
            }
            if (loanCharge == null) {
                String errorMessage = "Charge with identifier " + String.valueOf(chargeDefinition.getId()) + " cannot be applied: No valid loan disbursement available";
                throw new ChargeCannotBeAppliedToException("loan", errorMessage, new Object[]{chargeDefinition.getId()});
            }
            loan.addTrancheLoanCharge(chargeDefinition);
        } else {
            loanCharge = this.loanChargeAssembler.createNewFromJson(loan, chargeDefinition, command);
            this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanAddChargeBusinessEvent(loanCharge));
            this.validateAddLoanCharge(loan, chargeDefinition, loanCharge);
            isAppliedOnBackDate = this.addCharge(loan, chargeDefinition, loanCharge);
            if (DateUtils.isAfter((LocalDate)recalculateFrom, (LocalDate)loanCharge.getDueLocalDate())) {
                isAppliedOnBackDate = true;
                recalculateFrom = loanCharge.getDueLocalDate();
            }
            transactionDate = loanCharge.getEffectiveDueDate();
        }
        boolean reprocessRequired = true;
        boolean bl = overpaidReprocess = !loanCharge.isDueAtDisbursement() && !loanCharge.isPaid() && loan.getStatus().isOverpaid();
        if (!overpaidReprocess && loan.isInterestBearingAndInterestRecalculationEnabled()) {
            if (isAppliedOnBackDate && loan.isFeeCompoundingEnabledForInterestRecalculation()) {
                loan = this.runScheduleRecalculation(loan, recalculateFrom);
                reprocessRequired = false;
            }
            this.loanWritePlatformService.updateOriginalSchedule(loan);
        }
        if (!overpaidReprocess && "advanced-payment-allocation-strategy".equals(loan.transactionProcessingStrategy()) && (lastPaymentTransactionDate = this.loanTransactionRepository.findLastTransactionDateForReprocessing(loan)).isPresent() && DateUtils.isAfter((LocalDate)loanCharge.getEffectiveDueDate(), (LocalDate)((LocalDate)lastPaymentTransactionDate.get()))) {
            reprocessRequired = false;
        }
        if (reprocessRequired) {
            if (loan.isProgressiveSchedule() && (loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy() || loan.hasContractTerminationTransaction())) {
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
            if (overpaidReprocess) {
                this.reprocessLoanTransactionsService.reprocessTransactionsWithPostTransactionChecks(loan, transactionDate);
            } else {
                this.reprocessLoanTransactionsService.reprocessTransactions(loan);
            }
            this.loanLifecycleStateMachine.determineAndTransition(loan, transactionDate);
            loan = this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        }
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && isAppliedOnBackDate && loan.isFeeCompoundingEnabledForInterestRecalculation()) {
            this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, true, true);
        }
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAddChargeBusinessEvent(loanCharge));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loanCharge.getId()).withEntityExternalId(loanCharge.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).build();
    }

    @Transactional
    public CommandProcessingResult loanChargeRefund(Long loanId, JsonCommand command) {
        this.loanChargeApiJsonValidator.validateLoanChargeRefundTransaction(command.json());
        Long loanChargeId = command.longValueOfParameterNamed("loanChargeId");
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        Integer installmentNumber = command.integerValueOfParameterNamed("installmentNumber");
        LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("transactionAmount");
        LoanInstallmentCharge installmentChargeEntry = this.loanChargeRefundEntranceValidation(loanCharge, installmentNumber, dueDate);
        Integer installmentNumberIdentified = null;
        if (installmentChargeEntry != null) {
            installmentNumberIdentified = installmentChargeEntry.getRepaymentInstallment().getInstallmentNumber();
        }
        BigDecimal fullRefundAbleAmount = this.loanChargeValidateRefundAmount(loanCharge, installmentChargeEntry, transactionAmount);
        JsonCommand repaymentJsonCommand = this.adaptLoanChargeRefundCommandForFurtherRepaymentProcessing(command, fullRefundAbleAmount);
        boolean isRecoveryRepayment = false;
        String chargeRefundChargeType = "F";
        if (loanCharge.isPenaltyCharge()) {
            chargeRefundChargeType = "P";
        }
        CommandProcessingResult result = this.loanWritePlatformService.makeLoanRepaymentWithChargeRefundChargeType(LoanTransactionType.CHARGE_REFUND, repaymentJsonCommand.getLoanId(), repaymentJsonCommand, isRecoveryRepayment, chargeRefundChargeType);
        Long loanChargeRefundTransactionId = result.getResourceId();
        LoanTransaction newChargeRefundTxn = null;
        for (LoanTransaction chargeRefundTxn : loanCharge.getLoan().getLoanTransactions()) {
            if (!loanChargeRefundTransactionId.equals(chargeRefundTxn.getId())) continue;
            newChargeRefundTxn = chargeRefundTxn;
            BigDecimal appliedRefundAmount = newChargeRefundTxn.getAmount(loanCharge.getLoan().getCurrency()).getAmount().multiply(BigDecimal.valueOf(-1L));
            LoanChargePaidBy loanChargePaidByForChargeRefund = new LoanChargePaidBy(newChargeRefundTxn, loanCharge, appliedRefundAmount, installmentNumberIdentified);
            newChargeRefundTxn.getLoanChargesPaid().add(loanChargePaidByForChargeRefund);
            loanCharge.getLoanChargePaidBySet().add(loanChargePaidByForChargeRefund);
            break;
        }
        if (newChargeRefundTxn != null) {
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(newChargeRefundTxn.getLoan()));
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanChargeRefundBusinessEvent(newChargeRefundTxn));
        return result;
    }

    @Transactional
    public CommandProcessingResult undoWaiveLoanCharge(JsonCommand command) {
        LoanTransaction loanTransaction = (LoanTransaction)this.loanTransactionRepository.findByIdAndLoanId(command.entityId(), command.getLoanId()).orElseThrow(() -> new LoanTransactionNotFoundException(command.entityId(), command.getLoanId()));
        if (!loanTransaction.getTypeOf().getCode().equals(LoanTransactionType.WAIVE_CHARGES.getCode())) {
            throw new InvalidLoanTransactionTypeException("transaction", "undo.waive.charge", "Transaction is not a waive charge type.", new Object[0]);
        }
        if (!loanTransaction.isNotReversed()) {
            throw new LoanChargeWaiveCannotBeReversedException(LoanChargeWaiveCannotBeReversedException.LoanChargeWaiveCannotUndoReason.ALREADY_REVERSED, (Long)loanTransaction.getId());
        }
        Set loanChargePaidBySet = loanTransaction.getLoanChargesPaid();
        LoanChargePaidBy loanChargePaidBy = (LoanChargePaidBy)loanChargePaidBySet.stream().findFirst().orElseThrow(LoanChargeNotFoundException::new);
        LoanCharge loanCharge = loanChargePaidBy.getLoanCharge();
        if (loanCharge.isPaid()) {
            throw new LoanChargeWaiveCannotBeReversedException(LoanChargeWaiveCannotBeReversedException.LoanChargeWaiveCannotUndoReason.ALREADY_PAID, (Long)loanCharge.getId());
        }
        Long loanId = (Long)loanTransaction.getLoan().getId();
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        if (!loan.getStatus().isActive()) {
            throw new LoanChargeWaiveCannotBeReversedException(LoanChargeWaiveCannotBeReversedException.LoanChargeWaiveCannotUndoReason.LOAN_INACTIVE, (Long)loanCharge.getId());
        }
        if (loan.isChargedOff() && !DateUtils.isAfter((LocalDate)loanTransaction.getTransactionDate(), (LocalDate)loan.getChargedOffOnDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.transaction.date.cannot.be.earlier.than.charge.off.date", "Undo Loan transaction: " + String.valueOf(loanTransaction.getId()) + " is not allowed before or on the date when the loan got charged-off", new Object[]{loanTransaction.getId()});
        }
        LinkedHashMap<String, Serializable> changes = new LinkedHashMap<String, Serializable>();
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanWaiveChargeUndoBusinessEvent(loanCharge));
        this.undoWaivedCharge(changes, loan, loanTransaction, loanChargePaidBy);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanWaiveChargeUndoBusinessEvent(loanCharge));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        changes.put("principalPortion", loanTransaction.getPrincipalPortion());
        changes.put("interestPortion", loanTransaction.getInterestPortion());
        changes.put("feeChargesPortion", loanTransaction.getFeeChargesPortion());
        changes.put("penaltyChargesPortion", loanTransaction.getPenaltyChargesPortion());
        changes.put("outstandingLoanBalance", loanTransaction.getOutstandingLoanBalance());
        changes.put("id", loanTransaction.getId());
        changes.put("externalId", (Serializable)loanTransaction.getExternalId());
        changes.put("date", loanTransaction.getTransactionDate());
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)loanCharge.getId()).withEntityExternalId(loanCharge.getExternalId()).withSubEntityId((Long)loanTransaction.getId()).withSubEntityExternalId(loanTransaction.getExternalId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult updateLoanCharge(Long loanId, Long loanChargeId, JsonCommand command) {
        this.loanChargeApiJsonValidator.validateUpdateOfLoanCharge(command.json());
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        if (!loan.getStatus().isSubmittedAndPendingApproval()) {
            throw new LoanChargeCannotBeUpdatedException(LoanChargeCannotBeUpdatedException.LoanChargeCannotBeUpdatedReason.LOAN_NOT_IN_SUBMITTED_AND_PENDING_APPROVAL_STAGE, (Long)loanCharge.getId());
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanUpdateChargeBusinessEvent(loanCharge));
        this.loanChargeValidator.validateLoanIsNotClosed(loan, loanCharge);
        LinkedHashMap changes = new LinkedHashMap(3);
        if (loan.getActiveCharges().contains(loanCharge)) {
            BigDecimal amount = this.loanChargeService.calculateAmountPercentageAppliedTo(loan, loanCharge);
            Map loanChargeChanges = this.loanChargeService.update(command, amount, loanCharge);
            changes.putAll(loanChargeChanges);
            loan.updateSummaryWithTotalFeeChargesDueAtDisbursement(loan.deriveSumTotalOfChargesDueAtDisbursement());
        }
        if (!loanCharge.isDueAtDisbursement()) {
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        } else {
            LoanRepaymentScheduleProcessingWrapper wrapper = new LoanRepaymentScheduleProcessingWrapper();
            wrapper.reprocess(loan.getCurrency(), loan.getDisbursementDate(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        }
        this.loanRepositoryWrapper.save(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUpdateChargeBusinessEvent(loanCharge));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanChargeId).withEntityExternalId(loanCharge.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult waiveLoanCharge(Long loanId, Long loanChargeId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        this.loanChargeApiJsonValidator.validateInstallmentChargeTransaction(command.json());
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        if (!loan.getStatus().isActive()) {
            throw new LoanChargeCannotBeWaivedException(LoanChargeCannotBeWaivedException.LoanChargeCannotBeWaivedReason.LOAN_INACTIVE, (Long)loanCharge.getId());
        }
        if (loanCharge.isWaived()) {
            throw new LoanChargeCannotBeWaivedException(LoanChargeCannotBeWaivedException.LoanChargeCannotBeWaivedReason.ALREADY_WAIVED, (Long)loanCharge.getId());
        }
        if (loanCharge.isPaid()) {
            throw new LoanChargeCannotBeWaivedException(LoanChargeCannotBeWaivedException.LoanChargeCannotBeWaivedReason.ALREADY_PAID, (Long)loanCharge.getId());
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanWaiveChargeBusinessEvent(loanCharge));
        Integer loanInstallmentNumber = null;
        if (loanCharge.isInstalmentFee()) {
            LoanInstallmentCharge chargePerInstallment = null;
            if (!StringUtils.isBlank((CharSequence)command.json())) {
                LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
                Integer installmentNumber = command.integerValueOfParameterNamed("installmentNumber");
                if (dueDate != null) {
                    chargePerInstallment = loanCharge.getInstallmentLoanCharge(dueDate);
                } else if (installmentNumber != null) {
                    chargePerInstallment = loanCharge.getInstallmentLoanCharge(installmentNumber);
                }
            }
            if (chargePerInstallment == null) {
                chargePerInstallment = loanCharge.getUnpaidInstallmentLoanCharge();
            }
            if (chargePerInstallment.isWaived()) {
                throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_WAIVED, (Long)loanCharge.getId());
            }
            if (chargePerInstallment.isPaid()) {
                throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_PAID, (Long)loanCharge.getId());
            }
            loanInstallmentNumber = chargePerInstallment.getRepaymentInstallment().getInstallmentNumber();
        }
        LinkedHashMap<String, ExternalId> changes = new LinkedHashMap<String, ExternalId>();
        changes.put("externalId", externalId);
        LocalDate recalculateFrom = null;
        ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
        Money accruedCharge = Money.zero((MonetaryCurrency)loan.getCurrency());
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
            Collection chargePaidByCollection = this.loanChargeReadPlatformService.retrieveLoanChargesPaidBy((Long)loanCharge.getId(), LoanTransactionType.ACCRUAL, loanInstallmentNumber);
            for (LoanChargePaidByData chargePaidByData : chargePaidByCollection) {
                accruedCharge = accruedCharge.plus(chargePaidByData.getAmount());
            }
        }
        this.loanChargeValidator.validateLoanIsNotClosed(loan, loanCharge);
        LoanTransaction waiveTransaction = this.waiveLoanCharge(loan, loanCharge, changes, loanInstallmentNumber, scheduleGeneratorDTO, accruedCharge, externalId);
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && DateUtils.isBefore((LocalDate)loanCharge.getDueLocalDate(), (LocalDate)DateUtils.getBusinessLocalDate())) {
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
        }
        this.loanTransactionRepository.saveAndFlush((Object)waiveTransaction);
        this.loanRepositoryWrapper.save(loan);
        this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(waiveTransaction, false, false);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanWaiveChargeBusinessEvent(loanCharge));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanChargeId).withEntityExternalId(loanCharge.getExternalId()).withSubEntityId((Long)waiveTransaction.getId()).withSubEntityExternalId(waiveTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult deleteLoanCharge(Long loanId, Long loanChargeId, JsonCommand command) {
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        if (!loan.getStatus().isSubmittedAndPendingApproval()) {
            throw new LoanChargeCannotBeDeletedException(LoanChargeCannotBeDeletedException.LoanChargeCannotBeDeletedReason.LOAN_NOT_IN_SUBMITTED_AND_PENDING_APPROVAL_STAGE, (Long)loanCharge.getId());
        }
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanDeleteChargeBusinessEvent(loanCharge));
        this.loanChargeValidator.validateLoanIsNotClosed(loan, loanCharge);
        this.loanChargeValidator.validateLoanChargeIsNotWaived(loan, loanCharge);
        this.reprocessLoanTransactionsService.removeLoanCharge(loan, loanCharge);
        this.loanRepositoryWrapper.save(loan);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanDeleteChargeBusinessEvent(loanCharge));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanChargeId).withEntityExternalId(loanCharge.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).build();
    }

    @Transactional
    public CommandProcessingResult payLoanCharge(Long loanId, Long loanChargeId, JsonCommand command, boolean isChargeIdIncludedInJson) {
        PortfolioAccountData portfolioAccountData;
        this.loanChargeApiJsonValidator.validateChargePaymentTransaction(command.json(), isChargeIdIncludedInJson);
        if (isChargeIdIncludedInJson) {
            loanChargeId = command.longValueOfParameterNamed("chargeId");
        }
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        this.checkClientOrGroupActive(loan);
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        if (!loan.getStatus().isActive()) {
            throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.LOAN_INACTIVE, (Long)loanCharge.getId());
        }
        if (loanCharge.isWaived()) {
            throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_WAIVED, (Long)loanCharge.getId());
        }
        if (loanCharge.isPaid()) {
            throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_PAID, (Long)loanCharge.getId());
        }
        if (!loanCharge.getChargePaymentMode().isPaymentModeAccountTransfer()) {
            throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.CHARGE_NOT_ACCOUNT_TRANSFER, (Long)loanCharge.getId());
        }
        LocalDate transactionDate = command.localDateValueOfParameterNamed("transactionDate");
        Locale locale = command.extractLocale();
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern(command.dateFormat()).withLocale(locale);
        Integer loanInstallmentNumber = null;
        BigDecimal amount = loanCharge.amountOutstanding();
        if (loanCharge.isInstalmentFee()) {
            LoanInstallmentCharge chargePerInstallment = null;
            LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
            Integer installmentNumber = command.integerValueOfParameterNamed("installmentNumber");
            if (dueDate != null) {
                chargePerInstallment = loanCharge.getInstallmentLoanCharge(dueDate);
            } else if (installmentNumber != null) {
                chargePerInstallment = loanCharge.getInstallmentLoanCharge(installmentNumber);
            }
            if (chargePerInstallment == null) {
                chargePerInstallment = loanCharge.getUnpaidInstallmentLoanCharge();
            }
            if (chargePerInstallment.isWaived()) {
                throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_WAIVED, (Long)loanCharge.getId());
            }
            if (chargePerInstallment.isPaid()) {
                throw new LoanChargeCannotBePayedException(LoanChargeCannotBePayedException.LoanChargeCannotBePayedReason.ALREADY_PAID, (Long)loanCharge.getId());
            }
            loanInstallmentNumber = chargePerInstallment.getRepaymentInstallment().getInstallmentNumber();
            amount = chargePerInstallment.getAmountOutstanding();
        }
        if ((portfolioAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation(loanId)) == null) {
            String errorMessage = "Charge with id:" + loanChargeId + " requires linked savings account for payment";
            throw new LinkedAccountRequiredException("loanCharge.pay", errorMessage, new Object[]{loanChargeId});
        }
        SavingsAccount fromSavingsAccount = null;
        boolean isRegularTransaction = true;
        boolean isExceptionForBalanceCheck = false;
        AccountTransferDTO accountTransferDTO = new AccountTransferDTO(transactionDate, amount, PortfolioAccountType.SAVINGS, PortfolioAccountType.LOAN, portfolioAccountData.getId(), loanId, "Loan Charge Payment", locale, fmt, null, null, LoanTransactionType.CHARGE_PAYMENT.getValue(), loanChargeId, loanInstallmentNumber, AccountTransferType.CHARGE_PAYMENT.getValue(), null, null, externalId, null, null, fromSavingsAccount, Boolean.valueOf(true), Boolean.valueOf(false));
        Long transferTransactionId = this.accountTransfersWritePlatformService.transferFunds(accountTransferDTO);
        AccountTransferDetails transferDetails = (AccountTransferDetails)this.accountTransferDetailRepository.findById((Object)transferTransactionId).orElseThrow(() -> new AccountTransferNotFoundException(transferTransactionId));
        LoanTransaction loanTransaction = ((AccountTransferTransaction)transferDetails.getAccountTransferTransactions().get(0)).getToLoanTransaction();
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId(loanChargeId).withEntityExternalId(loanCharge.getExternalId()).withSubEntityId((Long)loanTransaction.getId()).withSubEntityExternalId(loanTransaction.getExternalId()).withOfficeId(loan.getOfficeId()).withClientId(loan.getClientId()).withGroupId(loan.getGroupId()).withLoanId(loanId).withSavingsId(portfolioAccountData.getId()).build();
    }

    @Transactional
    public CommandProcessingResult adjustmentForLoanCharge(Long loanId, Long loanChargeId, JsonCommand command) {
        this.loanChargeApiJsonValidator.validateLoanChargeAdjustmentRequest(loanId, loanChargeId, command.json());
        LoanCharge loanCharge = this.retrieveLoanChargeBy(loanId, loanChargeId);
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        BigDecimal transactionAmount = command.bigDecimalValueOfParameterNamed("amount");
        ExternalId externalId = this.externalIdFactory.createFromCommand(command, "externalId");
        String locale = command.locale();
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("externalId", externalId);
        changes.put("amount", transactionAmount);
        changes.put("transactionDate", transactionDate);
        changes.put("locale", locale);
        this.loanChargeAdjustmentEntranceValidation(loanCharge, transactionAmount);
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder();
        PaymentDetail paymentDetail = this.paymentDetailWritePlatformService.createPaymentDetail(command, changes);
        if (paymentDetail != null) {
            paymentDetail = this.paymentDetailWritePlatformService.persistPaymentDetail(paymentDetail);
        }
        LoanTransaction loanTransaction = this.applyChargeAdjustment(loan, loanCharge, transactionAmount, transactionDate, externalId, paymentDetail);
        this.loanAccountDomainService.updateAndSaveLoanCollateralTransactionsForIndividualAccounts(loan, loanTransaction);
        String noteText = command.stringValueOfParameterNamed("note");
        if (StringUtils.isNotBlank((CharSequence)noteText)) {
            Note note = Note.loanNote((Loan)loan, (String)noteText);
            changes.put("note", noteText);
            this.noteRepository.save((Object)note);
        }
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanChargeAdjustmentPostBusinessEvent(loanTransaction));
        return commandProcessingResultBuilder.withCommandId(command.commandId()).withLoanId(loanId).withEntityId(loanChargeId).withEntityExternalId(loanCharge.getExternalId()).withSubEntityId((Long)loanTransaction.getId()).withSubEntityExternalId(loanTransaction.getExternalId()).with(changes).build();
    }

    @Transactional
    public CommandProcessingResult deactivateOverdueLoanCharge(Long loanId, JsonCommand command) {
        LocalDate fromDueDate = command.dateValueOfParameterNamed("dueDate");
        List loanCharges = this.loanChargeRepository.findByLoanIdAndFromDueDate(loanId, fromDueDate);
        loanCharges.forEach(arg_0 -> this.inactivateOverdueLoanCharge(arg_0));
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        List repaymentScheduleInstallments = loan.getRepaymentScheduleInstallments(si -> DateUtils.isDateInRangeInclusive((LocalDate)fromDueDate, (LocalDate)si.getFromDate(), (LocalDate)si.getDueDate()) || DateUtils.isAfter((LocalDate)si.getFromDate(), (LocalDate)fromDueDate));
        repaymentScheduleInstallments.forEach(si -> si.setPenaltyAccrued(null));
        List accrualsToReverse = loan.getLoanTransactions(tx -> tx.isNotReversed() && DateUtils.isAfterInclusive((LocalDate)tx.getTransactionDate(), (LocalDate)fromDueDate) && tx.isAccrualRelated());
        accrualsToReverse.forEach(tx -> this.loanAdjustmentService.adjustLoanTransaction(loan, tx, LoanAdjustmentParameter.builder().transactionDate(tx.getTransactionDate()).build(), null, new HashMap()));
        this.loanRepositoryWrapper.saveAndFlush(loan);
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder();
        return commandProcessingResultBuilder.withLoanId(loanId).withEntityId(loanId).withEntityExternalId(loan.getExternalId()).build();
    }

    private void inactivateOverdueLoanCharge(LoanCharge loanCharge) {
        if (!loanCharge.getChargeTimeType().isOverdueInstallment()) {
            throw new LoanChargeDeactivationException("loan.charge.deactivate.invalid.charge.type", "Loan charge is not an overdue installment charge", new Object[0]);
        }
        if (!loanCharge.isActive()) {
            throw new LoanChargeDeactivationException("loan.charge.deactivate.invalid.status", "Loan charge is not active", new Object[0]);
        }
        loanCharge.setActive(false);
        this.loanChargeRepository.saveAndFlush((Object)loanCharge);
        this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanUpdateChargeBusinessEvent(loanCharge));
    }

    @Transactional
    public void applyOverdueChargesForLoan(Long loanId, Collection<OverdueLoanScheduleData> overdueLoanScheduleDataList) {
        if (overdueLoanScheduleDataList.isEmpty()) {
            return;
        }
        Loan loan = this.loanAssembler.assembleFrom(loanId);
        if (loan.isChargedOff()) {
            log.warn("Adding charge to Loan: {} is not allowed. Loan Account is Charged-off", (Object)loanId);
            return;
        }
        Optional<Charge> optPenaltyCharge = loan.getLoanProduct().getCharges().stream().filter(e -> ChargeTimeType.OVERDUE_INSTALLMENT.getValue().equals(e.getChargeTimeType()) && e.isLoanCharge()).findFirst();
        if (optPenaltyCharge.isEmpty()) {
            return;
        }
        boolean runInterestRecalculation = false;
        LocalDate recalculateFrom = DateUtils.getBusinessLocalDate();
        LocalDate lastChargeDate = null;
        for (OverdueLoanScheduleData overdueInstallment : overdueLoanScheduleDataList) {
            JsonElement parsedCommand = this.fromApiJsonHelper.parse(overdueInstallment.toString());
            JsonCommand command = JsonCommand.from((String)overdueInstallment.toString(), (JsonElement)parsedCommand, (FromJsonHelper)this.fromApiJsonHelper, null, null, null, null, null, (Long)loanId, null, null, null, null, null, null, null, null);
            LoanOverdueDTO overdueDTO = this.applyChargeToOverdueLoanInstallment(loan, overdueInstallment.getChargeId(), overdueInstallment.getPeriodNumber(), command);
            loan = overdueDTO.getLoan();
            boolean bl = runInterestRecalculation = runInterestRecalculation || overdueDTO.isRunInterestRecalculation();
            if (DateUtils.isAfter((LocalDate)recalculateFrom, (LocalDate)overdueDTO.getRecalculateFrom())) {
                recalculateFrom = overdueDTO.getRecalculateFrom();
            }
            if (lastChargeDate != null && !DateUtils.isAfter((LocalDate)overdueDTO.getLastChargeAppliedDate(), (LocalDate)lastChargeDate)) continue;
            lastChargeDate = overdueDTO.getLastChargeAppliedDate();
        }
        if (loan != null) {
            boolean reprocessRequired = true;
            LocalDate recalculatedTill = loan.fetchInterestRecalculateFromDate();
            if (DateUtils.isAfter((LocalDate)recalculateFrom, (LocalDate)recalculatedTill)) {
                recalculateFrom = recalculatedTill;
            }
            if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
                if (runInterestRecalculation && loan.isFeeCompoundingEnabledForInterestRecalculation()) {
                    loan = this.runScheduleRecalculation(loan, recalculateFrom);
                    reprocessRequired = false;
                }
                this.loanWritePlatformService.updateOriginalSchedule(loan);
            }
            if (reprocessRequired) {
                this.addInstallmentIfPenaltyAppliedAfterLastDueDate(loan, lastChargeDate);
                if (loan.isProgressiveSchedule() && (loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy() || loan.hasContractTerminationTransaction())) {
                    ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
                    this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
                }
                this.reprocessLoanTransactionsService.reprocessTransactions(loan);
                loan = this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
            }
            if (loan.isInterestBearingAndInterestRecalculationEnabled() && runInterestRecalculation && loan.isFeeCompoundingEnabledForInterestRecalculation()) {
                this.loanAccrualsProcessingService.processAccrualsOnInterestRecalculation(loan, true, true);
            }
            this.loanAccountDomainService.setLoanDelinquencyTag(loan, DateUtils.getBusinessLocalDate());
        }
    }

    private LoanTransaction applyChargeAdjustment(Loan loan, LoanCharge loanCharge, BigDecimal transactionAmount, LocalDate transactionDate, ExternalId txnExternalId, PaymentDetail paymentDetail) {
        this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanChargeAdjustmentPreBusinessEvent(loan));
        LoanTransaction loanChargeAdjustmentTransaction = LoanTransaction.chargeAdjustment((Loan)loan, (BigDecimal)transactionAmount, (LocalDate)transactionDate, (ExternalId)txnExternalId, (PaymentDetail)paymentDetail);
        LoanTransactionRelation loanTransactionRelation = LoanTransactionRelation.linkToCharge((LoanTransaction)loanChargeAdjustmentTransaction, (LoanCharge)loanCharge, (LoanTransactionRelationTypeEnum)LoanTransactionRelationTypeEnum.CHARGE_ADJUSTMENT);
        loanChargeAdjustmentTransaction.getLoanTransactionRelations().add(loanTransactionRelation);
        LoanRepaymentScheduleTransactionProcessor loanRepaymentScheduleTransactionProcessor = this.loanRepaymentScheduleTransactionProcessorFactory.determineProcessor(loan.transactionProcessingStrategy());
        loan.addLoanTransaction(loanChargeAdjustmentTransaction);
        if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            if (loan.isProgressiveSchedule() && (loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy() || loan.hasContractTerminationTransaction())) {
                ScheduleGeneratorDTO scheduleGeneratorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, null);
                this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
            }
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        } else {
            loanRepaymentScheduleTransactionProcessor.processLatestTransaction(loanChargeAdjustmentTransaction, new TransactionCtx(loan.getCurrency(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges(), new MoneyHolder(loan.getTotalOverpaidAsMoney()), null));
        }
        this.loanAccountService.saveLoanTransactionWithDataIntegrityViolationChecks(loanChargeAdjustmentTransaction);
        this.loanLifecycleStateMachine.determineAndTransition(loan, loan.getLastUserTransactionDate());
        this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(loanChargeAdjustmentTransaction, false, false);
        this.loanAccountDomainService.setLoanDelinquencyTag(loan, transactionDate);
        return loanChargeAdjustmentTransaction;
    }

    private void undoWaivedCharge(Map<String, Object> changes, Loan loan, LoanTransaction loanTransaction, LoanChargePaidBy loanChargePaidBy) {
        switch (1.$SwitchMap$org$apache$fineract$portfolio$charge$domain$ChargeTimeType[loanChargePaidBy.getLoanCharge().getChargeTimeType().ordinal()]) {
            case 1: {
                this.undoSpecifiedDueDateCharge(changes, loan, loanTransaction, loanChargePaidBy);
                break;
            }
            case 2: {
                this.undoInstalmentFee(changes, loan, loanTransaction, loanChargePaidBy);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Undo waive charge is not support for this charge: " + String.valueOf(loanChargePaidBy.getLoanCharge().getChargeTimeType()));
            }
        }
    }

    private void undoInstalmentFee(Map<String, Object> changes, Loan loan, LoanTransaction loanTransaction, LoanChargePaidBy loanChargePaidBy) {
        BigDecimal amountWaived;
        LoanCharge loanCharge = loanChargePaidBy.getLoanCharge();
        Integer installmentNumber = loanChargePaidBy.getInstallmentNumber();
        if (installmentNumber != null) {
            LoanInstallmentCharge chargePerInstallment = loanCharge.getInstallmentLoanCharge(installmentNumber);
            amountWaived = chargePerInstallment.getAmountWaived(loan.getCurrency()).getAmount();
            if (!chargePerInstallment.isWaived() || amountWaived == null) {
                throw new LoanChargeWaiveCannotBeReversedException(LoanChargeWaiveCannotBeReversedException.LoanChargeWaiveCannotUndoReason.NOT_WAIVED, (Long)loanCharge.getId());
            }
            this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loanTransaction.getLoan(), loanTransaction, "reversed");
            loanTransaction.reverse();
            loanTransaction.setManuallyAdjustedOrReversed();
            BigDecimal amountOutstanding = loanCharge.getAmountOutstanding(loan.getCurrency()).getAmount();
            loanCharge.setOutstandingAmount(amountOutstanding.add(amountWaived));
            BigDecimal totalAmountWaved = loanCharge.getAmountWaived(loan.getCurrency()).getAmount();
            loanCharge.setAmountWaived(totalAmountWaved.subtract(amountWaived));
            BigDecimal amountOutstandingPerInstallment = chargePerInstallment.getAmountOutstanding();
            chargePerInstallment.setOutstandingAmount(amountOutstandingPerInstallment.add(amountWaived));
            chargePerInstallment.setAmountWaived(null);
            chargePerInstallment.undoWaiveFlag();
            this.updateRepaymentInstalmentWithWaivedAmount(loanCharge, chargePerInstallment.getInstallment(), amountWaived);
            loanCharge.setInstallmentLoanCharge(chargePerInstallment, chargePerInstallment.getInstallment().getInstallmentNumber());
            if (loanCharge.amount().compareTo(loanCharge.amountOutstanding()) == 0 && loanCharge.isWaived()) {
                loanCharge.undoWaived();
            }
        } else {
            throw new InstallmentNotFoundException((Long)loanTransaction.getId());
        }
        loan.updateLoanSummaryForUndoWaiveCharge(amountWaived, loanCharge.isPenaltyCharge());
        this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
        changes.put("amount", amountWaived);
    }

    private void undoSpecifiedDueDateCharge(Map<String, Object> changes, Loan loan, LoanTransaction loanTransaction, LoanChargePaidBy loanChargePaidBy) {
        LoanCharge loanCharge = loanChargePaidBy.getLoanCharge();
        BigDecimal amountWaived = loanCharge.getAmountWaived(loan.getCurrency()).getAmount();
        if (!loanCharge.isWaived() || amountWaived == null) {
            throw new LoanChargeWaiveCannotBeReversedException(LoanChargeWaiveCannotBeReversedException.LoanChargeWaiveCannotUndoReason.NOT_WAIVED, (Long)loanCharge.getId());
        }
        this.loanChargeValidator.validateRepaymentTypeTransactionNotBeforeAChargeRefund(loanTransaction.getLoan(), loanTransaction, "reversed");
        loanTransaction.reverse();
        loanTransaction.setManuallyAdjustedOrReversed();
        loanCharge.setOutstandingAmount(loanCharge.amountOutstanding().add(amountWaived));
        loanCharge.setAmountWaived(null);
        loanCharge.undoWaived();
        LoanRepaymentScheduleInstallment installment = loan.getRepaymentScheduleInstallments().stream().filter(e -> LoanChargeWritePlatformServiceImpl.isPartOfThisInstallment((LoanCharge)loanCharge, (LoanRepaymentScheduleInstallment)e)).findFirst().orElseThrow();
        this.updateRepaymentInstalmentWithWaivedAmount(loanCharge, installment, amountWaived);
        loan.updateLoanSummaryForUndoWaiveCharge(amountWaived, loanCharge.isPenaltyCharge());
        this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
        changes.put("amount", amountWaived);
    }

    private void updateRepaymentInstalmentWithWaivedAmount(LoanCharge loanCharge, LoanRepaymentScheduleInstallment installment, BigDecimal amountWaived) {
        if (loanCharge.isPenaltyCharge()) {
            BigDecimal penaltyChargesWaivedAmount = installment.getPenaltyChargesWaived(loanCharge.getLoan().getCurrency()).getAmount();
            installment.setPenaltyChargesWaived(penaltyChargesWaivedAmount.subtract(amountWaived));
        } else {
            BigDecimal feeChargesWaivedAmount = installment.getFeeChargesWaived(loanCharge.getLoan().getCurrency()).getAmount();
            installment.setFeeChargesWaived(feeChargesWaivedAmount.subtract(amountWaived));
        }
    }

    private void validateAddingNewChargeAllowed(List<LoanDisbursementDetails> loanDisburseDetails) {
        boolean pendingDisbursementAvailable = false;
        for (LoanDisbursementDetails disbursementDetail : loanDisburseDetails) {
            if (disbursementDetail.actualDisbursementDate() != null) continue;
            pendingDisbursementAvailable = true;
            break;
        }
        if (!pendingDisbursementAvailable) {
            throw new ChargeCannotBeUpdatedException("error.msg.charge.cannot.be.updated.no.pending.disbursements.in.loan", "This charge cannot be added, No disbursement is pending", new Object[0]);
        }
    }

    private void validateAddLoanCharge(Loan loan, Charge chargeDefinition, LoanCharge loanCharge) {
        if (chargeDefinition.isOverdueInstallment()) {
            String defaultUserMessage = "Installment charge cannot be added to the loan.";
            throw new LoanChargeCannotBeAddedException("loanCharge", "overdue.charge", "Installment charge cannot be added to the loan.", new Object[]{null, chargeDefinition.getName()});
        }
        if (loanCharge.getDueLocalDate() != null) {
            LocalDate validationDate;
            boolean isCumulative = loan.getLoanRepaymentScheduleDetail().getLoanScheduleType().equals((Object)LoanScheduleType.CUMULATIVE);
            LocalDate localDate = validationDate = loan.isInterestBearingAndInterestRecalculationEnabled() && isCumulative ? loan.getLastUserTransactionDate() : loan.getDisbursementDate();
            if (DateUtils.isBefore((LocalDate)loanCharge.getDueLocalDate(), (LocalDate)validationDate)) {
                String defaultUserMessage = "charge with date before last transaction date can not be added to loan.";
                throw new LoanChargeCannotBeAddedException("loanCharge", "date.is.before.last.transaction.date", "charge with date before last transaction date can not be added to loan.", new Object[]{null, chargeDefinition.getName()});
            }
        } else if (loan.isInterestBearingAndInterestRecalculationEnabled()) {
            ArrayList dataValidationErrors = new ArrayList();
            HashSet<LoanCharge> loanCharges = new HashSet<LoanCharge>(1);
            loanCharges.add(loanCharge);
            this.loanChargeApiJsonValidator.validateLoanCharges(loanCharges, dataValidationErrors);
            if (!dataValidationErrors.isEmpty()) {
                throw new PlatformApiDataValidationException(dataValidationErrors);
            }
        }
    }

    private boolean addCharge(Loan loan, Charge chargeDefinition, LoanCharge loanCharge) {
        PortfolioAccountData portfolioAccountData;
        if (!loan.hasCurrencyCodeOf(chargeDefinition.getCurrencyCode())) {
            String errorMessage = "Charge and Loan must have the same currency.";
            throw new InvalidCurrencyException("loanCharge", "attach.to.loan", "Charge and Loan must have the same currency.", new Object[0]);
        }
        if (loanCharge.getChargePaymentMode().isPaymentModeAccountTransfer() && (portfolioAccountData = this.accountAssociationsReadPlatformService.retriveLoanLinkedAssociation((Long)loan.getId())) == null) {
            String errorMessage = loanCharge.name() + "Charge  requires linked savings account for payment";
            throw new LinkedAccountRequiredException("loanCharge.add", errorMessage, new Object[]{loanCharge.name()});
        }
        this.loanChargeValidator.validateChargeAdditionForDisbursedLoan(loan, loanCharge);
        this.loanChargeValidator.validateChargeHasValidSpecifiedDateIfApplicable(loan, loanCharge, loan.getDisbursementDate());
        this.loanChargeService.addLoanCharge(loan, loanCharge);
        loanCharge = (LoanCharge)this.loanChargeRepository.saveAndFlush((Object)loanCharge);
        if (loan.getStatus().isActive() && loan.isNoneOrCashOrUpfrontAccrualAccountingEnabledOnLoanProduct().booleanValue() || loan.getStatus().isOverpaid() || loan.getStatus().isClosedObligationsMet()) {
            LoanTransaction applyLoanChargeTransaction = this.loanChargeService.handleChargeAppliedTransaction(loan, loanCharge, null);
            if (applyLoanChargeTransaction != null) {
                this.loanTransactionRepository.saveAndFlush((Object)applyLoanChargeTransaction);
                this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(applyLoanChargeTransaction, false, false);
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAccrualTransactionCreatedBusinessEvent(applyLoanChargeTransaction));
            }
        } else if (this.configurationDomainService.isImmediateChargeAccrualPostMaturityEnabled() && DateUtils.getBusinessLocalDate().isAfter(loan.getMaturityDate())) {
            LoanTransaction loanTransaction = this.loanChargeService.createChargeAppliedTransaction(loan, loanCharge, null);
            this.loanTransactionRepository.saveAndFlush((Object)loanTransaction);
            this.loanJournalEntryPoster.postJournalEntriesForLoanTransaction(loanTransaction, false, false);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanAccrualTransactionCreatedBusinessEvent(loanTransaction));
        }
        return DateUtils.isBeforeBusinessDate((LocalDate)loanCharge.getDueLocalDate());
    }

    private LoanOverdueDTO applyChargeToOverdueLoanInstallment(Loan loan, Long loanChargeId, Integer periodNumber, JsonCommand command) {
        boolean runInterestRecalculation = false;
        Charge chargeDefinition = this.chargeRepository.findOneWithNotFoundDetection(loanChargeId);
        Collection frequencyNumbers = this.loanChargeReadPlatformService.retrieveOverdueInstallmentChargeFrequencyNumber(loan, chargeDefinition, periodNumber);
        Integer feeFrequency = chargeDefinition.feeFrequency();
        DefaultScheduledDateGenerator scheduledDateGenerator = new DefaultScheduledDateGenerator();
        HashMap<Integer, LocalDate> scheduleDates = new HashMap<Integer, LocalDate>();
        Long penaltyWaitPeriodValue = this.configurationDomainService.retrievePenaltyWaitPeriod();
        Long penaltyPostingWaitPeriodValue = this.configurationDomainService.retrieveGraceOnPenaltyPostingPeriod();
        LocalDate dueDate = command.localDateValueOfParameterNamed("dueDate");
        long diff = penaltyWaitPeriodValue + 1L - penaltyPostingWaitPeriodValue;
        if (diff < 1L) {
            diff = 1L;
        }
        LocalDate startDate = dueDate.plusDays(penaltyWaitPeriodValue + 1L);
        int frequencyNumber = 1;
        if (feeFrequency == null) {
            scheduleDates.put(frequencyNumber++, startDate.minusDays(diff));
        } else {
            while (!DateUtils.isDateInTheFuture((LocalDate)startDate)) {
                scheduleDates.put(frequencyNumber++, startDate.minusDays(diff));
                startDate = scheduledDateGenerator.getRepaymentPeriodDate(PeriodFrequencyType.fromInt((Integer)feeFrequency), chargeDefinition.feeInterval().intValue(), startDate);
            }
        }
        for (Integer frequency : frequencyNumbers) {
            scheduleDates.remove(frequency);
        }
        LoanRepaymentScheduleInstallment installment = null;
        LocalDate lastChargeAppliedDate = dueDate;
        LocalDate recalculateFrom = DateUtils.getBusinessLocalDate();
        if (!scheduleDates.isEmpty()) {
            installment = loan.fetchRepaymentScheduleInstallment(periodNumber);
            lastChargeAppliedDate = installment.getDueDate();
            this.businessEventNotifierService.notifyPreBusinessEvent((BusinessEvent)new LoanApplyOverdueChargeBusinessEvent(loan));
            for (Map.Entry entry : scheduleDates.entrySet()) {
                LoanCharge loanCharge = this.loanChargeAssembler.createNewFromJson(loan, chargeDefinition, command, (LocalDate)entry.getValue());
                if (BigDecimal.ZERO.compareTo(loanCharge.amount()) == 0) continue;
                LoanOverdueInstallmentCharge overdueInstallmentCharge = new LoanOverdueInstallmentCharge(loanCharge, installment, (Integer)entry.getKey());
                loanCharge.updateOverdueInstallmentCharge(overdueInstallmentCharge);
                boolean isAppliedOnBackDate = this.addCharge(loan, chargeDefinition, loanCharge);
                boolean bl = runInterestRecalculation = runInterestRecalculation || isAppliedOnBackDate;
                if (DateUtils.isBefore((LocalDate)((LocalDate)entry.getValue()), (LocalDate)recalculateFrom)) {
                    recalculateFrom = (LocalDate)entry.getValue();
                }
                if (!DateUtils.isAfter((LocalDate)((LocalDate)entry.getValue()), (LocalDate)lastChargeAppliedDate)) continue;
                lastChargeAppliedDate = (LocalDate)entry.getValue();
            }
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanApplyOverdueChargeBusinessEvent(loan));
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanBalanceChangedBusinessEvent(loan));
        }
        return new LoanOverdueDTO(loan, runInterestRecalculation, recalculateFrom, lastChargeAppliedDate);
    }

    private void addInstallmentIfPenaltyAppliedAfterLastDueDate(Loan loan, LocalDate lastChargeDate) {
        List installments;
        LoanRepaymentScheduleInstallment lastInstallment;
        if (lastChargeDate != null && DateUtils.isAfter((LocalDate)lastChargeDate, (LocalDate)(lastInstallment = loan.fetchRepaymentScheduleInstallment(Integer.valueOf((installments = loan.getRepaymentScheduleInstallments()).size()))).getDueDate())) {
            if (lastInstallment.isRecalculatedInterestComponent()) {
                installments.remove(lastInstallment);
                lastInstallment = loan.fetchRepaymentScheduleInstallment(Integer.valueOf(installments.size()));
            }
            boolean recalculatedInterestComponent = true;
            BigDecimal principal = BigDecimal.ZERO;
            BigDecimal interest = BigDecimal.ZERO;
            BigDecimal feeCharges = BigDecimal.ZERO;
            BigDecimal penaltyCharges = BigDecimal.ONE;
            Set compoundingDetails = null;
            LoanRepaymentScheduleInstallment newEntry = new LoanRepaymentScheduleInstallment(loan, Integer.valueOf(installments.size() + 1), lastInstallment.getDueDate(), lastChargeDate, principal, interest, feeCharges, penaltyCharges, recalculatedInterestComponent, compoundingDetails);
            loan.addLoanRepaymentScheduleInstallment(newEntry);
        }
    }

    public Loan runScheduleRecalculation(Loan loan, LocalDate recalculateFrom) {
        if (loan.isInterestBearingAndInterestRecalculationEnabled() && !loan.isChargedOff()) {
            ScheduleGeneratorDTO generatorDTO = this.loanUtilService.buildScheduleGeneratorDTO(loan, recalculateFrom);
            this.loanScheduleService.handleRegenerateRepaymentScheduleWithInterestRecalculation(loan, generatorDTO);
            this.loanAccrualsProcessingService.reprocessExistingAccruals(loan, true);
            this.loanAccrualsProcessingService.processIncomePostingAndAccruals(loan, true);
            loan = this.loanAccountService.saveAndFlushLoanWithDataIntegrityViolationChecks(loan);
        }
        return loan;
    }

    private JsonCommand adaptLoanChargeRefundCommandForFurtherRepaymentProcessing(JsonCommand command, BigDecimal fullRefundAbleAmount) {
        String dateFormat;
        JsonObject jsonObject = (JsonObject)this.fromApiJsonHelper.parse(command.json());
        if (this.fromApiJsonHelper.parameterExists("dateFormat", (JsonElement)jsonObject)) {
            dateFormat = this.fromApiJsonHelper.extractStringNamed("dateFormat", (JsonElement)jsonObject);
        } else {
            dateFormat = "dd MMMM yyyy";
            jsonObject.addProperty("dateFormat", dateFormat);
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(dateFormat);
        LocalDate transactionDate = DateUtils.getBusinessLocalDate();
        String transactionDateString = transactionDate.format(dateTimeFormatter);
        jsonObject.addProperty("transactionDate", transactionDateString);
        if (!this.fromApiJsonHelper.parameterExists("transactionAmount", (JsonElement)jsonObject)) {
            jsonObject.addProperty("transactionAmount", fullRefundAbleAmount.toString());
        }
        jsonObject.remove("loanChargeId");
        jsonObject.remove("installmentNumber");
        jsonObject.remove("dueDate");
        return JsonCommand.fromExistingCommand((JsonCommand)command, (JsonElement)jsonObject);
    }

    private BigDecimal loanChargeValidateRefundAmount(LoanCharge loanCharge, LoanInstallmentCharge installmentChargeEntry, BigDecimal transactionAmount) {
        BigDecimal chargeAmountPaid;
        BigDecimal chargeAmountRefunded = BigDecimal.ZERO;
        MonetaryCurrency loanCurrency = loanCharge.getLoan().getCurrency();
        if (loanCharge.isInstalmentFee() && installmentChargeEntry != null) {
            Integer installmentNumber = installmentChargeEntry.getRepaymentInstallment().getInstallmentNumber();
            chargeAmountPaid = installmentChargeEntry.getAmountPaid(loanCurrency).getAmount();
            for (LoanChargePaidBy loanChargePaidBy : loanCharge.getLoanChargePaidBySet()) {
                if (!installmentNumber.equals(loanChargePaidBy.getInstallmentNumber()) || !this.isRefundElementOfChargeRefund(loanChargePaidBy)) continue;
                chargeAmountRefunded = chargeAmountRefunded.add(loanChargePaidBy.getAmount());
            }
        } else {
            chargeAmountPaid = loanCharge.getAmountPaid(loanCurrency).getAmount();
            for (LoanChargePaidBy loanChargePaidBy : loanCharge.getLoanChargePaidBySet()) {
                if (!this.isRefundElementOfChargeRefund(loanChargePaidBy)) continue;
                chargeAmountRefunded = chargeAmountRefunded.add(loanChargePaidBy.getAmount());
            }
        }
        if ((chargeAmountRefunded = chargeAmountRefunded.multiply(BigDecimal.valueOf(-1L))).compareTo(chargeAmountPaid) > 0) {
            String errorMessage = "loan.charge.more.refunded.than.paid.unexpected.system.error";
            String details = "Paid: " + chargeAmountPaid.toString() + "  Refunded: " + String.valueOf(chargeAmountPaid);
            throw new LoanChargeRefundException("loan.charge.more.refunded.than.paid.unexpected.system.error", new Object[]{details});
        }
        BigDecimal refundableAmount = chargeAmountPaid.subtract(chargeAmountRefunded);
        if (transactionAmount != null && transactionAmount.compareTo(refundableAmount) > 0) {
            String errorMessage = "loan.charge.transaction.amount.is.more.than.is.refundable";
            String details = "transactionAmount: " + String.valueOf(transactionAmount) + "  Refundable: " + String.valueOf(refundableAmount);
            throw new LoanChargeRefundException("loan.charge.transaction.amount.is.more.than.is.refundable", new Object[]{details});
        }
        return refundableAmount;
    }

    private LoanCharge retrieveLoanChargeBy(Long loanId, Long loanChargeId) {
        LoanCharge loanCharge = (LoanCharge)this.loanChargeRepository.findById((Object)loanChargeId).orElseThrow(() -> new LoanChargeNotFoundException(loanChargeId));
        if (loanCharge.hasNotLoanIdentifiedBy(loanId)) {
            throw new LoanChargeNotFoundException(loanChargeId, loanId);
        }
        return loanCharge;
    }

    private boolean isRefundElementOfChargeRefund(LoanChargePaidBy loanChargePaidBy) {
        return loanChargePaidBy.getLoanTransaction().isChargeRefund() && loanChargePaidBy.getAmount().compareTo(BigDecimal.ZERO) < 0;
    }

    private LoanInstallmentCharge loanChargeRefundEntranceValidation(LoanCharge loanCharge, Integer installmentNumber, LocalDate dueDate) {
        LoanInstallmentCharge installmentChargeEntry = null;
        Loan loan = loanCharge.getLoan();
        if (!(loan.isOpen() || loan.getStatus().isClosedObligationsMet() || loan.getStatus().isOverpaid())) {
            String errorMessage = "loan.charge.refund.invalid.status";
            throw new LoanChargeRefundException("loan.charge.refund.invalid.status", new Object[]{loan.getStatus().toString()});
        }
        if (dueDate != null && installmentNumber != null) {
            this.throwLoanChargeRefundException("loan.charge.refund.dueDate.and.installmentNumber.provided.use.only.one", installmentNumber, dueDate);
        }
        if (loanCharge.isInstalmentFee()) {
            if (dueDate == null && installmentNumber == null) {
                this.throwLoanChargeRefundException("loan.charge.refund.neither.dueDate.nor.installmentNumber.provided.for.this.installment.charge", installmentNumber, dueDate);
            }
            if (dueDate != null) {
                installmentChargeEntry = loanCharge.getInstallmentLoanCharge(dueDate);
            } else if (installmentNumber != null) {
                installmentChargeEntry = loanCharge.getInstallmentLoanCharge(installmentNumber);
            }
            if (installmentChargeEntry == null) {
                this.throwLoanChargeRefundException("loan.charge.refund.installment.not.found", installmentNumber, dueDate);
            }
        } else if (dueDate != null || installmentNumber != null) {
            this.throwLoanChargeRefundException("loan.charge.refund.dueDate.or.installmentNumber.provided.but.this.is.not.an.installment.charge", installmentNumber, dueDate);
        }
        return installmentChargeEntry;
    }

    private void loanChargeAdjustmentEntranceValidation(LoanCharge loanCharge, BigDecimal transactionAmount) {
        Loan loan = loanCharge.getLoan();
        if (!(loan.isOpen() || loan.getStatus().isClosedObligationsMet() || loan.getStatus().isOverpaid())) {
            String errorCode = "loan.charge.adjustment.invalid.status";
            throw new LoanChargeAdjustmentException("loan.charge.adjustment.invalid.status", "Adjustment is not supported for the status of " + loan.getStatus().toString(), new Object[0]);
        }
        if (transactionAmount.compareTo(loanCharge.amount()) > 0) {
            String errorCode = "loan.charge.adjustment.invalid.amount";
            throw new LoanChargeAdjustmentException("loan.charge.adjustment.invalid.amount", "Transaction amount cannot be higher than the charge amount: " + String.valueOf(loanCharge.amount()), new Object[0]);
        }
        BigDecimal availableAmountForAdjustment = this.calculateAvailableAmountForChargeAdjustment(loanCharge);
        if (transactionAmount.compareTo(availableAmountForAdjustment) > 0) {
            String errorCode = "loan.charge.adjustment.invalid.amount";
            throw new LoanChargeAdjustmentException("loan.charge.adjustment.invalid.amount", "Transaction amount cannot be higher than the available charge amount for adjustment: " + String.valueOf(availableAmountForAdjustment), new Object[0]);
        }
        this.checkClientOrGroupActive(loan);
        this.loanDownPaymentTransactionValidator.validateAccountStatus(loan, LoanEvent.LOAN_CHARGE_ADJUSTMENT);
    }

    private BigDecimal calculateAvailableAmountForChargeAdjustment(LoanCharge loanCharge) {
        BigDecimal availableAmountForAdjustment = loanCharge.amount();
        for (LoanTransaction loanTransaction : loanCharge.getLoan().getLoanTransactions()) {
            LoanTransactionRelation loanTransactionRelation;
            if (!loanTransaction.isNotReversed() || !loanTransaction.getTypeOf().isChargeAdjustment() || !loanCharge.equals((loanTransactionRelation = loanTransaction.getLoanTransactionRelations().stream().filter(e -> e.getToCharge() != null).findFirst().orElseThrow()).getToCharge())) continue;
            availableAmountForAdjustment = availableAmountForAdjustment.subtract(loanTransaction.getAmount());
        }
        return availableAmountForAdjustment;
    }

    private void throwLoanChargeRefundException(String errorMessage, Integer installmentNumber, LocalDate dueDate) {
        String dueDateValue = "";
        String installmentNumberValue = "";
        if (dueDate != null) {
            dueDateValue = dueDate.toString();
        }
        if (installmentNumber != null) {
            installmentNumberValue = installmentNumber.toString();
        }
        throw new LoanChargeRefundException(errorMessage, new Object[]{"dueDate: " + dueDateValue + "  installmentNumber: " + installmentNumberValue});
    }

    private void checkClientOrGroupActive(Loan loan) {
        Client client = loan.client();
        if (client != null && client.isNotActive()) {
            throw new ClientNotActiveException((Long)client.getId());
        }
        Group group = loan.group();
        if (group != null && group.isNotActive()) {
            throw new GroupNotActiveException((Long)group.getId());
        }
    }

    public LoanTransaction waiveLoanCharge(Loan loan, LoanCharge loanCharge, Map<String, Object> changes, Integer loanInstallmentNumber, ScheduleGeneratorDTO scheduleGeneratorDTO, Money accruedCharge, ExternalId externalId) {
        Money amountWaived = loanCharge.waive(loan.getCurrency(), loanInstallmentNumber);
        changes.put("amount", amountWaived.getAmount());
        Money unrecognizedIncome = amountWaived.zero();
        Money chargeComponent = amountWaived;
        if (loan.isPeriodicAccrualAccountingEnabledOnLoanProduct().booleanValue()) {
            Money receivableCharge = loanInstallmentNumber != null ? accruedCharge.minus(loanCharge.getInstallmentLoanCharge(loanInstallmentNumber).getAmountPaid(loan.getCurrency())) : accruedCharge.minus(loanCharge.getAmountPaid(loan.getCurrency()));
            if (receivableCharge.isLessThanZero()) {
                receivableCharge = amountWaived.zero();
            }
            if (amountWaived.isGreaterThan(receivableCharge)) {
                chargeComponent = receivableCharge;
                unrecognizedIncome = amountWaived.minus(receivableCharge);
            }
        }
        Money feeChargesWaived = chargeComponent;
        Money penaltyChargesWaived = Money.zero((MonetaryCurrency)loan.getCurrency());
        if (loanCharge.isPenaltyCharge()) {
            penaltyChargesWaived = chargeComponent;
            feeChargesWaived = Money.zero((MonetaryCurrency)loan.getCurrency());
        }
        LocalDate transactionDate = loan.getDisbursementDate();
        LocalDate businessDate = DateUtils.getBusinessLocalDate();
        if (loanCharge.isDueDateCharge()) {
            transactionDate = DateUtils.isAfter((LocalDate)loanCharge.getDueLocalDate(), (LocalDate)businessDate) ? businessDate : loanCharge.getDueLocalDate();
        } else if (loanCharge.isInstalmentFee()) {
            LocalDate repaymentDueDate = loanCharge.getInstallmentLoanCharge(loanInstallmentNumber).getRepaymentInstallment().getDueDate();
            transactionDate = DateUtils.isAfter((LocalDate)repaymentDueDate, (LocalDate)businessDate) ? businessDate : repaymentDueDate;
        }
        scheduleGeneratorDTO.setRecalculateFrom(transactionDate);
        loan.updateSummaryWithTotalFeeChargesDueAtDisbursement(loan.deriveSumTotalOfChargesDueAtDisbursement());
        LoanTransaction waiveLoanChargeTransaction = LoanTransaction.waiveLoanCharge((Loan)loan, (Office)loan.getOffice(), (Money)amountWaived, (LocalDate)transactionDate, (Money)feeChargesWaived, (Money)penaltyChargesWaived, (Money)unrecognizedIncome, (ExternalId)externalId);
        LoanChargePaidBy loanChargePaidBy = new LoanChargePaidBy(waiveLoanChargeTransaction, loanCharge, waiveLoanChargeTransaction.getAmount(loan.getCurrency()).getAmount(), loanInstallmentNumber);
        waiveLoanChargeTransaction.getLoanChargesPaid().add(loanChargePaidBy);
        loan.addLoanTransaction(waiveLoanChargeTransaction);
        if (loan.isCumulativeSchedule() && loan.isInterestBearingAndInterestRecalculationEnabled() && DateUtils.isBefore((LocalDate)loanCharge.getDueLocalDate(), (LocalDate)businessDate)) {
            this.loanScheduleService.regenerateRepaymentScheduleWithInterestRecalculation(loan, scheduleGeneratorDTO);
        } else if (loan.isProgressiveSchedule() && (loan.hasChargeOffTransaction() && loan.hasAccelerateChargeOffStrategy() || loan.hasContractTerminationTransaction())) {
            this.loanScheduleService.regenerateRepaymentSchedule(loan, scheduleGeneratorDTO);
        }
        if (!loanCharge.isDueAtDisbursement() && loanCharge.isPaidOrPartiallyPaid(loan.getCurrency())) {
            this.reprocessLoanTransactionsService.reprocessTransactions(loan);
        } else {
            LoanRepaymentScheduleProcessingWrapper wrapper = new LoanRepaymentScheduleProcessingWrapper();
            wrapper.reprocess(loan.getCurrency(), loan.getDisbursementDate(), loan.getRepaymentScheduleInstallments(), loan.getActiveCharges());
        }
        this.loanLifecycleStateMachine.determineAndTransition(loan, waiveLoanChargeTransaction.getTransactionDate());
        return waiveLoanChargeTransaction;
    }

    @Generated
    public LoanChargeWritePlatformServiceImpl(LoanChargeApiJsonValidator loanChargeApiJsonValidator, LoanAssembler loanAssembler, ChargeRepositoryWrapper chargeRepository, BusinessEventNotifierService businessEventNotifierService, LoanTransactionRepository loanTransactionRepository, AccountTransfersWritePlatformService accountTransfersWritePlatformService, LoanRepositoryWrapper loanRepositoryWrapper, LoanAccountDomainService loanAccountDomainService, LoanChargeRepository loanChargeRepository, LoanWritePlatformService loanWritePlatformService, LoanUtilService loanUtilService, LoanChargeReadPlatformService loanChargeReadPlatformService, LoanLifecycleStateMachine loanLifecycleStateMachine, AccountAssociationsReadPlatformService accountAssociationsReadPlatformService, FromJsonHelper fromApiJsonHelper, ConfigurationDomainService configurationDomainService, LoanRepaymentScheduleTransactionProcessorFactory loanRepaymentScheduleTransactionProcessorFactory, ExternalIdFactory externalIdFactory, AccountTransferDetailRepository accountTransferDetailRepository, LoanChargeAssembler loanChargeAssembler, PaymentDetailWritePlatformService paymentDetailWritePlatformService, NoteRepository noteRepository, LoanAccrualsProcessingService loanAccrualsProcessingService, LoanDownPaymentTransactionValidator loanDownPaymentTransactionValidator, LoanChargeValidator loanChargeValidator, LoanScheduleService loanScheduleService, ReprocessLoanTransactionsService reprocessLoanTransactionsService, LoanAccountService loanAccountService, LoanAdjustmentService loanAdjustmentService, LoanChargeService loanChargeService, LoanJournalEntryPoster loanJournalEntryPoster) {
        this.loanChargeApiJsonValidator = loanChargeApiJsonValidator;
        this.loanAssembler = loanAssembler;
        this.chargeRepository = chargeRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.loanTransactionRepository = loanTransactionRepository;
        this.accountTransfersWritePlatformService = accountTransfersWritePlatformService;
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.loanAccountDomainService = loanAccountDomainService;
        this.loanChargeRepository = loanChargeRepository;
        this.loanWritePlatformService = loanWritePlatformService;
        this.loanUtilService = loanUtilService;
        this.loanChargeReadPlatformService = loanChargeReadPlatformService;
        this.loanLifecycleStateMachine = loanLifecycleStateMachine;
        this.accountAssociationsReadPlatformService = accountAssociationsReadPlatformService;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.configurationDomainService = configurationDomainService;
        this.loanRepaymentScheduleTransactionProcessorFactory = loanRepaymentScheduleTransactionProcessorFactory;
        this.externalIdFactory = externalIdFactory;
        this.accountTransferDetailRepository = accountTransferDetailRepository;
        this.loanChargeAssembler = loanChargeAssembler;
        this.paymentDetailWritePlatformService = paymentDetailWritePlatformService;
        this.noteRepository = noteRepository;
        this.loanAccrualsProcessingService = loanAccrualsProcessingService;
        this.loanDownPaymentTransactionValidator = loanDownPaymentTransactionValidator;
        this.loanChargeValidator = loanChargeValidator;
        this.loanScheduleService = loanScheduleService;
        this.reprocessLoanTransactionsService = reprocessLoanTransactionsService;
        this.loanAccountService = loanAccountService;
        this.loanAdjustmentService = loanAdjustmentService;
        this.loanChargeService = loanChargeService;
        this.loanJournalEntryPoster = loanJournalEntryPoster;
    }
}

