/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.accounting.common.AccountingRuleType;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.organisation.monetary.domain.MonetaryCurrency;
import org.apache.fineract.portfolio.charge.domain.Charge;
import org.apache.fineract.portfolio.common.domain.DaysInMonthType;
import org.apache.fineract.portfolio.common.domain.DaysInYearCustomStrategyType;
import org.apache.fineract.portfolio.common.domain.DaysInYearType;
import org.apache.fineract.portfolio.common.domain.PeriodFrequencyType;
import org.apache.fineract.portfolio.floatingrates.domain.FloatingRate;
import org.apache.fineract.portfolio.fund.domain.Fund;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanBuyDownFeeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeCalculationType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeStrategy;
import org.apache.fineract.portfolio.loanaccount.domain.LoanCapitalizedIncomeType;
import org.apache.fineract.portfolio.loanaccount.domain.LoanChargeOffBehaviour;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.AprCalculator;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleProcessingType;
import org.apache.fineract.portfolio.loanaccount.loanschedule.domain.LoanScheduleType;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductGuaranteeDetailsAssembler;
import org.apache.fineract.portfolio.loanaccount.service.LoanProductInterestRecalculationDetailsAssembler;
import org.apache.fineract.portfolio.loanproduct.LoanProductConstants;
import org.apache.fineract.portfolio.loanproduct.domain.AmortizationMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestCalculationPeriodMethod;
import org.apache.fineract.portfolio.loanproduct.domain.InterestMethod;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductBorrowerCycleVariations;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductConfigurableAttributes;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductCreditAllocationRule;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductGuaranteeDetails;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductInterestRecalculationDetails;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductParamType;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProductPaymentAllocationRule;
import org.apache.fineract.portfolio.loanproduct.domain.LoanSupportedInterestRefundTypes;
import org.apache.fineract.portfolio.loanproduct.domain.RepaymentStartDateType;
import org.apache.fineract.portfolio.rate.domain.Rate;
import org.springframework.stereotype.Service;

@Service
public class LoanProductAssembler {
    private final LoanProductInterestRecalculationDetailsAssembler interestRecalculationDetailsAssembler;
    private final LoanProductGuaranteeDetailsAssembler guaranteeDetailsAssembler;

    public LoanProduct assembleFromJson(Fund fund, String loanTransactionProcessingStrategy, List<Charge> productCharges, JsonCommand command, AprCalculator aprCalculator, FloatingRate floatingRate, List<Rate> productRates, List<LoanProductPaymentAllocationRule> loanProductPaymentAllocationRules, List<LoanProductCreditAllocationRule> loanProductCreditAllocationRules) {
        String name = command.stringValueOfParameterNamed("name");
        String shortName = command.stringValueOfParameterNamed("shortName");
        String description = command.stringValueOfParameterNamed("description");
        String currencyCode = command.stringValueOfParameterNamed("currencyCode");
        Integer digitsAfterDecimal = command.integerValueOfParameterNamed("digitsAfterDecimal");
        Integer inMultiplesOf = command.integerValueOfParameterNamed("inMultiplesOf");
        MonetaryCurrency currency = new MonetaryCurrency(currencyCode, digitsAfterDecimal.intValue(), inMultiplesOf);
        BigDecimal principal = command.bigDecimalValueOfParameterNamed("principal");
        BigDecimal minPrincipal = command.bigDecimalValueOfParameterNamed("minPrincipal");
        BigDecimal maxPrincipal = command.bigDecimalValueOfParameterNamed("maxPrincipal");
        InterestMethod interestMethod = InterestMethod.fromInt((Integer)command.integerValueOfParameterNamed("interestType"));
        InterestCalculationPeriodMethod interestCalculationPeriodMethod = InterestCalculationPeriodMethod.fromInt((Integer)command.integerValueOfParameterNamed("interestCalculationPeriodType"));
        boolean allowPartialPeriodInterestCalcualtion = command.booleanPrimitiveValueOfParameterNamed("allowPartialPeriodInterestCalcualtion");
        AmortizationMethod amortizationMethod = AmortizationMethod.fromInt((Integer)command.integerValueOfParameterNamed("amortizationType"));
        PeriodFrequencyType repaymentFrequencyType = PeriodFrequencyType.fromInt((Integer)command.integerValueOfParameterNamed("repaymentFrequencyType"));
        PeriodFrequencyType interestFrequencyType = PeriodFrequencyType.INVALID;
        BigDecimal interestRatePerPeriod = null;
        BigDecimal minInterestRatePerPeriod = null;
        BigDecimal maxInterestRatePerPeriod = null;
        BigDecimal annualInterestRate = null;
        BigDecimal interestRateDifferential = null;
        BigDecimal minDifferentialLendingRate = null;
        BigDecimal maxDifferentialLendingRate = null;
        BigDecimal defaultDifferentialLendingRate = null;
        Boolean isFloatingInterestRateCalculationAllowed = null;
        Integer minimumGapBetweenInstallments = null;
        Integer maximumGapBetweenInstallments = null;
        DaysInYearType daysInYearType = DaysInYearType.fromInt((Integer)command.integerValueOfParameterNamed("daysInYearType"));
        Integer repaymentEvery = command.integerValueOfParameterNamed("repaymentEvery");
        Integer numberOfRepayments = command.integerValueOfParameterNamed("numberOfRepayments");
        Boolean isLinkedToFloatingInterestRates = command.booleanObjectValueOfParameterNamed("isLinkedToFloatingInterestRates");
        if (isLinkedToFloatingInterestRates != null && isLinkedToFloatingInterestRates.booleanValue()) {
            interestRateDifferential = command.bigDecimalValueOfParameterNamed("interestRateDifferential");
            minDifferentialLendingRate = command.bigDecimalValueOfParameterNamed("minDifferentialLendingRate");
            maxDifferentialLendingRate = command.bigDecimalValueOfParameterNamed("maxDifferentialLendingRate");
            defaultDifferentialLendingRate = command.bigDecimalValueOfParameterNamed("defaultDifferentialLendingRate");
            isFloatingInterestRateCalculationAllowed = command.booleanObjectValueOfParameterNamed("isFloatingInterestRateCalculationAllowed");
        } else {
            interestFrequencyType = PeriodFrequencyType.fromInt((Integer)command.integerValueOfParameterNamed("interestRateFrequencyType"));
            interestRatePerPeriod = command.bigDecimalValueOfParameterNamed("interestRatePerPeriod");
            minInterestRatePerPeriod = command.bigDecimalValueOfParameterNamed("minInterestRatePerPeriod");
            maxInterestRatePerPeriod = command.bigDecimalValueOfParameterNamed("maxInterestRatePerPeriod");
            annualInterestRate = aprCalculator.calculateFrom(interestFrequencyType, interestRatePerPeriod, numberOfRepayments, repaymentEvery, repaymentFrequencyType, daysInYearType);
        }
        Boolean isVariableInstallmentsAllowed = command.booleanObjectValueOfParameterNamed("allowVariableInstallments");
        if (isVariableInstallmentsAllowed != null && isVariableInstallmentsAllowed.booleanValue()) {
            minimumGapBetweenInstallments = command.integerValueOfParameterNamed("minimumGap");
            maximumGapBetweenInstallments = command.integerValueOfParameterNamed("maximumGap");
        }
        Integer minNumberOfRepayments = command.integerValueOfParameterNamed("minNumberOfRepayments");
        Integer maxNumberOfRepayments = command.integerValueOfParameterNamed("maxNumberOfRepayments");
        BigDecimal inArrearsTolerance = command.bigDecimalValueOfParameterNamed("inArrearsTolerance");
        Integer graceOnPrincipalPayment = command.integerValueOfParameterNamed("graceOnPrincipalPayment");
        Integer recurringMoratoriumOnPrincipalPeriods = command.integerValueOfParameterNamed("recurringMoratoriumOnPrincipalPeriods");
        Integer graceOnInterestPayment = command.integerValueOfParameterNamed("graceOnInterestPayment");
        Integer graceOnInterestCharged = command.integerValueOfParameterNamed("graceOnInterestCharged");
        Integer minimumDaysBetweenDisbursalAndFirstRepayment = command.integerValueOfParameterNamed("minimumDaysBetweenDisbursalAndFirstRepayment");
        AccountingRuleType accountingRuleType = AccountingRuleType.fromInt((Integer)command.integerValueOfParameterNamed("accountingRule"));
        boolean includeInBorrowerCycle = command.booleanPrimitiveValueOfParameterNamed("includeInBorrowerCycle");
        LocalDate startDate = command.localDateValueOfParameterNamed("startDate");
        LocalDate closeDate = command.localDateValueOfParameterNamed("closeDate");
        ExternalId externalId = ExternalIdFactory.produce((String)command.stringValueOfParameterNamedAllowingNull("externalId"));
        LoanScheduleType loanScheduleType = command.hasParameter("loanScheduleType") ? LoanScheduleType.valueOf((String)command.stringValueOfParameterNamed("loanScheduleType")) : LoanScheduleType.CUMULATIVE;
        LoanScheduleProcessingType loanScheduleProcessingType = LoanScheduleType.PROGRESSIVE.equals((Object)loanScheduleType) && command.hasParameter("loanScheduleProcessingType") ? LoanScheduleProcessingType.valueOf((String)command.stringValueOfParameterNamed("loanScheduleProcessingType")) : LoanScheduleProcessingType.HORIZONTAL;
        boolean useBorrowerCycle = command.booleanPrimitiveValueOfParameterNamed("useBorrowerCycle");
        HashSet loanProductBorrowerCycleVariations = new HashSet();
        if (useBorrowerCycle) {
            this.populateBorrowerCycleVariations(command, loanProductBorrowerCycleVariations);
        }
        boolean multiDisburseLoan = command.booleanPrimitiveValueOfParameterNamed("multiDisburseLoan");
        Integer maxTrancheCount = null;
        BigDecimal outstandingLoanBalance = null;
        if (multiDisburseLoan) {
            outstandingLoanBalance = command.bigDecimalValueOfParameterNamed("outstandingLoanBalance");
            maxTrancheCount = command.integerValueOfParameterNamed("maxTrancheCount");
        }
        Integer graceOnArrearsAgeing = command.integerValueOfParameterNamed("graceOnArrearsAgeing");
        Integer overdueDaysForNPA = command.integerValueOfParameterNamed("overdueDaysForNPA");
        boolean isInterestRecalculationEnabled = command.booleanPrimitiveValueOfParameterNamed("isInterestRecalculationEnabled");
        DaysInMonthType daysInMonthType = DaysInMonthType.fromInt((Integer)command.integerValueOfParameterNamed("daysInMonthType"));
        DaysInYearCustomStrategyType daysInYearCustomStrategy = (DaysInYearCustomStrategyType)command.enumValueOfParameterNamed("daysInYearCustomStrategy", DaysInYearCustomStrategyType.class);
        LoanProductInterestRecalculationDetails interestRecalculationSettings = null;
        if (isInterestRecalculationEnabled) {
            interestRecalculationSettings = this.interestRecalculationDetailsAssembler.createFrom(command);
        }
        boolean holdGuarantorFunds = command.booleanPrimitiveValueOfParameterNamed("holdGuaranteeFunds");
        LoanProductGuaranteeDetails loanProductGuaranteeDetails = null;
        if (holdGuarantorFunds) {
            loanProductGuaranteeDetails = this.guaranteeDetailsAssembler.createFrom(command);
        }
        LoanProductConfigurableAttributes loanConfigurableAttributes = null;
        loanConfigurableAttributes = command.parameterExists("allowAttributeOverrides") ? LoanProductConfigurableAttributes.createFrom((JsonCommand)command) : LoanProductConfigurableAttributes.populateDefaultsForConfigurableAttributes();
        BigDecimal principalThresholdForLastInstallment = command.bigDecimalValueOfParameterNamed("principalThresholdForLastInstallment");
        if (principalThresholdForLastInstallment == null) {
            principalThresholdForLastInstallment = multiDisburseLoan ? LoanProductConstants.DEFAULT_PRINCIPAL_THRESHOLD_FOR_MULTI_DISBURSE_LOAN : LoanProductConstants.DEFAULT_PRINCIPAL_THRESHOLD_FOR_SINGLE_DISBURSE_LOAN;
        }
        boolean accountMovesOutOfNPAOnlyOnArrearsCompletion = command.booleanPrimitiveValueOfParameterNamed("accountMovesOutOfNPAOnlyOnArrearsCompletion");
        boolean canDefineEmiAmount = command.booleanPrimitiveValueOfParameterNamed("canDefineInstallmentAmount");
        Integer installmentAmountInMultiplesOf = command.integerValueOfParameterNamed("installmentAmountInMultiplesOf");
        boolean syncExpectedWithDisbursementDate = command.booleanPrimitiveValueOfParameterNamed("syncExpectedWithDisbursementDate");
        boolean canUseForTopup = command.parameterExists("canUseForTopup") && command.booleanPrimitiveValueOfParameterNamed("canUseForTopup");
        boolean isEqualAmortization = command.parameterExists("isEqualAmortization") && command.booleanPrimitiveValueOfParameterNamed("isEqualAmortization");
        BigDecimal fixedPrincipalPercentagePerInstallment = command.bigDecimalValueOfParameterNamed("fixedPrincipalPercentagePerInstallment");
        boolean disallowExpectedDisbursements = command.parameterExists("disallowExpectedDisbursements") && command.booleanPrimitiveValueOfParameterNamed("disallowExpectedDisbursements");
        boolean allowApprovedDisbursedAmountsOverApplied = command.parameterExists("allowApprovedDisbursedAmountsOverApplied") && command.booleanPrimitiveValueOfParameterNamed("allowApprovedDisbursedAmountsOverApplied");
        String overAppliedCalculationType = command.stringValueOfParameterNamedAllowingNull("overAppliedCalculationType");
        Integer overAppliedNumber = command.integerValueOfParameterNamed("overAppliedNumber");
        Integer dueDaysForRepaymentEvent = command.integerValueOfParameterNamed("dueDaysForRepaymentEvent");
        Integer overDueDaysForRepaymentEvent = command.integerValueOfParameterNamed("overDueDaysForRepaymentEvent");
        boolean enableDownPayment = command.booleanPrimitiveValueOfParameterNamed("enableDownPayment");
        BigDecimal disbursedAmountPercentageDownPayment = command.bigDecimalValueOfParameterNamed("disbursedAmountPercentageForDownPayment");
        boolean enableAutoRepaymentForDownPayment = command.booleanPrimitiveValueOfParameterNamed("enableAutoRepaymentForDownPayment");
        RepaymentStartDateType repaymentStartDateType = RepaymentStartDateType.fromInt((Integer)command.integerValueOfParameterNamed("repaymentStartDateType"));
        boolean enableInstallmentLevelDelinquency = command.booleanPrimitiveValueOfParameterNamed("enableInstallmentLevelDelinquency");
        Integer fixedLength = command.integerValueOfParameterNamed("fixedLength");
        boolean enableAccrualActivityPosting = command.booleanPrimitiveValueOfParameterNamed("enableAccrualActivityPosting");
        boolean interestRecognitionOnDisbursementDate = false;
        if (command.parameterExists("interestRecognitionOnDisbursementDate")) {
            interestRecognitionOnDisbursementDate = command.booleanPrimitiveValueOfParameterNamed("interestRecognitionOnDisbursementDate");
        }
        ArrayList supportedInterestRefundTypes = new ArrayList();
        if (command.parameterExists("supportedInterestRefundTypes")) {
            JsonArray supportedTransactionsForInterestRefund = command.arrayOfParameterNamed("supportedInterestRefundTypes");
            supportedTransactionsForInterestRefund.iterator().forEachRemaining(value -> supportedInterestRefundTypes.add(LoanSupportedInterestRefundTypes.valueOf((String)value.getAsString())));
        }
        LoanChargeOffBehaviour chargeOffBehaviour = command.parameterExists("chargeOffBehaviour") ? LoanChargeOffBehaviour.valueOf((String)command.stringValueOfParameterNamed("chargeOffBehaviour")) : LoanChargeOffBehaviour.REGULAR;
        boolean enableIncomeCapitalization = command.booleanPrimitiveValueOfParameterNamed("enableIncomeCapitalization");
        LoanCapitalizedIncomeCalculationType capitalizedIncomeCalculationType = (LoanCapitalizedIncomeCalculationType)command.enumValueOfParameterNamed("capitalizedIncomeCalculationType", LoanCapitalizedIncomeCalculationType.class);
        LoanCapitalizedIncomeStrategy capitalizedIncomeStrategy = (LoanCapitalizedIncomeStrategy)command.enumValueOfParameterNamed("capitalizedIncomeStrategy", LoanCapitalizedIncomeStrategy.class);
        LoanCapitalizedIncomeType capitalizedIncomeType = (LoanCapitalizedIncomeType)command.enumValueOfParameterNamed("capitalizedIncomeType", LoanCapitalizedIncomeType.class);
        boolean enableBuyDownFee = command.booleanPrimitiveValueOfParameterNamed("enableBuyDownFee");
        LoanBuyDownFeeCalculationType buyDownFeeCalculationType = (LoanBuyDownFeeCalculationType)command.enumValueOfParameterNamed("buyDownFeeCalculationType", LoanBuyDownFeeCalculationType.class);
        LoanBuyDownFeeStrategy buyDownFeeStrategy = (LoanBuyDownFeeStrategy)command.enumValueOfParameterNamed("buyDownFeeStrategy", LoanBuyDownFeeStrategy.class);
        LoanBuyDownFeeIncomeType buyDownFeeIncomeType = (LoanBuyDownFeeIncomeType)command.enumValueOfParameterNamed("buyDownFeeIncomeType", LoanBuyDownFeeIncomeType.class);
        boolean merchantBuyDownFee = command.booleanPrimitiveValueOfParameterNamed("merchantBuyDownFee");
        return new LoanProduct(fund, loanTransactionProcessingStrategy, loanProductPaymentAllocationRules, loanProductCreditAllocationRules, name, shortName, description, currency, principal, minPrincipal, maxPrincipal, interestRatePerPeriod, minInterestRatePerPeriod, maxInterestRatePerPeriod, interestFrequencyType, annualInterestRate, interestMethod, interestCalculationPeriodMethod, allowPartialPeriodInterestCalcualtion, repaymentEvery, repaymentFrequencyType, numberOfRepayments, minNumberOfRepayments, maxNumberOfRepayments, graceOnPrincipalPayment, recurringMoratoriumOnPrincipalPeriods, graceOnInterestPayment, graceOnInterestCharged, amortizationMethod, inArrearsTolerance, productCharges, accountingRuleType, includeInBorrowerCycle, startDate, closeDate, externalId, useBorrowerCycle, loanProductBorrowerCycleVariations, multiDisburseLoan, maxTrancheCount, outstandingLoanBalance, graceOnArrearsAgeing, overdueDaysForNPA, daysInMonthType, daysInYearType, isInterestRecalculationEnabled, interestRecalculationSettings, minimumDaysBetweenDisbursalAndFirstRepayment, holdGuarantorFunds, loanProductGuaranteeDetails, principalThresholdForLastInstallment, accountMovesOutOfNPAOnlyOnArrearsCompletion, canDefineEmiAmount, installmentAmountInMultiplesOf, loanConfigurableAttributes, isLinkedToFloatingInterestRates, floatingRate, interestRateDifferential, minDifferentialLendingRate, maxDifferentialLendingRate, defaultDifferentialLendingRate, isFloatingInterestRateCalculationAllowed, isVariableInstallmentsAllowed, minimumGapBetweenInstallments, maximumGapBetweenInstallments, syncExpectedWithDisbursementDate, canUseForTopup, isEqualAmortization, productRates, fixedPrincipalPercentagePerInstallment, disallowExpectedDisbursements, allowApprovedDisbursedAmountsOverApplied, overAppliedCalculationType, overAppliedNumber, dueDaysForRepaymentEvent, overDueDaysForRepaymentEvent, enableDownPayment, disbursedAmountPercentageDownPayment, enableAutoRepaymentForDownPayment, repaymentStartDateType, enableInstallmentLevelDelinquency, loanScheduleType, loanScheduleProcessingType, fixedLength, enableAccrualActivityPosting, supportedInterestRefundTypes, chargeOffBehaviour, interestRecognitionOnDisbursementDate, daysInYearCustomStrategy, enableIncomeCapitalization, capitalizedIncomeCalculationType, capitalizedIncomeStrategy, capitalizedIncomeType, enableBuyDownFee, buyDownFeeCalculationType, buyDownFeeStrategy, buyDownFeeIncomeType, merchantBuyDownFee);
    }

    private void populateBorrowerCycleVariations(JsonCommand command, Set<LoanProductBorrowerCycleVariations> loanProductBorrowerCycleVariations) {
        this.assemblePrincipalVariations(command, loanProductBorrowerCycleVariations);
        this.assembleRepaymentVariations(command, loanProductBorrowerCycleVariations);
        this.assembleInterestRateVariations(command, loanProductBorrowerCycleVariations);
    }

    private void assembleInterestRateVariations(JsonCommand command, Set<LoanProductBorrowerCycleVariations> loanProductBorrowerCycleVariations) {
        this.assembleVariations(command, loanProductBorrowerCycleVariations, LoanProductParamType.INTERESTRATE.getValue(), "interestRateVariationsForBorrowerCycle");
    }

    private void assembleRepaymentVariations(JsonCommand command, Set<LoanProductBorrowerCycleVariations> loanProductBorrowerCycleVariations) {
        this.assembleVariations(command, loanProductBorrowerCycleVariations, LoanProductParamType.REPAYMENT.getValue(), "numberOfRepaymentVariationsForBorrowerCycle");
    }

    private void assemblePrincipalVariations(JsonCommand command, Set<LoanProductBorrowerCycleVariations> loanProductBorrowerCycleVariations) {
        this.assembleVariations(command, loanProductBorrowerCycleVariations, LoanProductParamType.PRINCIPAL.getValue(), "principalVariationsForBorrowerCycle");
    }

    private void assembleVariations(JsonCommand command, Set<LoanProductBorrowerCycleVariations> loanProductBorrowerCycleVariations, Integer paramType, String variationParameterName) {
        JsonArray variationArray;
        if (command.parameterExists(variationParameterName) && (variationArray = command.arrayOfParameterNamed(variationParameterName)) != null && variationArray.size() > 0) {
            int i = 0;
            do {
                JsonObject jsonObject = variationArray.get(i).getAsJsonObject();
                BigDecimal defaultValue = null;
                BigDecimal minValue = null;
                BigDecimal maxValue = null;
                Integer cycleNumber = null;
                Integer valueUsageCondition = null;
                if (jsonObject.has("defaultValue") && jsonObject.get("defaultValue").isJsonPrimitive()) {
                    defaultValue = jsonObject.getAsJsonPrimitive("defaultValue").getAsBigDecimal();
                }
                if (jsonObject.has("minValue") && jsonObject.get("minValue").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("minValue").getAsString())) {
                    minValue = jsonObject.getAsJsonPrimitive("minValue").getAsBigDecimal();
                }
                if (jsonObject.has("maxValue") && jsonObject.get("maxValue").isJsonPrimitive() && StringUtils.isNotBlank((CharSequence)jsonObject.get("maxValue").getAsString())) {
                    maxValue = jsonObject.getAsJsonPrimitive("maxValue").getAsBigDecimal();
                }
                if (jsonObject.has("borrowerCycleNumber") && jsonObject.get("borrowerCycleNumber").isJsonPrimitive()) {
                    cycleNumber = jsonObject.getAsJsonPrimitive("borrowerCycleNumber").getAsInt();
                }
                if (jsonObject.has("valueConditionType") && jsonObject.get("valueConditionType").isJsonPrimitive()) {
                    valueUsageCondition = jsonObject.getAsJsonPrimitive("valueConditionType").getAsInt();
                }
                LoanProductBorrowerCycleVariations borrowerCycleVariations = new LoanProductBorrowerCycleVariations(cycleNumber, paramType, valueUsageCondition, minValue, maxValue, defaultValue);
                loanProductBorrowerCycleVariations.add(borrowerCycleVariations);
            } while (++i < variationArray.size());
        }
    }

    @Generated
    public LoanProductAssembler(LoanProductInterestRecalculationDetailsAssembler interestRecalculationDetailsAssembler, LoanProductGuaranteeDetailsAssembler guaranteeDetailsAssembler) {
        this.interestRecalculationDetailsAssembler = interestRecalculationDetailsAssembler;
        this.guaranteeDetailsAssembler = guaranteeDetailsAssembler;
    }
}

