/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.client.data;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.fineract.infrastructure.core.api.ApiParameterHelper;
import org.apache.fineract.infrastructure.core.exception.UnsupportedParameterException;
import org.springframework.stereotype.Component;

@Component
public class SelfClientDataValidator {
    private static final Set<String> allowedChargesAssociationParameters = new HashSet<String>(Arrays.asList("transactions"));

    public void validateClientCharges(UriInfo uriInfo) {
        ArrayList<String> unsupportedParams = new ArrayList<String>();
        Set associationParameters = ApiParameterHelper.extractAssociationsForResponseIfProvided((MultivaluedMap)uriInfo.getQueryParameters());
        if (!associationParameters.isEmpty()) {
            associationParameters.removeAll(allowedChargesAssociationParameters);
            if (!associationParameters.isEmpty()) {
                unsupportedParams.addAll(associationParameters);
            }
        }
        if (uriInfo.getQueryParameters().getFirst((Object)"exclude") != null) {
            unsupportedParams.add("exclude");
        }
        if (unsupportedParams.size() > 0) {
            throw new UnsupportedParameterException(unsupportedParams);
        }
    }

    public void validateRetrieveOne(UriInfo uriInfo) {
        ArrayList<String> unsupportedParams = new ArrayList<String>();
        boolean templateRequest = ApiParameterHelper.template((MultivaluedMap)uriInfo.getQueryParameters());
        if (templateRequest) {
            unsupportedParams.add("template");
        }
        if (unsupportedParams.size() > 0) {
            throw new UnsupportedParameterException(unsupportedParams);
        }
    }
}

