/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.shareproducts.service;

import com.google.gson.JsonElement;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.accounting.producttoaccountmapping.service.ProductToGLAccountMappingWritePlatformService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.share.ShareProductDividentsCreateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProduct;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividendPayOutDetails;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductDividentPayOutDetailsRepositoryWrapper;
import org.apache.fineract.portfolio.shareproducts.domain.ShareProductRepositoryWrapper;
import org.apache.fineract.portfolio.shareproducts.exception.DividentProcessingException;
import org.apache.fineract.portfolio.shareproducts.serialization.ShareProductDataSerializer;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductDividendAssembler;
import org.apache.fineract.portfolio.shareproducts.service.ShareProductWritePlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;

public class ShareProductWritePlatformServiceJpaRepositoryImpl
implements ShareProductWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShareProductWritePlatformServiceJpaRepositoryImpl.class);
    private final ShareProductRepositoryWrapper repository;
    private final ShareProductDataSerializer serializer;
    private final FromJsonHelper fromApiJsonHelper;
    private final ShareProductDividentPayOutDetailsRepositoryWrapper shareProductDividentPayOutDetailsRepository;
    private final ShareProductDividendAssembler shareProductDividendAssembler;
    private final ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService;
    private final BusinessEventNotifierService businessEventNotifierService;

    public CommandProcessingResult createShareProduct(JsonCommand jsonCommand) {
        try {
            ShareProduct product = this.serializer.validateAndCreate(jsonCommand);
            this.repository.saveAndFlush(product);
            this.accountMappingWritePlatformService.createShareProductToGLAccountMapping((Long)product.getId(), jsonCommand);
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId((Long)product.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(jsonCommand, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult updateProduct(Long productId, JsonCommand jsonCommand) {
        try {
            ShareProduct product = this.repository.findOneWithNotFoundDetection(productId);
            Map changes = this.serializer.validateAndUpdate(jsonCommand, product);
            boolean accountingTypeChanged = changes.containsKey("accountingRule");
            Map accountingMappingChanges = this.accountMappingWritePlatformService.updateShareProductToGLAccountMapping((Long)product.getId(), jsonCommand, accountingTypeChanged, product.getAccountingType().intValue());
            changes.putAll(accountingMappingChanges);
            if (!changes.isEmpty()) {
                this.repository.saveAndFlush(product);
            }
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(productId).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(jsonCommand, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(jsonCommand, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult createShareProductDividend(Long productId, JsonCommand jsonCommand) {
        try {
            this.serializer.validateDividendDetails(jsonCommand);
            JsonElement element = jsonCommand.parsedJson();
            LocalDate dividendPeriodStartDate = this.fromApiJsonHelper.extractLocalDateNamed("dividendPeriodStartDate", element);
            LocalDate dividendPeriodEndDate = this.fromApiJsonHelper.extractLocalDateNamed("dividendPeriodEndDate", element);
            BigDecimal dividendAmount = this.fromApiJsonHelper.extractBigDecimalWithLocaleNamed("dividendAmount", element);
            ShareProductDividendPayOutDetails dividendPayOutDetails = this.shareProductDividendAssembler.calculateDividends(productId, dividendAmount, dividendPeriodStartDate, dividendPeriodEndDate);
            if (dividendPayOutDetails == null) {
                throw new DividentProcessingException("eligible.shares.not.found", "No eligible shares for creating dividends");
            }
            this.shareProductDividentPayOutDetailsRepository.save(dividendPayOutDetails);
            this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new ShareProductDividentsCreateBusinessEvent(productId));
            return new CommandProcessingResultBuilder().withCommandId(jsonCommand.commandId()).withEntityId(productId).withSubEntityId((Long)dividendPayOutDetails.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult approveShareProductDividend(Long PayOutDetailId) {
        try {
            ShareProductDividendPayOutDetails dividendPayOutDetails = this.shareProductDividentPayOutDetailsRepository.findOneWithNotFoundDetection(PayOutDetailId);
            if (dividendPayOutDetails.getStatus().isApproved()) {
                throw new DividentProcessingException("alreay.approved", "Can't approve already appoved  dividends ");
            }
            dividendPayOutDetails.approveDividendPayout();
            this.shareProductDividentPayOutDetailsRepository.save(dividendPayOutDetails);
            return new CommandProcessingResultBuilder().withEntityId(PayOutDetailId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    public CommandProcessingResult deleteShareProductDividend(Long PayOutDetailId) {
        try {
            ShareProductDividendPayOutDetails dividendPayOutDetails = this.shareProductDividentPayOutDetailsRepository.findOneWithNotFoundDetection(PayOutDetailId);
            if (dividendPayOutDetails.getStatus().isApproved()) {
                throw new DividentProcessingException("alreay.approved", "Can't delete already appoved  dividends ");
            }
            this.shareProductDividentPayOutDetailsRepository.delete(dividendPayOutDetails);
            return new CommandProcessingResultBuilder().withEntityId(PayOutDetailId).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues((Exception)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void handleDataIntegrityIssues(Exception e) {
        log.error("Unknown data integrity issue with resource", (Throwable)e);
        throw ErrorHandler.getMappable((Throwable)e, (String)"error.msg.shareproduct.unknown.data.integrity.issue", (String)"Unknown data integrity issue with resource.");
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("'name'")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.shareproduct.duplicate.name", "Share Product with name `" + name + "` already exists", "name", new Object[]{name});
        }
        this.handleDataIntegrityIssues(dve);
    }

    @Generated
    public ShareProductWritePlatformServiceJpaRepositoryImpl(ShareProductRepositoryWrapper repository, ShareProductDataSerializer serializer, FromJsonHelper fromApiJsonHelper, ShareProductDividentPayOutDetailsRepositoryWrapper shareProductDividentPayOutDetailsRepository, ShareProductDividendAssembler shareProductDividendAssembler, ProductToGLAccountMappingWritePlatformService accountMappingWritePlatformService, BusinessEventNotifierService businessEventNotifierService) {
        this.repository = repository;
        this.serializer = serializer;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.shareProductDividentPayOutDetailsRepository = shareProductDividentPayOutDetailsRepository;
        this.shareProductDividendAssembler = shareProductDividendAssembler;
        this.accountMappingWritePlatformService = accountMappingWritePlatformService;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

