/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.spm.api;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.spm.data.SurveyData;
import org.apache.fineract.spm.domain.Survey;
import org.apache.fineract.spm.service.SpmService;
import org.apache.fineract.spm.util.SurveyMapper;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Path(value="/v1/surveys")
@Component
@Tag(name="Spm-Surveys", description="")
public class SpmApiResource {
    private final PlatformSecurityContext securityContext;
    private final SpmService spmService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="List all Surveys", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SurveyData.class)))})})
    public List<SurveyData> fetchAllSurveys(@QueryParam(value="isActive") Boolean isActive) {
        this.securityContext.authenticatedUser();
        ArrayList<SurveyData> result = new ArrayList<SurveyData>();
        List surveys = null;
        surveys = isActive != null && isActive != false ? this.spmService.fetchValidSurveys() : this.spmService.fetchAllSurveys();
        if (surveys != null) {
            for (Survey survey : surveys) {
                result.add(SurveyMapper.map((Survey)survey));
            }
        }
        return result;
    }

    @GET
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Retrieve a Survey", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=SurveyData.class))})})
    public SurveyData findSurvey(@PathParam(value="id") @Parameter(description="Enter id") Long id) {
        this.securityContext.authenticatedUser();
        Survey survey = this.spmService.findById(id);
        return SurveyMapper.map((Survey)survey);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Create a Survey", description="Adds a new survey to collect client related data.\n\nMandatory Fields\n\ncountryCode, key, name, questions, responses, sequenceNo, text, description")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public String createSurvey(@Parameter(description="Create survey") SurveyData surveyData) {
        this.securityContext.authenticatedUser();
        Survey survey = SurveyMapper.map((SurveyData)surveyData, (Survey)new Survey());
        this.spmService.createSurvey(survey);
        return this.getResponse((Long)survey.getId());
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    public String editSurvey(@PathParam(value="id") Long id, SurveyData surveyData) {
        this.securityContext.authenticatedUser();
        Survey surveyToUpdate = this.spmService.findById(id);
        Survey survey = SurveyMapper.map((SurveyData)surveyData, (Survey)surveyToUpdate);
        this.spmService.updateSurvey(survey);
        return this.getResponse((Long)survey.getId());
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Transactional
    @Operation(summary="Deactivate Survey", description="")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK")})
    public void activateOrDeactivateSurvey(@PathParam(value="id") Long id, @QueryParam(value="command") String command) {
        this.securityContext.authenticatedUser();
        if (command != null && command.equalsIgnoreCase("activate")) {
            this.spmService.activateSurvey(id);
        } else if (command != null && command.equalsIgnoreCase("deactivate")) {
            this.spmService.deactivateSurvey(id);
        } else {
            throw new UnrecognizedQueryParamException("command", command, new Object[0]);
        }
    }

    private String getResponse(Long id) {
        Gson gson = new Gson();
        HashMap<String, Long> response = new HashMap<String, Long>();
        response.put("resourceId", id);
        return gson.toJson(response);
    }

    @Generated
    public SpmApiResource(PlatformSecurityContext securityContext, SpmService spmService) {
        this.securityContext = securityContext;
        this.spmService = spmService;
    }
}

