/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.13.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.fineract.client.models.AdvancedPaymentData;
import org.apache.fineract.client.models.CreditAllocationData;
import org.apache.fineract.client.models.DelinquencyBucketData;
import org.apache.fineract.client.models.EnumOptionData;
import org.apache.fineract.client.models.GetChargeOffReasonToExpenseAccountMappings;
import org.apache.fineract.client.models.GetClassificationToIncomeAccountMappings;
import org.apache.fineract.client.models.GetCodeValuesDataResponse;
import org.apache.fineract.client.models.GetLoanAccountingMappings;
import org.apache.fineract.client.models.GetLoanFeeToIncomeAccountMappings;
import org.apache.fineract.client.models.GetLoanPaymentChannelToFundSourceMappings;
import org.apache.fineract.client.models.GetLoanProductsAccountingRule;
import org.apache.fineract.client.models.GetLoanProductsAmortizationType;
import org.apache.fineract.client.models.GetLoanProductsChargeOffReasonOptions;
import org.apache.fineract.client.models.GetLoanProductsCurrency;
import org.apache.fineract.client.models.GetLoanProductsDaysInMonthType;
import org.apache.fineract.client.models.GetLoanProductsDaysInYearType;
import org.apache.fineract.client.models.GetLoanProductsInterestRateFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsInterestRecalculationData;
import org.apache.fineract.client.models.GetLoanProductsInterestTemplateType;
import org.apache.fineract.client.models.GetLoanProductsPrincipalVariationsForBorrowerCycle;
import org.apache.fineract.client.models.GetLoanProductsRepaymentFrequencyType;
import org.apache.fineract.client.models.GetLoanProductsRepaymentStartDateType;
import org.apache.fineract.client.models.GetLoanProductsWriteOffReasonOptions;
import org.apache.fineract.client.models.GetLoansProductsInterestCalculationPeriodType;
import org.apache.fineract.client.models.LoanProductChargeData;
import org.apache.fineract.client.models.PostWriteOffReasonToExpenseAccountMappings;
import org.apache.fineract.client.models.StringEnumOptionData;

/**
 * GetLoanProductsProductIdResponse
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class GetLoanProductsProductIdResponse {
  public static final String SERIALIZED_NAME_ACCOUNTING_MAPPINGS = "accountingMappings";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_MAPPINGS)
  private GetLoanAccountingMappings accountingMappings;

  public static final String SERIALIZED_NAME_ACCOUNTING_RULE = "accountingRule";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_RULE)
  private GetLoanProductsAccountingRule accountingRule;

  public static final String SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED = "allowApprovedDisbursedAmountsOverApplied";
  @SerializedName(SERIALIZED_NAME_ALLOW_APPROVED_DISBURSED_AMOUNTS_OVER_APPLIED)
  private Boolean allowApprovedDisbursedAmountsOverApplied;

  public static final String SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION = "allowPartialPeriodInterestCalculation";
  @SerializedName(SERIALIZED_NAME_ALLOW_PARTIAL_PERIOD_INTEREST_CALCULATION)
  private Boolean allowPartialPeriodInterestCalculation;

  public static final String SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS = "allowVariableInstallments";
  @SerializedName(SERIALIZED_NAME_ALLOW_VARIABLE_INSTALLMENTS)
  private Boolean allowVariableInstallments;

  public static final String SERIALIZED_NAME_AMORTIZATION_TYPE = "amortizationType";
  @SerializedName(SERIALIZED_NAME_AMORTIZATION_TYPE)
  private GetLoanProductsAmortizationType amortizationType;

  public static final String SERIALIZED_NAME_ANNUAL_INTEREST_RATE = "annualInterestRate";
  @SerializedName(SERIALIZED_NAME_ANNUAL_INTEREST_RATE)
  private Double annualInterestRate;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE = "buyDownFeeCalculationType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE)
  private StringEnumOptionData buyDownFeeCalculationType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE_OPTIONS = "buyDownFeeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_CALCULATION_TYPE_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE = "buyDownFeeIncomeType";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE)
  private StringEnumOptionData buyDownFeeIncomeType;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE_OPTIONS = "buyDownFeeIncomeTypeOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_INCOME_TYPE_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeIncomeTypeOptions;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY = "buyDownFeeStrategy";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY)
  private StringEnumOptionData buyDownFeeStrategy;

  public static final String SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY_OPTIONS = "buyDownFeeStrategyOptions";
  @SerializedName(SERIALIZED_NAME_BUY_DOWN_FEE_STRATEGY_OPTIONS)
  private List<StringEnumOptionData> buyDownFeeStrategyOptions;

  public static final String SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_OPTIONS = "buydownFeeClassificationOptions";
  @SerializedName(SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_OPTIONS)
  private List<GetCodeValuesDataResponse> buydownFeeClassificationOptions;

  public static final String SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS = "buydownFeeClassificationToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_BUYDOWN_FEE_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<GetClassificationToIncomeAccountMappings> buydownFeeClassificationToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT = "canDefineInstallmentAmount";
  @SerializedName(SERIALIZED_NAME_CAN_DEFINE_INSTALLMENT_AMOUNT)
  private Boolean canDefineInstallmentAmount;

  public static final String SERIALIZED_NAME_CAN_USE_FOR_TOPUP = "canUseForTopup";
  @SerializedName(SERIALIZED_NAME_CAN_USE_FOR_TOPUP)
  private Boolean canUseForTopup;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE = "capitalizedIncomeCalculationType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE)
  private StringEnumOptionData capitalizedIncomeCalculationType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE_OPTIONS = "capitalizedIncomeCalculationTypeOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CALCULATION_TYPE_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_OPTIONS = "capitalizedIncomeClassificationOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_OPTIONS)
  private List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS = "capitalizedIncomeClassificationToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_CLASSIFICATION_TO_INCOME_ACCOUNT_MAPPINGS)
  private List<GetClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY = "capitalizedIncomeStrategy";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY)
  private StringEnumOptionData capitalizedIncomeStrategy;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY_OPTIONS = "capitalizedIncomeStrategyOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_STRATEGY_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeStrategyOptions;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE = "capitalizedIncomeType";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE)
  private StringEnumOptionData capitalizedIncomeType;

  public static final String SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE_OPTIONS = "capitalizedIncomeTypeOptions";
  @SerializedName(SERIALIZED_NAME_CAPITALIZED_INCOME_TYPE_OPTIONS)
  private List<StringEnumOptionData> capitalizedIncomeTypeOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR = "chargeOffBehaviour";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_BEHAVIOUR)
  private StringEnumOptionData chargeOffBehaviour;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS = "chargeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_OPTIONS)
  private List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions;

  public static final String SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS = "chargeOffReasonToExpenseAccountMappings";
  @SerializedName(SERIALIZED_NAME_CHARGE_OFF_REASON_TO_EXPENSE_ACCOUNT_MAPPINGS)
  private List<GetChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings;

  public static final String SERIALIZED_NAME_CHARGES = "charges";
  @SerializedName(SERIALIZED_NAME_CHARGES)
  private List<LoanProductChargeData> charges;

  public static final String SERIALIZED_NAME_CREDIT_ALLOCATION = "creditAllocation";
  @SerializedName(SERIALIZED_NAME_CREDIT_ALLOCATION)
  private List<CreditAllocationData> creditAllocation;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private GetLoanProductsCurrency currency;

  public static final String SERIALIZED_NAME_DAYS_IN_MONTH_TYPE = "daysInMonthType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_MONTH_TYPE)
  private GetLoanProductsDaysInMonthType daysInMonthType;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY = "daysInYearCustomStrategy";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_CUSTOM_STRATEGY)
  private StringEnumOptionData daysInYearCustomStrategy;

  public static final String SERIALIZED_NAME_DAYS_IN_YEAR_TYPE = "daysInYearType";
  @SerializedName(SERIALIZED_NAME_DAYS_IN_YEAR_TYPE)
  private GetLoanProductsDaysInYearType daysInYearType;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET = "delinquencyBucket";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET)
  private DelinquencyBucketData delinquencyBucket;

  public static final String SERIALIZED_NAME_DELINQUENCY_BUCKET_OPTIONS = "delinquencyBucketOptions";
  @SerializedName(SERIALIZED_NAME_DELINQUENCY_BUCKET_OPTIONS)
  private List<DelinquencyBucketData> delinquencyBucketOptions;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS = "disallowExpectedDisbursements";
  @SerializedName(SERIALIZED_NAME_DISALLOW_EXPECTED_DISBURSEMENTS)
  private Boolean disallowExpectedDisbursements;

  public static final String SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT = "disbursedAmountPercentageForDownPayment";
  @SerializedName(SERIALIZED_NAME_DISBURSED_AMOUNT_PERCENTAGE_FOR_DOWN_PAYMENT)
  private BigDecimal disbursedAmountPercentageForDownPayment;

  public static final String SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT = "dueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer dueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING = "enableAccrualActivityPosting";
  @SerializedName(SERIALIZED_NAME_ENABLE_ACCRUAL_ACTIVITY_POSTING)
  private Boolean enableAccrualActivityPosting;

  public static final String SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT = "enableAutoRepaymentForDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_AUTO_REPAYMENT_FOR_DOWN_PAYMENT)
  private Boolean enableAutoRepaymentForDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE = "enableBuyDownFee";
  @SerializedName(SERIALIZED_NAME_ENABLE_BUY_DOWN_FEE)
  private Boolean enableBuyDownFee;

  public static final String SERIALIZED_NAME_ENABLE_DOWN_PAYMENT = "enableDownPayment";
  @SerializedName(SERIALIZED_NAME_ENABLE_DOWN_PAYMENT)
  private Boolean enableDownPayment;

  public static final String SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION = "enableIncomeCapitalization";
  @SerializedName(SERIALIZED_NAME_ENABLE_INCOME_CAPITALIZATION)
  private Boolean enableIncomeCapitalization;

  public static final String SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY = "enableInstallmentLevelDelinquency";
  @SerializedName(SERIALIZED_NAME_ENABLE_INSTALLMENT_LEVEL_DELINQUENCY)
  private Boolean enableInstallmentLevelDelinquency;

  public static final String SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS = "feeToIncomeAccountMappings";
  @SerializedName(SERIALIZED_NAME_FEE_TO_INCOME_ACCOUNT_MAPPINGS)
  private Set<GetLoanFeeToIncomeAccountMappings> feeToIncomeAccountMappings;

  public static final String SERIALIZED_NAME_FIXED_LENGTH = "fixedLength";
  @SerializedName(SERIALIZED_NAME_FIXED_LENGTH)
  private Integer fixedLength;

  public static final String SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT = "fixedPrincipalPercentagePerInstallment";
  @SerializedName(SERIALIZED_NAME_FIXED_PRINCIPAL_PERCENTAGE_PER_INSTALLMENT)
  private BigDecimal fixedPrincipalPercentagePerInstallment;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Long id;

  public static final String SERIALIZED_NAME_IN_ARREARS_TOLERANCE = "inArrearsTolerance";
  @SerializedName(SERIALIZED_NAME_IN_ARREARS_TOLERANCE)
  private Integer inArrearsTolerance;

  public static final String SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE = "includeInBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INCLUDE_IN_BORROWER_CYCLE)
  private Boolean includeInBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE = "interestCalculationPeriodType";
  @SerializedName(SERIALIZED_NAME_INTEREST_CALCULATION_PERIOD_TYPE)
  private GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE = "interestRateFrequencyType";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_FREQUENCY_TYPE)
  private GetLoanProductsInterestRateFrequencyType interestRateFrequencyType;

  public static final String SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD = "interestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_PER_PERIOD)
  private Double interestRatePerPeriod;

  public static final String SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE = "interestRateVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_INTEREST_RATE_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> interestRateVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_INTEREST_RECALCULATION_DATA = "interestRecalculationData";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECALCULATION_DATA)
  private GetLoanProductsInterestRecalculationData interestRecalculationData;

  public static final String SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE = "interestRecognitionOnDisbursementDate";
  @SerializedName(SERIALIZED_NAME_INTEREST_RECOGNITION_ON_DISBURSEMENT_DATE)
  private Boolean interestRecognitionOnDisbursementDate;

  public static final String SERIALIZED_NAME_INTEREST_TYPE = "interestType";
  @SerializedName(SERIALIZED_NAME_INTEREST_TYPE)
  private GetLoanProductsInterestTemplateType interestType;

  public static final String SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED = "isFloatingInterestRateCalculationAllowed";
  @SerializedName(SERIALIZED_NAME_IS_FLOATING_INTEREST_RATE_CALCULATION_ALLOWED)
  private Boolean isFloatingInterestRateCalculationAllowed;

  public static final String SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED = "isInterestRecalculationEnabled";
  @SerializedName(SERIALIZED_NAME_IS_INTEREST_RECALCULATION_ENABLED)
  private Boolean isInterestRecalculationEnabled;

  public static final String SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES = "isLinkedToFloatingInterestRates";
  @SerializedName(SERIALIZED_NAME_IS_LINKED_TO_FLOATING_INTEREST_RATES)
  private Boolean isLinkedToFloatingInterestRates;

  public static final String SERIALIZED_NAME_IS_RATES_ENABLED = "isRatesEnabled";
  @SerializedName(SERIALIZED_NAME_IS_RATES_ENABLED)
  private Boolean isRatesEnabled;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE = "loanScheduleProcessingType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_PROCESSING_TYPE)
  private EnumOptionData loanScheduleProcessingType;

  public static final String SERIALIZED_NAME_LOAN_SCHEDULE_TYPE = "loanScheduleType";
  @SerializedName(SERIALIZED_NAME_LOAN_SCHEDULE_TYPE)
  private EnumOptionData loanScheduleType;

  public static final String SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD = "maxInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MAX_INTEREST_RATE_PER_PERIOD)
  private Double maxInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS = "maxNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MAX_NUMBER_OF_REPAYMENTS)
  private Integer maxNumberOfRepayments;

  public static final String SERIALIZED_NAME_MAX_PRINCIPAL = "maxPrincipal";
  @SerializedName(SERIALIZED_NAME_MAX_PRINCIPAL)
  private Double maxPrincipal;

  public static final String SERIALIZED_NAME_MAX_TRANCHE_COUNT = "maxTrancheCount";
  @SerializedName(SERIALIZED_NAME_MAX_TRANCHE_COUNT)
  private Integer maxTrancheCount;

  public static final String SERIALIZED_NAME_MAXIMUM_GAP = "maximumGap";
  @SerializedName(SERIALIZED_NAME_MAXIMUM_GAP)
  private Integer maximumGap;

  public static final String SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE = "merchantBuyDownFee";
  @SerializedName(SERIALIZED_NAME_MERCHANT_BUY_DOWN_FEE)
  private Boolean merchantBuyDownFee;

  public static final String SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD = "minInterestRatePerPeriod";
  @SerializedName(SERIALIZED_NAME_MIN_INTEREST_RATE_PER_PERIOD)
  private Double minInterestRatePerPeriod;

  public static final String SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS = "minNumberOfRepayments";
  @SerializedName(SERIALIZED_NAME_MIN_NUMBER_OF_REPAYMENTS)
  private Integer minNumberOfRepayments;

  public static final String SERIALIZED_NAME_MIN_PRINCIPAL = "minPrincipal";
  @SerializedName(SERIALIZED_NAME_MIN_PRINCIPAL)
  private Double minPrincipal;

  public static final String SERIALIZED_NAME_MINIMUM_GAP = "minimumGap";
  @SerializedName(SERIALIZED_NAME_MINIMUM_GAP)
  private Integer minimumGap;

  public static final String SERIALIZED_NAME_MULTI_DISBURSE_LOAN = "multiDisburseLoan";
  @SerializedName(SERIALIZED_NAME_MULTI_DISBURSE_LOAN)
  private Boolean multiDisburseLoan;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE = "numberOfRepaymentVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENT_VARIATIONS_FOR_BORROWER_CYCLE)
  private List<Integer> numberOfRepaymentVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_NUMBER_OF_REPAYMENTS = "numberOfRepayments";
  @SerializedName(SERIALIZED_NAME_NUMBER_OF_REPAYMENTS)
  private Integer numberOfRepayments;

  public static final String SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE = "outstandingLoanBalance";
  @SerializedName(SERIALIZED_NAME_OUTSTANDING_LOAN_BALANCE)
  private Double outstandingLoanBalance;

  public static final String SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE = "overAppliedCalculationType";
  @SerializedName(SERIALIZED_NAME_OVER_APPLIED_CALCULATION_TYPE)
  private String overAppliedCalculationType;

  public static final String SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT = "overDueDaysForRepaymentEvent";
  @SerializedName(SERIALIZED_NAME_OVER_DUE_DAYS_FOR_REPAYMENT_EVENT)
  private Integer overDueDaysForRepaymentEvent;

  public static final String SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A = "overdueDaysForNPA";
  @SerializedName(SERIALIZED_NAME_OVERDUE_DAYS_FOR_N_P_A)
  private Integer overdueDaysForNPA;

  public static final String SERIALIZED_NAME_PAYMENT_ALLOCATION = "paymentAllocation";
  @SerializedName(SERIALIZED_NAME_PAYMENT_ALLOCATION)
  private List<AdvancedPaymentData> paymentAllocation;

  public static final String SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS = "paymentChannelToFundSourceMappings";
  @SerializedName(SERIALIZED_NAME_PAYMENT_CHANNEL_TO_FUND_SOURCE_MAPPINGS)
  private Set<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings;

  public static final String SERIALIZED_NAME_PRINCIPAL = "principal";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL)
  private Double principal;

  public static final String SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALMENT = "principalThresholdForLastInstalment";
  @SerializedName(SERIALIZED_NAME_PRINCIPAL_THRESHOLD_FOR_LAST_INSTALMENT)
  private Integer principalThresholdForLastInstalment;

  public static final String SERIALIZED_NAME_PRODUCTS_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE = "productsPrincipalVariationsForBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_PRODUCTS_PRINCIPAL_VARIATIONS_FOR_BORROWER_CYCLE)
  private Set<GetLoanProductsPrincipalVariationsForBorrowerCycle> productsPrincipalVariationsForBorrowerCycle;

  public static final String SERIALIZED_NAME_REPAYMENT_EVERY = "repaymentEvery";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_EVERY)
  private Integer repaymentEvery;

  public static final String SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE = "repaymentFrequencyType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_FREQUENCY_TYPE)
  private GetLoanProductsRepaymentFrequencyType repaymentFrequencyType;

  public static final String SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE = "repaymentStartDateType";
  @SerializedName(SERIALIZED_NAME_REPAYMENT_START_DATE_TYPE)
  private GetLoanProductsRepaymentStartDateType repaymentStartDateType;

  public static final String SERIALIZED_NAME_SHORT_NAME = "shortName";
  @SerializedName(SERIALIZED_NAME_SHORT_NAME)
  private String shortName;

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private String status;

  public static final String SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES = "supportedInterestRefundTypes";
  @SerializedName(SERIALIZED_NAME_SUPPORTED_INTEREST_REFUND_TYPES)
  private List<StringEnumOptionData> supportedInterestRefundTypes;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE = "transactionProcessingStrategyCode";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_CODE)
  private String transactionProcessingStrategyCode;

  public static final String SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME = "transactionProcessingStrategyName";
  @SerializedName(SERIALIZED_NAME_TRANSACTION_PROCESSING_STRATEGY_NAME)
  private String transactionProcessingStrategyName;

  public static final String SERIALIZED_NAME_USE_BORROWER_CYCLE = "useBorrowerCycle";
  @SerializedName(SERIALIZED_NAME_USE_BORROWER_CYCLE)
  private Boolean useBorrowerCycle;

  public static final String SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS = "writeOffReasonOptions";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_REASON_OPTIONS)
  private List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions;

  public static final String SERIALIZED_NAME_WRITE_OFF_REASONS_TO_EXPENSE_MAPPINGS = "writeOffReasonsToExpenseMappings";
  @SerializedName(SERIALIZED_NAME_WRITE_OFF_REASONS_TO_EXPENSE_MAPPINGS)
  private List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings;

  public GetLoanProductsProductIdResponse() {
  }

  public GetLoanProductsProductIdResponse accountingMappings(GetLoanAccountingMappings accountingMappings) {
    
    this.accountingMappings = accountingMappings;
    return this;
  }

  /**
   * Get accountingMappings
   * @return accountingMappings
   */
  @javax.annotation.Nullable

  public GetLoanAccountingMappings getAccountingMappings() {
    return accountingMappings;
  }


  public void setAccountingMappings(GetLoanAccountingMappings accountingMappings) {
    this.accountingMappings = accountingMappings;
  }

  public GetLoanProductsProductIdResponse accountingRule(GetLoanProductsAccountingRule accountingRule) {
    
    this.accountingRule = accountingRule;
    return this;
  }

  /**
   * Get accountingRule
   * @return accountingRule
   */
  @javax.annotation.Nullable

  public GetLoanProductsAccountingRule getAccountingRule() {
    return accountingRule;
  }


  public void setAccountingRule(GetLoanProductsAccountingRule accountingRule) {
    this.accountingRule = accountingRule;
  }

  public GetLoanProductsProductIdResponse allowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
    return this;
  }

  /**
   * Get allowApprovedDisbursedAmountsOverApplied
   * @return allowApprovedDisbursedAmountsOverApplied
   */
  @javax.annotation.Nullable

  public Boolean getAllowApprovedDisbursedAmountsOverApplied() {
    return allowApprovedDisbursedAmountsOverApplied;
  }


  public void setAllowApprovedDisbursedAmountsOverApplied(Boolean allowApprovedDisbursedAmountsOverApplied) {
    this.allowApprovedDisbursedAmountsOverApplied = allowApprovedDisbursedAmountsOverApplied;
  }

  public GetLoanProductsProductIdResponse allowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
    return this;
  }

  /**
   * Get allowPartialPeriodInterestCalculation
   * @return allowPartialPeriodInterestCalculation
   */
  @javax.annotation.Nullable

  public Boolean getAllowPartialPeriodInterestCalculation() {
    return allowPartialPeriodInterestCalculation;
  }


  public void setAllowPartialPeriodInterestCalculation(Boolean allowPartialPeriodInterestCalculation) {
    this.allowPartialPeriodInterestCalculation = allowPartialPeriodInterestCalculation;
  }

  public GetLoanProductsProductIdResponse allowVariableInstallments(Boolean allowVariableInstallments) {
    
    this.allowVariableInstallments = allowVariableInstallments;
    return this;
  }

  /**
   * Get allowVariableInstallments
   * @return allowVariableInstallments
   */
  @javax.annotation.Nullable

  public Boolean getAllowVariableInstallments() {
    return allowVariableInstallments;
  }


  public void setAllowVariableInstallments(Boolean allowVariableInstallments) {
    this.allowVariableInstallments = allowVariableInstallments;
  }

  public GetLoanProductsProductIdResponse amortizationType(GetLoanProductsAmortizationType amortizationType) {
    
    this.amortizationType = amortizationType;
    return this;
  }

  /**
   * Get amortizationType
   * @return amortizationType
   */
  @javax.annotation.Nullable

  public GetLoanProductsAmortizationType getAmortizationType() {
    return amortizationType;
  }


  public void setAmortizationType(GetLoanProductsAmortizationType amortizationType) {
    this.amortizationType = amortizationType;
  }

  public GetLoanProductsProductIdResponse annualInterestRate(Double annualInterestRate) {
    
    this.annualInterestRate = annualInterestRate;
    return this;
  }

  /**
   * Get annualInterestRate
   * @return annualInterestRate
   */
  @javax.annotation.Nullable

  public Double getAnnualInterestRate() {
    return annualInterestRate;
  }


  public void setAnnualInterestRate(Double annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  public GetLoanProductsProductIdResponse buyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
    return this;
  }

  /**
   * Get buyDownFeeCalculationType
   * @return buyDownFeeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeCalculationType() {
    return buyDownFeeCalculationType;
  }


  public void setBuyDownFeeCalculationType(StringEnumOptionData buyDownFeeCalculationType) {
    this.buyDownFeeCalculationType = buyDownFeeCalculationType;
  }

  public GetLoanProductsProductIdResponse buyDownFeeCalculationTypeOptions(List<StringEnumOptionData> buyDownFeeCalculationTypeOptions) {
    
    this.buyDownFeeCalculationTypeOptions = buyDownFeeCalculationTypeOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addBuyDownFeeCalculationTypeOptionsItem(StringEnumOptionData buyDownFeeCalculationTypeOptionsItem) {
    if (this.buyDownFeeCalculationTypeOptions == null) {
      this.buyDownFeeCalculationTypeOptions = new ArrayList<>();
    }
    this.buyDownFeeCalculationTypeOptions.add(buyDownFeeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeCalculationTypeOptions
   * @return buyDownFeeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeCalculationTypeOptions() {
    return buyDownFeeCalculationTypeOptions;
  }


  public void setBuyDownFeeCalculationTypeOptions(List<StringEnumOptionData> buyDownFeeCalculationTypeOptions) {
    this.buyDownFeeCalculationTypeOptions = buyDownFeeCalculationTypeOptions;
  }

  public GetLoanProductsProductIdResponse buyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
    return this;
  }

  /**
   * Get buyDownFeeIncomeType
   * @return buyDownFeeIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeIncomeType() {
    return buyDownFeeIncomeType;
  }


  public void setBuyDownFeeIncomeType(StringEnumOptionData buyDownFeeIncomeType) {
    this.buyDownFeeIncomeType = buyDownFeeIncomeType;
  }

  public GetLoanProductsProductIdResponse buyDownFeeIncomeTypeOptions(List<StringEnumOptionData> buyDownFeeIncomeTypeOptions) {
    
    this.buyDownFeeIncomeTypeOptions = buyDownFeeIncomeTypeOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addBuyDownFeeIncomeTypeOptionsItem(StringEnumOptionData buyDownFeeIncomeTypeOptionsItem) {
    if (this.buyDownFeeIncomeTypeOptions == null) {
      this.buyDownFeeIncomeTypeOptions = new ArrayList<>();
    }
    this.buyDownFeeIncomeTypeOptions.add(buyDownFeeIncomeTypeOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeIncomeTypeOptions
   * @return buyDownFeeIncomeTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeIncomeTypeOptions() {
    return buyDownFeeIncomeTypeOptions;
  }


  public void setBuyDownFeeIncomeTypeOptions(List<StringEnumOptionData> buyDownFeeIncomeTypeOptions) {
    this.buyDownFeeIncomeTypeOptions = buyDownFeeIncomeTypeOptions;
  }

  public GetLoanProductsProductIdResponse buyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    
    this.buyDownFeeStrategy = buyDownFeeStrategy;
    return this;
  }

  /**
   * Get buyDownFeeStrategy
   * @return buyDownFeeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getBuyDownFeeStrategy() {
    return buyDownFeeStrategy;
  }


  public void setBuyDownFeeStrategy(StringEnumOptionData buyDownFeeStrategy) {
    this.buyDownFeeStrategy = buyDownFeeStrategy;
  }

  public GetLoanProductsProductIdResponse buyDownFeeStrategyOptions(List<StringEnumOptionData> buyDownFeeStrategyOptions) {
    
    this.buyDownFeeStrategyOptions = buyDownFeeStrategyOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addBuyDownFeeStrategyOptionsItem(StringEnumOptionData buyDownFeeStrategyOptionsItem) {
    if (this.buyDownFeeStrategyOptions == null) {
      this.buyDownFeeStrategyOptions = new ArrayList<>();
    }
    this.buyDownFeeStrategyOptions.add(buyDownFeeStrategyOptionsItem);
    return this;
  }

  /**
   * Get buyDownFeeStrategyOptions
   * @return buyDownFeeStrategyOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getBuyDownFeeStrategyOptions() {
    return buyDownFeeStrategyOptions;
  }


  public void setBuyDownFeeStrategyOptions(List<StringEnumOptionData> buyDownFeeStrategyOptions) {
    this.buyDownFeeStrategyOptions = buyDownFeeStrategyOptions;
  }

  public GetLoanProductsProductIdResponse buydownFeeClassificationOptions(List<GetCodeValuesDataResponse> buydownFeeClassificationOptions) {
    
    this.buydownFeeClassificationOptions = buydownFeeClassificationOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addBuydownFeeClassificationOptionsItem(GetCodeValuesDataResponse buydownFeeClassificationOptionsItem) {
    if (this.buydownFeeClassificationOptions == null) {
      this.buydownFeeClassificationOptions = new ArrayList<>();
    }
    this.buydownFeeClassificationOptions.add(buydownFeeClassificationOptionsItem);
    return this;
  }

  /**
   * Get buydownFeeClassificationOptions
   * @return buydownFeeClassificationOptions
   */
  @javax.annotation.Nullable

  public List<GetCodeValuesDataResponse> getBuydownFeeClassificationOptions() {
    return buydownFeeClassificationOptions;
  }


  public void setBuydownFeeClassificationOptions(List<GetCodeValuesDataResponse> buydownFeeClassificationOptions) {
    this.buydownFeeClassificationOptions = buydownFeeClassificationOptions;
  }

  public GetLoanProductsProductIdResponse buydownFeeClassificationToIncomeAccountMappings(List<GetClassificationToIncomeAccountMappings> buydownFeeClassificationToIncomeAccountMappings) {
    
    this.buydownFeeClassificationToIncomeAccountMappings = buydownFeeClassificationToIncomeAccountMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addBuydownFeeClassificationToIncomeAccountMappingsItem(GetClassificationToIncomeAccountMappings buydownFeeClassificationToIncomeAccountMappingsItem) {
    if (this.buydownFeeClassificationToIncomeAccountMappings == null) {
      this.buydownFeeClassificationToIncomeAccountMappings = new ArrayList<>();
    }
    this.buydownFeeClassificationToIncomeAccountMappings.add(buydownFeeClassificationToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get buydownFeeClassificationToIncomeAccountMappings
   * @return buydownFeeClassificationToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<GetClassificationToIncomeAccountMappings> getBuydownFeeClassificationToIncomeAccountMappings() {
    return buydownFeeClassificationToIncomeAccountMappings;
  }


  public void setBuydownFeeClassificationToIncomeAccountMappings(List<GetClassificationToIncomeAccountMappings> buydownFeeClassificationToIncomeAccountMappings) {
    this.buydownFeeClassificationToIncomeAccountMappings = buydownFeeClassificationToIncomeAccountMappings;
  }

  public GetLoanProductsProductIdResponse canDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
    return this;
  }

  /**
   * Get canDefineInstallmentAmount
   * @return canDefineInstallmentAmount
   */
  @javax.annotation.Nullable

  public Boolean getCanDefineInstallmentAmount() {
    return canDefineInstallmentAmount;
  }


  public void setCanDefineInstallmentAmount(Boolean canDefineInstallmentAmount) {
    this.canDefineInstallmentAmount = canDefineInstallmentAmount;
  }

  public GetLoanProductsProductIdResponse canUseForTopup(Boolean canUseForTopup) {
    
    this.canUseForTopup = canUseForTopup;
    return this;
  }

  /**
   * Get canUseForTopup
   * @return canUseForTopup
   */
  @javax.annotation.Nullable

  public Boolean getCanUseForTopup() {
    return canUseForTopup;
  }


  public void setCanUseForTopup(Boolean canUseForTopup) {
    this.canUseForTopup = canUseForTopup;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationType
   * @return capitalizedIncomeCalculationType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeCalculationType() {
    return capitalizedIncomeCalculationType;
  }


  public void setCapitalizedIncomeCalculationType(StringEnumOptionData capitalizedIncomeCalculationType) {
    this.capitalizedIncomeCalculationType = capitalizedIncomeCalculationType;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeCalculationTypeOptions(List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions) {
    
    this.capitalizedIncomeCalculationTypeOptions = capitalizedIncomeCalculationTypeOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addCapitalizedIncomeCalculationTypeOptionsItem(StringEnumOptionData capitalizedIncomeCalculationTypeOptionsItem) {
    if (this.capitalizedIncomeCalculationTypeOptions == null) {
      this.capitalizedIncomeCalculationTypeOptions = new ArrayList<>();
    }
    this.capitalizedIncomeCalculationTypeOptions.add(capitalizedIncomeCalculationTypeOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeCalculationTypeOptions
   * @return capitalizedIncomeCalculationTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeCalculationTypeOptions() {
    return capitalizedIncomeCalculationTypeOptions;
  }


  public void setCapitalizedIncomeCalculationTypeOptions(List<StringEnumOptionData> capitalizedIncomeCalculationTypeOptions) {
    this.capitalizedIncomeCalculationTypeOptions = capitalizedIncomeCalculationTypeOptions;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeClassificationOptions(List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions) {
    
    this.capitalizedIncomeClassificationOptions = capitalizedIncomeClassificationOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addCapitalizedIncomeClassificationOptionsItem(GetCodeValuesDataResponse capitalizedIncomeClassificationOptionsItem) {
    if (this.capitalizedIncomeClassificationOptions == null) {
      this.capitalizedIncomeClassificationOptions = new ArrayList<>();
    }
    this.capitalizedIncomeClassificationOptions.add(capitalizedIncomeClassificationOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeClassificationOptions
   * @return capitalizedIncomeClassificationOptions
   */
  @javax.annotation.Nullable

  public List<GetCodeValuesDataResponse> getCapitalizedIncomeClassificationOptions() {
    return capitalizedIncomeClassificationOptions;
  }


  public void setCapitalizedIncomeClassificationOptions(List<GetCodeValuesDataResponse> capitalizedIncomeClassificationOptions) {
    this.capitalizedIncomeClassificationOptions = capitalizedIncomeClassificationOptions;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeClassificationToIncomeAccountMappings(List<GetClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings) {
    
    this.capitalizedIncomeClassificationToIncomeAccountMappings = capitalizedIncomeClassificationToIncomeAccountMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addCapitalizedIncomeClassificationToIncomeAccountMappingsItem(GetClassificationToIncomeAccountMappings capitalizedIncomeClassificationToIncomeAccountMappingsItem) {
    if (this.capitalizedIncomeClassificationToIncomeAccountMappings == null) {
      this.capitalizedIncomeClassificationToIncomeAccountMappings = new ArrayList<>();
    }
    this.capitalizedIncomeClassificationToIncomeAccountMappings.add(capitalizedIncomeClassificationToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeClassificationToIncomeAccountMappings
   * @return capitalizedIncomeClassificationToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public List<GetClassificationToIncomeAccountMappings> getCapitalizedIncomeClassificationToIncomeAccountMappings() {
    return capitalizedIncomeClassificationToIncomeAccountMappings;
  }


  public void setCapitalizedIncomeClassificationToIncomeAccountMappings(List<GetClassificationToIncomeAccountMappings> capitalizedIncomeClassificationToIncomeAccountMappings) {
    this.capitalizedIncomeClassificationToIncomeAccountMappings = capitalizedIncomeClassificationToIncomeAccountMappings;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
    return this;
  }

  /**
   * Get capitalizedIncomeStrategy
   * @return capitalizedIncomeStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeStrategy() {
    return capitalizedIncomeStrategy;
  }


  public void setCapitalizedIncomeStrategy(StringEnumOptionData capitalizedIncomeStrategy) {
    this.capitalizedIncomeStrategy = capitalizedIncomeStrategy;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeStrategyOptions(List<StringEnumOptionData> capitalizedIncomeStrategyOptions) {
    
    this.capitalizedIncomeStrategyOptions = capitalizedIncomeStrategyOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addCapitalizedIncomeStrategyOptionsItem(StringEnumOptionData capitalizedIncomeStrategyOptionsItem) {
    if (this.capitalizedIncomeStrategyOptions == null) {
      this.capitalizedIncomeStrategyOptions = new ArrayList<>();
    }
    this.capitalizedIncomeStrategyOptions.add(capitalizedIncomeStrategyOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeStrategyOptions
   * @return capitalizedIncomeStrategyOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeStrategyOptions() {
    return capitalizedIncomeStrategyOptions;
  }


  public void setCapitalizedIncomeStrategyOptions(List<StringEnumOptionData> capitalizedIncomeStrategyOptions) {
    this.capitalizedIncomeStrategyOptions = capitalizedIncomeStrategyOptions;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    
    this.capitalizedIncomeType = capitalizedIncomeType;
    return this;
  }

  /**
   * Get capitalizedIncomeType
   * @return capitalizedIncomeType
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getCapitalizedIncomeType() {
    return capitalizedIncomeType;
  }


  public void setCapitalizedIncomeType(StringEnumOptionData capitalizedIncomeType) {
    this.capitalizedIncomeType = capitalizedIncomeType;
  }

  public GetLoanProductsProductIdResponse capitalizedIncomeTypeOptions(List<StringEnumOptionData> capitalizedIncomeTypeOptions) {
    
    this.capitalizedIncomeTypeOptions = capitalizedIncomeTypeOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addCapitalizedIncomeTypeOptionsItem(StringEnumOptionData capitalizedIncomeTypeOptionsItem) {
    if (this.capitalizedIncomeTypeOptions == null) {
      this.capitalizedIncomeTypeOptions = new ArrayList<>();
    }
    this.capitalizedIncomeTypeOptions.add(capitalizedIncomeTypeOptionsItem);
    return this;
  }

  /**
   * Get capitalizedIncomeTypeOptions
   * @return capitalizedIncomeTypeOptions
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getCapitalizedIncomeTypeOptions() {
    return capitalizedIncomeTypeOptions;
  }


  public void setCapitalizedIncomeTypeOptions(List<StringEnumOptionData> capitalizedIncomeTypeOptions) {
    this.capitalizedIncomeTypeOptions = capitalizedIncomeTypeOptions;
  }

  public GetLoanProductsProductIdResponse chargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    
    this.chargeOffBehaviour = chargeOffBehaviour;
    return this;
  }

  /**
   * Get chargeOffBehaviour
   * @return chargeOffBehaviour
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getChargeOffBehaviour() {
    return chargeOffBehaviour;
  }


  public void setChargeOffBehaviour(StringEnumOptionData chargeOffBehaviour) {
    this.chargeOffBehaviour = chargeOffBehaviour;
  }

  public GetLoanProductsProductIdResponse chargeOffReasonOptions(List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions) {
    
    this.chargeOffReasonOptions = chargeOffReasonOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addChargeOffReasonOptionsItem(GetLoanProductsChargeOffReasonOptions chargeOffReasonOptionsItem) {
    if (this.chargeOffReasonOptions == null) {
      this.chargeOffReasonOptions = new ArrayList<>();
    }
    this.chargeOffReasonOptions.add(chargeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get chargeOffReasonOptions
   * @return chargeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<GetLoanProductsChargeOffReasonOptions> getChargeOffReasonOptions() {
    return chargeOffReasonOptions;
  }


  public void setChargeOffReasonOptions(List<GetLoanProductsChargeOffReasonOptions> chargeOffReasonOptions) {
    this.chargeOffReasonOptions = chargeOffReasonOptions;
  }

  public GetLoanProductsProductIdResponse chargeOffReasonToExpenseAccountMappings(List<GetChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addChargeOffReasonToExpenseAccountMappingsItem(GetChargeOffReasonToExpenseAccountMappings chargeOffReasonToExpenseAccountMappingsItem) {
    if (this.chargeOffReasonToExpenseAccountMappings == null) {
      this.chargeOffReasonToExpenseAccountMappings = new ArrayList<>();
    }
    this.chargeOffReasonToExpenseAccountMappings.add(chargeOffReasonToExpenseAccountMappingsItem);
    return this;
  }

  /**
   * Get chargeOffReasonToExpenseAccountMappings
   * @return chargeOffReasonToExpenseAccountMappings
   */
  @javax.annotation.Nullable

  public List<GetChargeOffReasonToExpenseAccountMappings> getChargeOffReasonToExpenseAccountMappings() {
    return chargeOffReasonToExpenseAccountMappings;
  }


  public void setChargeOffReasonToExpenseAccountMappings(List<GetChargeOffReasonToExpenseAccountMappings> chargeOffReasonToExpenseAccountMappings) {
    this.chargeOffReasonToExpenseAccountMappings = chargeOffReasonToExpenseAccountMappings;
  }

  public GetLoanProductsProductIdResponse charges(List<LoanProductChargeData> charges) {
    
    this.charges = charges;
    return this;
  }

  public GetLoanProductsProductIdResponse addChargesItem(LoanProductChargeData chargesItem) {
    if (this.charges == null) {
      this.charges = new ArrayList<>();
    }
    this.charges.add(chargesItem);
    return this;
  }

  /**
   * Get charges
   * @return charges
   */
  @javax.annotation.Nullable

  public List<LoanProductChargeData> getCharges() {
    return charges;
  }


  public void setCharges(List<LoanProductChargeData> charges) {
    this.charges = charges;
  }

  public GetLoanProductsProductIdResponse creditAllocation(List<CreditAllocationData> creditAllocation) {
    
    this.creditAllocation = creditAllocation;
    return this;
  }

  public GetLoanProductsProductIdResponse addCreditAllocationItem(CreditAllocationData creditAllocationItem) {
    if (this.creditAllocation == null) {
      this.creditAllocation = new ArrayList<>();
    }
    this.creditAllocation.add(creditAllocationItem);
    return this;
  }

  /**
   * Get creditAllocation
   * @return creditAllocation
   */
  @javax.annotation.Nullable

  public List<CreditAllocationData> getCreditAllocation() {
    return creditAllocation;
  }


  public void setCreditAllocation(List<CreditAllocationData> creditAllocation) {
    this.creditAllocation = creditAllocation;
  }

  public GetLoanProductsProductIdResponse currency(GetLoanProductsCurrency currency) {
    
    this.currency = currency;
    return this;
  }

  /**
   * Get currency
   * @return currency
   */
  @javax.annotation.Nullable

  public GetLoanProductsCurrency getCurrency() {
    return currency;
  }


  public void setCurrency(GetLoanProductsCurrency currency) {
    this.currency = currency;
  }

  public GetLoanProductsProductIdResponse daysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    
    this.daysInMonthType = daysInMonthType;
    return this;
  }

  /**
   * Get daysInMonthType
   * @return daysInMonthType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInMonthType getDaysInMonthType() {
    return daysInMonthType;
  }


  public void setDaysInMonthType(GetLoanProductsDaysInMonthType daysInMonthType) {
    this.daysInMonthType = daysInMonthType;
  }

  public GetLoanProductsProductIdResponse daysInYearCustomStrategy(StringEnumOptionData daysInYearCustomStrategy) {
    
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
    return this;
  }

  /**
   * Get daysInYearCustomStrategy
   * @return daysInYearCustomStrategy
   */
  @javax.annotation.Nullable

  public StringEnumOptionData getDaysInYearCustomStrategy() {
    return daysInYearCustomStrategy;
  }


  public void setDaysInYearCustomStrategy(StringEnumOptionData daysInYearCustomStrategy) {
    this.daysInYearCustomStrategy = daysInYearCustomStrategy;
  }

  public GetLoanProductsProductIdResponse daysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    
    this.daysInYearType = daysInYearType;
    return this;
  }

  /**
   * Get daysInYearType
   * @return daysInYearType
   */
  @javax.annotation.Nullable

  public GetLoanProductsDaysInYearType getDaysInYearType() {
    return daysInYearType;
  }


  public void setDaysInYearType(GetLoanProductsDaysInYearType daysInYearType) {
    this.daysInYearType = daysInYearType;
  }

  public GetLoanProductsProductIdResponse delinquencyBucket(DelinquencyBucketData delinquencyBucket) {
    
    this.delinquencyBucket = delinquencyBucket;
    return this;
  }

  /**
   * Get delinquencyBucket
   * @return delinquencyBucket
   */
  @javax.annotation.Nullable

  public DelinquencyBucketData getDelinquencyBucket() {
    return delinquencyBucket;
  }


  public void setDelinquencyBucket(DelinquencyBucketData delinquencyBucket) {
    this.delinquencyBucket = delinquencyBucket;
  }

  public GetLoanProductsProductIdResponse delinquencyBucketOptions(List<DelinquencyBucketData> delinquencyBucketOptions) {
    
    this.delinquencyBucketOptions = delinquencyBucketOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addDelinquencyBucketOptionsItem(DelinquencyBucketData delinquencyBucketOptionsItem) {
    if (this.delinquencyBucketOptions == null) {
      this.delinquencyBucketOptions = new ArrayList<>();
    }
    this.delinquencyBucketOptions.add(delinquencyBucketOptionsItem);
    return this;
  }

  /**
   * Get delinquencyBucketOptions
   * @return delinquencyBucketOptions
   */
  @javax.annotation.Nullable

  public List<DelinquencyBucketData> getDelinquencyBucketOptions() {
    return delinquencyBucketOptions;
  }


  public void setDelinquencyBucketOptions(List<DelinquencyBucketData> delinquencyBucketOptions) {
    this.delinquencyBucketOptions = delinquencyBucketOptions;
  }

  public GetLoanProductsProductIdResponse description(String description) {
    
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  public void setDescription(String description) {
    this.description = description;
  }

  public GetLoanProductsProductIdResponse disallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
    return this;
  }

  /**
   * Get disallowExpectedDisbursements
   * @return disallowExpectedDisbursements
   */
  @javax.annotation.Nullable

  public Boolean getDisallowExpectedDisbursements() {
    return disallowExpectedDisbursements;
  }


  public void setDisallowExpectedDisbursements(Boolean disallowExpectedDisbursements) {
    this.disallowExpectedDisbursements = disallowExpectedDisbursements;
  }

  public GetLoanProductsProductIdResponse disbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
    return this;
  }

  /**
   * Get disbursedAmountPercentageForDownPayment
   * @return disbursedAmountPercentageForDownPayment
   */
  @javax.annotation.Nullable

  public BigDecimal getDisbursedAmountPercentageForDownPayment() {
    return disbursedAmountPercentageForDownPayment;
  }


  public void setDisbursedAmountPercentageForDownPayment(BigDecimal disbursedAmountPercentageForDownPayment) {
    this.disbursedAmountPercentageForDownPayment = disbursedAmountPercentageForDownPayment;
  }

  public GetLoanProductsProductIdResponse dueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get dueDaysForRepaymentEvent
   * @return dueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getDueDaysForRepaymentEvent() {
    return dueDaysForRepaymentEvent;
  }


  public void setDueDaysForRepaymentEvent(Integer dueDaysForRepaymentEvent) {
    this.dueDaysForRepaymentEvent = dueDaysForRepaymentEvent;
  }

  public GetLoanProductsProductIdResponse enableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
    return this;
  }

  /**
   * Get enableAccrualActivityPosting
   * @return enableAccrualActivityPosting
   */
  @javax.annotation.Nullable

  public Boolean getEnableAccrualActivityPosting() {
    return enableAccrualActivityPosting;
  }


  public void setEnableAccrualActivityPosting(Boolean enableAccrualActivityPosting) {
    this.enableAccrualActivityPosting = enableAccrualActivityPosting;
  }

  public GetLoanProductsProductIdResponse enableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
    return this;
  }

  /**
   * Get enableAutoRepaymentForDownPayment
   * @return enableAutoRepaymentForDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableAutoRepaymentForDownPayment() {
    return enableAutoRepaymentForDownPayment;
  }


  public void setEnableAutoRepaymentForDownPayment(Boolean enableAutoRepaymentForDownPayment) {
    this.enableAutoRepaymentForDownPayment = enableAutoRepaymentForDownPayment;
  }

  public GetLoanProductsProductIdResponse enableBuyDownFee(Boolean enableBuyDownFee) {
    
    this.enableBuyDownFee = enableBuyDownFee;
    return this;
  }

  /**
   * Get enableBuyDownFee
   * @return enableBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getEnableBuyDownFee() {
    return enableBuyDownFee;
  }


  public void setEnableBuyDownFee(Boolean enableBuyDownFee) {
    this.enableBuyDownFee = enableBuyDownFee;
  }

  public GetLoanProductsProductIdResponse enableDownPayment(Boolean enableDownPayment) {
    
    this.enableDownPayment = enableDownPayment;
    return this;
  }

  /**
   * Get enableDownPayment
   * @return enableDownPayment
   */
  @javax.annotation.Nullable

  public Boolean getEnableDownPayment() {
    return enableDownPayment;
  }


  public void setEnableDownPayment(Boolean enableDownPayment) {
    this.enableDownPayment = enableDownPayment;
  }

  public GetLoanProductsProductIdResponse enableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    
    this.enableIncomeCapitalization = enableIncomeCapitalization;
    return this;
  }

  /**
   * Get enableIncomeCapitalization
   * @return enableIncomeCapitalization
   */
  @javax.annotation.Nullable

  public Boolean getEnableIncomeCapitalization() {
    return enableIncomeCapitalization;
  }


  public void setEnableIncomeCapitalization(Boolean enableIncomeCapitalization) {
    this.enableIncomeCapitalization = enableIncomeCapitalization;
  }

  public GetLoanProductsProductIdResponse enableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
    return this;
  }

  /**
   * Get enableInstallmentLevelDelinquency
   * @return enableInstallmentLevelDelinquency
   */
  @javax.annotation.Nullable

  public Boolean getEnableInstallmentLevelDelinquency() {
    return enableInstallmentLevelDelinquency;
  }


  public void setEnableInstallmentLevelDelinquency(Boolean enableInstallmentLevelDelinquency) {
    this.enableInstallmentLevelDelinquency = enableInstallmentLevelDelinquency;
  }

  public GetLoanProductsProductIdResponse feeToIncomeAccountMappings(Set<GetLoanFeeToIncomeAccountMappings> feeToIncomeAccountMappings) {
    
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addFeeToIncomeAccountMappingsItem(GetLoanFeeToIncomeAccountMappings feeToIncomeAccountMappingsItem) {
    if (this.feeToIncomeAccountMappings == null) {
      this.feeToIncomeAccountMappings = new LinkedHashSet<>();
    }
    this.feeToIncomeAccountMappings.add(feeToIncomeAccountMappingsItem);
    return this;
  }

  /**
   * Get feeToIncomeAccountMappings
   * @return feeToIncomeAccountMappings
   */
  @javax.annotation.Nullable

  public Set<GetLoanFeeToIncomeAccountMappings> getFeeToIncomeAccountMappings() {
    return feeToIncomeAccountMappings;
  }


  public void setFeeToIncomeAccountMappings(Set<GetLoanFeeToIncomeAccountMappings> feeToIncomeAccountMappings) {
    this.feeToIncomeAccountMappings = feeToIncomeAccountMappings;
  }

  public GetLoanProductsProductIdResponse fixedLength(Integer fixedLength) {
    
    this.fixedLength = fixedLength;
    return this;
  }

  /**
   * Get fixedLength
   * @return fixedLength
   */
  @javax.annotation.Nullable

  public Integer getFixedLength() {
    return fixedLength;
  }


  public void setFixedLength(Integer fixedLength) {
    this.fixedLength = fixedLength;
  }

  public GetLoanProductsProductIdResponse fixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
    return this;
  }

  /**
   * Get fixedPrincipalPercentagePerInstallment
   * @return fixedPrincipalPercentagePerInstallment
   */
  @javax.annotation.Nullable

  public BigDecimal getFixedPrincipalPercentagePerInstallment() {
    return fixedPrincipalPercentagePerInstallment;
  }


  public void setFixedPrincipalPercentagePerInstallment(BigDecimal fixedPrincipalPercentagePerInstallment) {
    this.fixedPrincipalPercentagePerInstallment = fixedPrincipalPercentagePerInstallment;
  }

  public GetLoanProductsProductIdResponse id(Long id) {
    
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @javax.annotation.Nullable

  public Long getId() {
    return id;
  }


  public void setId(Long id) {
    this.id = id;
  }

  public GetLoanProductsProductIdResponse inArrearsTolerance(Integer inArrearsTolerance) {
    
    this.inArrearsTolerance = inArrearsTolerance;
    return this;
  }

  /**
   * Get inArrearsTolerance
   * @return inArrearsTolerance
   */
  @javax.annotation.Nullable

  public Integer getInArrearsTolerance() {
    return inArrearsTolerance;
  }


  public void setInArrearsTolerance(Integer inArrearsTolerance) {
    this.inArrearsTolerance = inArrearsTolerance;
  }

  public GetLoanProductsProductIdResponse includeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    
    this.includeInBorrowerCycle = includeInBorrowerCycle;
    return this;
  }

  /**
   * Get includeInBorrowerCycle
   * @return includeInBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getIncludeInBorrowerCycle() {
    return includeInBorrowerCycle;
  }


  public void setIncludeInBorrowerCycle(Boolean includeInBorrowerCycle) {
    this.includeInBorrowerCycle = includeInBorrowerCycle;
  }

  public GetLoanProductsProductIdResponse interestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    
    this.interestCalculationPeriodType = interestCalculationPeriodType;
    return this;
  }

  /**
   * Get interestCalculationPeriodType
   * @return interestCalculationPeriodType
   */
  @javax.annotation.Nullable

  public GetLoansProductsInterestCalculationPeriodType getInterestCalculationPeriodType() {
    return interestCalculationPeriodType;
  }


  public void setInterestCalculationPeriodType(GetLoansProductsInterestCalculationPeriodType interestCalculationPeriodType) {
    this.interestCalculationPeriodType = interestCalculationPeriodType;
  }

  public GetLoanProductsProductIdResponse interestRateFrequencyType(GetLoanProductsInterestRateFrequencyType interestRateFrequencyType) {
    
    this.interestRateFrequencyType = interestRateFrequencyType;
    return this;
  }

  /**
   * Get interestRateFrequencyType
   * @return interestRateFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRateFrequencyType getInterestRateFrequencyType() {
    return interestRateFrequencyType;
  }


  public void setInterestRateFrequencyType(GetLoanProductsInterestRateFrequencyType interestRateFrequencyType) {
    this.interestRateFrequencyType = interestRateFrequencyType;
  }

  public GetLoanProductsProductIdResponse interestRatePerPeriod(Double interestRatePerPeriod) {
    
    this.interestRatePerPeriod = interestRatePerPeriod;
    return this;
  }

  /**
   * Get interestRatePerPeriod
   * @return interestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getInterestRatePerPeriod() {
    return interestRatePerPeriod;
  }


  public void setInterestRatePerPeriod(Double interestRatePerPeriod) {
    this.interestRatePerPeriod = interestRatePerPeriod;
  }

  public GetLoanProductsProductIdResponse interestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsProductIdResponse addInterestRateVariationsForBorrowerCycleItem(Integer interestRateVariationsForBorrowerCycleItem) {
    if (this.interestRateVariationsForBorrowerCycle == null) {
      this.interestRateVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.interestRateVariationsForBorrowerCycle.add(interestRateVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get interestRateVariationsForBorrowerCycle
   * @return interestRateVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getInterestRateVariationsForBorrowerCycle() {
    return interestRateVariationsForBorrowerCycle;
  }


  public void setInterestRateVariationsForBorrowerCycle(List<Integer> interestRateVariationsForBorrowerCycle) {
    this.interestRateVariationsForBorrowerCycle = interestRateVariationsForBorrowerCycle;
  }

  public GetLoanProductsProductIdResponse interestRecalculationData(GetLoanProductsInterestRecalculationData interestRecalculationData) {
    
    this.interestRecalculationData = interestRecalculationData;
    return this;
  }

  /**
   * Get interestRecalculationData
   * @return interestRecalculationData
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestRecalculationData getInterestRecalculationData() {
    return interestRecalculationData;
  }


  public void setInterestRecalculationData(GetLoanProductsInterestRecalculationData interestRecalculationData) {
    this.interestRecalculationData = interestRecalculationData;
  }

  public GetLoanProductsProductIdResponse interestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
    return this;
  }

  /**
   * Get interestRecognitionOnDisbursementDate
   * @return interestRecognitionOnDisbursementDate
   */
  @javax.annotation.Nullable

  public Boolean getInterestRecognitionOnDisbursementDate() {
    return interestRecognitionOnDisbursementDate;
  }


  public void setInterestRecognitionOnDisbursementDate(Boolean interestRecognitionOnDisbursementDate) {
    this.interestRecognitionOnDisbursementDate = interestRecognitionOnDisbursementDate;
  }

  public GetLoanProductsProductIdResponse interestType(GetLoanProductsInterestTemplateType interestType) {
    
    this.interestType = interestType;
    return this;
  }

  /**
   * Get interestType
   * @return interestType
   */
  @javax.annotation.Nullable

  public GetLoanProductsInterestTemplateType getInterestType() {
    return interestType;
  }


  public void setInterestType(GetLoanProductsInterestTemplateType interestType) {
    this.interestType = interestType;
  }

  public GetLoanProductsProductIdResponse isFloatingInterestRateCalculationAllowed(Boolean isFloatingInterestRateCalculationAllowed) {
    
    this.isFloatingInterestRateCalculationAllowed = isFloatingInterestRateCalculationAllowed;
    return this;
  }

  /**
   * Get isFloatingInterestRateCalculationAllowed
   * @return isFloatingInterestRateCalculationAllowed
   */
  @javax.annotation.Nullable

  public Boolean getIsFloatingInterestRateCalculationAllowed() {
    return isFloatingInterestRateCalculationAllowed;
  }


  public void setIsFloatingInterestRateCalculationAllowed(Boolean isFloatingInterestRateCalculationAllowed) {
    this.isFloatingInterestRateCalculationAllowed = isFloatingInterestRateCalculationAllowed;
  }

  public GetLoanProductsProductIdResponse isInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
    return this;
  }

  /**
   * Get isInterestRecalculationEnabled
   * @return isInterestRecalculationEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsInterestRecalculationEnabled() {
    return isInterestRecalculationEnabled;
  }


  public void setIsInterestRecalculationEnabled(Boolean isInterestRecalculationEnabled) {
    this.isInterestRecalculationEnabled = isInterestRecalculationEnabled;
  }

  public GetLoanProductsProductIdResponse isLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
    return this;
  }

  /**
   * Get isLinkedToFloatingInterestRates
   * @return isLinkedToFloatingInterestRates
   */
  @javax.annotation.Nullable

  public Boolean getIsLinkedToFloatingInterestRates() {
    return isLinkedToFloatingInterestRates;
  }


  public void setIsLinkedToFloatingInterestRates(Boolean isLinkedToFloatingInterestRates) {
    this.isLinkedToFloatingInterestRates = isLinkedToFloatingInterestRates;
  }

  public GetLoanProductsProductIdResponse isRatesEnabled(Boolean isRatesEnabled) {
    
    this.isRatesEnabled = isRatesEnabled;
    return this;
  }

  /**
   * Get isRatesEnabled
   * @return isRatesEnabled
   */
  @javax.annotation.Nullable

  public Boolean getIsRatesEnabled() {
    return isRatesEnabled;
  }


  public void setIsRatesEnabled(Boolean isRatesEnabled) {
    this.isRatesEnabled = isRatesEnabled;
  }

  public GetLoanProductsProductIdResponse loanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    
    this.loanScheduleProcessingType = loanScheduleProcessingType;
    return this;
  }

  /**
   * Get loanScheduleProcessingType
   * @return loanScheduleProcessingType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleProcessingType() {
    return loanScheduleProcessingType;
  }


  public void setLoanScheduleProcessingType(EnumOptionData loanScheduleProcessingType) {
    this.loanScheduleProcessingType = loanScheduleProcessingType;
  }

  public GetLoanProductsProductIdResponse loanScheduleType(EnumOptionData loanScheduleType) {
    
    this.loanScheduleType = loanScheduleType;
    return this;
  }

  /**
   * Get loanScheduleType
   * @return loanScheduleType
   */
  @javax.annotation.Nullable

  public EnumOptionData getLoanScheduleType() {
    return loanScheduleType;
  }


  public void setLoanScheduleType(EnumOptionData loanScheduleType) {
    this.loanScheduleType = loanScheduleType;
  }

  public GetLoanProductsProductIdResponse maxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
    return this;
  }

  /**
   * Get maxInterestRatePerPeriod
   * @return maxInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMaxInterestRatePerPeriod() {
    return maxInterestRatePerPeriod;
  }


  public void setMaxInterestRatePerPeriod(Double maxInterestRatePerPeriod) {
    this.maxInterestRatePerPeriod = maxInterestRatePerPeriod;
  }

  public GetLoanProductsProductIdResponse maxNumberOfRepayments(Integer maxNumberOfRepayments) {
    
    this.maxNumberOfRepayments = maxNumberOfRepayments;
    return this;
  }

  /**
   * Get maxNumberOfRepayments
   * @return maxNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMaxNumberOfRepayments() {
    return maxNumberOfRepayments;
  }


  public void setMaxNumberOfRepayments(Integer maxNumberOfRepayments) {
    this.maxNumberOfRepayments = maxNumberOfRepayments;
  }

  public GetLoanProductsProductIdResponse maxPrincipal(Double maxPrincipal) {
    
    this.maxPrincipal = maxPrincipal;
    return this;
  }

  /**
   * Get maxPrincipal
   * @return maxPrincipal
   */
  @javax.annotation.Nullable

  public Double getMaxPrincipal() {
    return maxPrincipal;
  }


  public void setMaxPrincipal(Double maxPrincipal) {
    this.maxPrincipal = maxPrincipal;
  }

  public GetLoanProductsProductIdResponse maxTrancheCount(Integer maxTrancheCount) {
    
    this.maxTrancheCount = maxTrancheCount;
    return this;
  }

  /**
   * Get maxTrancheCount
   * @return maxTrancheCount
   */
  @javax.annotation.Nullable

  public Integer getMaxTrancheCount() {
    return maxTrancheCount;
  }


  public void setMaxTrancheCount(Integer maxTrancheCount) {
    this.maxTrancheCount = maxTrancheCount;
  }

  public GetLoanProductsProductIdResponse maximumGap(Integer maximumGap) {
    
    this.maximumGap = maximumGap;
    return this;
  }

  /**
   * Get maximumGap
   * @return maximumGap
   */
  @javax.annotation.Nullable

  public Integer getMaximumGap() {
    return maximumGap;
  }


  public void setMaximumGap(Integer maximumGap) {
    this.maximumGap = maximumGap;
  }

  public GetLoanProductsProductIdResponse merchantBuyDownFee(Boolean merchantBuyDownFee) {
    
    this.merchantBuyDownFee = merchantBuyDownFee;
    return this;
  }

  /**
   * Get merchantBuyDownFee
   * @return merchantBuyDownFee
   */
  @javax.annotation.Nullable

  public Boolean getMerchantBuyDownFee() {
    return merchantBuyDownFee;
  }


  public void setMerchantBuyDownFee(Boolean merchantBuyDownFee) {
    this.merchantBuyDownFee = merchantBuyDownFee;
  }

  public GetLoanProductsProductIdResponse minInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
    return this;
  }

  /**
   * Get minInterestRatePerPeriod
   * @return minInterestRatePerPeriod
   */
  @javax.annotation.Nullable

  public Double getMinInterestRatePerPeriod() {
    return minInterestRatePerPeriod;
  }


  public void setMinInterestRatePerPeriod(Double minInterestRatePerPeriod) {
    this.minInterestRatePerPeriod = minInterestRatePerPeriod;
  }

  public GetLoanProductsProductIdResponse minNumberOfRepayments(Integer minNumberOfRepayments) {
    
    this.minNumberOfRepayments = minNumberOfRepayments;
    return this;
  }

  /**
   * Get minNumberOfRepayments
   * @return minNumberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getMinNumberOfRepayments() {
    return minNumberOfRepayments;
  }


  public void setMinNumberOfRepayments(Integer minNumberOfRepayments) {
    this.minNumberOfRepayments = minNumberOfRepayments;
  }

  public GetLoanProductsProductIdResponse minPrincipal(Double minPrincipal) {
    
    this.minPrincipal = minPrincipal;
    return this;
  }

  /**
   * Get minPrincipal
   * @return minPrincipal
   */
  @javax.annotation.Nullable

  public Double getMinPrincipal() {
    return minPrincipal;
  }


  public void setMinPrincipal(Double minPrincipal) {
    this.minPrincipal = minPrincipal;
  }

  public GetLoanProductsProductIdResponse minimumGap(Integer minimumGap) {
    
    this.minimumGap = minimumGap;
    return this;
  }

  /**
   * Get minimumGap
   * @return minimumGap
   */
  @javax.annotation.Nullable

  public Integer getMinimumGap() {
    return minimumGap;
  }


  public void setMinimumGap(Integer minimumGap) {
    this.minimumGap = minimumGap;
  }

  public GetLoanProductsProductIdResponse multiDisburseLoan(Boolean multiDisburseLoan) {
    
    this.multiDisburseLoan = multiDisburseLoan;
    return this;
  }

  /**
   * Get multiDisburseLoan
   * @return multiDisburseLoan
   */
  @javax.annotation.Nullable

  public Boolean getMultiDisburseLoan() {
    return multiDisburseLoan;
  }


  public void setMultiDisburseLoan(Boolean multiDisburseLoan) {
    this.multiDisburseLoan = multiDisburseLoan;
  }

  public GetLoanProductsProductIdResponse name(String name) {
    
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }

  public GetLoanProductsProductIdResponse numberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsProductIdResponse addNumberOfRepaymentVariationsForBorrowerCycleItem(Integer numberOfRepaymentVariationsForBorrowerCycleItem) {
    if (this.numberOfRepaymentVariationsForBorrowerCycle == null) {
      this.numberOfRepaymentVariationsForBorrowerCycle = new ArrayList<>();
    }
    this.numberOfRepaymentVariationsForBorrowerCycle.add(numberOfRepaymentVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get numberOfRepaymentVariationsForBorrowerCycle
   * @return numberOfRepaymentVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public List<Integer> getNumberOfRepaymentVariationsForBorrowerCycle() {
    return numberOfRepaymentVariationsForBorrowerCycle;
  }


  public void setNumberOfRepaymentVariationsForBorrowerCycle(List<Integer> numberOfRepaymentVariationsForBorrowerCycle) {
    this.numberOfRepaymentVariationsForBorrowerCycle = numberOfRepaymentVariationsForBorrowerCycle;
  }

  public GetLoanProductsProductIdResponse numberOfRepayments(Integer numberOfRepayments) {
    
    this.numberOfRepayments = numberOfRepayments;
    return this;
  }

  /**
   * Get numberOfRepayments
   * @return numberOfRepayments
   */
  @javax.annotation.Nullable

  public Integer getNumberOfRepayments() {
    return numberOfRepayments;
  }


  public void setNumberOfRepayments(Integer numberOfRepayments) {
    this.numberOfRepayments = numberOfRepayments;
  }

  public GetLoanProductsProductIdResponse outstandingLoanBalance(Double outstandingLoanBalance) {
    
    this.outstandingLoanBalance = outstandingLoanBalance;
    return this;
  }

  /**
   * Get outstandingLoanBalance
   * @return outstandingLoanBalance
   */
  @javax.annotation.Nullable

  public Double getOutstandingLoanBalance() {
    return outstandingLoanBalance;
  }


  public void setOutstandingLoanBalance(Double outstandingLoanBalance) {
    this.outstandingLoanBalance = outstandingLoanBalance;
  }

  public GetLoanProductsProductIdResponse overAppliedCalculationType(String overAppliedCalculationType) {
    
    this.overAppliedCalculationType = overAppliedCalculationType;
    return this;
  }

  /**
   * Get overAppliedCalculationType
   * @return overAppliedCalculationType
   */
  @javax.annotation.Nullable

  public String getOverAppliedCalculationType() {
    return overAppliedCalculationType;
  }


  public void setOverAppliedCalculationType(String overAppliedCalculationType) {
    this.overAppliedCalculationType = overAppliedCalculationType;
  }

  public GetLoanProductsProductIdResponse overDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
    return this;
  }

  /**
   * Get overDueDaysForRepaymentEvent
   * @return overDueDaysForRepaymentEvent
   */
  @javax.annotation.Nullable

  public Integer getOverDueDaysForRepaymentEvent() {
    return overDueDaysForRepaymentEvent;
  }


  public void setOverDueDaysForRepaymentEvent(Integer overDueDaysForRepaymentEvent) {
    this.overDueDaysForRepaymentEvent = overDueDaysForRepaymentEvent;
  }

  public GetLoanProductsProductIdResponse overdueDaysForNPA(Integer overdueDaysForNPA) {
    
    this.overdueDaysForNPA = overdueDaysForNPA;
    return this;
  }

  /**
   * Get overdueDaysForNPA
   * @return overdueDaysForNPA
   */
  @javax.annotation.Nullable

  public Integer getOverdueDaysForNPA() {
    return overdueDaysForNPA;
  }


  public void setOverdueDaysForNPA(Integer overdueDaysForNPA) {
    this.overdueDaysForNPA = overdueDaysForNPA;
  }

  public GetLoanProductsProductIdResponse paymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    
    this.paymentAllocation = paymentAllocation;
    return this;
  }

  public GetLoanProductsProductIdResponse addPaymentAllocationItem(AdvancedPaymentData paymentAllocationItem) {
    if (this.paymentAllocation == null) {
      this.paymentAllocation = new ArrayList<>();
    }
    this.paymentAllocation.add(paymentAllocationItem);
    return this;
  }

  /**
   * Get paymentAllocation
   * @return paymentAllocation
   */
  @javax.annotation.Nullable

  public List<AdvancedPaymentData> getPaymentAllocation() {
    return paymentAllocation;
  }


  public void setPaymentAllocation(List<AdvancedPaymentData> paymentAllocation) {
    this.paymentAllocation = paymentAllocation;
  }

  public GetLoanProductsProductIdResponse paymentChannelToFundSourceMappings(Set<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addPaymentChannelToFundSourceMappingsItem(GetLoanPaymentChannelToFundSourceMappings paymentChannelToFundSourceMappingsItem) {
    if (this.paymentChannelToFundSourceMappings == null) {
      this.paymentChannelToFundSourceMappings = new LinkedHashSet<>();
    }
    this.paymentChannelToFundSourceMappings.add(paymentChannelToFundSourceMappingsItem);
    return this;
  }

  /**
   * Get paymentChannelToFundSourceMappings
   * @return paymentChannelToFundSourceMappings
   */
  @javax.annotation.Nullable

  public Set<GetLoanPaymentChannelToFundSourceMappings> getPaymentChannelToFundSourceMappings() {
    return paymentChannelToFundSourceMappings;
  }


  public void setPaymentChannelToFundSourceMappings(Set<GetLoanPaymentChannelToFundSourceMappings> paymentChannelToFundSourceMappings) {
    this.paymentChannelToFundSourceMappings = paymentChannelToFundSourceMappings;
  }

  public GetLoanProductsProductIdResponse principal(Double principal) {
    
    this.principal = principal;
    return this;
  }

  /**
   * Get principal
   * @return principal
   */
  @javax.annotation.Nullable

  public Double getPrincipal() {
    return principal;
  }


  public void setPrincipal(Double principal) {
    this.principal = principal;
  }

  public GetLoanProductsProductIdResponse principalThresholdForLastInstalment(Integer principalThresholdForLastInstalment) {
    
    this.principalThresholdForLastInstalment = principalThresholdForLastInstalment;
    return this;
  }

  /**
   * Get principalThresholdForLastInstalment
   * @return principalThresholdForLastInstalment
   */
  @javax.annotation.Nullable

  public Integer getPrincipalThresholdForLastInstalment() {
    return principalThresholdForLastInstalment;
  }


  public void setPrincipalThresholdForLastInstalment(Integer principalThresholdForLastInstalment) {
    this.principalThresholdForLastInstalment = principalThresholdForLastInstalment;
  }

  public GetLoanProductsProductIdResponse productsPrincipalVariationsForBorrowerCycle(Set<GetLoanProductsPrincipalVariationsForBorrowerCycle> productsPrincipalVariationsForBorrowerCycle) {
    
    this.productsPrincipalVariationsForBorrowerCycle = productsPrincipalVariationsForBorrowerCycle;
    return this;
  }

  public GetLoanProductsProductIdResponse addProductsPrincipalVariationsForBorrowerCycleItem(GetLoanProductsPrincipalVariationsForBorrowerCycle productsPrincipalVariationsForBorrowerCycleItem) {
    if (this.productsPrincipalVariationsForBorrowerCycle == null) {
      this.productsPrincipalVariationsForBorrowerCycle = new LinkedHashSet<>();
    }
    this.productsPrincipalVariationsForBorrowerCycle.add(productsPrincipalVariationsForBorrowerCycleItem);
    return this;
  }

  /**
   * Get productsPrincipalVariationsForBorrowerCycle
   * @return productsPrincipalVariationsForBorrowerCycle
   */
  @javax.annotation.Nullable

  public Set<GetLoanProductsPrincipalVariationsForBorrowerCycle> getProductsPrincipalVariationsForBorrowerCycle() {
    return productsPrincipalVariationsForBorrowerCycle;
  }


  public void setProductsPrincipalVariationsForBorrowerCycle(Set<GetLoanProductsPrincipalVariationsForBorrowerCycle> productsPrincipalVariationsForBorrowerCycle) {
    this.productsPrincipalVariationsForBorrowerCycle = productsPrincipalVariationsForBorrowerCycle;
  }

  public GetLoanProductsProductIdResponse repaymentEvery(Integer repaymentEvery) {
    
    this.repaymentEvery = repaymentEvery;
    return this;
  }

  /**
   * Get repaymentEvery
   * @return repaymentEvery
   */
  @javax.annotation.Nullable

  public Integer getRepaymentEvery() {
    return repaymentEvery;
  }


  public void setRepaymentEvery(Integer repaymentEvery) {
    this.repaymentEvery = repaymentEvery;
  }

  public GetLoanProductsProductIdResponse repaymentFrequencyType(GetLoanProductsRepaymentFrequencyType repaymentFrequencyType) {
    
    this.repaymentFrequencyType = repaymentFrequencyType;
    return this;
  }

  /**
   * Get repaymentFrequencyType
   * @return repaymentFrequencyType
   */
  @javax.annotation.Nullable

  public GetLoanProductsRepaymentFrequencyType getRepaymentFrequencyType() {
    return repaymentFrequencyType;
  }


  public void setRepaymentFrequencyType(GetLoanProductsRepaymentFrequencyType repaymentFrequencyType) {
    this.repaymentFrequencyType = repaymentFrequencyType;
  }

  public GetLoanProductsProductIdResponse repaymentStartDateType(GetLoanProductsRepaymentStartDateType repaymentStartDateType) {
    
    this.repaymentStartDateType = repaymentStartDateType;
    return this;
  }

  /**
   * Get repaymentStartDateType
   * @return repaymentStartDateType
   */
  @javax.annotation.Nullable

  public GetLoanProductsRepaymentStartDateType getRepaymentStartDateType() {
    return repaymentStartDateType;
  }


  public void setRepaymentStartDateType(GetLoanProductsRepaymentStartDateType repaymentStartDateType) {
    this.repaymentStartDateType = repaymentStartDateType;
  }

  public GetLoanProductsProductIdResponse shortName(String shortName) {
    
    this.shortName = shortName;
    return this;
  }

  /**
   * Get shortName
   * @return shortName
   */
  @javax.annotation.Nullable

  public String getShortName() {
    return shortName;
  }


  public void setShortName(String shortName) {
    this.shortName = shortName;
  }

  public GetLoanProductsProductIdResponse status(String status) {
    
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
   */
  @javax.annotation.Nullable

  public String getStatus() {
    return status;
  }


  public void setStatus(String status) {
    this.status = status;
  }

  public GetLoanProductsProductIdResponse supportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
    return this;
  }

  public GetLoanProductsProductIdResponse addSupportedInterestRefundTypesItem(StringEnumOptionData supportedInterestRefundTypesItem) {
    if (this.supportedInterestRefundTypes == null) {
      this.supportedInterestRefundTypes = new ArrayList<>();
    }
    this.supportedInterestRefundTypes.add(supportedInterestRefundTypesItem);
    return this;
  }

  /**
   * Get supportedInterestRefundTypes
   * @return supportedInterestRefundTypes
   */
  @javax.annotation.Nullable

  public List<StringEnumOptionData> getSupportedInterestRefundTypes() {
    return supportedInterestRefundTypes;
  }


  public void setSupportedInterestRefundTypes(List<StringEnumOptionData> supportedInterestRefundTypes) {
    this.supportedInterestRefundTypes = supportedInterestRefundTypes;
  }

  public GetLoanProductsProductIdResponse transactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
    return this;
  }

  /**
   * Get transactionProcessingStrategyCode
   * @return transactionProcessingStrategyCode
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyCode() {
    return transactionProcessingStrategyCode;
  }


  public void setTransactionProcessingStrategyCode(String transactionProcessingStrategyCode) {
    this.transactionProcessingStrategyCode = transactionProcessingStrategyCode;
  }

  public GetLoanProductsProductIdResponse transactionProcessingStrategyName(String transactionProcessingStrategyName) {
    
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
    return this;
  }

  /**
   * Get transactionProcessingStrategyName
   * @return transactionProcessingStrategyName
   */
  @javax.annotation.Nullable

  public String getTransactionProcessingStrategyName() {
    return transactionProcessingStrategyName;
  }


  public void setTransactionProcessingStrategyName(String transactionProcessingStrategyName) {
    this.transactionProcessingStrategyName = transactionProcessingStrategyName;
  }

  public GetLoanProductsProductIdResponse useBorrowerCycle(Boolean useBorrowerCycle) {
    
    this.useBorrowerCycle = useBorrowerCycle;
    return this;
  }

  /**
   * Get useBorrowerCycle
   * @return useBorrowerCycle
   */
  @javax.annotation.Nullable

  public Boolean getUseBorrowerCycle() {
    return useBorrowerCycle;
  }


  public void setUseBorrowerCycle(Boolean useBorrowerCycle) {
    this.useBorrowerCycle = useBorrowerCycle;
  }

  public GetLoanProductsProductIdResponse writeOffReasonOptions(List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions) {
    
    this.writeOffReasonOptions = writeOffReasonOptions;
    return this;
  }

  public GetLoanProductsProductIdResponse addWriteOffReasonOptionsItem(GetLoanProductsWriteOffReasonOptions writeOffReasonOptionsItem) {
    if (this.writeOffReasonOptions == null) {
      this.writeOffReasonOptions = new ArrayList<>();
    }
    this.writeOffReasonOptions.add(writeOffReasonOptionsItem);
    return this;
  }

  /**
   * Get writeOffReasonOptions
   * @return writeOffReasonOptions
   */
  @javax.annotation.Nullable

  public List<GetLoanProductsWriteOffReasonOptions> getWriteOffReasonOptions() {
    return writeOffReasonOptions;
  }


  public void setWriteOffReasonOptions(List<GetLoanProductsWriteOffReasonOptions> writeOffReasonOptions) {
    this.writeOffReasonOptions = writeOffReasonOptions;
  }

  public GetLoanProductsProductIdResponse writeOffReasonsToExpenseMappings(List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings) {
    
    this.writeOffReasonsToExpenseMappings = writeOffReasonsToExpenseMappings;
    return this;
  }

  public GetLoanProductsProductIdResponse addWriteOffReasonsToExpenseMappingsItem(PostWriteOffReasonToExpenseAccountMappings writeOffReasonsToExpenseMappingsItem) {
    if (this.writeOffReasonsToExpenseMappings == null) {
      this.writeOffReasonsToExpenseMappings = new ArrayList<>();
    }
    this.writeOffReasonsToExpenseMappings.add(writeOffReasonsToExpenseMappingsItem);
    return this;
  }

  /**
   * Get writeOffReasonsToExpenseMappings
   * @return writeOffReasonsToExpenseMappings
   */
  @javax.annotation.Nullable

  public List<PostWriteOffReasonToExpenseAccountMappings> getWriteOffReasonsToExpenseMappings() {
    return writeOffReasonsToExpenseMappings;
  }


  public void setWriteOffReasonsToExpenseMappings(List<PostWriteOffReasonToExpenseAccountMappings> writeOffReasonsToExpenseMappings) {
    this.writeOffReasonsToExpenseMappings = writeOffReasonsToExpenseMappings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GetLoanProductsProductIdResponse getLoanProductsProductIdResponse = (GetLoanProductsProductIdResponse) o;
    return Objects.equals(this.accountingMappings, getLoanProductsProductIdResponse.accountingMappings) &&
        Objects.equals(this.accountingRule, getLoanProductsProductIdResponse.accountingRule) &&
        Objects.equals(this.allowApprovedDisbursedAmountsOverApplied, getLoanProductsProductIdResponse.allowApprovedDisbursedAmountsOverApplied) &&
        Objects.equals(this.allowPartialPeriodInterestCalculation, getLoanProductsProductIdResponse.allowPartialPeriodInterestCalculation) &&
        Objects.equals(this.allowVariableInstallments, getLoanProductsProductIdResponse.allowVariableInstallments) &&
        Objects.equals(this.amortizationType, getLoanProductsProductIdResponse.amortizationType) &&
        Objects.equals(this.annualInterestRate, getLoanProductsProductIdResponse.annualInterestRate) &&
        Objects.equals(this.buyDownFeeCalculationType, getLoanProductsProductIdResponse.buyDownFeeCalculationType) &&
        Objects.equals(this.buyDownFeeCalculationTypeOptions, getLoanProductsProductIdResponse.buyDownFeeCalculationTypeOptions) &&
        Objects.equals(this.buyDownFeeIncomeType, getLoanProductsProductIdResponse.buyDownFeeIncomeType) &&
        Objects.equals(this.buyDownFeeIncomeTypeOptions, getLoanProductsProductIdResponse.buyDownFeeIncomeTypeOptions) &&
        Objects.equals(this.buyDownFeeStrategy, getLoanProductsProductIdResponse.buyDownFeeStrategy) &&
        Objects.equals(this.buyDownFeeStrategyOptions, getLoanProductsProductIdResponse.buyDownFeeStrategyOptions) &&
        Objects.equals(this.buydownFeeClassificationOptions, getLoanProductsProductIdResponse.buydownFeeClassificationOptions) &&
        Objects.equals(this.buydownFeeClassificationToIncomeAccountMappings, getLoanProductsProductIdResponse.buydownFeeClassificationToIncomeAccountMappings) &&
        Objects.equals(this.canDefineInstallmentAmount, getLoanProductsProductIdResponse.canDefineInstallmentAmount) &&
        Objects.equals(this.canUseForTopup, getLoanProductsProductIdResponse.canUseForTopup) &&
        Objects.equals(this.capitalizedIncomeCalculationType, getLoanProductsProductIdResponse.capitalizedIncomeCalculationType) &&
        Objects.equals(this.capitalizedIncomeCalculationTypeOptions, getLoanProductsProductIdResponse.capitalizedIncomeCalculationTypeOptions) &&
        Objects.equals(this.capitalizedIncomeClassificationOptions, getLoanProductsProductIdResponse.capitalizedIncomeClassificationOptions) &&
        Objects.equals(this.capitalizedIncomeClassificationToIncomeAccountMappings, getLoanProductsProductIdResponse.capitalizedIncomeClassificationToIncomeAccountMappings) &&
        Objects.equals(this.capitalizedIncomeStrategy, getLoanProductsProductIdResponse.capitalizedIncomeStrategy) &&
        Objects.equals(this.capitalizedIncomeStrategyOptions, getLoanProductsProductIdResponse.capitalizedIncomeStrategyOptions) &&
        Objects.equals(this.capitalizedIncomeType, getLoanProductsProductIdResponse.capitalizedIncomeType) &&
        Objects.equals(this.capitalizedIncomeTypeOptions, getLoanProductsProductIdResponse.capitalizedIncomeTypeOptions) &&
        Objects.equals(this.chargeOffBehaviour, getLoanProductsProductIdResponse.chargeOffBehaviour) &&
        Objects.equals(this.chargeOffReasonOptions, getLoanProductsProductIdResponse.chargeOffReasonOptions) &&
        Objects.equals(this.chargeOffReasonToExpenseAccountMappings, getLoanProductsProductIdResponse.chargeOffReasonToExpenseAccountMappings) &&
        Objects.equals(this.charges, getLoanProductsProductIdResponse.charges) &&
        Objects.equals(this.creditAllocation, getLoanProductsProductIdResponse.creditAllocation) &&
        Objects.equals(this.currency, getLoanProductsProductIdResponse.currency) &&
        Objects.equals(this.daysInMonthType, getLoanProductsProductIdResponse.daysInMonthType) &&
        Objects.equals(this.daysInYearCustomStrategy, getLoanProductsProductIdResponse.daysInYearCustomStrategy) &&
        Objects.equals(this.daysInYearType, getLoanProductsProductIdResponse.daysInYearType) &&
        Objects.equals(this.delinquencyBucket, getLoanProductsProductIdResponse.delinquencyBucket) &&
        Objects.equals(this.delinquencyBucketOptions, getLoanProductsProductIdResponse.delinquencyBucketOptions) &&
        Objects.equals(this.description, getLoanProductsProductIdResponse.description) &&
        Objects.equals(this.disallowExpectedDisbursements, getLoanProductsProductIdResponse.disallowExpectedDisbursements) &&
        Objects.equals(this.disbursedAmountPercentageForDownPayment, getLoanProductsProductIdResponse.disbursedAmountPercentageForDownPayment) &&
        Objects.equals(this.dueDaysForRepaymentEvent, getLoanProductsProductIdResponse.dueDaysForRepaymentEvent) &&
        Objects.equals(this.enableAccrualActivityPosting, getLoanProductsProductIdResponse.enableAccrualActivityPosting) &&
        Objects.equals(this.enableAutoRepaymentForDownPayment, getLoanProductsProductIdResponse.enableAutoRepaymentForDownPayment) &&
        Objects.equals(this.enableBuyDownFee, getLoanProductsProductIdResponse.enableBuyDownFee) &&
        Objects.equals(this.enableDownPayment, getLoanProductsProductIdResponse.enableDownPayment) &&
        Objects.equals(this.enableIncomeCapitalization, getLoanProductsProductIdResponse.enableIncomeCapitalization) &&
        Objects.equals(this.enableInstallmentLevelDelinquency, getLoanProductsProductIdResponse.enableInstallmentLevelDelinquency) &&
        Objects.equals(this.feeToIncomeAccountMappings, getLoanProductsProductIdResponse.feeToIncomeAccountMappings) &&
        Objects.equals(this.fixedLength, getLoanProductsProductIdResponse.fixedLength) &&
        Objects.equals(this.fixedPrincipalPercentagePerInstallment, getLoanProductsProductIdResponse.fixedPrincipalPercentagePerInstallment) &&
        Objects.equals(this.id, getLoanProductsProductIdResponse.id) &&
        Objects.equals(this.inArrearsTolerance, getLoanProductsProductIdResponse.inArrearsTolerance) &&
        Objects.equals(this.includeInBorrowerCycle, getLoanProductsProductIdResponse.includeInBorrowerCycle) &&
        Objects.equals(this.interestCalculationPeriodType, getLoanProductsProductIdResponse.interestCalculationPeriodType) &&
        Objects.equals(this.interestRateFrequencyType, getLoanProductsProductIdResponse.interestRateFrequencyType) &&
        Objects.equals(this.interestRatePerPeriod, getLoanProductsProductIdResponse.interestRatePerPeriod) &&
        Objects.equals(this.interestRateVariationsForBorrowerCycle, getLoanProductsProductIdResponse.interestRateVariationsForBorrowerCycle) &&
        Objects.equals(this.interestRecalculationData, getLoanProductsProductIdResponse.interestRecalculationData) &&
        Objects.equals(this.interestRecognitionOnDisbursementDate, getLoanProductsProductIdResponse.interestRecognitionOnDisbursementDate) &&
        Objects.equals(this.interestType, getLoanProductsProductIdResponse.interestType) &&
        Objects.equals(this.isFloatingInterestRateCalculationAllowed, getLoanProductsProductIdResponse.isFloatingInterestRateCalculationAllowed) &&
        Objects.equals(this.isInterestRecalculationEnabled, getLoanProductsProductIdResponse.isInterestRecalculationEnabled) &&
        Objects.equals(this.isLinkedToFloatingInterestRates, getLoanProductsProductIdResponse.isLinkedToFloatingInterestRates) &&
        Objects.equals(this.isRatesEnabled, getLoanProductsProductIdResponse.isRatesEnabled) &&
        Objects.equals(this.loanScheduleProcessingType, getLoanProductsProductIdResponse.loanScheduleProcessingType) &&
        Objects.equals(this.loanScheduleType, getLoanProductsProductIdResponse.loanScheduleType) &&
        Objects.equals(this.maxInterestRatePerPeriod, getLoanProductsProductIdResponse.maxInterestRatePerPeriod) &&
        Objects.equals(this.maxNumberOfRepayments, getLoanProductsProductIdResponse.maxNumberOfRepayments) &&
        Objects.equals(this.maxPrincipal, getLoanProductsProductIdResponse.maxPrincipal) &&
        Objects.equals(this.maxTrancheCount, getLoanProductsProductIdResponse.maxTrancheCount) &&
        Objects.equals(this.maximumGap, getLoanProductsProductIdResponse.maximumGap) &&
        Objects.equals(this.merchantBuyDownFee, getLoanProductsProductIdResponse.merchantBuyDownFee) &&
        Objects.equals(this.minInterestRatePerPeriod, getLoanProductsProductIdResponse.minInterestRatePerPeriod) &&
        Objects.equals(this.minNumberOfRepayments, getLoanProductsProductIdResponse.minNumberOfRepayments) &&
        Objects.equals(this.minPrincipal, getLoanProductsProductIdResponse.minPrincipal) &&
        Objects.equals(this.minimumGap, getLoanProductsProductIdResponse.minimumGap) &&
        Objects.equals(this.multiDisburseLoan, getLoanProductsProductIdResponse.multiDisburseLoan) &&
        Objects.equals(this.name, getLoanProductsProductIdResponse.name) &&
        Objects.equals(this.numberOfRepaymentVariationsForBorrowerCycle, getLoanProductsProductIdResponse.numberOfRepaymentVariationsForBorrowerCycle) &&
        Objects.equals(this.numberOfRepayments, getLoanProductsProductIdResponse.numberOfRepayments) &&
        Objects.equals(this.outstandingLoanBalance, getLoanProductsProductIdResponse.outstandingLoanBalance) &&
        Objects.equals(this.overAppliedCalculationType, getLoanProductsProductIdResponse.overAppliedCalculationType) &&
        Objects.equals(this.overDueDaysForRepaymentEvent, getLoanProductsProductIdResponse.overDueDaysForRepaymentEvent) &&
        Objects.equals(this.overdueDaysForNPA, getLoanProductsProductIdResponse.overdueDaysForNPA) &&
        Objects.equals(this.paymentAllocation, getLoanProductsProductIdResponse.paymentAllocation) &&
        Objects.equals(this.paymentChannelToFundSourceMappings, getLoanProductsProductIdResponse.paymentChannelToFundSourceMappings) &&
        Objects.equals(this.principal, getLoanProductsProductIdResponse.principal) &&
        Objects.equals(this.principalThresholdForLastInstalment, getLoanProductsProductIdResponse.principalThresholdForLastInstalment) &&
        Objects.equals(this.productsPrincipalVariationsForBorrowerCycle, getLoanProductsProductIdResponse.productsPrincipalVariationsForBorrowerCycle) &&
        Objects.equals(this.repaymentEvery, getLoanProductsProductIdResponse.repaymentEvery) &&
        Objects.equals(this.repaymentFrequencyType, getLoanProductsProductIdResponse.repaymentFrequencyType) &&
        Objects.equals(this.repaymentStartDateType, getLoanProductsProductIdResponse.repaymentStartDateType) &&
        Objects.equals(this.shortName, getLoanProductsProductIdResponse.shortName) &&
        Objects.equals(this.status, getLoanProductsProductIdResponse.status) &&
        Objects.equals(this.supportedInterestRefundTypes, getLoanProductsProductIdResponse.supportedInterestRefundTypes) &&
        Objects.equals(this.transactionProcessingStrategyCode, getLoanProductsProductIdResponse.transactionProcessingStrategyCode) &&
        Objects.equals(this.transactionProcessingStrategyName, getLoanProductsProductIdResponse.transactionProcessingStrategyName) &&
        Objects.equals(this.useBorrowerCycle, getLoanProductsProductIdResponse.useBorrowerCycle) &&
        Objects.equals(this.writeOffReasonOptions, getLoanProductsProductIdResponse.writeOffReasonOptions) &&
        Objects.equals(this.writeOffReasonsToExpenseMappings, getLoanProductsProductIdResponse.writeOffReasonsToExpenseMappings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountingMappings, accountingRule, allowApprovedDisbursedAmountsOverApplied, allowPartialPeriodInterestCalculation, allowVariableInstallments, amortizationType, annualInterestRate, buyDownFeeCalculationType, buyDownFeeCalculationTypeOptions, buyDownFeeIncomeType, buyDownFeeIncomeTypeOptions, buyDownFeeStrategy, buyDownFeeStrategyOptions, buydownFeeClassificationOptions, buydownFeeClassificationToIncomeAccountMappings, canDefineInstallmentAmount, canUseForTopup, capitalizedIncomeCalculationType, capitalizedIncomeCalculationTypeOptions, capitalizedIncomeClassificationOptions, capitalizedIncomeClassificationToIncomeAccountMappings, capitalizedIncomeStrategy, capitalizedIncomeStrategyOptions, capitalizedIncomeType, capitalizedIncomeTypeOptions, chargeOffBehaviour, chargeOffReasonOptions, chargeOffReasonToExpenseAccountMappings, charges, creditAllocation, currency, daysInMonthType, daysInYearCustomStrategy, daysInYearType, delinquencyBucket, delinquencyBucketOptions, description, disallowExpectedDisbursements, disbursedAmountPercentageForDownPayment, dueDaysForRepaymentEvent, enableAccrualActivityPosting, enableAutoRepaymentForDownPayment, enableBuyDownFee, enableDownPayment, enableIncomeCapitalization, enableInstallmentLevelDelinquency, feeToIncomeAccountMappings, fixedLength, fixedPrincipalPercentagePerInstallment, id, inArrearsTolerance, includeInBorrowerCycle, interestCalculationPeriodType, interestRateFrequencyType, interestRatePerPeriod, interestRateVariationsForBorrowerCycle, interestRecalculationData, interestRecognitionOnDisbursementDate, interestType, isFloatingInterestRateCalculationAllowed, isInterestRecalculationEnabled, isLinkedToFloatingInterestRates, isRatesEnabled, loanScheduleProcessingType, loanScheduleType, maxInterestRatePerPeriod, maxNumberOfRepayments, maxPrincipal, maxTrancheCount, maximumGap, merchantBuyDownFee, minInterestRatePerPeriod, minNumberOfRepayments, minPrincipal, minimumGap, multiDisburseLoan, name, numberOfRepaymentVariationsForBorrowerCycle, numberOfRepayments, outstandingLoanBalance, overAppliedCalculationType, overDueDaysForRepaymentEvent, overdueDaysForNPA, paymentAllocation, paymentChannelToFundSourceMappings, principal, principalThresholdForLastInstalment, productsPrincipalVariationsForBorrowerCycle, repaymentEvery, repaymentFrequencyType, repaymentStartDateType, shortName, status, supportedInterestRefundTypes, transactionProcessingStrategyCode, transactionProcessingStrategyName, useBorrowerCycle, writeOffReasonOptions, writeOffReasonsToExpenseMappings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GetLoanProductsProductIdResponse {\n");
    sb.append("    accountingMappings: ").append(toIndentedString(accountingMappings)).append("\n");
    sb.append("    accountingRule: ").append(toIndentedString(accountingRule)).append("\n");
    sb.append("    allowApprovedDisbursedAmountsOverApplied: ").append(toIndentedString(allowApprovedDisbursedAmountsOverApplied)).append("\n");
    sb.append("    allowPartialPeriodInterestCalculation: ").append(toIndentedString(allowPartialPeriodInterestCalculation)).append("\n");
    sb.append("    allowVariableInstallments: ").append(toIndentedString(allowVariableInstallments)).append("\n");
    sb.append("    amortizationType: ").append(toIndentedString(amortizationType)).append("\n");
    sb.append("    annualInterestRate: ").append(toIndentedString(annualInterestRate)).append("\n");
    sb.append("    buyDownFeeCalculationType: ").append(toIndentedString(buyDownFeeCalculationType)).append("\n");
    sb.append("    buyDownFeeCalculationTypeOptions: ").append(toIndentedString(buyDownFeeCalculationTypeOptions)).append("\n");
    sb.append("    buyDownFeeIncomeType: ").append(toIndentedString(buyDownFeeIncomeType)).append("\n");
    sb.append("    buyDownFeeIncomeTypeOptions: ").append(toIndentedString(buyDownFeeIncomeTypeOptions)).append("\n");
    sb.append("    buyDownFeeStrategy: ").append(toIndentedString(buyDownFeeStrategy)).append("\n");
    sb.append("    buyDownFeeStrategyOptions: ").append(toIndentedString(buyDownFeeStrategyOptions)).append("\n");
    sb.append("    buydownFeeClassificationOptions: ").append(toIndentedString(buydownFeeClassificationOptions)).append("\n");
    sb.append("    buydownFeeClassificationToIncomeAccountMappings: ").append(toIndentedString(buydownFeeClassificationToIncomeAccountMappings)).append("\n");
    sb.append("    canDefineInstallmentAmount: ").append(toIndentedString(canDefineInstallmentAmount)).append("\n");
    sb.append("    canUseForTopup: ").append(toIndentedString(canUseForTopup)).append("\n");
    sb.append("    capitalizedIncomeCalculationType: ").append(toIndentedString(capitalizedIncomeCalculationType)).append("\n");
    sb.append("    capitalizedIncomeCalculationTypeOptions: ").append(toIndentedString(capitalizedIncomeCalculationTypeOptions)).append("\n");
    sb.append("    capitalizedIncomeClassificationOptions: ").append(toIndentedString(capitalizedIncomeClassificationOptions)).append("\n");
    sb.append("    capitalizedIncomeClassificationToIncomeAccountMappings: ").append(toIndentedString(capitalizedIncomeClassificationToIncomeAccountMappings)).append("\n");
    sb.append("    capitalizedIncomeStrategy: ").append(toIndentedString(capitalizedIncomeStrategy)).append("\n");
    sb.append("    capitalizedIncomeStrategyOptions: ").append(toIndentedString(capitalizedIncomeStrategyOptions)).append("\n");
    sb.append("    capitalizedIncomeType: ").append(toIndentedString(capitalizedIncomeType)).append("\n");
    sb.append("    capitalizedIncomeTypeOptions: ").append(toIndentedString(capitalizedIncomeTypeOptions)).append("\n");
    sb.append("    chargeOffBehaviour: ").append(toIndentedString(chargeOffBehaviour)).append("\n");
    sb.append("    chargeOffReasonOptions: ").append(toIndentedString(chargeOffReasonOptions)).append("\n");
    sb.append("    chargeOffReasonToExpenseAccountMappings: ").append(toIndentedString(chargeOffReasonToExpenseAccountMappings)).append("\n");
    sb.append("    charges: ").append(toIndentedString(charges)).append("\n");
    sb.append("    creditAllocation: ").append(toIndentedString(creditAllocation)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    daysInMonthType: ").append(toIndentedString(daysInMonthType)).append("\n");
    sb.append("    daysInYearCustomStrategy: ").append(toIndentedString(daysInYearCustomStrategy)).append("\n");
    sb.append("    daysInYearType: ").append(toIndentedString(daysInYearType)).append("\n");
    sb.append("    delinquencyBucket: ").append(toIndentedString(delinquencyBucket)).append("\n");
    sb.append("    delinquencyBucketOptions: ").append(toIndentedString(delinquencyBucketOptions)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    disallowExpectedDisbursements: ").append(toIndentedString(disallowExpectedDisbursements)).append("\n");
    sb.append("    disbursedAmountPercentageForDownPayment: ").append(toIndentedString(disbursedAmountPercentageForDownPayment)).append("\n");
    sb.append("    dueDaysForRepaymentEvent: ").append(toIndentedString(dueDaysForRepaymentEvent)).append("\n");
    sb.append("    enableAccrualActivityPosting: ").append(toIndentedString(enableAccrualActivityPosting)).append("\n");
    sb.append("    enableAutoRepaymentForDownPayment: ").append(toIndentedString(enableAutoRepaymentForDownPayment)).append("\n");
    sb.append("    enableBuyDownFee: ").append(toIndentedString(enableBuyDownFee)).append("\n");
    sb.append("    enableDownPayment: ").append(toIndentedString(enableDownPayment)).append("\n");
    sb.append("    enableIncomeCapitalization: ").append(toIndentedString(enableIncomeCapitalization)).append("\n");
    sb.append("    enableInstallmentLevelDelinquency: ").append(toIndentedString(enableInstallmentLevelDelinquency)).append("\n");
    sb.append("    feeToIncomeAccountMappings: ").append(toIndentedString(feeToIncomeAccountMappings)).append("\n");
    sb.append("    fixedLength: ").append(toIndentedString(fixedLength)).append("\n");
    sb.append("    fixedPrincipalPercentagePerInstallment: ").append(toIndentedString(fixedPrincipalPercentagePerInstallment)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inArrearsTolerance: ").append(toIndentedString(inArrearsTolerance)).append("\n");
    sb.append("    includeInBorrowerCycle: ").append(toIndentedString(includeInBorrowerCycle)).append("\n");
    sb.append("    interestCalculationPeriodType: ").append(toIndentedString(interestCalculationPeriodType)).append("\n");
    sb.append("    interestRateFrequencyType: ").append(toIndentedString(interestRateFrequencyType)).append("\n");
    sb.append("    interestRatePerPeriod: ").append(toIndentedString(interestRatePerPeriod)).append("\n");
    sb.append("    interestRateVariationsForBorrowerCycle: ").append(toIndentedString(interestRateVariationsForBorrowerCycle)).append("\n");
    sb.append("    interestRecalculationData: ").append(toIndentedString(interestRecalculationData)).append("\n");
    sb.append("    interestRecognitionOnDisbursementDate: ").append(toIndentedString(interestRecognitionOnDisbursementDate)).append("\n");
    sb.append("    interestType: ").append(toIndentedString(interestType)).append("\n");
    sb.append("    isFloatingInterestRateCalculationAllowed: ").append(toIndentedString(isFloatingInterestRateCalculationAllowed)).append("\n");
    sb.append("    isInterestRecalculationEnabled: ").append(toIndentedString(isInterestRecalculationEnabled)).append("\n");
    sb.append("    isLinkedToFloatingInterestRates: ").append(toIndentedString(isLinkedToFloatingInterestRates)).append("\n");
    sb.append("    isRatesEnabled: ").append(toIndentedString(isRatesEnabled)).append("\n");
    sb.append("    loanScheduleProcessingType: ").append(toIndentedString(loanScheduleProcessingType)).append("\n");
    sb.append("    loanScheduleType: ").append(toIndentedString(loanScheduleType)).append("\n");
    sb.append("    maxInterestRatePerPeriod: ").append(toIndentedString(maxInterestRatePerPeriod)).append("\n");
    sb.append("    maxNumberOfRepayments: ").append(toIndentedString(maxNumberOfRepayments)).append("\n");
    sb.append("    maxPrincipal: ").append(toIndentedString(maxPrincipal)).append("\n");
    sb.append("    maxTrancheCount: ").append(toIndentedString(maxTrancheCount)).append("\n");
    sb.append("    maximumGap: ").append(toIndentedString(maximumGap)).append("\n");
    sb.append("    merchantBuyDownFee: ").append(toIndentedString(merchantBuyDownFee)).append("\n");
    sb.append("    minInterestRatePerPeriod: ").append(toIndentedString(minInterestRatePerPeriod)).append("\n");
    sb.append("    minNumberOfRepayments: ").append(toIndentedString(minNumberOfRepayments)).append("\n");
    sb.append("    minPrincipal: ").append(toIndentedString(minPrincipal)).append("\n");
    sb.append("    minimumGap: ").append(toIndentedString(minimumGap)).append("\n");
    sb.append("    multiDisburseLoan: ").append(toIndentedString(multiDisburseLoan)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    numberOfRepaymentVariationsForBorrowerCycle: ").append(toIndentedString(numberOfRepaymentVariationsForBorrowerCycle)).append("\n");
    sb.append("    numberOfRepayments: ").append(toIndentedString(numberOfRepayments)).append("\n");
    sb.append("    outstandingLoanBalance: ").append(toIndentedString(outstandingLoanBalance)).append("\n");
    sb.append("    overAppliedCalculationType: ").append(toIndentedString(overAppliedCalculationType)).append("\n");
    sb.append("    overDueDaysForRepaymentEvent: ").append(toIndentedString(overDueDaysForRepaymentEvent)).append("\n");
    sb.append("    overdueDaysForNPA: ").append(toIndentedString(overdueDaysForNPA)).append("\n");
    sb.append("    paymentAllocation: ").append(toIndentedString(paymentAllocation)).append("\n");
    sb.append("    paymentChannelToFundSourceMappings: ").append(toIndentedString(paymentChannelToFundSourceMappings)).append("\n");
    sb.append("    principal: ").append(toIndentedString(principal)).append("\n");
    sb.append("    principalThresholdForLastInstalment: ").append(toIndentedString(principalThresholdForLastInstalment)).append("\n");
    sb.append("    productsPrincipalVariationsForBorrowerCycle: ").append(toIndentedString(productsPrincipalVariationsForBorrowerCycle)).append("\n");
    sb.append("    repaymentEvery: ").append(toIndentedString(repaymentEvery)).append("\n");
    sb.append("    repaymentFrequencyType: ").append(toIndentedString(repaymentFrequencyType)).append("\n");
    sb.append("    repaymentStartDateType: ").append(toIndentedString(repaymentStartDateType)).append("\n");
    sb.append("    shortName: ").append(toIndentedString(shortName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    supportedInterestRefundTypes: ").append(toIndentedString(supportedInterestRefundTypes)).append("\n");
    sb.append("    transactionProcessingStrategyCode: ").append(toIndentedString(transactionProcessingStrategyCode)).append("\n");
    sb.append("    transactionProcessingStrategyName: ").append(toIndentedString(transactionProcessingStrategyName)).append("\n");
    sb.append("    useBorrowerCycle: ").append(toIndentedString(useBorrowerCycle)).append("\n");
    sb.append("    writeOffReasonOptions: ").append(toIndentedString(writeOffReasonOptions)).append("\n");
    sb.append("    writeOffReasonsToExpenseMappings: ").append(toIndentedString(writeOffReasonsToExpenseMappings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

