package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.PageClientSearchData;
import org.apache.fineract.client.models.PagedRequestClientTextSearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ClientSearchV2Api {
    /**
    * Search Clients by text
    * 
        * @param pagedRequestClientTextSearch  (optional)
    * @return Call&lt;PageClientSearchData&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v2/clients/search")
    Call<PageClientSearchData> searchByText(@retrofit2.http.Body PagedRequestClientTextSearch pagedRequestClientTextSearch);


        /**
        * Search Clients by text
        * 
            * @param pagedRequestClientTextSearch  (optional)
        * @return Call&lt;PageClientSearchData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v2/clients/search")
    Call<PageClientSearchData> searchByText();

        /**
        * Search Clients by text
        * 
            * @param pagedRequestClientTextSearch  (optional)
        * @return Call&lt;PageClientSearchData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v2/clients/search")
    Call<PageClientSearchData> searchByText(@retrofit2.http.Body PagedRequestClientTextSearch pagedRequestClientTextSearch, @HeaderMap Map<String, String> headers);


        /**
        * Search Clients by text
        * 
            * @param pagedRequestClientTextSearch  (optional)
        * @return Call&lt;PageClientSearchData&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v2/clients/search")
    Call<PageClientSearchData> searchByText(@HeaderMap Map<String, String> headers);
}
