package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import java.math.BigDecimal;
import org.apache.fineract.client.models.PagedLocalRequestAdvancedQueryRequest;
import org.apache.fineract.client.models.PostSavingsAccountBulkReversalTransactionsRequest;
import org.apache.fineract.client.models.PostSavingsAccountTransactionsRequest;
import org.apache.fineract.client.models.PostSavingsAccountTransactionsResponse;
import org.apache.fineract.client.models.SavingsAccountTransactionsSearchResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SavingsAccountTransactionsApi {
    /**
    * Undo/Reverse/Modify/Release Amount transaction API
    * Undo/Reverse/Modify/Release Amount transaction API  Example Requests:   savingsaccounts/{savingsId}/transactions/{transactionId}?command&#x3D;reverse  Accepted command &#x3D; undo, reverse, modify, releaseAmount
        * @param savingsId  (required)
        * @param transactionId  (required)
        * @param postSavingsAccountBulkReversalTransactionsRequest  (required)
        * @param command  (optional)
    * @return Call&lt;List&lt;PostSavingsAccountBulkReversalTransactionsRequest&gt;&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/savingsaccounts/{savingsId}/transactions/{transactionId}")
    Call<List<PostSavingsAccountBulkReversalTransactionsRequest>> adjustTransaction1(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostSavingsAccountBulkReversalTransactionsRequest postSavingsAccountBulkReversalTransactionsRequest, @retrofit2.http.Query("command") String command);

    /**
    * Advanced search Savings Account Transactions
    * 
        * @param savingsId savingsId (required)
        * @param pagedLocalRequestAdvancedQueryRequest  (optional)
    * @return Call&lt;String&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/savingsaccounts/{savingsId}/transactions/query")
    Call<String> advancedQuery1(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Body PagedLocalRequestAdvancedQueryRequest pagedLocalRequestAdvancedQueryRequest);

    /**
    * 
    * 
        * @param savingsId  (required)
        * @param transactionId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/savingsaccounts/{savingsId}/transactions/{transactionId}")
    Call<String> retrieveOne24(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Path("transactionId") Long transactionId);

    /**
    * 
    * 
        * @param savingsId  (required)
    * @return Call&lt;String&gt;
    */
    @GET("v1/savingsaccounts/{savingsId}/transactions/template")
    Call<String> retrieveTemplate19(@retrofit2.http.Path("savingsId") Long savingsId);

    /**
    * Search Savings Account Transactions
    * 
        * @param savingsId savings account id (required)
        * @param fromDate minimum value date (inclusive) (optional)
        * @param toDate maximum value date (inclusive) (optional)
        * @param fromSubmittedDate minimum booking date (inclusive) (optional)
        * @param toSubmittedDate maximum booking date (inclusive) (optional)
        * @param fromAmount minimum transaction amount (inclusive) (optional)
        * @param toAmount maximum transaction amount (inclusive) (optional)
        * @param types transaction types (optional)
        * @param credit credit (optional)
        * @param debit debit (optional)
        * @param offset offset (optional)
        * @param limit limit (optional)
        * @param orderBy sort properties (optional)
        * @param sortOrder sort direction (optional)
        * @param locale locale (optional)
        * @param dateFormat date format (optional)
    * @return Call&lt;SavingsAccountTransactionsSearchResponse&gt;
    */
    @GET("v1/savingsaccounts/{savingsId}/transactions/search")
    Call<SavingsAccountTransactionsSearchResponse> searchTransactions(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Query("fromDate") String fromDate, @retrofit2.http.Query("toDate") String toDate, @retrofit2.http.Query("fromSubmittedDate") String fromSubmittedDate, @retrofit2.http.Query("toSubmittedDate") String toSubmittedDate, @retrofit2.http.Query("fromAmount") BigDecimal fromAmount, @retrofit2.http.Query("toAmount") BigDecimal toAmount, @retrofit2.http.Query("types") String types, @retrofit2.http.Query("credit") Boolean credit, @retrofit2.http.Query("debit") Boolean debit, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat);

    /**
    * 
    * 
        * @param savingsId  (required)
        * @param postSavingsAccountTransactionsRequest  (required)
        * @param command  (optional)
    * @return Call&lt;PostSavingsAccountTransactionsResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/savingsaccounts/{savingsId}/transactions")
    Call<PostSavingsAccountTransactionsResponse> transaction2(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Body PostSavingsAccountTransactionsRequest postSavingsAccountTransactionsRequest, @retrofit2.http.Query("command") String command);


        /**
        * Advanced search Savings Account Transactions
        * 
            * @param savingsId savingsId (required)
            * @param pagedLocalRequestAdvancedQueryRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/savingsaccounts/{savingsId}/transactions/query")
    Call<String> advancedQuery1(@retrofit2.http.Path("savingsId") Long savingsId);

        /**
        * Undo/Reverse/Modify/Release Amount transaction API
        * Undo/Reverse/Modify/Release Amount transaction API  Example Requests:   savingsaccounts/{savingsId}/transactions/{transactionId}?command&#x3D;reverse  Accepted command &#x3D; undo, reverse, modify, releaseAmount
            * @param savingsId  (required)
            * @param transactionId  (required)
            * @param postSavingsAccountBulkReversalTransactionsRequest  (required)
            * @param command  (optional)
        * @return Call&lt;List&lt;PostSavingsAccountBulkReversalTransactionsRequest&gt;&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/savingsaccounts/{savingsId}/transactions/{transactionId}")
    Call<List<PostSavingsAccountBulkReversalTransactionsRequest>> adjustTransaction1(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Path("transactionId") Long transactionId, @retrofit2.http.Body PostSavingsAccountBulkReversalTransactionsRequest postSavingsAccountBulkReversalTransactionsRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);

        /**
        * Advanced search Savings Account Transactions
        * 
            * @param savingsId savingsId (required)
            * @param pagedLocalRequestAdvancedQueryRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/savingsaccounts/{savingsId}/transactions/query")
    Call<String> advancedQuery1(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Body PagedLocalRequestAdvancedQueryRequest pagedLocalRequestAdvancedQueryRequest, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param savingsId  (required)
            * @param transactionId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/savingsaccounts/{savingsId}/transactions/{transactionId}")
    Call<String> retrieveOne24(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Path("transactionId") Long transactionId, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param savingsId  (required)
        * @return Call&lt;String&gt;
        */
    @GET("v1/savingsaccounts/{savingsId}/transactions/template")
    Call<String> retrieveTemplate19(@retrofit2.http.Path("savingsId") Long savingsId, @HeaderMap Map<String, String> headers);

        /**
        * Search Savings Account Transactions
        * 
            * @param savingsId savings account id (required)
            * @param fromDate minimum value date (inclusive) (optional)
            * @param toDate maximum value date (inclusive) (optional)
            * @param fromSubmittedDate minimum booking date (inclusive) (optional)
            * @param toSubmittedDate maximum booking date (inclusive) (optional)
            * @param fromAmount minimum transaction amount (inclusive) (optional)
            * @param toAmount maximum transaction amount (inclusive) (optional)
            * @param types transaction types (optional)
            * @param credit credit (optional)
            * @param debit debit (optional)
            * @param offset offset (optional)
            * @param limit limit (optional)
            * @param orderBy sort properties (optional)
            * @param sortOrder sort direction (optional)
            * @param locale locale (optional)
            * @param dateFormat date format (optional)
        * @return Call&lt;SavingsAccountTransactionsSearchResponse&gt;
        */
    @GET("v1/savingsaccounts/{savingsId}/transactions/search")
    Call<SavingsAccountTransactionsSearchResponse> searchTransactions(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Query("fromDate") String fromDate, @retrofit2.http.Query("toDate") String toDate, @retrofit2.http.Query("fromSubmittedDate") String fromSubmittedDate, @retrofit2.http.Query("toSubmittedDate") String toSubmittedDate, @retrofit2.http.Query("fromAmount") BigDecimal fromAmount, @retrofit2.http.Query("toAmount") BigDecimal toAmount, @retrofit2.http.Query("types") String types, @retrofit2.http.Query("credit") Boolean credit, @retrofit2.http.Query("debit") Boolean debit, @retrofit2.http.Query("offset") Integer offset, @retrofit2.http.Query("limit") Integer limit, @retrofit2.http.Query("orderBy") String orderBy, @retrofit2.http.Query("sortOrder") String sortOrder, @retrofit2.http.Query("locale") String locale, @retrofit2.http.Query("dateFormat") String dateFormat, @HeaderMap Map<String, String> headers);

        /**
        * 
        * 
            * @param savingsId  (required)
            * @param postSavingsAccountTransactionsRequest  (required)
            * @param command  (optional)
        * @return Call&lt;PostSavingsAccountTransactionsResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/savingsaccounts/{savingsId}/transactions")
    Call<PostSavingsAccountTransactionsResponse> transaction2(@retrofit2.http.Path("savingsId") Long savingsId, @retrofit2.http.Body PostSavingsAccountTransactionsRequest postSavingsAccountTransactionsRequest, @retrofit2.http.Query("command") String command, @HeaderMap Map<String, String> headers);


        /**
        * Advanced search Savings Account Transactions
        * 
            * @param savingsId savingsId (required)
            * @param pagedLocalRequestAdvancedQueryRequest  (optional)
        * @return Call&lt;String&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/savingsaccounts/{savingsId}/transactions/query")
    Call<String> advancedQuery1(@retrofit2.http.Path("savingsId") Long savingsId, @HeaderMap Map<String, String> headers);
}
