/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.ImmutableJoinPushTransitivePredicatesRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinPushTransitivePredicatesRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinPushTransitivePredicatesRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinPushTransitivePredicatesRule(Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(joinClass));
    }

    @Deprecated
    public JoinPushTransitivePredicatesRule(Class<? extends Join> joinClass, RelFactories.FilterFactory filterFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(RelBuilder.proto(Contexts.of((Object)filterFactory))).as(Config.class).withOperandFor(joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        RelMetadataQuery mq = call.getMetadataQuery();
        RelOptPredicateList preds = mq.getPulledUpPredicates(join);
        if (preds.leftInferredPredicates.isEmpty() && preds.rightInferredPredicates.isEmpty()) {
            return;
        }
        RelBuilder relBuilder = call.builder();
        RelNode left = join.getLeft();
        if (preds.leftInferredPredicates.size() > 0) {
            RelNode curr = left;
            left = relBuilder.push(left).filter(preds.leftInferredPredicates).build();
            call.getPlanner().onCopy(curr, left);
        }
        RelNode right = join.getRight();
        if (preds.rightInferredPredicates.size() > 0) {
            RelNode curr = right;
            right = relBuilder.push(right).filter(preds.rightInferredPredicates).build();
            call.getPlanner().onCopy(curr, right);
        }
        Join newRel = join.copy(join.getTraitSet(), join.getCondition(), left, right, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy(join, newRel);
        call.transformTo(newRel);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinPushTransitivePredicatesRule.Config.of().withOperandFor(Join.class);

        @Override
        default public JoinPushTransitivePredicatesRule toRule() {
            return new JoinPushTransitivePredicatesRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b -> b.operand(joinClass).anyInputs()).as(Config.class);
        }
    }
}

