/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;

public class RexSetSemanticsTableCall
extends RexCall {
    private final int[] partitionKeys;
    private final int[] orderKeys;

    public RexSetSemanticsTableCall(RelDataType type, SqlOperator operator, List<? extends RexNode> operands, int[] partitionKeys, int[] orderKeys) {
        super(type, operator, operands);
        this.partitionKeys = partitionKeys;
        this.orderKeys = orderKeys;
    }

    public int[] getPartitionKeys() {
        return this.partitionKeys;
    }

    public int[] getOrderKeys() {
        return this.orderKeys;
    }

    @Override
    protected String computeDigest(boolean withType) {
        if (this.operands.isEmpty() && this.op.getSyntax() == SqlSyntax.FUNCTION_ID) {
            return super.computeDigest(withType);
        }
        StringBuilder sb = new StringBuilder(this.op.getName());
        sb.append("(");
        this.appendKeys(this.partitionKeys, "PARTITION BY", sb);
        this.appendKeys(this.orderKeys, "ORDER BY", sb);
        this.appendOperands(sb);
        sb.append(")");
        if (withType) {
            sb.append(":");
            sb.append(this.type.getFullTypeString());
        }
        return sb.toString();
    }

    private void appendKeys(int[] keys, String prefix, StringBuilder sb) {
        if (keys.length == 0) {
            return;
        }
        sb.append(Arrays.stream(keys).mapToObj(key -> "$" + key).collect(Collectors.joining(", ", prefix + "(", "), ")));
    }

    public RexSetSemanticsTableCall copy(List<? extends RexNode> newOperands, int[] newPartitionKeys, int[] newOrderKeys) {
        return new RexSetSemanticsTableCall(this.type, this.op, newOperands, newPartitionKeys, newOrderKeys);
    }

    @Override
    public RexSetSemanticsTableCall clone(RelDataType type, List<RexNode> operands) {
        return new RexSetSemanticsTableCall(type, this.getOperator(), operands, this.partitionKeys, this.orderKeys);
    }
}

