/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import com.amazonaws.services.s3.model.PartETag;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;

@Internal
final class S3RecoverableSerializer
implements SimpleVersionedSerializer<S3Recoverable> {
    static final S3RecoverableSerializer INSTANCE = new S3RecoverableSerializer();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final int MAGIC_NUMBER = -1737092046;

    private S3RecoverableSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(S3Recoverable obj) throws IOException {
        List<PartETag> partList = obj.parts();
        PartETag[] parts = partList.toArray(new PartETag[partList.size()]);
        byte[] keyBytes = obj.getObjectName().getBytes(CHARSET);
        byte[] uploadIdBytes = obj.uploadId().getBytes(CHARSET);
        byte[][] etags = new byte[parts.length][];
        int partEtagBytes = 0;
        for (int i = 0; i < parts.length; ++i) {
            etags[i] = parts[i].getETag().getBytes(CHARSET);
            partEtagBytes += etags[i].length + 8;
        }
        String lastObjectKey = obj.incompleteObjectName();
        byte[] lastPartBytes = lastObjectKey == null ? null : lastObjectKey.getBytes(CHARSET);
        byte[] targetBytes = new byte[8 + keyBytes.length + 4 + uploadIdBytes.length + 4 + partEtagBytes + 8 + 4 + (lastPartBytes == null ? 0 : lastPartBytes.length) + 8];
        ByteBuffer bb = ByteBuffer.wrap(targetBytes).order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(-1737092046);
        bb.putInt(keyBytes.length);
        bb.put(keyBytes);
        bb.putInt(uploadIdBytes.length);
        bb.put(uploadIdBytes);
        bb.putInt(etags.length);
        for (int i = 0; i < parts.length; ++i) {
            PartETag pe = parts[i];
            bb.putInt(pe.getPartNumber());
            bb.putInt(etags[i].length);
            bb.put(etags[i]);
        }
        bb.putLong(obj.numBytesInParts());
        if (lastPartBytes == null) {
            bb.putInt(0);
        } else {
            bb.putInt(lastPartBytes.length);
            bb.put(lastPartBytes);
        }
        bb.putLong(obj.incompleteObjectLength());
        return targetBytes;
    }

    public S3Recoverable deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return S3RecoverableSerializer.deserializeV1(serialized);
            }
        }
        throw new IOException("Unrecognized version or corrupt state: " + version);
    }

    private static S3Recoverable deserializeV1(byte[] serialized) throws IOException {
        String lastPart;
        ByteBuffer bb = ByteBuffer.wrap(serialized).order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != -1737092046) {
            throw new IOException("Corrupt data: Unexpected magic number.");
        }
        byte[] keyBytes = new byte[bb.getInt()];
        bb.get(keyBytes);
        byte[] uploadIdBytes = new byte[bb.getInt()];
        bb.get(uploadIdBytes);
        int numParts = bb.getInt();
        ArrayList<PartETag> parts = new ArrayList<PartETag>(numParts);
        for (int i = 0; i < numParts; ++i) {
            int partNum = bb.getInt();
            byte[] buffer = new byte[bb.getInt()];
            bb.get(buffer);
            parts.add(new PartETag(partNum, new String(buffer, CHARSET)));
        }
        long numBytes = bb.getLong();
        int lastObjectArraySize = bb.getInt();
        if (lastObjectArraySize == 0) {
            lastPart = null;
        } else {
            byte[] lastPartBytes = new byte[lastObjectArraySize];
            bb.get(lastPartBytes);
            lastPart = new String(lastPartBytes, CHARSET);
        }
        long lastPartLength = bb.getLong();
        return new S3Recoverable(new String(keyBytes, CHARSET), new String(uploadIdBytes, CHARSET), parts, numBytes, lastPart, lastPartLength);
    }
}

