/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.runtime.Enumerables;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableCollection;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public class TableScanNode
implements Node {
    private TableScanNode(Compiler compiler, TableScan rel, Enumerable<Row> enumerable) {
        compiler.enumerable(rel, enumerable);
    }

    @Override
    public void run() {
    }

    static TableScanNode create(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, @Nullable ImmutableIntList projects) {
        RelOptTable relOptTable = rel.getTable();
        ProjectableFilterableTable pfTable = relOptTable.unwrap(ProjectableFilterableTable.class);
        if (pfTable != null) {
            return TableScanNode.createProjectableFilterable(compiler, rel, filters, projects, pfTable);
        }
        FilterableTable filterableTable = relOptTable.unwrap(FilterableTable.class);
        if (filterableTable != null) {
            return TableScanNode.createFilterable(compiler, rel, filters, projects, filterableTable);
        }
        ScannableTable scannableTable = relOptTable.unwrap(ScannableTable.class);
        if (scannableTable != null) {
            return TableScanNode.createScannable(compiler, rel, filters, projects, scannableTable);
        }
        Enumerable enumerable = relOptTable.unwrap(Enumerable.class);
        if (enumerable != null) {
            return TableScanNode.createEnumerable(compiler, rel, enumerable, null, filters, projects);
        }
        QueryableTable queryableTable = relOptTable.unwrap(QueryableTable.class);
        if (queryableTable != null) {
            return TableScanNode.createQueryable(compiler, rel, filters, projects, queryableTable);
        }
        throw new AssertionError((Object)("cannot convert table " + relOptTable + " to enumerable"));
    }

    private static TableScanNode createScannable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, @Nullable ImmutableIntList projects, ScannableTable scannableTable) {
        Enumerable<Row> rowEnumerable = Enumerables.toRow(scannableTable.scan(compiler.getDataContext()));
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createQueryable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, @Nullable ImmutableIntList projects, QueryableTable queryableTable) {
        Enumerable<Row> rowEnumerable;
        DataContext root = compiler.getDataContext();
        RelOptTable relOptTable = rel.getTable();
        Type elementType = queryableTable.getElementType();
        SchemaPlus schema = root.getRootSchema();
        for (String name : Util.skipLast(relOptTable.getQualifiedName())) {
            Objects.requireNonNull(schema, () -> "schema is null while resolving " + name + " for table" + relOptTable.getQualifiedName());
            schema = schema.getSubSchema(name);
        }
        if (elementType instanceof Class) {
            Queryable queryable = Schemas.queryable(root, (Class)elementType, relOptTable.getQualifiedName());
            ImmutableList.Builder fieldBuilder = ImmutableList.builder();
            Class type = (Class)elementType;
            for (Field field : type.getFields()) {
                if (!ReflectUtil.isPublic(field) || ReflectUtil.isStatic(field)) continue;
                fieldBuilder.add(field);
            }
            ImmutableCollection fields = fieldBuilder.build();
            rowEnumerable = queryable.select(arg_0 -> TableScanNode.lambda$createQueryable$1((List)((Object)fields), arg_0));
        } else {
            rowEnumerable = Schemas.queryable(root, Row.class, relOptTable.getQualifiedName());
        }
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, filters, projects);
    }

    private static TableScanNode createFilterable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, @Nullable ImmutableIntList projects, FilterableTable filterableTable) {
        DataContext root = compiler.getDataContext();
        ArrayList<RexNode> mutableFilters = Lists.newArrayList(filters);
        Enumerable<@Nullable Object[]> enumerable = filterableTable.scan(root, mutableFilters);
        for (RexNode filter : mutableFilters) {
            if (filters.contains(filter)) continue;
            throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
        }
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable);
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, null, mutableFilters, projects);
    }

    private static TableScanNode createProjectableFilterable(Compiler compiler, TableScan rel, ImmutableList<RexNode> filters, @Nullable ImmutableIntList projects, ProjectableFilterableTable pfTable) {
        int[] projectInts;
        ArrayList<RexNode> mutableFilters;
        int changeCount;
        DataContext root = compiler.getDataContext();
        ImmutableIntList originalProjects = projects;
        do {
            mutableFilters = Lists.newArrayList(filters);
            projectInts = projects == null || projects.equals(TableScan.identity(rel.getTable())) ? null : projects.toIntArray();
            for (RexNode filter : mutableFilters) {
                if (filters.contains(filter)) continue;
                throw Static.RESOURCE.filterableTableInventedFilter(filter.toString()).ex();
            }
            ImmutableBitSet usedFields = RelOptUtil.InputFinder.bits(mutableFilters, null);
            if (projects == null) break;
            changeCount = 0;
            for (int usedField : usedFields) {
                if (projects.contains(usedField)) continue;
                projects = ImmutableIntList.copyOf(Iterables.concat(projects, ImmutableList.of(Integer.valueOf(usedField))));
                ++changeCount;
            }
        } while (changeCount > 0);
        Enumerable<@Nullable Object[]> enumerable1 = pfTable.scan(root, mutableFilters, projectInts);
        Enumerable<Row> rowEnumerable = Enumerables.toRow(enumerable1);
        ImmutableIntList rejectedProjects = originalProjects == null || originalProjects.equals(projects) ? null : ImmutableIntList.identity(originalProjects.size());
        return TableScanNode.createEnumerable(compiler, rel, rowEnumerable, projects, mutableFilters, rejectedProjects);
    }

    private static TableScanNode createEnumerable(Compiler compiler, TableScan rel, Enumerable<Row> enumerable, @Nullable ImmutableIntList acceptedProjects, List<RexNode> rejectedFilters, @Nullable ImmutableIntList rejectedProjects) {
        if (!rejectedFilters.isEmpty()) {
            RelDataType inputRowType;
            RexNode filter2;
            RexNode filter = RexUtil.composeConjunction(rel.getCluster().getRexBuilder(), rejectedFilters);
            if (acceptedProjects == null) {
                filter2 = filter;
                inputRowType = rel.getRowType();
            } else {
                Mapping mapping = Mappings.target(acceptedProjects, rel.getTable().getRowType().getFieldCount());
                filter2 = RexUtil.apply((Mappings.TargetMapping)mapping, filter);
                RelDataTypeFactory.FieldInfoBuilder builder = rel.getCluster().getTypeFactory().builder();
                List<RelDataTypeField> fieldList = rel.getTable().getRowType().getFieldList();
                for (int acceptedProject : acceptedProjects) {
                    ((RelDataTypeFactory.Builder)builder).add(fieldList.get(acceptedProject));
                }
                inputRowType = builder.build();
            }
            Scalar condition = compiler.compile(ImmutableList.of(filter2), inputRowType);
            Context context = compiler.createContext();
            enumerable = enumerable.where(row -> {
                context.values = row.getValues();
                Boolean b = (Boolean)condition.execute(context);
                return b != null && b != false;
            });
        }
        if (rejectedProjects != null) {
            @Nullable Object[] values = new Object[rejectedProjects.size()];
            enumerable = enumerable.select(row -> {
                @Nullable Object[] inValues = row.getValues();
                for (int i = 0; i < rejectedProjects.size(); ++i) {
                    values[i] = inValues[rejectedProjects.get(i)];
                }
                return Row.asCopy(values);
            });
        }
        return new TableScanNode(compiler, rel, enumerable);
    }

    private static /* synthetic */ Row lambda$createQueryable$1(List fields, Object o) {
        @Nullable Object[] values = new Object[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = (Field)fields.get(i);
            try {
                values[i] = field.get(o);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return new Row(values);
    }
}

