/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.EnumerableDefaults;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.EqualityComparer;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.RequiresNonNull;

final class MergeUnionEnumerator<TSource, TKey>
implements Enumerator<TSource> {
    private final Enumerator<TSource>[] inputs;
    private final TSource[] currentInputsValues;
    private final boolean[] inputsFinished;
    private final Function1<TSource, TKey> sortKeySelector;
    private final Comparator<TKey> sortComparator;
    private TSource currentValue;
    private int activeInputs;
    private final @Nullable Set<EnumerableDefaults.Wrapped<TSource>> processed;
    private final @Nullable Function1<TSource, EnumerableDefaults.Wrapped<TSource>> wrapper;
    private @Nullable TKey currentKeyInProcessedSet;
    private static final Object NOT_INIT = new Object();

    MergeUnionEnumerator(List<Enumerable<TSource>> sources, Function1<TSource, TKey> sortKeySelector, Comparator<TKey> sortComparator, boolean all, EqualityComparer<TSource> equalityComparer) {
        this.sortKeySelector = sortKeySelector;
        this.sortComparator = sortComparator;
        if (all) {
            this.processed = null;
            this.wrapper = null;
        } else {
            this.processed = new HashSet<EnumerableDefaults.Wrapped<TSource>>();
            this.wrapper = EnumerableDefaults.wrapperFor(equalityComparer);
        }
        int size = sources.size();
        this.inputs = new Enumerator[size];
        int i = 0;
        for (Enumerable<TSource> source : sources) {
            this.inputs[i++] = source.enumerator();
        }
        this.currentInputsValues = new Object[size];
        this.activeInputs = this.currentInputsValues.length;
        this.inputsFinished = new boolean[size];
        this.currentValue = NOT_INIT;
        this.initEnumerators();
    }

    @RequiresNonNull(value={"inputs"})
    private void initEnumerators(@UnknownInitialization MergeUnionEnumerator<TSource, TKey> this) {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.moveEnumerator(i);
        }
    }

    private void moveEnumerator(int i) {
        Enumerator<TSource> enumerator = this.inputs[i];
        if (!enumerator.moveNext()) {
            --this.activeInputs;
            this.inputsFinished[i] = true;
            @Nullable TSource[] auxInputsValues = this.currentInputsValues;
            auxInputsValues[i] = null;
        } else {
            this.currentInputsValues[i] = enumerator.current();
            this.inputsFinished[i] = false;
        }
    }

    private boolean checkNotDuplicated(TSource value) {
        if (this.processed == null) {
            return true;
        }
        EnumerableDefaults.Wrapped<TSource> wrapped = this.wrapper.apply(value);
        if (!this.processed.contains(wrapped)) {
            TKey key = this.sortKeySelector.apply(value);
            if (!this.processed.isEmpty()) {
                int sortComparison = this.sortComparator.compare(key, this.currentKeyInProcessedSet);
                if (sortComparison != 0) {
                    this.processed.clear();
                    this.currentKeyInProcessedSet = key;
                }
            } else {
                this.currentKeyInProcessedSet = key;
            }
            this.processed.add(wrapped);
            return true;
        }
        return false;
    }

    private int compare(TSource e1, TSource e2) {
        TKey key1 = this.sortKeySelector.apply(e1);
        TKey key2 = this.sortKeySelector.apply(e2);
        return this.sortComparator.compare(key1, key2);
    }

    @Override
    public TSource current() {
        if (this.currentValue == NOT_INIT) {
            throw new NoSuchElementException();
        }
        return this.currentValue;
    }

    @Override
    public boolean moveNext() {
        while (this.activeInputs > 0) {
            int i;
            int candidateIndex = -1;
            for (i = 0; i < this.currentInputsValues.length; ++i) {
                if (this.inputsFinished[i]) continue;
                candidateIndex = i;
                break;
            }
            if (this.activeInputs > 1) {
                for (i = candidateIndex + 1; i < this.currentInputsValues.length; ++i) {
                    int comp;
                    if (this.inputsFinished[i] || (comp = this.compare(this.currentInputsValues[candidateIndex], this.currentInputsValues[i])) <= 0) continue;
                    candidateIndex = i;
                }
            }
            if (this.checkNotDuplicated(this.currentInputsValues[candidateIndex])) {
                this.currentValue = this.currentInputsValues[candidateIndex];
                this.moveEnumerator(candidateIndex);
                return true;
            }
            this.moveEnumerator(candidateIndex);
        }
        return false;
    }

    @Override
    public void reset() {
        for (Enumerator<TSource> enumerator : this.inputs) {
            enumerator.reset();
        }
        if (this.processed != null) {
            this.processed.clear();
            this.currentKeyInProcessedSet = null;
        }
        this.currentValue = NOT_INIT;
        this.activeInputs = this.currentInputsValues.length;
        this.initEnumerators();
    }

    @Override
    public void close() {
        for (Enumerator<TSource> enumerator : this.inputs) {
            enumerator.close();
        }
    }
}

