/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ImmutableProjectMergeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Permutation;
import org.immutables.value.Value;

@Value.Enclosing
public class ProjectMergeRule
extends RelRule<Config>
implements TransformationRule {
    public static final int DEFAULT_BLOAT = 100;

    protected ProjectMergeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectMergeRule(boolean force, int bloat, RelBuilderFactory relBuilderFactory) {
        this(((Config)CoreRules.PROJECT_MERGE.config).withRelBuilderFactory(relBuilderFactory).as(Config.class).withForce(force).withBloat(bloat));
    }

    @Deprecated
    public ProjectMergeRule(boolean force, RelBuilderFactory relBuilderFactory) {
        this(((Config)CoreRules.PROJECT_MERGE.config).withRelBuilderFactory(relBuilderFactory).as(Config.class).withForce(force));
    }

    @Deprecated
    public ProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        this(((Config)CoreRules.PROJECT_MERGE.config).withRelBuilderFactory(RelBuilder.proto(projectFactory)).as(Config.class).withForce(force));
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        return topProject.getConvention() == bottomProject.getConvention();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RelBuilder relBuilder = call.builder();
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                relBuilder.push(bottomProject.getInput());
                relBuilder.project(relBuilder.fields(product), topProject.getRowType().getFieldNames());
                call.transformTo(relBuilder.build());
                return;
            }
        }
        if (!((Config)this.config).force() && RexUtil.isIdentity(topProject.getProjects(), topProject.getInput().getRowType())) {
            return;
        }
        List<RexNode> newProjects = RelOptUtil.pushPastProjectUnlessBloat(topProject.getProjects(), bottomProject, ((Config)this.config).bloat());
        if (newProjects == null) {
            return;
        }
        RelNode input = bottomProject.getInput();
        if (RexUtil.isIdentity(newProjects, input.getRowType()) && (((Config)this.config).force() || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        relBuilder.push(bottomProject.getInput());
        relBuilder.project(newProjects, topProject.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableProjectMergeRule.Config.of().withOperandFor(Project.class);

        @Override
        default public ProjectMergeRule toRule() {
            return new ProjectMergeRule(this);
        }

        @Value.Default
        default public int bloat() {
            return 100;
        }

        public Config withBloat(int var1);

        @Value.Default
        default public boolean force() {
            return true;
        }

        public Config withForce(boolean var1);

        default public Config withOperandFor(Class<? extends Project> projectClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(projectClass).anyInputs())).as(Config.class);
        }
    }
}

