/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlAlterModel;

public class SqlAlterModelReset
extends SqlAlterModel {
    private final SqlNodeList optionKeyList;

    public SqlAlterModelReset(SqlParserPos pos, SqlIdentifier modelName, boolean ifModelExists, SqlNodeList optionKeyList) {
        super(pos, modelName, ifModelExists);
        this.optionKeyList = Objects.requireNonNull(optionKeyList, "optionKeyList should not be null");
    }

    @Override
    public List<SqlNode> getOperandList() {
        return List.of(this.modelName, this.optionKeyList);
    }

    public Set<String> getResetKeys() {
        return this.optionKeyList.getList().stream().map(key -> ((NlsString)SqlLiteral.value(key)).getValue()).collect(Collectors.toSet());
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        super.unparse(writer, leftPrec, rightPrec);
        writer.keyword("RESET");
        SqlWriter.Frame withFrame = writer.startList("(", ")");
        for (SqlNode optionKey : this.optionKeyList) {
            SqlUnparseUtils.printIndent(writer);
            optionKey.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        writer.endList(withFrame);
    }
}

