/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateModel
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE MODEL", SqlKind.OTHER_DDL);
    private final SqlIdentifier modelName;
    @Nullable
    private final SqlCharStringLiteral comment;
    private final SqlNodeList inputColumnList;
    private final SqlNodeList outputColumnList;
    private final SqlNodeList propertyList;
    private final boolean isTemporary;
    private final boolean ifNotExists;

    public SqlCreateModel(SqlParserPos pos, SqlIdentifier modelName, SqlCharStringLiteral comment, SqlNodeList inputColumnList, SqlNodeList outputColumnList, SqlNodeList propertyList, boolean isTemporary, boolean ifNotExists) {
        super(OPERATOR, pos, false, ifNotExists);
        this.modelName = Objects.requireNonNull(modelName, "modelName should not be null");
        this.comment = comment;
        this.inputColumnList = inputColumnList;
        this.outputColumnList = outputColumnList;
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.isTemporary = isTemporary;
        this.ifNotExists = ifNotExists;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.modelName, this.comment, this.inputColumnList, this.outputColumnList, this.propertyList);
    }

    public SqlIdentifier getModelName() {
        return this.modelName;
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public SqlNodeList getInputColumnList() {
        return this.inputColumnList;
    }

    public SqlNodeList getOutputColumnList() {
        return this.outputColumnList;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void validate() throws SqlValidateException {
        if (!this.inputColumnList.isEmpty() && this.outputColumnList.isEmpty()) {
            throw new SqlValidateException(this.inputColumnList.get(0).getParserPosition(), "Output column list can not be empty with non-empty input column list.");
        }
        if (this.inputColumnList.isEmpty() && !this.outputColumnList.isEmpty()) {
            throw new SqlValidateException(this.outputColumnList.get(0).getParserPosition(), "Input column list can not be empty with non-empty output column list.");
        }
        if (this.propertyList.isEmpty()) {
            throw new SqlValidateException(this.getParserPosition(), "Model property list can not be empty.");
        }
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame withFrame;
        writer.keyword("CREATE");
        writer.keyword("MODEL");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.modelName.unparse(writer, leftPrec, rightPrec);
        if (!this.inputColumnList.isEmpty()) {
            writer.keyword("INPUT");
            withFrame = writer.startList("(", ")");
            for (SqlNode column : this.inputColumnList) {
                SqlUnparseUtils.printIndent(writer);
                column.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        if (!this.outputColumnList.isEmpty()) {
            writer.keyword("OUTPUT");
            withFrame = writer.startList("(", ")");
            for (SqlNode column : this.outputColumnList) {
                SqlUnparseUtils.printIndent(writer);
                column.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (!this.propertyList.isEmpty()) {
            writer.keyword("WITH");
            withFrame = writer.startList("(", ")");
            for (SqlNode modelProperty : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                modelProperty.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    public String[] fullModelName() {
        return this.modelName.names.toArray(new String[0]);
    }
}

