/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.flink.sql.parser.ExtendedSqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.SqlUnparseUtils;
import org.apache.flink.sql.parser.ddl.SqlDistribution;
import org.apache.flink.sql.parser.ddl.SqlTableColumn;
import org.apache.flink.sql.parser.ddl.SqlWatermark;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;

public class SqlCreateTable
extends SqlCreate
implements ExtendedSqlNode {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE TABLE", SqlKind.CREATE_TABLE);
    private final SqlIdentifier tableName;
    private final SqlNodeList columnList;
    private final SqlNodeList propertyList;
    private final List<SqlTableConstraint> tableConstraints;
    private final SqlDistribution distribution;
    private final SqlNodeList partitionKeyList;
    private final SqlWatermark watermark;
    private final SqlCharStringLiteral comment;
    private final boolean isTemporary;

    public SqlCreateTable(SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, SqlDistribution distribution, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, boolean isTemporary, boolean ifNotExists) {
        this(OPERATOR, pos, tableName, columnList, tableConstraints, propertyList, distribution, partitionKeyList, watermark, comment, isTemporary, ifNotExists, false);
    }

    protected SqlCreateTable(SqlSpecialOperator operator, SqlParserPos pos, SqlIdentifier tableName, SqlNodeList columnList, List<SqlTableConstraint> tableConstraints, SqlNodeList propertyList, @Nullable SqlDistribution distribution, SqlNodeList partitionKeyList, @Nullable SqlWatermark watermark, @Nullable SqlCharStringLiteral comment, boolean isTemporary, boolean ifNotExists, boolean replace) {
        super(operator, pos, replace, ifNotExists);
        this.tableName = Objects.requireNonNull(tableName, "tableName should not be null");
        this.columnList = Objects.requireNonNull(columnList, "columnList should not be null");
        this.tableConstraints = Objects.requireNonNull(tableConstraints, "table constraints should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.distribution = distribution;
        this.partitionKeyList = Objects.requireNonNull(partitionKeyList, "partitionKeyList should not be null");
        this.watermark = watermark;
        this.comment = comment;
        this.isTemporary = isTemporary;
    }

    @Override
    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    @Nonnull
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.tableName, this.columnList, new SqlNodeList(this.tableConstraints, SqlParserPos.ZERO), this.propertyList, this.partitionKeyList, this.watermark, this.comment);
    }

    public SqlIdentifier getTableName() {
        return this.tableName;
    }

    public SqlNodeList getColumnList() {
        return this.columnList;
    }

    public final SqlDistribution getDistribution() {
        return this.distribution;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public SqlNodeList getPartitionKeyList() {
        return this.partitionKeyList;
    }

    public List<SqlTableConstraint> getTableConstraints() {
        return this.tableConstraints;
    }

    public Optional<SqlWatermark> getWatermark() {
        return Optional.ofNullable(this.watermark);
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public void validate() throws SqlValidateException {
        SqlConstraintValidator.validateAndChangeColumnNullability(this.tableConstraints, this.columnList);
    }

    public boolean hasRegularColumnsOnly() {
        for (SqlNode column : this.columnList) {
            SqlTableColumn tableColumn = (SqlTableColumn)column;
            if (tableColumn instanceof SqlTableColumn.SqlRegularColumn) continue;
            return false;
        }
        return true;
    }

    public List<SqlTableConstraint> getFullConstraints() {
        return SqlConstraintValidator.getFullConstraints(this.tableConstraints, this.columnList);
    }

    public String getColumnSqlString() {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config().withDialect(AnsiSqlDialect.DEFAULT).withAlwaysUseParentheses(true).withSelectListItemsOnSeparateLines(false).withIndentation(0));
        writer.startList("", "");
        for (SqlNode column : this.columnList) {
            writer.sep(",");
            SqlTableColumn tableColumn = (SqlTableColumn)column;
            if (tableColumn instanceof SqlTableColumn.SqlComputedColumn) {
                SqlTableColumn.SqlComputedColumn computedColumn = (SqlTableColumn.SqlComputedColumn)tableColumn;
                computedColumn.getExpr().unparse(writer, 0, 0);
                writer.keyword("AS");
            }
            tableColumn.getName().unparse(writer, 0, 0);
        }
        return writer.toString();
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.isTemporary()) {
            writer.keyword("TEMPORARY");
        }
        writer.keyword("TABLE");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.tableName.unparse(writer, leftPrec, rightPrec);
        if (!this.columnList.isEmpty() || !this.tableConstraints.isEmpty() || this.watermark != null) {
            SqlUnparseUtils.unparseTableSchema(writer, leftPrec, rightPrec, this.columnList, this.tableConstraints, this.watermark);
        }
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.distribution != null) {
            writer.newlineAndIndent();
            this.distribution.unparse(writer, leftPrec, rightPrec);
        }
        if (!this.partitionKeyList.isEmpty()) {
            writer.newlineAndIndent();
            writer.keyword("PARTITIONED BY");
            SqlWriter.Frame partitionedByFrame = writer.startList("(", ")");
            this.partitionKeyList.unparse(writer, leftPrec, rightPrec);
            writer.endList(partitionedByFrame);
        }
        if (!this.propertyList.isEmpty()) {
            writer.newlineAndIndent();
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                SqlUnparseUtils.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    public String[] fullTableName() {
        return this.tableName.names.toArray(new String[0]);
    }

    public static class TableCreationContext {
        public List<SqlNode> columnList = new ArrayList<SqlNode>();
        public List<SqlTableConstraint> constraints = new ArrayList<SqlTableConstraint>();
        @Nullable
        public SqlWatermark watermark;
        @Nullable
        public SqlDistribution distribution;

        public boolean isColumnsIdentifiersOnly() {
            return !this.columnList.isEmpty() && this.columnList.get(0) instanceof SqlIdentifier;
        }
    }
}

