/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlModelCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlTableFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.calcite.RexTableArgCall;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.util.Preconditions;

@Internal
public class FlinkConvertletTable
implements SqlRexConvertletTable {
    public static final FlinkConvertletTable INSTANCE = new FlinkConvertletTable();

    private FlinkConvertletTable() {
    }

    @Override
    public SqlRexConvertlet get(SqlCall call) {
        SqlOperator operator = call.getOperator();
        if (operator == FlinkSqlOperatorTable.TRY_CAST) {
            return this::convertTryCast;
        }
        if (operator instanceof SqlTableFunction) {
            return this::convertTableArgs;
        }
        if (call instanceof SqlModelCall) {
            return this::convertModelCall;
        }
        return StandardConvertletTable.INSTANCE.get(call);
    }

    private RexNode convertModelCall(SqlRexContext cx, SqlCall call) {
        SqlModelCall modelCall = (SqlModelCall)call;
        return modelCall.getModel().toRex(cx);
    }

    private RexNode convertTryCast(SqlRexContext cx, SqlCall call) {
        RelDataType type;
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        Object leftNode = call.operand(0);
        Object rightNode = call.operand(1);
        RexNode valueRex = cx.convertExpression((SqlNode)leftNode);
        if (rightNode instanceof SqlIntervalQualifier) {
            type = typeFactory.createSqlIntervalType((SqlIntervalQualifier)rightNode);
        } else if (rightNode instanceof SqlDataTypeSpec) {
            SqlDataTypeSpec dataType = (SqlDataTypeSpec)rightNode;
            type = dataType.deriveType(cx.getValidator());
            if (type == null) {
                type = cx.getValidator().getValidatedNodeType(dataType.getTypeName());
            }
        } else {
            throw new IllegalStateException("Invalid right argument type for TRY_CAST: " + String.valueOf(rightNode));
        }
        type = typeFactory.createTypeWithNullability(type, true);
        if (SqlUtil.isNullLiteral(leftNode, false) || type.equals(valueRex.getType())) {
            SqlValidatorImpl validator = (SqlValidatorImpl)cx.getValidator();
            validator.setValidatedNodeType((SqlNode)leftNode, type);
            return cx.convertExpression((SqlNode)leftNode);
        }
        return cx.getRexBuilder().makeCall(type, FlinkSqlOperatorTable.TRY_CAST, Collections.singletonList(valueRex));
    }

    private RexNode convertTableArgs(SqlRexContext cx, SqlCall call) {
        Preconditions.checkArgument((boolean)(call.getOperator() instanceof SqlTableFunction), (Object)"Only table functions can have set semantics arguments.");
        SqlOperator operator = call.getOperator();
        ArrayList<RexNode> rewrittenOperands = new ArrayList<RexNode>();
        int tableInputCount = 0;
        for (int pos = 0; pos < call.getOperandList().size(); ++pos) {
            RelDataType tableType;
            Object operand = call.operand(pos);
            if (((SqlNode)operand).getKind() == SqlKind.SET_SEMANTICS_TABLE) {
                tableType = cx.getValidator().getValidatedNodeType((SqlNode)operand);
                SqlBasicCall setSemanticsCall = (SqlBasicCall)operand;
                SqlNodeList partitionKeys = (SqlNodeList)setSemanticsCall.operand(1);
                SqlNodeList orderKeys = (SqlNodeList)setSemanticsCall.operand(2);
                Preconditions.checkArgument((boolean)orderKeys.isEmpty(), (Object)"Table functions do not support order keys yet.");
                int[] keys = FlinkConvertletTable.getPartitionKeyIndices(tableType, partitionKeys);
                rewrittenOperands.add(new RexTableArgCall(tableType, tableInputCount++, keys, new int[0]));
                continue;
            }
            if (((SqlNode)operand).isA(SqlKind.QUERY)) {
                tableType = cx.getValidator().getValidatedNodeType((SqlNode)operand);
                rewrittenOperands.add(new RexTableArgCall(tableType, tableInputCount++, new int[0], new int[0]));
                continue;
            }
            rewrittenOperands.add(cx.convertExpression((SqlNode)operand));
        }
        RelDataType returnType = cx.getValidator().getValidatedNodeType(call);
        return cx.getRexBuilder().makeCall(returnType, operator, rewrittenOperands);
    }

    private static int[] getPartitionKeyIndices(RelDataType tableType, SqlNodeList partitions) {
        List<String> tableColumns = tableType.getFieldNames();
        int[] result = new int[partitions.size()];
        for (int i = 0; i < partitions.getList().size(); ++i) {
            SqlIdentifier column = (SqlIdentifier)partitions.get(i);
            result[i] = tableColumns.indexOf(column.getSimple());
        }
        return result;
    }
}

