/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.TimestampString;

public final class FlinkRexBuilder
extends RexBuilder {
    public FlinkRexBuilder(RelDataTypeFactory typeFactory) {
        super(typeFactory);
    }

    @Override
    public RexNode makeFieldAccess(RexNode expr, String fieldName, boolean caseSensitive) {
        RexNode field = super.makeFieldAccess(expr, fieldName, caseSensitive);
        return this.makeFieldAccess(expr, field);
    }

    @Override
    public RexNode makeFieldAccess(RexNode expr, int i) {
        RexNode field = super.makeFieldAccess(expr, i);
        return this.makeFieldAccess(expr, field);
    }

    @Override
    public RexLiteral makeZeroLiteral(RelDataType type) {
        switch (type.getSqlTypeName()) {
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return this.makeLiteral(new TimestampString(1970, 1, 1, 0, 0, 0), type);
            }
        }
        return super.makeZeroLiteral(type);
    }

    private RexNode makeFieldAccess(RexNode expr, RexNode field) {
        boolean nullabilityShouldChange;
        RexNode fieldWithRemovedCast = this.removeCastNullableFromFieldAccess(field);
        boolean bl = nullabilityShouldChange = field.getType().isNullable() != fieldWithRemovedCast.getType().isNullable() || expr.getType().isNullable() && !field.getType().isNullable();
        if (nullabilityShouldChange) {
            return this.makeCast(this.typeFactory.createTypeWithNullability(field.getType(), true), fieldWithRemovedCast, true, false);
        }
        return expr.getType().isNullable() && fieldWithRemovedCast.getType().isNullable() ? fieldWithRemovedCast : field;
    }

    private RexNode removeCastNullableFromFieldAccess(RexNode rexFieldAccess) {
        if (!(rexFieldAccess instanceof RexFieldAccess)) {
            return rexFieldAccess;
        }
        RexNode rexNode = rexFieldAccess;
        while (rexNode instanceof RexFieldAccess) {
            rexNode = ((RexFieldAccess)rexNode).getReferenceExpr();
        }
        if (rexNode.getKind() != SqlKind.CAST) {
            return rexFieldAccess;
        }
        RexShuttle visitor = new RexShuttle(){

            @Override
            public RexNode visitCall(RexCall call) {
                if (call.getKind() == SqlKind.CAST && !((RexNode)call.operands.get(0)).getType().isNullable() && call.getType().isNullable() && call.getOperands().get(0).getType().getFieldList().equals(call.getType().getFieldList())) {
                    return RexUtil.removeCast(call);
                }
                return call;
            }
        };
        return RexUtil.apply((RexVisitor)visitor, (RexNode[])new RexNode[]{rexFieldAccess})[0];
    }
}

