/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCallBinding;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.TableSemantics;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.RexTableArgCall;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.StaticArgument;
import org.apache.flink.table.types.inference.StaticArgumentTrait;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.ColumnList;

@Internal
public final class OperatorBindingCallContext
extends AbstractSqlCallContext {
    private final SqlOperatorBinding binding;
    private final List<DataType> argumentDataTypes;
    @Nullable
    private final DataType outputDataType;
    @Nullable
    private final List<Integer> inputTimeColumns;
    @Nullable
    private final List<ChangelogMode> inputChangelogModes;
    @Nullable
    private final ChangelogMode outputChangelogMode;

    public OperatorBindingCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, SqlOperatorBinding binding, RelDataType returnRelDataType) {
        this(dataTypeFactory, definition, binding, returnRelDataType, null, null, null);
    }

    public OperatorBindingCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, final SqlOperatorBinding binding, RelDataType returnRelDataType, @Nullable List<Integer> inputTimeColumns, @Nullable List<ChangelogMode> inputChangelogModes, @Nullable ChangelogMode outputChangelogMode) {
        super(dataTypeFactory, definition, binding.getOperator().getNameAsId().toString(), binding.getGroupCount() > 0);
        this.binding = binding;
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int pos) {
                LogicalType logicalType = FlinkTypeFactory.toLogicalType(binding.getOperandType(pos));
                return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
            }

            @Override
            public int size() {
                return binding.getOperandCount();
            }
        };
        this.outputDataType = returnRelDataType != null ? TypeConversions.fromLogicalToDataType((LogicalType)FlinkTypeFactory.toLogicalType(returnRelDataType)) : null;
        this.inputTimeColumns = inputTimeColumns;
        this.inputChangelogModes = inputChangelogModes;
        this.outputChangelogMode = outputChangelogMode;
    }

    public boolean isArgumentLiteral(int pos) {
        return this.binding.isOperandLiteral(pos, false) || this.isDescriptor(pos);
    }

    public boolean isArgumentNull(int pos) {
        return this.binding.isOperandNull(pos, true) || this.isDefault(pos);
    }

    public <T> Optional<T> getArgumentValue(final int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        if (this.isDescriptor(pos) && clazz == ColumnList.class) {
            return Optional.ofNullable(this.convertColumnList(pos));
        }
        try {
            return Optional.ofNullable(OperatorBindingCallContext.getLiteralValueAs(new AbstractSqlCallContext.LiteralValueAccessor(){

                public <R> R getValueAs(Class<R> clazz) {
                    return OperatorBindingCallContext.this.binding.getOperandLiteralValue(pos, clazz);
                }
            }, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public Optional<TableSemantics> getTableSemantics(int pos) {
        StaticArgument staticArg = this.getStaticArg(pos);
        if (staticArg == null || !staticArg.is(StaticArgumentTrait.TABLE)) {
            return Optional.empty();
        }
        RexTableArgCall tableArgCall = this.getTableArgCall(pos);
        if (tableArgCall == null) {
            return Optional.empty();
        }
        Integer timeColumn = Optional.ofNullable(this.inputTimeColumns).map(m3 -> (Integer)m3.get(tableArgCall.getInputIndex())).orElse(-1);
        ChangelogMode changelogMode = Optional.ofNullable(this.inputChangelogModes).map(m3 -> (ChangelogMode)m3.get(tableArgCall.getInputIndex())).orElse(null);
        return Optional.of(OperatorBindingTableSemantics.create(this.argumentDataTypes.get(pos), staticArg, tableArgCall, timeColumn, changelogMode));
    }

    public Optional<ChangelogMode> getOutputChangelogMode() {
        return Optional.ofNullable(this.outputChangelogMode);
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.ofNullable(this.outputDataType);
    }

    private boolean isDescriptor(int pos) {
        if (this.binding instanceof RexCallBinding) {
            List<RexNode> operands = ((RexCallBinding)this.binding).operands();
            RexNode operand = operands.get(pos);
            return operand.getKind() == SqlKind.DESCRIPTOR;
        }
        return false;
    }

    private boolean isDefault(int pos) {
        if (this.binding instanceof RexCallBinding) {
            List<RexNode> operands = ((RexCallBinding)this.binding).operands();
            RexNode operand = operands.get(pos);
            return operand.getKind() == SqlKind.DEFAULT;
        }
        return false;
    }

    @Nullable
    private RexTableArgCall getTableArgCall(int pos) {
        if (this.binding instanceof RexCallBinding) {
            List<RexNode> operands = ((RexCallBinding)this.binding).operands();
            RexNode operand = operands.get(pos);
            return (RexTableArgCall)operand;
        }
        return null;
    }

    private ColumnList convertColumnList(int pos) {
        if (this.binding instanceof RexCallBinding) {
            List<RexNode> operands = ((RexCallBinding)this.binding).operands();
            RexCall call = (RexCall)operands.get(pos);
            List names = call.getOperands().stream().map(RexLiteral::stringValue).collect(Collectors.toList());
            return ColumnList.of(names);
        }
        return null;
    }

    @Nullable
    private StaticArgument getStaticArg(int pos) {
        SqlOperator operator = this.binding.getOperator();
        if (!(operator instanceof BridgingSqlFunction)) {
            return null;
        }
        BridgingSqlFunction function = (BridgingSqlFunction)operator;
        return function.getTypeInference().getStaticArguments().map(args -> (StaticArgument)args.get(pos)).orElse(null);
    }

    private static class OperatorBindingTableSemantics
    implements TableSemantics {
        private final DataType dataType;
        private final int[] partitionByColumns;
        private final int timeColumn;
        @Nullable
        private final ChangelogMode changelogMode;

        public static OperatorBindingTableSemantics create(DataType tableDataType, StaticArgument staticArg, RexTableArgCall tableArgCall, int timeColumn, @Nullable ChangelogMode changelogMode) {
            OperatorBindingTableSemantics.checkNoOrderBy(tableArgCall);
            return new OperatorBindingTableSemantics(OperatorBindingTableSemantics.createDataType(tableDataType, staticArg), tableArgCall.getPartitionKeys(), timeColumn, changelogMode);
        }

        private OperatorBindingTableSemantics(DataType dataType, int[] partitionByColumns, int timeColumn, @Nullable ChangelogMode changelogMode) {
            this.dataType = dataType;
            this.partitionByColumns = partitionByColumns;
            this.timeColumn = timeColumn;
            this.changelogMode = changelogMode;
        }

        private static void checkNoOrderBy(RexTableArgCall tableArgCall) {
            if (tableArgCall.getOrderKeys().length > 0) {
                throw new ValidationException("ORDER BY clause is currently not supported.");
            }
        }

        private static DataType createDataType(DataType tableDataType, StaticArgument staticArg) {
            DataType dataType = staticArg.getDataType().orElse(null);
            if (dataType != null) {
                return dataType;
            }
            return tableDataType;
        }

        public DataType dataType() {
            return this.dataType;
        }

        public int[] partitionByColumns() {
            return this.partitionByColumns;
        }

        public int[] orderByColumns() {
            return new int[0];
        }

        public int timeColumn() {
            return this.timeColumn;
        }

        public Optional<ChangelogMode> changelogMode() {
            return Optional.ofNullable(this.changelogMode);
        }
    }
}

