/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.flink.sql.parser.ddl.position.SqlTableColumnPosition;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.planner.operations.converters.SchemaConverter;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public class SchemaAddConverter
extends SchemaConverter {
    public SchemaAddConverter(ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        super(oldTable, context);
    }

    @Override
    protected void checkAndCollectPrimaryKeyChange() {
        if (this.primaryKey != null) {
            throw new ValidationException(String.format("%sThe base table has already defined the primary key constraint %s. You might want to drop it before adding a new one.", "Failed to execute ALTER TABLE statement.\n", this.primaryKey.getColumnNames().stream().collect(Collectors.joining("`, `", "[`", "`]"))));
        }
        this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((UniqueConstraint)((UniqueConstraint)this.unwrap(schema.getPrimaryKey())))));
    }

    @Override
    protected void checkAndCollectDistributionChange(TableDistribution newDistribution) {
        if (this.distribution != null) {
            throw new ValidationException(String.format("%sThe base table has already defined the distribution `%s`. You can modify it or drop it before adding a new one.", "Failed to execute ALTER TABLE statement.\n", this.distribution));
        }
        this.changesCollector.add(TableChange.add((TableDistribution)newDistribution));
    }

    @Override
    protected void checkAndCollectWatermarkChange() {
        if (this.watermarkSpec != null) {
            throw new ValidationException(String.format("%sThe base table has already defined the watermark strategy `%s` AS %s. You might want to drop it before adding a new one.", "Failed to execute ALTER TABLE statement.\n", this.watermarkSpec.getColumnName(), ((SqlCallExpression)this.watermarkSpec.getWatermarkExpression()).getSqlExpression()));
        }
        this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((WatermarkSpec)((WatermarkSpec)schema.getWatermarkSpecs().get(0)))));
    }

    @Override
    protected void updatePositionAndCollectColumnChange(SqlTableColumnPosition columnPosition, String columnName) {
        if (this.sortedColumnNames.contains(columnName)) {
            throw new ValidationException(String.format("%sTry to add a column `%s` which already exists in the table.", "Failed to execute ALTER TABLE statement.\n", columnName));
        }
        if (columnPosition.isFirstColumn()) {
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)this.unwrap(schema.getColumn(columnName))), (TableChange.ColumnPosition)TableChange.ColumnPosition.first())));
            this.sortedColumnNames.add(0, columnName);
        } else if (columnPosition.isAfterReferencedColumn()) {
            String referenceName = this.getReferencedColumn(columnPosition);
            this.sortedColumnNames.add(this.sortedColumnNames.indexOf(referenceName) + 1, columnName);
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)this.unwrap(schema.getColumn(columnName))), (TableChange.ColumnPosition)TableChange.ColumnPosition.after((String)referenceName))));
        } else {
            this.changeBuilders.add(schema -> Collections.singletonList(TableChange.add((Column)((Column)this.unwrap(schema.getColumn(columnName))))));
            this.sortedColumnNames.add(columnName);
        }
    }
}

