/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.SqlConstraintValidator;
import org.apache.flink.sql.parser.ddl.SqlCreateMaterializedTable;
import org.apache.flink.sql.parser.ddl.SqlRefreshMode;
import org.apache.flink.sql.parser.ddl.constraint.SqlTableConstraint;
import org.apache.flink.sql.parser.error.SqlValidateException;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.materializedtable.CreateMaterializedTableOperation;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.utils.MaterializedTableUtils;
import org.apache.flink.table.planner.utils.OperationConverterUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;

public class SqlCreateMaterializedTableConverter
implements SqlNodeConverter<SqlCreateMaterializedTable> {
    @Override
    public Operation convertSqlNode(SqlCreateMaterializedTable sqlCreateMaterializedTable, SqlNodeConverter.ConvertContext context) {
        CatalogMaterializedTable.RefreshMode refreshMode;
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of((String[])sqlCreateMaterializedTable.fullTableName());
        ObjectIdentifier identifier = context.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        String tableComment = OperationConverterUtils.getComment(sqlCreateMaterializedTable.getComment());
        Map<String, String> tableOptions = OperationConverterUtils.getProperties(sqlCreateMaterializedTable.getPropertyList());
        IntervalFreshness intervalFreshness = Optional.ofNullable(sqlCreateMaterializedTable.getFreshness()).map(MaterializedTableUtils::getMaterializedTableFreshness).orElse(null);
        SqlRefreshMode sqlRefreshMode = Optional.ofNullable(sqlCreateMaterializedTable.getRefreshMode()).map(mode -> mode.getValueAs(SqlRefreshMode.class)).orElse(null);
        CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode = MaterializedTableUtils.deriveLogicalRefreshMode(sqlRefreshMode);
        CatalogMaterializedTable.RefreshMode refreshMode2 = refreshMode = sqlRefreshMode == null ? null : MaterializedTableUtils.fromSqltoRefreshMode(sqlRefreshMode);
        if (CatalogMaterializedTable.RefreshMode.FULL == refreshMode && intervalFreshness != null) {
            IntervalFreshness.validateFreshnessForCron((IntervalFreshness)intervalFreshness);
        }
        SqlNode selectQuery = sqlCreateMaterializedTable.getAsQuery();
        SqlNode validatedQuery = context.getSqlValidator().validate(selectQuery);
        String definitionQuery = context.toQuotedSqlString(validatedQuery);
        PlannerQueryOperation queryOperation = new PlannerQueryOperation(context.toRelRoot(validatedQuery).project(), () -> definitionQuery);
        ResolvedSchema resolvedSchema = queryOperation.getResolvedSchema();
        Schema.Builder builder = Schema.newBuilder().fromResolvedSchema(resolvedSchema);
        List<String> partitionKeys = OperationConverterUtils.getColumnNames(sqlCreateMaterializedTable.getPartitionKeyList());
        SqlCreateMaterializedTableConverter.verifyPartitioningColumnsExist(resolvedSchema, partitionKeys, tableOptions.keySet().stream().filter(k -> k.startsWith("partition.fields")).collect(Collectors.toSet()));
        sqlCreateMaterializedTable.getTableConstraint().ifPresent(sqlTableConstraint -> SqlCreateMaterializedTableConverter.verifyAndBuildPrimaryKey(builder, resolvedSchema, sqlTableConstraint));
        Optional<TableDistribution> tableDistribution = Optional.ofNullable(sqlCreateMaterializedTable.getDistribution()).map(OperationConverterUtils::getDistributionFromSqlDistribution);
        CatalogMaterializedTable materializedTable = CatalogMaterializedTable.newBuilder().schema(builder.build()).comment(tableComment).distribution((TableDistribution)tableDistribution.orElse(null)).partitionKeys(partitionKeys).options(tableOptions).definitionQuery(definitionQuery).freshness(intervalFreshness).logicalRefreshMode(logicalRefreshMode).refreshMode(refreshMode).refreshStatus(CatalogMaterializedTable.RefreshStatus.INITIALIZING).build();
        return new CreateMaterializedTableOperation(identifier, context.getCatalogManager().resolveCatalogMaterializedTable(materializedTable));
    }

    private static void verifyPartitioningColumnsExist(ResolvedSchema resolvedSchema, List<String> partitionKeys, Set<String> partitionFieldOptions) {
        for (String partitionKey : partitionKeys) {
            if (resolvedSchema.getColumn(partitionKey).isPresent()) continue;
            throw new ValidationException(String.format("Partition column '%s' not defined in the query schema. Available columns: [%s].", partitionKey, resolvedSchema.getColumnNames().stream().collect(Collectors.joining("', '", "'", "'"))));
        }
        for (String partitionOption : partitionFieldOptions) {
            String partitionKey = partitionOption.substring("partition.fields".length() + 1, partitionOption.length() - ("date-formatter".length() + 1));
            if (!partitionKeys.contains(partitionKey)) {
                throw new ValidationException(String.format("Column '%s' referenced by materialized table option '%s' isn't a partition column. Available partition columns: [%s].", partitionKey, partitionOption, partitionKeys.stream().collect(Collectors.joining("', '", "'", "'"))));
            }
            LogicalType partitionKeyType = ((Column)resolvedSchema.getColumn(partitionKey).get()).getDataType().getLogicalType();
            if (partitionKeyType.getTypeRoot().getFamilies().contains(LogicalTypeFamily.CHARACTER_STRING)) continue;
            throw new ValidationException(String.format("Materialized table option '%s' only supports referring to char, varchar and string type partition column. Column %s type is %s.", partitionOption, partitionKey, partitionKeyType.asSummaryString()));
        }
    }

    private static void verifyAndBuildPrimaryKey(Schema.Builder schemaBuilder, ResolvedSchema resolvedSchema, SqlTableConstraint sqlTableConstraint) {
        try {
            SqlConstraintValidator.validate(sqlTableConstraint);
        }
        catch (SqlValidateException e) {
            throw new ValidationException(String.format("Primary key validation failed: %s.", e.getMessage()), (Throwable)e);
        }
        List<String> primaryKeyColumns = Arrays.asList(sqlTableConstraint.getColumnNames());
        for (String columnName : primaryKeyColumns) {
            Optional columnOptional = resolvedSchema.getColumn(columnName);
            if (!columnOptional.isPresent()) {
                throw new ValidationException(String.format("Primary key column '%s' not defined in the query schema. Available columns: [%s].", columnName, resolvedSchema.getColumnNames().stream().collect(Collectors.joining("', '", "'", "'"))));
            }
            if (!((Column)columnOptional.get()).getDataType().getLogicalType().isNullable()) continue;
            throw new ValidationException(String.format("Could not create a PRIMARY KEY with nullable column '%s'.\nA PRIMARY KEY column must be declared on non-nullable physical columns.", columnName));
        }
        String constraintName = sqlTableConstraint.getConstraintName().orElseGet(() -> primaryKeyColumns.stream().collect(Collectors.joining("_", "PK_", "")));
        schemaBuilder.primaryKeyNamed(constraintName, primaryKeyColumns);
    }
}

