/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.flink.sql.parser.ddl.SqlAlterTableDropColumn;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.TableChange;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.planner.operations.converters.SchemaReferencesManager;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;
import org.apache.flink.table.planner.operations.converters.table.AbstractAlterTableConverter;

public class SqlAlterTableDropColumnConverter
extends AbstractAlterTableConverter<SqlAlterTableDropColumn> {
    @Override
    protected Operation convertToOperation(SqlAlterTableDropColumn dropColumn, ResolvedCatalogTable oldTable, SqlNodeConverter.ConvertContext context) {
        HashSet<String> columnsToDrop = new HashSet<String>();
        dropColumn.getColumnList().forEach((Consumer<? super SqlNode>)((Consumer<SqlNode>)identifier -> {
            String name = SqlAlterTableDropColumnConverter.getColumnName((SqlIdentifier)identifier);
            if (!columnsToDrop.add(name)) {
                throw new ValidationException(String.format("%sDuplicate column `%s`.", "Failed to execute ALTER TABLE statement.\n", name));
            }
        }));
        SchemaReferencesManager referencesManager = SchemaReferencesManager.create(oldTable);
        List sortedColumnsToDrop = columnsToDrop.stream().sorted(Comparator.comparingInt(col -> referencesManager.getColumnDependencyCount((String)col)).reversed()).collect(Collectors.toList());
        ArrayList<TableChange> tableChanges = new ArrayList<TableChange>(sortedColumnsToDrop.size());
        for (String columnToDrop : sortedColumnsToDrop) {
            referencesManager.dropColumn(columnToDrop, () -> "Failed to execute ALTER TABLE statement.\n");
            tableChanges.add((TableChange)TableChange.dropColumn((String)columnToDrop));
        }
        Schema schema = this.getUpdatedSchema((ResolvedCatalogBaseTable<?>)oldTable, (Set<String>)columnsToDrop);
        return this.buildAlterTableChangeOperation(dropColumn, tableChanges, schema, oldTable, context.getCatalogManager());
    }

    private Schema getUpdatedSchema(ResolvedCatalogBaseTable<?> oldTable, Set<String> columnsToDrop) {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        SchemaReferencesManager.buildUpdatedColumn(schemaBuilder, oldTable, (builder, column) -> {
            if (!columnsToDrop.contains(column.getName())) {
                builder.fromColumns(Collections.singletonList(column));
            }
        });
        SchemaReferencesManager.buildUpdatedPrimaryKey(schemaBuilder, oldTable, Function.identity());
        SchemaReferencesManager.buildUpdatedWatermark(schemaBuilder, oldTable);
        return schemaBuilder.build();
    }
}

