/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.calcite;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.NumberUtil;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil$;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.typeutils.RowTypeUtils;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc!B\u000b\u0017\u0003\u00039\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011)\u0019!C\u0001}!AQ\t\u0001B\u0001B\u0003%q\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0001H\u0011!Y\u0005A!A!\u0002\u0013A\u0005\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011A'\t\u0011a\u0003!\u0011!Q\u0001\n9C\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\t=\u0002\u0011\t\u0011)A\u00057\"Aq\f\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005h\u0001\t\u0005\t\u0015!\u0003b\u0011!A\u0007A!b\u0001\n\u0003I\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00026\t\u000bE\u0004A\u0011\u0001:\t\u000by\u0004A\u0011I@\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0002\u0005%\u0006t7N\u0003\u0002\u00181\u000591-\u00197dSR,'BA\r\u001b\u0003\u0015qw\u000eZ3t\u0015\tYB$\u0001\u0003qY\u0006t'BA\u000f\u001f\u0003\u001d\u0001H.\u00198oKJT!a\b\u0011\u0002\u000bQ\f'\r\\3\u000b\u0005\u0005\u0012\u0013!\u00024mS:\\'BA\u0012%\u0003\u0019\t\u0007/Y2iK*\tQ%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001QA\u0011\u0011&L\u0007\u0002U)\u00111\u0006L\u0001\u0004e\u0016d'BA\f#\u0013\tq#FA\u0005TS:<G.\u001a*fY\u000691\r\\;ti\u0016\u0014\bCA\u00194\u001b\u0005\u0011$BA\u000e-\u0013\t!$GA\u0007SK2|\u0005\u000f^\"mkN$XM]\u0001\tiJ\f\u0017\u000e^*fiB\u0011\u0011gN\u0005\u0003qI\u00121BU3m)J\f\u0017\u000e^*fi\u0006)\u0011N\u001c9viB\u0011\u0011fO\u0005\u0003y)\u0012qAU3m\u001d>$W-\u0001\u0007qCJ$\u0018\u000e^5p].+\u00170F\u0001@!\t\u00015)D\u0001B\u0015\t\u0011E&\u0001\u0003vi&d\u0017B\u0001#B\u0005=IU.\\;uC\ndWMQ5u'\u0016$\u0018!\u00049beRLG/[8o\u0017\u0016L\b%\u0001\u0005pe\u0012,'oS3z+\u0005A\u0005CA\u0015J\u0013\tQ%F\u0001\u0007SK2\u001cu\u000e\u001c7bi&|g.A\u0005pe\u0012,'oS3zA\u0005A!/\u00198l)f\u0004X-F\u0001O!\tye+D\u0001Q\u0015\t\t&+\u0001\u0003sC:\\'BA*U\u0003%y\u0007/\u001a:bi>\u00148O\u0003\u0002V=\u00059!/\u001e8uS6,\u0017BA,Q\u0005!\u0011\u0016M\\6UsB,\u0017!\u0003:b].$\u0016\u0010]3!\u0003%\u0011\u0018M\\6SC:<W-F\u0001\\!\tyE,\u0003\u0002^!\nI!+\u00198l%\u0006tw-Z\u0001\u000be\u0006t7NU1oO\u0016\u0004\u0013A\u0004:b].tU/\u001c2feRK\b/Z\u000b\u0002CB\u0011!-Z\u0007\u0002G*\u0011AMK\u0001\u0005if\u0004X-\u0003\u0002gG\n\u0001\"+\u001a7ECR\fG+\u001f9f\r&,G\u000eZ\u0001\u0010e\u0006t7NT;nE\u0016\u0014H+\u001f9fA\u0005\u0001r.\u001e;qkR\u0014\u0016M\\6Ok6\u0014WM]\u000b\u0002UB\u00111N\\\u0007\u0002Y*\tQ.A\u0003tG\u0006d\u0017-\u0003\u0002pY\n9!i\\8mK\u0006t\u0017!E8viB,HOU1oW:+XNY3sA\u00051A(\u001b8jiz\"\"b];wobL(p\u001f?~!\t!\b!D\u0001\u0017\u0011\u0015y\u0003\u00031\u00011\u0011\u0015)\u0004\u00031\u00017\u0011\u0015I\u0004\u00031\u0001;\u0011\u0015i\u0004\u00031\u0001@\u0011\u00151\u0005\u00031\u0001I\u0011\u0015a\u0005\u00031\u0001O\u0011\u0015I\u0006\u00031\u0001\\\u0011\u0015y\u0006\u00031\u0001b\u0011\u0015A\u0007\u00031\u0001k\u00035!WM]5wKJ{w\u000fV=qKR\u0011\u0011\u0011\u0001\t\u0004E\u0006\r\u0011bAA\u0003G\nY!+\u001a7ECR\fG+\u001f9f\u00031)\u0007\u0010\u001d7bS:$VM]7t)\u0011\tY!!\u0005\u0011\u0007%\ni!C\u0002\u0002\u0010)\u0012\u0011BU3m/JLG/\u001a:\t\u000f\u0005M!\u00031\u0001\u0002\f\u0005\u0011\u0001o^\u0001\u0011KN$\u0018.\\1uKJ{woQ8v]R$B!!\u0007\u0002 A\u00191.a\u0007\n\u0007\u0005uAN\u0001\u0004E_V\u0014G.\u001a\u0005\b\u0003C\u0019\u0002\u0019AA\u0012\u0003\ti\u0017\u000f\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tICK\u0001\t[\u0016$\u0018\rZ1uC&!\u0011QFA\u0014\u0005A\u0011V\r\\'fi\u0006$\u0017\r^1Rk\u0016\u0014\u00180A\bd_6\u0004X\u000f^3TK247i\\:u)\u0019\t\u0019$!\u000f\u0002BA\u0019\u0011'!\u000e\n\u0007\u0005]\"G\u0001\u0006SK2|\u0005\u000f^\"pgRDa!\b\u000bA\u0002\u0005m\u0002cA\u0019\u0002>%\u0019\u0011q\b\u001a\u0003\u001bI+Gn\u00149u!2\fgN\\3s\u0011\u001d\t\t\u0003\u0006a\u0001\u0003G\u0001")
public abstract class Rank
extends SingleRel {
    private final RelOptCluster cluster;
    private final RelNode input;
    private final ImmutableBitSet partitionKey;
    private final RelCollation orderKey;
    private final RankType rankType;
    private final RankRange rankRange;
    private final RelDataTypeField rankNumberType;
    private final boolean outputRankNumber;

    public ImmutableBitSet partitionKey() {
        return this.partitionKey;
    }

    public RelCollation orderKey() {
        return this.orderKey;
    }

    public RankType rankType() {
        return this.rankType;
    }

    public RankRange rankRange() {
        return this.rankRange;
    }

    public RelDataTypeField rankNumberType() {
        return this.rankNumberType;
    }

    public boolean outputRankNumber() {
        return this.outputRankNumber;
    }

    @Override
    public RelDataType deriveRowType() {
        String newRankNumberName;
        if (!this.outputRankNumber()) {
            return this.input.getRowType();
        }
        RelDataTypeFactory typeFactory = this.cluster.getRexBuilder().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder typeBuilder = typeFactory.builder();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.input.getRowType().getFieldList()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> typeBuilder.add((RelDataTypeField)x$1));
        String string = newRankNumberName = RowTypeUtils.getUniqueName((String)this.rankNumberType().getName(), this.input.getRowType().getFieldNames());
        String string2 = this.rankNumberType().getName();
        RelDataTypeFactory.FieldInfoBuilder fieldInfoBuilder = !(string != null ? !string.equals(string2) : string2 != null) ? typeBuilder.add(this.rankNumberType()) : typeBuilder.add(new RelDataTypeFieldImpl(newRankNumberName, this.rankNumberType().getIndex(), this.rankNumberType().getType()));
        return typeBuilder.build();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String select = ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.getRowType().getFieldNames()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                return new StringBuilder(2).append(name).append("=$").append(idx).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Buffer$.MODULE$.canBuildFrom())).mkString(", ");
        return super.explainTerms(pw).item("rankType", this.rankType()).item("rankRange", this.rankRange()).item("partitionBy", ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((Iterable)this.partitionKey()).map((Function1 & Serializable & scala.Serializable)i -> new StringBuilder(1).append("$").append(i).toString(), Iterable$.MODULE$.canBuildFrom())).mkString(",")).item("orderBy", RelExplainUtil$.MODULE$.collationToString(this.orderKey())).item("select", select);
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        Double countPerGroup = FlinkRelMdUtil$.MODULE$.getRankRangeNdv(this.rankRange());
        if (this.partitionKey().isEmpty()) {
            return Predef$.MODULE$.Double2double(countPerGroup);
        }
        Double inputRowCount = mq.getRowCount(this.input);
        Double numOfGroup = mq.getDistinctRowCount(this.input, this.partitionKey(), null);
        if (numOfGroup != null) {
            return Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(numOfGroup) * Predef$.MODULE$.Double2double(countPerGroup)), inputRowCount));
        }
        return Predef$.MODULE$.Double2double(NumberUtil.min(Predef$.MODULE$.double2Double(Predef$.MODULE$.Double2double(mq.getRowCount(this.input)) * 0.1), inputRowCount));
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double rowCount;
        Double cpuCost = rowCount = mq.getRowCount(this.input);
        return planner.getCostFactory().makeCost(Predef$.MODULE$.Double2double(rowCount), Predef$.MODULE$.Double2double(cpuCost), 0.0);
    }

    public Rank(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, ImmutableBitSet partitionKey, RelCollation orderKey, RankType rankType, RankRange rankRange, RelDataTypeField rankNumberType, boolean outputRankNumber) {
        this.cluster = cluster;
        this.input = input;
        this.partitionKey = partitionKey;
        this.orderKey = orderKey;
        this.rankType = rankType;
        this.rankRange = rankRange;
        this.rankNumberType = rankNumberType;
        this.outputRankNumber = outputRankNumber;
        super(cluster, traitSet, input);
        if (orderKey.getFieldCollations().isEmpty()) {
            throw new TableException("orderKey should not be empty.");
        }
        RankRange rankRange2 = rankRange;
        if (rankRange2 instanceof ConstantRankRange) {
            ConstantRankRange constantRankRange = (ConstantRankRange)rankRange2;
            if (constantRankRange.getRankEnd() <= 0L) {
                throw new TableException(new StringBuilder(50).append("Rank end can't smaller than zero. The rank end is ").append(constantRankRange.getRankEnd()).toString());
            }
            if (constantRankRange.getRankStart() > constantRankRange.getRankEnd()) {
                throw new TableException(new StringBuilder(45).append("Rank start '").append(constantRankRange.getRankStart()).append("' can't greater than rank end '").append(constantRankRange.getRankEnd()).append("'.").toString());
            }
        } else if (rankRange2 instanceof VariableRankRange) {
            VariableRankRange variableRankRange = (VariableRankRange)rankRange2;
            if (variableRankRange.getRankEndIndex() < 0) {
                throw new TableException("Rank end index can't smaller than zero.");
            }
            if (variableRankRange.getRankEndIndex() >= input.getRowType().getFieldCount()) {
                throw new TableException("Rank end index can't greater than input field count.");
            }
        } else {
            throw new MatchError((Object)rankRange2);
        }
    }
}

