/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DatabindContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;

@Internal
final class AggregateCallJsonDeserializer
extends StdDeserializer<AggregateCall> {
    private static final long serialVersionUID = 1L;

    AggregateCallJsonDeserializer() {
        super(AggregateCall.class);
    }

    public AggregateCall deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        SerdeContext serdeContext = SerdeContext.get((DatabindContext)ctx);
        JsonNode nameNode = jsonNode.required("name");
        String name = nameNode.getNodeType() == JsonNodeType.NULL ? null : nameNode.asText();
        SqlAggFunction aggFunction = (SqlAggFunction)RexNodeJsonDeserializer.deserializeSqlOperator(jsonNode, serdeContext);
        ArrayList<Integer> argList = new ArrayList<Integer>();
        JsonNode argListNode = jsonNode.required("argList");
        for (JsonNode argNode : argListNode) {
            argList.add(argNode.intValue());
        }
        int filterArg = jsonNode.required("filterArg").asInt();
        boolean distinct = jsonNode.required("distinct").asBoolean();
        boolean approximate = jsonNode.required("approximate").asBoolean();
        boolean ignoreNulls = jsonNode.required("ignoreNulls").asBoolean();
        RelDataType relDataType = RelDataTypeJsonDeserializer.deserialize(jsonNode.required("type"), serdeContext);
        return AggregateCall.create(aggFunction, distinct, approximate, ignoreNulls, new ArrayList<RexNode>(), argList, filterArg, null, RelCollations.EMPTY, relDataType, name);
    }
}

