/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexWindowBound;
import org.apache.flink.FlinkVersion;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.FormatFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.ObjectCodec;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JavaType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ContextResolvedModel;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.DefaultIndex;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeGraph;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.serde.AggregateCallJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.AggregateCallJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ChangelogModeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ColumnJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ColumnJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ConfigurationJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ConfigurationJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedModelJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedModelJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ContextResolvedTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.DefaultIndexMixin;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ExecNodeGraphJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ExecNodeGraphJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkVersionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.FlinkVersionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.LogicalWindowJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ObjectIdentifierJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RelDataTypeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RequiredDistributionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RequiredDistributionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogModelJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogModelJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogTableJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedCatalogTableJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedExpressionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedExpressionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedSchemaJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ResolvedSchemaJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexNodeJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.RexWindowBoundJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.table.planner.plan.nodes.exec.serde.TableDistributionJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.TableDistributionJsonSerializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.UniqueConstraintMixin;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WatermarkSpecMixin;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WindowReferenceJsonDeserializer;
import org.apache.flink.table.planner.plan.nodes.exec.serde.WindowReferenceJsonSerializer;
import org.apache.flink.table.planner.plan.utils.ExecNodeMetadataUtil;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.extraction.ExtractionUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.jackson.JacksonMapperFactory;

@Internal
public class CompiledPlanSerdeUtil {
    private static final ObjectMapper JSON_OBJECT_MAPPER_INSTANCE = JacksonMapperFactory.createObjectMapper();
    private static final ObjectMapper SMILE_OBJECT_MAPPER_INSTANCE;

    public static ObjectReader createJsonObjectReader(SerdeContext serdeContext) {
        return JSON_OBJECT_MAPPER_INSTANCE.reader().withAttribute((Object)"serdeCtx", (Object)serdeContext).with(CompiledPlanSerdeUtil.defaultInjectedValues());
    }

    public static ObjectWriter createJsonObjectWriter(SerdeContext serdeContext) {
        return JSON_OBJECT_MAPPER_INSTANCE.writer().withAttribute((Object)"serdeCtx", (Object)serdeContext);
    }

    public static ObjectWriter createSmileObjectWriter(SerdeContext serdeContext) {
        return SMILE_OBJECT_MAPPER_INSTANCE.writer().withAttribute((Object)"serdeCtx", (Object)serdeContext).with((FormatFeature)SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES);
    }

    public static ObjectReader createSmileObjectReader(SerdeContext serdeContext) {
        return SMILE_OBJECT_MAPPER_INSTANCE.reader().withAttribute((Object)"serdeCtx", (Object)serdeContext).with((FormatFeature)SmileGenerator.Feature.CHECK_SHARED_STRING_VALUES).with(CompiledPlanSerdeUtil.defaultInjectedValues());
    }

    private static InjectableValues defaultInjectedValues() {
        return new InjectableValues.Std().addValue("isDeserialize", (Object)true);
    }

    private static Module createFlinkTableJacksonModule() {
        SimpleModule module = new SimpleModule("Flink table module");
        ExecNodeMetadataUtil.execNodes().forEach(c -> module.registerSubtypes(new NamedType[]{new NamedType(c, c.getName())}));
        CompiledPlanSerdeUtil.registerSerializers(module);
        CompiledPlanSerdeUtil.registerDeserializers(module);
        CompiledPlanSerdeUtil.registerMixins(module);
        return module;
    }

    private static void registerSerializers(SimpleModule module) {
        module.addSerializer((JsonSerializer)new ExecNodeGraphJsonSerializer());
        module.addSerializer((JsonSerializer)new FlinkVersionJsonSerializer());
        module.addSerializer((JsonSerializer)new ConfigurationJsonSerializer());
        module.addSerializer((JsonSerializer)new ObjectIdentifierJsonSerializer());
        module.addSerializer((JsonSerializer)new LogicalTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new DataTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new RelDataTypeJsonSerializer());
        module.addSerializer((JsonSerializer)new RexNodeJsonSerializer());
        module.addSerializer((JsonSerializer)new AggregateCallJsonSerializer());
        module.addSerializer((JsonSerializer)new ChangelogModeJsonSerializer());
        module.addSerializer((JsonSerializer)new LogicalWindowJsonSerializer());
        module.addSerializer((JsonSerializer)new RexWindowBoundJsonSerializer());
        module.addSerializer((JsonSerializer)new WindowReferenceJsonSerializer());
        module.addSerializer((JsonSerializer)new ContextResolvedTableJsonSerializer());
        module.addSerializer((JsonSerializer)new ColumnJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedCatalogTableJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedExpressionJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedSchemaJsonSerializer());
        module.addSerializer((JsonSerializer)new RequiredDistributionJsonSerializer());
        module.addSerializer((JsonSerializer)new TableDistributionJsonSerializer());
        module.addSerializer((JsonSerializer)new ResolvedCatalogModelJsonSerializer());
        module.addSerializer((JsonSerializer)new ContextResolvedModelJsonSerializer());
    }

    private static void registerDeserializers(SimpleModule module) {
        module.addDeserializer(ExecNodeGraph.class, (JsonDeserializer)new ExecNodeGraphJsonDeserializer());
        module.addDeserializer(FlinkVersion.class, (JsonDeserializer)new FlinkVersionJsonDeserializer());
        module.addDeserializer(ReadableConfig.class, (JsonDeserializer)new ConfigurationJsonDeserializer());
        module.addDeserializer(ObjectIdentifier.class, (JsonDeserializer)new ObjectIdentifierJsonDeserializer());
        module.addDeserializer(LogicalType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addDeserializer(RowType.class, (JsonDeserializer)new LogicalTypeJsonDeserializer());
        module.addDeserializer(DataType.class, (JsonDeserializer)new DataTypeJsonDeserializer());
        module.addDeserializer(RelDataType.class, (JsonDeserializer)new RelDataTypeJsonDeserializer());
        module.addDeserializer(RexNode.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(RexLiteral.class, (JsonDeserializer)new RexNodeJsonDeserializer());
        module.addDeserializer(AggregateCall.class, (JsonDeserializer)new AggregateCallJsonDeserializer());
        module.addDeserializer(ChangelogMode.class, (JsonDeserializer)new ChangelogModeJsonDeserializer());
        module.addDeserializer(LogicalWindow.class, (JsonDeserializer)new LogicalWindowJsonDeserializer());
        module.addDeserializer(RexWindowBound.class, (JsonDeserializer)new RexWindowBoundJsonDeserializer());
        module.addDeserializer(WindowReference.class, (JsonDeserializer)new WindowReferenceJsonDeserializer());
        module.addDeserializer(ContextResolvedTable.class, (JsonDeserializer)new ContextResolvedTableJsonDeserializer());
        module.addDeserializer(Column.class, (JsonDeserializer)new ColumnJsonDeserializer());
        module.addDeserializer(ResolvedCatalogTable.class, (JsonDeserializer)new ResolvedCatalogTableJsonDeserializer());
        module.addDeserializer(ResolvedExpression.class, (JsonDeserializer)new ResolvedExpressionJsonDeserializer());
        module.addDeserializer(ResolvedSchema.class, (JsonDeserializer)new ResolvedSchemaJsonDeserializer());
        module.addDeserializer(InputProperty.RequiredDistribution.class, (JsonDeserializer)new RequiredDistributionJsonDeserializer());
        module.addDeserializer(TableDistribution.class, (JsonDeserializer)new TableDistributionJsonDeserializer());
        module.addDeserializer(ContextResolvedModel.class, (JsonDeserializer)new ContextResolvedModelJsonDeserializer());
        module.addDeserializer(ResolvedCatalogModel.class, (JsonDeserializer)new ResolvedCatalogModelJsonDeserializer());
    }

    private static void registerMixins(SimpleModule module) {
        module.setMixInAnnotation(WatermarkSpec.class, WatermarkSpecMixin.class);
        module.setMixInAnnotation(UniqueConstraint.class, UniqueConstraintMixin.class);
        module.setMixInAnnotation(DefaultIndex.class, DefaultIndexMixin.class);
    }

    static JsonParser traverse(TreeNode node, ObjectCodec objectCodec) throws IOException {
        JsonParser jsonParser = node.traverse(objectCodec);
        if (!node.isMissingNode() && jsonParser.getCurrentToken() == null) {
            jsonParser.nextToken();
        }
        return jsonParser;
    }

    static void serializeOptionalField(JsonGenerator jsonGenerator, String fieldName, Optional<?> value, SerializerProvider serializerProvider) throws IOException {
        if (value.isPresent()) {
            serializerProvider.defaultSerializeField(fieldName, value.get(), jsonGenerator);
        }
    }

    static void serializeListIfNotEmpty(JsonGenerator jsonGenerator, String fieldName, List<?> value, SerializerProvider serializerProvider) throws IOException {
        if (!value.isEmpty()) {
            serializerProvider.defaultSerializeField(fieldName, value, jsonGenerator);
        }
    }

    static <T> Optional<T> deserializeOptionalField(ObjectNode objectNode, String fieldName, Class<T> clazz, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return Optional.ofNullable(ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), clazz));
        }
        return Optional.empty();
    }

    static <T> List<T> deserializeList(ObjectNode objectNode, String fieldName, Class<? extends T> type, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        return (List)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.required(fieldName), codec), (JavaType)ctx.getTypeFactory().constructCollectionType(List.class, type));
    }

    static <T> List<T> deserializeListOrEmpty(ObjectNode objectNode, String fieldName, Class<? extends T> type, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return CompiledPlanSerdeUtil.deserializeList(objectNode, fieldName, type, codec, ctx);
        }
        return List.of();
    }

    static <K, V> Map<K, V> deserializeMapOrEmpty(ObjectNode objectNode, String fieldName, Class<? extends K> keyType, Class<? extends V> valueType, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return (Map)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), (JavaType)ctx.getTypeFactory().constructMapType(Map.class, keyType, valueType));
        }
        return Map.of();
    }

    static <T> Optional<T> deserializeOptionalField(ObjectNode objectNode, String fieldName, JavaType type, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return Optional.of(ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), type));
        }
        return Optional.empty();
    }

    @Nullable
    static <T> T deserializeFieldOrNull(ObjectNode objectNode, String fieldName, Class<T> type, ObjectCodec codec, DeserializationContext ctx) throws IOException {
        if (objectNode.hasNonNull(fieldName)) {
            return (T)ctx.readValue(CompiledPlanSerdeUtil.traverse((TreeNode)objectNode.get(fieldName), codec), type);
        }
        return null;
    }

    static boolean areColumnsEqual(ResolvedSchema schemaFromPlan, ResolvedSchema schemaFromCatalog) {
        List columnsFromPlan = schemaFromPlan.getColumns();
        List columnsFromCatalog = schemaFromCatalog.getColumns();
        if (columnsFromPlan.size() != columnsFromCatalog.size()) {
            return false;
        }
        for (int i = 0; i < columnsFromPlan.size(); ++i) {
            Column columnFromPlan = (Column)columnsFromPlan.get(i);
            Column columnFromCatalog = (Column)columnsFromCatalog.get(i);
            if (Objects.equals(columnFromPlan.getName(), columnFromCatalog.getName()) && Objects.equals(columnFromPlan.getClass(), columnFromCatalog.getClass()) && Objects.equals(columnFromPlan.getDataType(), columnFromCatalog.getDataType())) continue;
            return false;
        }
        return true;
    }

    static boolean isLookupForced(TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        return planRestoreOption == TableConfigOptions.CatalogPlanRestore.IDENTIFIER;
    }

    static boolean isPlanEnforced(TableConfigOptions.CatalogPlanRestore planRestoreOption) {
        return planRestoreOption == TableConfigOptions.CatalogPlanRestore.ALL_ENFORCED;
    }

    static Class<?> loadClass(String className, SerdeContext serdeContext, String explanation) {
        try {
            return ExtractionUtils.classForName((String)className, (boolean)true, (ClassLoader)serdeContext.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TableException(String.format("Could not load class '%s' for %s.", className, explanation), (Throwable)e);
        }
    }

    private CompiledPlanSerdeUtil() {
    }

    static {
        JSON_OBJECT_MAPPER_INSTANCE.setTypeFactory(JSON_OBJECT_MAPPER_INSTANCE.getTypeFactory().withClassLoader(CompiledPlanSerdeUtil.class.getClassLoader())).disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS}).enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS).registerModule(CompiledPlanSerdeUtil.createFlinkTableJacksonModule());
        SMILE_OBJECT_MAPPER_INSTANCE = JacksonMapperFactory.createObjectMapper((JsonFactory)new SmileFactory());
        SMILE_OBJECT_MAPPER_INSTANCE.setTypeFactory(SMILE_OBJECT_MAPPER_INSTANCE.getTypeFactory().withClassLoader(CompiledPlanSerdeUtil.class.getClassLoader())).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(new MapperFeature[]{MapperFeature.USE_GETTERS_AS_SETTERS}).registerModule(CompiledPlanSerdeUtil.createFlinkTableJacksonModule());
    }
}

