/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.VectorSearchTableSource;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilityContext;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSpecBase;
import org.apache.flink.table.types.logical.RowType;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DynamicTableSourceSpec
extends DynamicTableSpecBase {
    public static final String FIELD_NAME_CATALOG_TABLE = "table";
    public static final String FIELD_NAME_SOURCE_ABILITIES = "abilities";
    private final ContextResolvedTable contextResolvedTable;
    @Nullable
    private final List<SourceAbilitySpec> sourceAbilities;
    private DynamicTableSource tableSource;

    @JsonCreator
    public DynamicTableSourceSpec(@JsonProperty(value="table") ContextResolvedTable contextResolvedTable, @Nullable @JsonProperty(value="abilities") List<SourceAbilitySpec> sourceAbilities) {
        this.contextResolvedTable = contextResolvedTable;
        this.sourceAbilities = sourceAbilities;
    }

    private DynamicTableSource getTableSource(FlinkContext context, FlinkTypeFactory typeFactory) {
        if (this.tableSource == null) {
            DynamicTableSourceFactory factory = context.getModuleManager().getFactory(Module::getTableSourceFactory).orElse(null);
            if (factory == null) {
                Catalog catalog = context.getCatalogManager().getCatalog(this.contextResolvedTable.getIdentifier().getCatalogName()).orElse(null);
                factory = FactoryUtil.getDynamicTableFactory(DynamicTableSourceFactory.class, (Catalog)catalog).orElse(null);
            }
            this.tableSource = FactoryUtil.createDynamicTableSource((DynamicTableSourceFactory)factory, (ObjectIdentifier)this.contextResolvedTable.getIdentifier(), (ResolvedCatalogTable)((ResolvedCatalogTable)this.contextResolvedTable.getResolvedTable()), this.loadOptionsFromCatalogTable(this.contextResolvedTable, context), (ReadableConfig)context.getTableConfig(), (ClassLoader)context.getClassLoader(), (boolean)this.contextResolvedTable.isTemporary());
            if (this.sourceAbilities != null) {
                RowType newProducedType = (RowType)this.contextResolvedTable.getResolvedSchema().toPhysicalRowDataType().getLogicalType();
                for (SourceAbilitySpec spec : this.sourceAbilities) {
                    SourceAbilityContext sourceAbilityContext = new SourceAbilityContext(context, typeFactory, newProducedType);
                    spec.apply(this.tableSource, sourceAbilityContext);
                    if (!spec.getProducedType().isPresent()) continue;
                    newProducedType = spec.getProducedType().get();
                }
            }
        }
        return this.tableSource;
    }

    public ScanTableSource getScanTableSource(FlinkContext context, FlinkTypeFactory typeFactory) {
        DynamicTableSource tableSource = this.getTableSource(context, typeFactory);
        if (tableSource instanceof ScanTableSource) {
            return (ScanTableSource)tableSource;
        }
        throw new TableException(String.format("%s is not a ScanTableSource.\nPlease check it.", tableSource.getClass().getName()));
    }

    public LookupTableSource getLookupTableSource(FlinkContext context, FlinkTypeFactory typeFactory) {
        DynamicTableSource tableSource = this.getTableSource(context, typeFactory);
        if (tableSource instanceof LookupTableSource) {
            return (LookupTableSource)tableSource;
        }
        throw new TableException(String.format("%s is not a LookupTableSource.\nPlease check it.", tableSource.getClass().getName()));
    }

    public VectorSearchTableSource getVectorSearchTableSource(FlinkContext context, FlinkTypeFactory typeFactory) {
        DynamicTableSource tableSource = this.getTableSource(context, typeFactory);
        if (tableSource instanceof VectorSearchTableSource) {
            return (VectorSearchTableSource)tableSource;
        }
        throw new TableException(String.format("%s is not a VectorSearchTableSource.\nPlease check it.", tableSource.getClass().getName()));
    }

    @JsonGetter(value="table")
    public ContextResolvedTable getContextResolvedTable() {
        return this.contextResolvedTable;
    }

    @JsonGetter(value="abilities")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    public List<SourceAbilitySpec> getSourceAbilities() {
        return this.sourceAbilities;
    }

    public void setTableSource(DynamicTableSource tableSource) {
        this.tableSource = tableSource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicTableSourceSpec that = (DynamicTableSourceSpec)o;
        return Objects.equals(this.contextResolvedTable, that.contextResolvedTable) && Objects.equals(this.sourceAbilities, that.sourceAbilities) && Objects.equals(this.tableSource, that.tableSource);
    }

    public int hashCode() {
        return Objects.hash(this.contextResolvedTable, this.sourceAbilities, this.tableSource);
    }

    public String toString() {
        return "DynamicTableSourceSpec{contextResolvedTable=" + String.valueOf(this.contextResolvedTable) + ", sourceAbilities=" + String.valueOf(this.sourceAbilities) + ", tableSource=" + String.valueOf(this.tableSource) + "}";
    }
}

