/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.streaming.api.TimeDomain;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.EqualiserCodeGenerator;
import org.apache.flink.table.planner.codegen.HashCodeGenerator;
import org.apache.flink.table.planner.connectors.CollectDynamicSink;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.StateMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.common.CommonExecSink;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSinkSpec;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.runtime.generated.GeneratedHashFunction;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.sink.SinkUpsertMaterializer;
import org.apache.flink.table.runtime.operators.sink.SinkUpsertMaterializerV2;
import org.apache.flink.table.runtime.sequencedmultisetstate.SequencedMultiSetStateConfig;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.typeutils.RowTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExecNodeMetadata(name="stream-exec-sink", version=1, consumedOptions={"table.exec.sink.not-null-enforcer", "table.exec.sink.type-length-enforcer", "table.exec.sink.upsert-materialize", "table.exec.sink.keyed-shuffle", "table.exec.sink.rowtime-inserter"}, producedTransformations={"constraint-validator", "partitioner", "upsert-materialize", "timestamp-inserter", "sink"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecSink
extends CommonExecSink
implements StreamExecNode<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(StreamExecSink.class);
    public static final String FIELD_NAME_INPUT_CHANGELOG_MODE = "inputChangelogMode";
    public static final String FIELD_NAME_REQUIRE_UPSERT_MATERIALIZE = "requireUpsertMaterialize";
    public static final String FIELD_NAME_UPSERT_MATERIALIZE_STRATEGY = "upsertMaterializeStrategy";
    public static final String FIELD_NAME_INPUT_UPSERT_KEY = "inputUpsertKey";
    public static final String STATE_NAME = "sinkMaterializeState";
    @JsonProperty(value="inputChangelogMode")
    private final ChangelogMode inputChangelogMode;
    @JsonProperty(value="requireUpsertMaterialize")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean upsertMaterialize;
    @JsonProperty(value="upsertMaterializeStrategy")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final ExecutionConfigOptions.SinkUpsertMaterializeStrategy upsertMaterializeStrategy;
    @JsonProperty(value="inputUpsertKey")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final int[] inputUpsertKey;
    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<StateMetadata> stateMetadataList;

    public StreamExecSink(ReadableConfig tableConfig, DynamicTableSinkSpec tableSinkSpec, ChangelogMode inputChangelogMode, InputProperty inputProperty, LogicalType outputType, boolean upsertMaterialize, ExecutionConfigOptions.SinkUpsertMaterializeStrategy upsertMaterializeStrategy, int[] inputUpsertKey, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecSink.class), ExecNodeContext.newPersistedConfig(StreamExecSink.class, tableConfig), tableSinkSpec, inputChangelogMode, upsertMaterialize, upsertMaterializeStrategy, upsertMaterialize ? StateMetadata.getOneInputOperatorDefaultMeta(tableConfig, STATE_NAME) : null, inputUpsertKey, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecSink(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="dynamicTableSink") DynamicTableSinkSpec tableSinkSpec, @JsonProperty(value="inputChangelogMode") ChangelogMode inputChangelogMode, @JsonProperty(value="requireUpsertMaterialize") boolean upsertMaterialize, @Nullable @JsonProperty(value="upsertMaterializeStrategy") ExecutionConfigOptions.SinkUpsertMaterializeStrategy sinkUpsertMaterializeStrategy, @Nullable @JsonProperty(value="state") List<StateMetadata> stateMetadataList, @JsonProperty(value="inputUpsertKey") int[] inputUpsertKey, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") LogicalType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, tableSinkSpec, inputChangelogMode, false, inputProperties, outputType, description);
        this.inputChangelogMode = inputChangelogMode;
        this.upsertMaterialize = upsertMaterialize;
        this.inputUpsertKey = inputUpsertKey;
        this.stateMetadataList = stateMetadataList;
        this.upsertMaterializeStrategy = sinkUpsertMaterializeStrategy;
    }

    @Override
    protected Transformation<Object> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        int rowtimeFieldIndex;
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        DynamicTableSink tableSink = this.tableSinkSpec.getTableSink(planner.getFlinkContext());
        boolean isCollectSink = tableSink instanceof CollectDynamicSink;
        boolean isDisabled = config.get(ExecutionConfigOptions.TABLE_EXEC_SINK_ROWTIME_INSERTER) == ExecutionConfigOptions.RowtimeInserter.DISABLED;
        ArrayList<Integer> rowtimeFieldIndices = new ArrayList<Integer>();
        for (int i2 = 0; i2 < inputRowType.getFieldCount(); ++i2) {
            if (!TypeCheckUtils.isRowTime((LogicalType)inputRowType.getTypeAt(i2))) continue;
            rowtimeFieldIndices.add(i2);
        }
        if (isCollectSink || isDisabled) {
            rowtimeFieldIndex = -1;
        } else {
            if (rowtimeFieldIndices.size() > 1) {
                throw new TableException(String.format("The query contains more than one rowtime attribute column [%s] for writing into table '%s'.\nPlease select the column that should be used as the event-time timestamp for the table sink by casting all other columns to regular TIMESTAMP or TIMESTAMP_LTZ.", rowtimeFieldIndices.stream().map(i -> (String)inputRowType.getFieldNames().get((int)i)).collect(Collectors.joining(", ")), this.tableSinkSpec.getContextResolvedTable().getIdentifier().asSummaryString()));
            }
            rowtimeFieldIndex = rowtimeFieldIndices.size() == 1 ? (Integer)rowtimeFieldIndices.get(0) : -1;
        }
        return this.createSinkTransformation(planner.getExecEnv(), config, planner.getFlinkContext().getClassLoader(), inputTransform, tableSink, rowtimeFieldIndex, this.upsertMaterialize, this.inputUpsertKey);
    }

    @Override
    protected Transformation<RowData> applyUpsertMaterialize(Transformation<RowData> inputTransform, int[] primaryKeys, int sinkParallelism, ExecNodeConfig config, ClassLoader classLoader, RowType physicalRowType, int[] inputUpsertKey) {
        GeneratedRecordEqualiser rowEqualiser = new EqualiserCodeGenerator((LogicalType)physicalRowType, classLoader).generateRecordEqualiser("SinkMaterializeEqualiser");
        GeneratedRecordEqualiser upsertKeyEqualiser = inputUpsertKey == null ? null : new EqualiserCodeGenerator((LogicalType)RowTypeUtils.projectRowType((RowType)physicalRowType, (int[])inputUpsertKey), classLoader).generateRecordEqualiser("SinkMaterializeUpsertKeyEqualiser");
        GeneratedHashFunction rowHashFunction = HashCodeGenerator.generateRowHash(new CodeGeneratorContext(config, classLoader), (LogicalType)physicalRowType, "hashCode", IntStream.range(0, physicalRowType.getFieldCount()).toArray());
        GeneratedHashFunction upsertKeyHashFunction = inputUpsertKey == null ? null : HashCodeGenerator.generateRowHash(new CodeGeneratorContext(config, classLoader), (LogicalType)RowTypeUtils.projectRowType((RowType)physicalRowType, (int[])inputUpsertKey), "generated_hashcode_for_" + inputUpsertKey.length + "_keys", IntStream.range(0, inputUpsertKey.length).toArray());
        StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig((long)StateMetadata.getStateTtlForOneInputOperator(config, this.stateMetadataList));
        OneInputStreamOperator<RowData, RowData> operator = this.createSumOperator(config, physicalRowType, inputUpsertKey, upsertKeyEqualiser, upsertKeyHashFunction, ttlConfig, rowEqualiser, rowHashFunction);
        String[] fieldNames = physicalRowType.getFieldNames().toArray(new String[0]);
        List pkFieldNames = Arrays.stream(primaryKeys).mapToObj(idx -> fieldNames[idx]).collect(Collectors.toList());
        OneInputTransformation materializeTransform = ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta("upsert-materialize", String.format("SinkMaterializer(pk=[%s])", String.join((CharSequence)", ", pkFieldNames)), "SinkMaterializer", config), operator, inputTransform.getOutputType(), sinkParallelism, this.sinkParallelismConfigured);
        RowDataKeySelector keySelector = KeySelectorUtil.getRowDataSelector(classLoader, primaryKeys, (InternalTypeInfo<RowData>)InternalTypeInfo.of((RowType)physicalRowType));
        materializeTransform.setStateKeySelector((KeySelector)keySelector);
        materializeTransform.setStateKeyType((TypeInformation)keySelector.getProducedType());
        return materializeTransform;
    }

    private OneInputStreamOperator<RowData, RowData> createSumOperator(ExecNodeConfig config, RowType physicalRowType, int[] inputUpsertKey, GeneratedRecordEqualiser upsertKeyEqualiser, GeneratedHashFunction upsertKeyHashFunction, StateTtlConfig ttlConfig, GeneratedRecordEqualiser rowEqualiser, GeneratedHashFunction rowHashFunction) {
        ExecutionConfigOptions.SinkUpsertMaterializeStrategy sinkUpsertMaterializeStrategy = Optional.ofNullable(this.upsertMaterializeStrategy).orElse(ExecutionConfigOptions.SinkUpsertMaterializeStrategy.LEGACY);
        return sinkUpsertMaterializeStrategy == ExecutionConfigOptions.SinkUpsertMaterializeStrategy.LEGACY ? SinkUpsertMaterializer.create((StateTtlConfig)ttlConfig, (RowType)physicalRowType, (GeneratedRecordEqualiser)rowEqualiser, (GeneratedRecordEqualiser)upsertKeyEqualiser, (int[])inputUpsertKey) : SinkUpsertMaterializerV2.create((RowType)physicalRowType, (GeneratedRecordEqualiser)rowEqualiser, (GeneratedRecordEqualiser)upsertKeyEqualiser, (GeneratedHashFunction)rowHashFunction, (GeneratedHashFunction)upsertKeyHashFunction, (int[])inputUpsertKey, (SequencedMultiSetStateConfig)StreamExecSink.createStateConfig(sinkUpsertMaterializeStrategy, TimeDomain.EVENT_TIME, ttlConfig, config));
    }

    private static SequencedMultiSetStateConfig createStateConfig(ExecutionConfigOptions.SinkUpsertMaterializeStrategy strategy, TimeDomain ttlTimeDomain, StateTtlConfig ttlConfig, ReadableConfig config) {
        if (ttlConfig.isEnabled()) {
            LOG.warn("TTL is not supported and will be disabled: {}", (Object)ttlConfig);
            ttlConfig = StateTtlConfig.DISABLED;
        }
        switch (strategy) {
            case VALUE: {
                return SequencedMultiSetStateConfig.forValue((TimeDomain)ttlTimeDomain, (StateTtlConfig)ttlConfig);
            }
            case MAP: {
                return SequencedMultiSetStateConfig.forMap((TimeDomain)ttlTimeDomain, (StateTtlConfig)ttlConfig);
            }
            case ADAPTIVE: {
                return SequencedMultiSetStateConfig.adaptive((TimeDomain)ttlTimeDomain, (Long)((Long)config.get(ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE_ADAPTIVE_THRESHOLD_HIGH)), (Long)((Long)config.get(ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE_ADAPTIVE_THRESHOLD_LOW)), (StateTtlConfig)ttlConfig);
            }
        }
        throw new IllegalArgumentException("Unsupported strategy: " + String.valueOf(strategy));
    }
}

