/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.common;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.FlinkRelNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.physical.FlinkPhysicalRel;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua!\u0002\u0006\f\u0003\u0003q\u0002\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u0011M\u0002!\u0011!Q\u0001\nQB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\")\u0001\n\u0001C!\u0013\")\u0011\f\u0001C!5\")\u0001\r\u0001C\u0005C\")q\u000e\u0001C\ta\n12i\\7n_:\u0004\u0006._:jG\u0006dW\t_2iC:<WM\u0003\u0002\r\u001b\u000511m\\7n_:T!AD\b\u0002\u0011AD\u0017p]5dC2T!\u0001E\t\u0002\u000b9|G-Z:\u000b\u0005I\u0019\u0012\u0001\u00029mC:T!\u0001F\u000b\u0002\u000fAd\u0017M\u001c8fe*\u0011acF\u0001\u0006i\u0006\u0014G.\u001a\u0006\u00031e\tQA\u001a7j].T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u00011c\u0001\u0001 SA\u0011\u0001eJ\u0007\u0002C)\u0011!eI\u0001\u0005G>\u0014XM\u0003\u0002%K\u0005\u0019!/\u001a7\u000b\u0005\u0019J\u0012aB2bY\u000eLG/Z\u0005\u0003Q\u0005\u0012\u0001\"\u0012=dQ\u0006tw-\u001a\t\u0003U-j\u0011!D\u0005\u0003Y5\u0011\u0001C\u00127j].\u0004\u0006._:jG\u0006d'+\u001a7\u0002\u000f\rdWo\u001d;feB\u0011q&M\u0007\u0002a)\u0011!#J\u0005\u0003eA\u0012QBU3m\u001fB$8\t\\;ti\u0016\u0014\u0018\u0001\u0003;sC&$8+\u001a;\u0011\u0005=*\u0014B\u0001\u001c1\u0005-\u0011V\r\u001c+sC&$8+\u001a;\u0002\u0011%t\u0007/\u001e;SK2\u0004\"!\u000f\u001e\u000e\u0003\rJ!aO\u0012\u0003\u000fI+GNT8eK\u0006y!/\u001a7ESN$(/\u001b2vi&|g\u000e\u0005\u0002:}%\u0011qh\t\u0002\u0010%\u0016dG)[:ue&\u0014W\u000f^5p]\u00061A(\u001b8jiz\"RA\u0011#F\r\u001e\u0003\"a\u0011\u0001\u000e\u0003-AQ!L\u0003A\u00029BQaM\u0003A\u0002QBQaN\u0003A\u0002aBQ\u0001P\u0003A\u0002u\nqbY8naV$XmU3mM\u000e{7\u000f\u001e\u000b\u0004\u00156\u000b\u0006CA\u0018L\u0013\ta\u0005G\u0001\u0006SK2|\u0005\u000f^\"pgRDQ\u0001\u0006\u0004A\u00029\u0003\"aL(\n\u0005A\u0003$!\u0004*fY>\u0003H\u000f\u00157b]:,'\u000fC\u0003S\r\u0001\u00071+\u0001\u0002ncB\u0011AkV\u0007\u0002+*\u0011akI\u0001\t[\u0016$\u0018\rZ1uC&\u0011\u0001,\u0016\u0002\u0011%\u0016dW*\u001a;bI\u0006$\u0018-U;fef\fA\"\u001a=qY\u0006Lg\u000eV3s[N$\"a\u00170\u0011\u0005eb\u0016BA/$\u0005%\u0011V\r\\,sSR,'\u000fC\u0003`\u000f\u0001\u00071,\u0001\u0002qo\u0006!B-[:ue&\u0014W\u000f^5p]R{7\u000b\u001e:j]\u001e$\u0012A\u0019\t\u0003G2t!\u0001\u001a6\u0011\u0005\u0015DW\"\u00014\u000b\u0005\u001dl\u0012A\u0002\u001fs_>$hHC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007.\u0001\u0004Qe\u0016$WMZ\u0005\u0003[:\u0014aa\u0015;sS:<'BA6i\u0003]9W\r\u001e*fcVL'/\u001a3ESN$(/\u001b2vi&|g.F\u0001r!\r\u0011\u0018q\u0002\b\u0004g\u0006%ab\u0001;\u0002\u00069\u0019Q/a\u0001\u000f\u0007Y\f\tA\u0004\u0002x\u007f:\u0011\u0001P \b\u0003svt!A\u001f?\u000f\u0005\u0015\\\u0018\"\u0001\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002\u0015+%\u0011!cE\u0005\u0003!EI1!a\u0002\u0010\u0003\u0011)\u00070Z2\n\t\u0005-\u0011QB\u0001\u000e\u0013:\u0004X\u000f\u001e)s_B,'\u000f^=\u000b\u0007\u0005\u001dq\"\u0003\u0003\u0002\u0012\u0005M!\u0001\u0006*fcVL'/\u001a3ESN$(/\u001b2vi&|gN\u0003\u0003\u0002\f\u00055\u0001")
public abstract class CommonPhysicalExchange
extends Exchange
implements FlinkPhysicalRel {
    private final RelDistribution relDistribution;

    @Override
    public Option<RelNode> satisfyTraits(RelTraitSet requiredTraitSet) {
        return FlinkPhysicalRel.satisfyTraits$(this, requiredTraitSet);
    }

    @Override
    public ExecNode<?> translateToExecNode(boolean isCompiled) {
        return FlinkPhysicalRel.translateToExecNode$(this, isCompiled);
    }

    @Override
    public String getRelDetailedDescription() {
        return FlinkRelNode.getRelDetailedDescription$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionDetail);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, sqlExplainLevel);
    }

    @Override
    public String getExpressionString(RexNode expr, List<String> inFields, Option<List<RexNode>> localExprsTable, Enumeration.Value expressionFormat, Enumeration.Value expressionDetail) {
        return FlinkRelNode.getExpressionString$((FlinkRelNode)this, expr, inFields, localExprsTable, expressionFormat, expressionDetail);
    }

    @Override
    public Enumeration.Value convertToExpressionDetail(SqlExplainLevel sqlExplainLevel) {
        return FlinkRelNode.convertToExpressionDetail$(this, sqlExplainLevel);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        Double inputRows = mq.getRowCount(this.input);
        if (inputRows == null) {
            return null;
        }
        double inputSize = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this.input)) * Predef$.MODULE$.Double2double(inputRows);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        RelDistribution.Type type = this.relDistribution.getType();
        if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.SINGLETON_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        }
        if (((Object)((Object)RelDistribution.Type.RANDOM_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANDOM_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        }
        if (((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.RANGE_PARTITION_CPU_COST() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            double diskIoCost = inputSize;
            double networkCost = (double)2 * inputSize;
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, diskIoCost, networkCost, 0.0);
        }
        if (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) {
            int nParallelism = Math.max(1, (int)(inputSize / (double)FlinkCost$.MODULE$.SQL_DEFAULT_PARALLELISM_WORKER_PROCESS_SIZE()));
            double cpuCost = (double)nParallelism * Predef$.MODULE$.Double2double(inputRows) * (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST();
            double networkCost = (double)nParallelism * inputSize;
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, networkCost, 0.0);
        }
        if (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) {
            double cpuCost = (double)(FlinkCost$.MODULE$.HASH_CPU_COST() * this.relDistribution.getKeys().size() + FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST()) * Predef$.MODULE$.Double2double(inputRows);
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), cpuCost, 0.0, inputSize, 0.0);
        }
        if (((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) {
            return costFactory.makeCost(Predef$.MODULE$.Double2double(inputRows), (double)FlinkCost$.MODULE$.SERIALIZE_DESERIALIZE_CPU_COST() * Predef$.MODULE$.Double2double(inputRows), 0.0, inputSize, 0.0);
        }
        throw new UnsupportedOperationException(new StringBuilder(34).append("not support RelDistribution: ").append((Object)this.relDistribution.getType()).append(" now!").toString());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("distribution", this.distributionToString());
    }

    private String distributionToString() {
        java.util.List fieldNames;
        FlinkRelDistribution flinkRelDistribution = (FlinkRelDistribution)this.relDistribution;
        java.util.List<String> inputFieldNames = this.getInput().getRowType().getFieldNames();
        String exchangeName = this.relDistribution.getType().shortName;
        RelDistribution.Type type = this.relDistribution.getType();
        java.util.List list = fieldNames = ((Object)((Object)RelDistribution.Type.RANGE_DISTRIBUTED)).equals((Object)type) ? (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getFieldCollations().get()).asScala()).map((Function1 & Serializable & scala.Serializable)fieldCollation -> {
            String name = (String)inputFieldNames.get(fieldCollation.getFieldIndex());
            return new StringBuilder(1).append(name).append(" ").append(fieldCollation.getDirection().shortString).toString();
        }, Buffer$.MODULE$.canBuildFrom())).asJava() : (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)flinkRelDistribution.getKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)inputFieldNames.get(Predef$.MODULE$.Integer2int(x$1)), Buffer$.MODULE$.canBuildFrom())).asJava();
        if (fieldNames.isEmpty()) {
            return exchangeName;
        }
        return new StringBuilder(0).append(exchangeName).append(fieldNames).toString();
    }

    public InputProperty.RequiredDistribution getRequiredDistribution() {
        RelDistribution.Type type = this.relDistribution.getType();
        if (((Object)((Object)RelDistribution.Type.ANY)).equals((Object)type)) {
            return InputProperty.ANY_DISTRIBUTION;
        }
        if (((Object)((Object)RelDistribution.Type.BROADCAST_DISTRIBUTED)).equals((Object)type)) {
            return InputProperty.BROADCAST_DISTRIBUTION;
        }
        if (((Object)((Object)RelDistribution.Type.SINGLETON)).equals((Object)type)) {
            return InputProperty.SINGLETON_DISTRIBUTION;
        }
        if (((Object)((Object)RelDistribution.Type.HASH_DISTRIBUTED)).equals((Object)type)) {
            int[] keys = (int[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.relDistribution.getKeys()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
            if (new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(keys)).isEmpty()) {
                return InputProperty.SINGLETON_DISTRIBUTION;
            }
            return InputProperty.hashDistribution(keys);
        }
        throw new TableException(new StringBuilder(31).append("Unsupported distribution type: ").append((Object)this.relDistribution.getType()).toString());
    }

    public CommonPhysicalExchange(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDistribution relDistribution) {
        this.relDistribution = relDistribution;
        super(cluster, traitSet, inputRel, relDistribution);
        FlinkRelNode.$init$(this);
        FlinkPhysicalRel.$init$(this);
    }
}

