/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.optimize;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.planner.connectors.DynamicSourceUtils;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalCalcBase;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalChangelogNormalize;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalWatermarkAssigner;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.trait.UpdateKindTrait$;
import org.apache.flink.table.planner.plan.trait.UpdateKindTraitDef$;
import org.apache.flink.table.planner.plan.utils.FlinkRelUtil;
import org.apache.flink.table.planner.utils.ShortcutUtils;

public class ChangelogNormalizeRequirementResolver {
    public static boolean isRequired(StreamPhysicalChangelogNormalize normalize) {
        if (normalize.filterCondition() != null) {
            return true;
        }
        if (!Objects.equals(normalize.getTraitSet().getTrait(UpdateKindTraitDef$.MODULE$.INSTANCE()), UpdateKindTrait$.MODULE$.ONLY_UPDATE_AFTER())) {
            return true;
        }
        if (((Boolean)ShortcutUtils.unwrapTableConfig(normalize).get(ExecutionConfigOptions.TABLE_EXEC_SOURCE_CDC_EVENTS_DUPLICATE)).booleanValue()) {
            return true;
        }
        RelNode input = normalize.getInput();
        return ChangelogNormalizeRequirementResolver.visit(input, ChangelogNormalizeRequirementResolver.bitSetForAllOutputColumns(input));
    }

    private static ImmutableBitSet bitSetForAllOutputColumns(RelNode input) {
        return ImmutableBitSet.builder().set(0, input.getRowType().getFieldCount()).build();
    }

    private static boolean visit(RelNode rel, ImmutableBitSet requiredColumns) {
        if (rel instanceof StreamPhysicalCalcBase) {
            return ChangelogNormalizeRequirementResolver.visitCalc((StreamPhysicalCalcBase)rel, requiredColumns);
        }
        if (rel instanceof StreamPhysicalTableSourceScan) {
            return ChangelogNormalizeRequirementResolver.visitTableSourceScan((StreamPhysicalTableSourceScan)rel, requiredColumns);
        }
        if (rel instanceof StreamPhysicalWatermarkAssigner || rel instanceof StreamPhysicalExchange) {
            RelNode input = ((SingleRel)rel).getInput();
            return ChangelogNormalizeRequirementResolver.visit(input, ChangelogNormalizeRequirementResolver.bitSetForAllOutputColumns(input));
        }
        throw new UnsupportedOperationException(String.format("Unsupported to visit node %s. The node either should not be pushed through the changelog normalize or is not supported yet.", rel.getClass().getSimpleName()));
    }

    private static boolean visitTableSourceScan(StreamPhysicalTableSourceScan tableScan, ImmutableBitSet requiredColumns) {
        if (!(tableScan.tableSource() instanceof SupportsReadingMetadata)) {
            return false;
        }
        TableSourceTable sourceTable = tableScan.getTable().unwrap(TableSourceTable.class);
        assert (sourceTable != null);
        List<Column.MetadataColumn> metadataColumns = DynamicSourceUtils.extractMetadataColumns(sourceTable.contextResolvedTable().getResolvedSchema());
        Set metaColumnSet = metadataColumns.stream().map(Column::getName).collect(Collectors.toSet());
        List<String> columns = tableScan.getRowType().getFieldNames();
        for (int index = 0; index < columns.size(); ++index) {
            String column = columns.get(index);
            if (!metaColumnSet.contains(column) || !requiredColumns.get(index)) continue;
            return true;
        }
        return false;
    }

    private static boolean visitCalc(StreamPhysicalCalcBase calc, ImmutableBitSet requiredColumns) {
        List<RexNode> projects = calc.getProgram().getProjectList().stream().map(expr -> calc.getProgram().expandLocalRef((RexLocalRef)expr)).collect(Collectors.toList());
        Map<Integer, List<Integer>> outFromSourcePos = FlinkRelUtil.extractSourceMapping(projects);
        List<Integer> conv2Inputs = requiredColumns.toList().stream().map(out -> Optional.ofNullable((List)outFromSourcePos.get(out)).orElseThrow(() -> new IllegalStateException(String.format("Invalid pos:%d over projection:%s", out, calc.getProgram())))).flatMap(Collection::stream).filter(index -> index != -1).distinct().collect(Collectors.toList());
        return ChangelogNormalizeRequirementResolver.visit(calc.getInput(), ImmutableBitSet.of(conv2Inputs));
    }
}

