/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.common;

import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.legacy.sources.LookupableTableSource;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalLegacyTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRel;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalSnapshot;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableSourceScan;
import org.apache.flink.table.planner.plan.schema.LegacyTableSourceTable;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.schema.TimeIndicatorRelDataType;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3q\u0001C\u0005\u0011\u0002\u0007\u0005!\u0004C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011Eq\u0005C\u00036\u0001\u0011Ea\u0007C\u0003>\u0001\u0011%a\bC\u0003R\u0001\u0011%!\u000bC\u0003V\u0001\u0011%a\u000bC\u0003Y\u0001\u0011E\u0011LA\u000eD_6lwN\u001c+f[B|'/\u00197UC\ndWMS8j]J+H.\u001a\u0006\u0003\u0015-\taaY8n[>t'B\u0001\u0007\u000e\u0003\u0015\u0011X\u000f\\3t\u0015\tqq\"\u0001\u0003qY\u0006t'B\u0001\t\u0012\u0003\u001d\u0001H.\u00198oKJT!AE\n\u0002\u000bQ\f'\r\\3\u000b\u0005Q)\u0012!\u00024mS:\\'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0012\u0011\u0005q!\u0013BA\u0013\u001e\u0005\u0011)f.\u001b;\u0002\u000f5\fGo\u00195fgR\u0011\u0001f\u000b\t\u00039%J!AK\u000f\u0003\u000f\t{w\u000e\\3b]\")AF\u0001a\u0001[\u0005A1O\\1qg\"|G\u000f\u0005\u0002/g5\tqF\u0003\u00021c\u00059An\\4jG\u0006d'B\u0001\u001a\u000e\u0003\u0015qw\u000eZ3t\u0013\t!tF\u0001\u000bGY&t7\u000eT8hS\u000e\fGn\u00158baNDw\u000e^\u0001\u0017G\u0006t7i\u001c8wKJ$Hk\u001c'p_.,\bOS8j]R\u0019\u0001f\u000e\u001d\t\u000b1\u001a\u0001\u0019A\u0017\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\u001bMt\u0017\r]:i_RLe\u000e];u!\tq3(\u0003\u0002=_\tya\t\\5oW2{w-[2bYJ+G.\u0001\u0007hKR$\u0016M\u00197f'\u000e\fg\u000e\u0006\u0002@\u0019B\u0019A\u0004\u0011\"\n\u0005\u0005k\"AB(qi&|g\u000e\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u0006!1m\u001c:f\u0015\t9\u0005*A\u0002sK2T!!S\u000b\u0002\u000f\r\fGnY5uK&\u00111\n\u0012\u0002\n)\u0006\u0014G.Z*dC:DQ!\u000f\u0003A\u00025\u0003\"AT(\u000e\u0003\u0019K!\u0001\u0015$\u0003\u000fI+GNT8eK\u0006\t\u0012n\u001d+bE2,7k\\;sG\u0016\u001c6-\u00198\u0015\u0005!\u001a\u0006\"\u0002+\u0006\u0001\u0004i\u0015a\u0002:fY:{G-Z\u0001\u0014SNdun\\6vaR\u000b'\r\\3T_V\u00148-\u001a\u000b\u0003Q]CQ\u0001\u0016\u0004A\u00025\u000bq\u0001\u001e:j[\"+\u0007\u000f\u0006\u0002N5\")1l\u0002a\u0001\u001b\u0006!an\u001c3f\u0001")
public interface CommonTemporalTableJoinRule {
    public static /* synthetic */ boolean matches$(CommonTemporalTableJoinRule $this, FlinkLogicalSnapshot snapshot) {
        return $this.matches(snapshot);
    }

    default public boolean matches(FlinkLogicalSnapshot snapshot) {
        RexFieldAccess rexFieldAccess;
        RexNode rexNode = snapshot.getPeriod();
        if (!(rexNode instanceof RexFieldAccess && (rexFieldAccess = (RexFieldAccess)rexNode).getType() instanceof TimeIndicatorRelDataType && rexFieldAccess.getReferenceExpr() instanceof RexCorrelVariable)) {
            throw new TableException("Temporal table join currently only supports 'FOR SYSTEM_TIME AS OF' left table's time attribute field.");
        }
        return true;
    }

    public static /* synthetic */ boolean canConvertToLookupJoin$(CommonTemporalTableJoinRule $this, FlinkLogicalSnapshot snapshot, FlinkLogicalRel snapshotInput) {
        return $this.canConvertToLookupJoin(snapshot, snapshotInput);
    }

    default public boolean canConvertToLookupJoin(FlinkLogicalSnapshot snapshot, FlinkLogicalRel snapshotInput) {
        Some some;
        TableScan scan;
        TimeIndicatorRelDataType timeIndicatorRelDataType;
        RelDataType relDataType = snapshot.getPeriod().getType();
        boolean isProcessingTime = relDataType instanceof TimeIndicatorRelDataType && !(timeIndicatorRelDataType = (TimeIndicatorRelDataType)relDataType).isEventTime();
        Option<TableScan> tableScan = this.getTableScan(snapshotInput);
        Option<TableScan> option = tableScan;
        boolean snapshotOnLookupSource = option instanceof Some ? this.isTableSourceScan(scan = (TableScan)(some = (Some)option).value()) && this.isLookupTableSource(scan) : false;
        return isProcessingTime && snapshotOnLookupSource;
    }

    private Option<TableScan> getTableScan(RelNode snapshotInput) {
        LogicalProject logicalProject;
        RelNode relNode = snapshotInput;
        if (relNode instanceof TableScan) {
            TableScan tableScan = (TableScan)relNode;
            return new Some((Object)tableScan);
        }
        if (relNode instanceof LogicalProject && this.trimHep((logicalProject = (LogicalProject)relNode).getInput()) instanceof TableScan) {
            return new Some((Object)((TableScan)this.trimHep(logicalProject.getInput())));
        }
        return None$.MODULE$;
    }

    private boolean isTableSourceScan(RelNode relNode) {
        RelNode relNode2 = relNode;
        if (relNode2 instanceof LogicalTableScan) {
            LogicalTableScan logicalTableScan = (LogicalTableScan)relNode2;
            RelOptTable table = logicalTableScan.getTable();
            RelOptTable relOptTable = table;
            return relOptTable instanceof LegacyTableSourceTable ? true : relOptTable instanceof TableSourceTable;
        }
        return relNode2 instanceof FlinkLogicalLegacyTableSourceScan ? true : relNode2 instanceof FlinkLogicalTableSourceScan;
    }

    private boolean isLookupTableSource(RelNode relNode) {
        RelNode relNode2 = relNode;
        if (relNode2 instanceof FlinkLogicalLegacyTableSourceScan) {
            FlinkLogicalLegacyTableSourceScan flinkLogicalLegacyTableSourceScan = (FlinkLogicalLegacyTableSourceScan)relNode2;
            return flinkLogicalLegacyTableSourceScan.tableSource() instanceof LookupableTableSource;
        }
        if (relNode2 instanceof FlinkLogicalTableSourceScan) {
            FlinkLogicalTableSourceScan flinkLogicalTableSourceScan = (FlinkLogicalTableSourceScan)relNode2;
            return flinkLogicalTableSourceScan.tableSource() instanceof LookupTableSource;
        }
        if (relNode2 instanceof LogicalTableScan) {
            LogicalTableScan logicalTableScan = (LogicalTableScan)relNode2;
            RelOptTable relOptTable = logicalTableScan.getTable();
            if (relOptTable instanceof LegacyTableSourceTable) {
                LegacyTableSourceTable legacyTableSourceTable = (LegacyTableSourceTable)relOptTable;
                return legacyTableSourceTable.tableSource() instanceof LookupableTableSource;
            }
            if (relOptTable instanceof TableSourceTable) {
                TableSourceTable tableSourceTable = (TableSourceTable)relOptTable;
                return tableSourceTable.tableSource() instanceof LookupTableSource;
            }
            return false;
        }
        return false;
    }

    public static /* synthetic */ RelNode trimHep$(CommonTemporalTableJoinRule $this, RelNode node) {
        return $this.trimHep(node);
    }

    default public RelNode trimHep(RelNode node) {
        RelNode relNode = node;
        if (relNode instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode;
            return hepRelVertex.getCurrentRel();
        }
        return node;
    }

    public static void $init$(CommonTemporalTableJoinRule $this) {
    }
}

