/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.metadata.FlinkRelMetadataQuery;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalRank;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableCalcRankTransposeRule;
import org.apache.flink.table.planner.plan.utils.FlinkRexUtil;
import org.apache.flink.table.planner.plan.utils.RankUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.immutables.value.Value;

@Value.Enclosing
public class CalcRankTransposeRule
extends RelRule<CalcRankTransposeRuleConfig> {
    public static final CalcRankTransposeRule INSTANCE = CalcRankTransposeRuleConfig.DEFAULT.toRule();

    private CalcRankTransposeRule(CalcRankTransposeRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        int totalColumnCount = rank.getInput().getRowType().getFieldCount();
        int[] pushableColumns = this.getPushableColumns(calc, rank);
        return pushableColumns.length < totalColumnCount;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RexProgram topProgram;
        FlinkLogicalCalc calc = (FlinkLogicalCalc)call.rel(0);
        FlinkLogicalRank rank = (FlinkLogicalRank)call.rel(1);
        int[] pushableColumns = this.getPushableColumns(calc, rank);
        RexBuilder rexBuilder = calc.getCluster().getRexBuilder();
        RexProgram innerProgram = this.createNewInnerCalcProgram(pushableColumns, rank.getInput().getRowType(), rexBuilder);
        FlinkLogicalCalc newInnerCalc = (FlinkLogicalCalc)calc.copy(calc.getTraitSet(), rank.getInput(), innerProgram);
        Map<Integer, Integer> fieldMapping = IntStream.range(0, pushableColumns.length).boxed().collect(Collectors.toMap(i -> pushableColumns[i], Function.identity()));
        FlinkLogicalRank newRank = this.createNewRankOnCalc(fieldMapping, newInnerCalc, rank);
        if (rank.outputRankNumber()) {
            int oldRankFunFieldIdx = (Integer)RankUtil.getRankNumberColumnIndex(rank).getOrElse(() -> {
                throw new TableException("This should not happen");
            });
            int newRankFunFieldIdx = (Integer)RankUtil.getRankNumberColumnIndex(newRank).getOrElse(() -> {
                throw new TableException("This should not happen");
            });
            fieldMapping.put(oldRankFunFieldIdx, newRankFunFieldIdx);
        }
        SingleRel equiv = (topProgram = this.createNewTopCalcProgram(calc.getProgram(), fieldMapping, newRank.getRowType(), rexBuilder)).isTrivial() ? newRank : calc.copy(calc.getTraitSet(), newRank, topProgram);
        call.transformTo(equiv);
    }

    private int[] getPushableColumns(Calc calc, FlinkLogicalRank rank) {
        int[] usedFields = this.getUsedFields(calc.getProgram());
        int rankFunFieldIndex = (Integer)JavaScalaConversionUtil.toJava(RankUtil.getRankNumberColumnIndex(rank)).orElse(-1);
        int[] usedFieldsExcludeRankNumber = Arrays.stream(usedFields).filter(index -> index != rankFunFieldIndex).toArray();
        int[] requiredFields = this.getKeyFields(rank);
        return Stream.of(usedFieldsExcludeRankNumber, requiredFields).flatMapToInt(Arrays::stream).distinct().sorted().toArray();
    }

    private int[] getUsedFields(RexProgram program) {
        List<RexNode> projects = program.getProjectList().stream().map(program::expandLocalRef).collect(Collectors.toList());
        RexNode condition = program.getCondition() != null ? program.expandLocalRef(program.getCondition()) : null;
        return RelOptUtil.InputFinder.bits(projects, condition).toArray();
    }

    private int[] getKeyFields(FlinkLogicalRank rank) {
        int[] nArray;
        int[] keysInUniqueKeys;
        int[] partitionKey = rank.partitionKey().toArray();
        int[] orderKey = rank.orderKey().getFieldCollations().stream().mapToInt(RelFieldCollation::getFieldIndex).toArray();
        Set<ImmutableBitSet> upsertKeys = FlinkRelMetadataQuery.reuseOrCreate(rank.getCluster().getMetadataQuery()).getUpsertKeysInKeyGroupRange(rank.getInput(), partitionKey);
        int[] nArray2 = keysInUniqueKeys = upsertKeys == null || upsertKeys.isEmpty() ? new int[]{} : upsertKeys.stream().flatMapToInt(key -> Arrays.stream(key.toArray())).toArray();
        if (rank.rankRange() instanceof VariableRankRange) {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = ((VariableRankRange)rank.rankRange()).getRankEndIndex();
        } else {
            nArray = new int[]{};
        }
        int[] rankRangeKey = nArray;
        return Stream.of(partitionKey, orderKey, keysInUniqueKeys, rankRangeKey).flatMapToInt(Arrays::stream).toArray();
    }

    private RexProgram createNewInnerCalcProgram(int[] projectedFields, RelDataType inputRowType, RexBuilder rexBuilder) {
        List projects = Arrays.stream(projectedFields).mapToObj(i -> RexInputRef.of(i, inputRowType)).collect(Collectors.toList());
        List<String> inputColNames = inputRowType.getFieldNames();
        List colNames = Arrays.stream(projectedFields).mapToObj(inputColNames::get).collect(Collectors.toList());
        return RexProgram.create(inputRowType, projects, null, colNames, rexBuilder);
    }

    private RexProgram createNewTopCalcProgram(RexProgram oldTopProgram, Map<Integer, Integer> fieldMapping, RelDataType inputRowType, RexBuilder rexBuilder) {
        List newProjects = oldTopProgram.getProjectList().stream().map(oldTopProgram::expandLocalRef).map(p -> FlinkRexUtil.adjustInputRef(p, fieldMapping)).collect(Collectors.toList());
        RexNode newCondition = oldTopProgram.getCondition() != null ? FlinkRexUtil.adjustInputRef(oldTopProgram.expandLocalRef(oldTopProgram.getCondition()), fieldMapping) : null;
        List<String> colNames = oldTopProgram.getOutputRowType().getFieldNames();
        return RexProgram.create(inputRowType, newProjects, newCondition, colNames, rexBuilder);
    }

    private FlinkLogicalRank createNewRankOnCalc(Map<Integer, Integer> fieldMapping, Calc input, FlinkLogicalRank rank) {
        int[] newPartitionKey = Arrays.stream(rank.partitionKey().toArray()).map(fieldMapping::get).toArray();
        RelCollation oldOrderKey = rank.orderKey();
        List<RelFieldCollation> oldFieldCollations = oldOrderKey.getFieldCollations();
        List<RelFieldCollation> newFieldCollations = oldFieldCollations.stream().map(fc -> fc.withFieldIndex((Integer)fieldMapping.get(fc.getFieldIndex()))).collect(Collectors.toList());
        RelCollation newOrderKey = newFieldCollations.equals(oldFieldCollations) ? oldOrderKey : RelCollations.of(newFieldCollations);
        return new FlinkLogicalRank(rank.getCluster(), rank.getTraitSet(), input, ImmutableBitSet.of(newPartitionKey), newOrderKey, rank.rankType(), rank.rankRange(), rank.rankNumberType(), rank.outputRankNumber());
    }

    @Value.Immutable(singleton=false)
    public static interface CalcRankTransposeRuleConfig
    extends RelRule.Config {
        public static final CalcRankTransposeRuleConfig DEFAULT = ImmutableCalcRankTransposeRule.CalcRankTransposeRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(FlinkLogicalCalc.class).inputs(b1 -> b1.operand(FlinkLogicalRank.class).anyInputs())).withDescription("CalcRankTransposeRule");

        @Override
        default public CalcRankTransposeRule toRule() {
            return new CalcRankTransposeRule(this);
        }
    }
}

