/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.io.Serializable;
import java.util.Collections;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlGroupedWindowFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.logical.LogicalWindow;
import org.apache.flink.table.planner.plan.logical.SessionGroupWindow;
import org.apache.flink.table.planner.plan.logical.SlidingGroupWindow;
import org.apache.flink.table.planner.plan.logical.TumblingGroupWindow;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate;
import org.apache.flink.table.planner.plan.nodes.calcite.LogicalWindowAggregate$;
import org.apache.flink.table.runtime.groupwindow.WindowReference;
import org.apache.flink.table.runtime.types.LogicalTypeDataTypeConverter;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\t\u0013\u0003\u0003\u0019\u0003\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0017\t\u000be\u0002A\u0011\u0001\u001e\t\u000by\u0002A\u0011I \t\u000b%\u0003A\u0011\t&\t\u000b=\u0003A\u0011\u0002)\t\u000be\u0003A\u0011\u0002.\t\u000b)\u0004A\u0011A6\t\u000bQ\u0004A\u0011A;\t\u000bi\u0004A\u0011B>\t\u000f\u0005m\u0002\u0001\"\u0003\u0002>!A\u0011\u0011\t\u0001\u0005\u0002i\t\u0019\u0005\u0003\u0005\u0002b\u00011\tAGA2\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kB\u0001\"a\u001f\u0001\t\u0003Q\u0012Q\u0010\u0005\t\u0003+\u0003a\u0011\u0001\u000e\u0002\u0018\"9\u0011Q\u0016\u0001\u0007\u0002\u0005=&A\b'pO&\u001c\u0017\r\\,j]\u0012|w/Q4he\u0016<\u0017\r^3Sk2,')Y:f\u0015\t\u0019B#A\u0004m_\u001eL7-\u00197\u000b\u0005U1\u0012!\u0002:vY\u0016\u001c(BA\f\u0019\u0003\u0011\u0001H.\u00198\u000b\u0005eQ\u0012a\u00029mC:tWM\u001d\u0006\u00037q\tQ\u0001^1cY\u0016T!!\b\u0010\u0002\u000b\u0019d\u0017N\\6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0005\u0005\u0002&S5\taE\u0003\u0002\u0018O)\u0011\u0001FH\u0001\bG\u0006d7-\u001b;f\u0013\tQcE\u0001\u0006SK2|\u0005\u000f\u001e*vY\u0016\f1\u0002Z3tGJL\u0007\u000f^5p]B\u0011QF\u000e\b\u0003]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0012\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0012\u0014A\u0002\u001fj]&$h\b\u0006\u0002<{A\u0011A\bA\u0007\u0002%!)1F\u0001a\u0001Y\u00059Q.\u0019;dQ\u0016\u001cHC\u0001!E!\t\t%)D\u00013\u0013\t\u0019%GA\u0004C_>dW-\u00198\t\u000b\u0015\u001b\u0001\u0019\u0001$\u0002\t\r\fG\u000e\u001c\t\u0003K\u001dK!\u0001\u0013\u0014\u0003\u001dI+Gn\u00149u%VdWmQ1mY\u00069qN\\'bi\u000eDGCA&O!\t\tE*\u0003\u0002Ne\t!QK\\5u\u0011\u0015)E\u00011\u0001G\u0003\u001d!(/[7IKB$\"!U,\u0011\u0005I+V\"A*\u000b\u0005Q;\u0013a\u0001:fY&\u0011ak\u0015\u0002\b%\u0016dgj\u001c3f\u0011\u0015AV\u00011\u0001R\u0003\u0011qw\u000eZ3\u0002-I,wO]5uKB\u0013xn\u0019;j[\u0016<\u0016N\u001c3poN$2a\u00171c!\taf,D\u0001^\u0015\t\u00192+\u0003\u0002`;\nqAj\\4jG\u0006d\u0007K]8kK\u000e$\b\"B1\u0007\u0001\u0004Y\u0016a\u00029s_*,7\r\u001e\u0005\u0006G\u001a\u0001\r\u0001Z\u0001\u000be\u0016d')^5mI\u0016\u0014\bCA3i\u001b\u00051'BA4(\u0003\u0015!xn\u001c7t\u0013\tIgM\u0001\u0006SK2\u0014U/\u001b7eKJ\fa\"[:Qe>\u001cG/[7f\u0007\u0006dG\u000e\u0006\u0002AY\")Qn\u0002a\u0001]\u00069!/\u001a=O_\u0012,\u0007CA8s\u001b\u0005\u0001(BA9(\u0003\r\u0011X\r_\u0005\u0003gB\u0014qAU3y\u001d>$W-\u0001\u0007jg^Kg\u000eZ8x\u0007\u0006dG\u000e\u0006\u0002Am\")Q\t\u0003a\u0001oB\u0011q\u000e_\u0005\u0003sB\u0014qAU3y\u0007\u0006dG.A\u0006bI*,8\u000f\u001e+za\u0016\u001cH#\u0002?\u0002\u0016\u0005}\u0001#B?\u0002\u0006\u0005%Q\"\u0001@\u000b\u0007}\f\t!A\u0004nkR\f'\r\\3\u000b\u0007\u0005\r!'\u0001\u0006d_2dWm\u0019;j_:L1!a\u0002\u007f\u0005\u0019\u0011UO\u001a4feB!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010M\u000bAaY8sK&!\u00111CA\u0007\u00055\tum\u001a:fO\u0006$XmQ1mY\"9\u0011qC\u0005A\u0002\u0005e\u0011aA1hOB\u0019A,a\u0007\n\u0007\u0005uQL\u0001\tM_\u001eL7-\u00197BO\u001e\u0014XmZ1uK\"9\u0011\u0011E\u0005A\u0002\u0005\r\u0012!D5oI\u0016D\u0018I\u001c3UsB,7\u000fE\u0004.\u0003K\tI#a\f\n\u0007\u0005\u001d\u0002HA\u0002NCB\u00042!QA\u0016\u0013\r\tiC\r\u0002\u0004\u0013:$\b\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U2+\u0001\u0003usB,\u0017\u0002BA\u001d\u0003g\u00111BU3m\t\u0006$\u0018\rV=qK\u0006\ts-\u001a;J]\u0012,\u00070\u00118e\u0013:4WM\u001d:fIRK\b/Z:JM\u000eC\u0017M\\4fIR!\u00111EA \u0011\u001d\t9B\u0003a\u0001\u00033\tAcZ3u/&tGm\\<FqB\u0014Xm]:j_:\u001cHCBA#\u0003;\ny\u0006\u0005\u0004\u0002H\u0005E\u0013q\u000b\b\u0005\u0003\u0013\niED\u00020\u0003\u0017J\u0011aM\u0005\u0004\u0003\u001f\u0012\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003'\n)FA\u0002TKFT1!a\u00143!\u0019\t\u0015\u0011L<\u0002*%\u0019\u00111\f\u001a\u0003\rQ+\b\u000f\\33\u0011\u001d\t9b\u0003a\u0001\u00033AQ!Y\u0006A\u0002m\u000bQdZ3u\u0013:\fum\u001a:fO\u0006$Xm\u0012:pkB,\u0005\u0010\u001d:fgNLwN\u001c\u000b\u0006]\u0006\u0015\u0014q\u000e\u0005\b\u0003Ob\u0001\u0019AA5\u0003)\u0011X\r\u001f\"vS2$WM\u001d\t\u0004_\u0006-\u0014bAA7a\nQ!+\u001a=Ck&dG-\u001a:\t\r\u0005ED\u00021\u0001x\u0003A9\u0018N\u001c3po\u0016C\bO]3tg&|g.\u0001\u0010hKR|U\u000f^!hOJ,w-\u0019;f\u000fJ|W\u000f]#yaJ,7o]5p]R)a.a\u001e\u0002z!9\u0011qM\u0007A\u0002\u0005%\u0004BBA9\u001b\u0001\u0007q/A\bue\u0006t7\u000f\\1uK^Kg\u000eZ8x)!\ty(!#\u0002\u000e\u0006E\u0005\u0003BAA\u0003\u000bk!!a!\u000b\u0005M1\u0012\u0002BAD\u0003\u0007\u0013Q\u0002T8hS\u000e\fGnV5oI><\bBBAF\u001d\u0001\u0007q/\u0001\u0006xS:$wn^#yaJDq!a$\u000f\u0001\u0004\tI#A\u0007xS:$wn^#yaJLE\r\u001f\u0005\b\u0003's\u0001\u0019AA\u0018\u0003\u001d\u0011xn\u001e+za\u0016\fQcZ3u)&lWMR5fY\u0012\u0014VMZ3sK:\u001cW\r\u0006\u0005\u0002\u001a\u0006\u0015\u0016\u0011VAV!\u0011\tY*!)\u000e\u0005\u0005u%bAAP5\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\u0019+!(\u00031\u0019KW\r\u001c3SK\u001a,'/\u001a8dK\u0016C\bO]3tg&|g\u000e\u0003\u0004\u0002(>\u0001\rA\\\u0001\b_B,'/\u00198e\u0011\u001d\tyi\u0004a\u0001\u0003SAq!a%\u0010\u0001\u0004\ty#\u0001\thKR|\u0005/\u001a:b]\u0012\f5\u000fT8oOR1\u0011\u0011WA\\\u0003s\u00032!QAZ\u0013\r\t)L\r\u0002\u0005\u0019>tw\rC\u0003F!\u0001\u0007q\u000fC\u0004\u0002<B\u0001\r!!\u000b\u0002\u0007%$\u0007\u0010")
public abstract class LogicalWindowAggregateRuleBase
extends RelOptRule {
    @Override
    public boolean matches(RelOptRuleCall call) {
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        Seq<Tuple2<RexCall, Object>> windowExpressions = this.getWindowExpressions(agg, (LogicalProject)this.trimHep(agg.getInput()));
        if (windowExpressions.length() > 1) {
            throw new TableException("Only a single window group function may be used in GROUP BY");
        }
        Aggregate.Group group = agg.getGroupType();
        Aggregate.Group group2 = Aggregate.Group.SIMPLE;
        boolean groupSets = group == null ? group2 != null : !((Object)((Object)group)).equals((Object)group2);
        return !groupSets && windowExpressions.nonEmpty();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalProject project;
        RelBuilder builder = call.builder();
        LogicalAggregate agg = (LogicalAggregate)call.rel(0);
        Tuple2 tuple2 = (Tuple2)this.getWindowExpressions(agg, project = this.rewriteProctimeWindows((LogicalProject)call.rel(1), builder)).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RexCall windowExpr = (RexCall)tuple2._1();
        int windowExprIdx = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)windowExpr, (Object)BoxesRunTime.boxToInteger((int)windowExprIdx));
        RexCall windowExpr2 = (RexCall)tuple22._1();
        int windowExprIdx2 = tuple22._2$mcI$sp();
        RexBuilder rexBuilder = agg.getCluster().getRexBuilder();
        RexNode inAggGroupExpression = this.getInAggregateGroupExpression(rexBuilder, windowExpr2);
        ImmutableBitSet newGroupSet = agg.getGroupSet().except(ImmutableBitSet.of(windowExprIdx2));
        RelNode newProject = builder.push(project.getInput()).project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).updated(windowExprIdx2, (Object)inAggGroupExpression, Buffer$.MODULE$.canBuildFrom()))).build();
        LogicalWindow window = this.translateWindow(windowExpr2, windowExprIdx2, newProject.getRowType());
        scala.collection.immutable.Map<Object, RelDataType> indexAndTypes = this.getIndexAndInferredTypesIfChanged(agg);
        Buffer<AggregateCall> finalCalls = this.adjustTypes(agg, indexAndTypes);
        LogicalAggregate newAgg = LogicalAggregate.create(newProject, ImmutableList.of(), newGroupSet, ImmutableList.of(newGroupSet), (java.util.List<AggregateCall>)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(finalCalls));
        RelBuilder transformed = call.builder();
        LogicalWindowAggregate windowAgg = LogicalWindowAggregate$.MODULE$.create(window, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$), newAgg);
        transformed.push(windowAgg);
        RexNode outAggGroupExpression0 = this.getOutAggregateGroupExpression(rexBuilder, windowExpr2);
        RexNode outAggGroupExpression = windowExpr2.getType().isNullable() != outAggGroupExpression0.getType().isNullable() ? builder.getRexBuilder().makeAbstractCast(builder.getRexBuilder().matchNullability(outAggGroupExpression0.getType(), windowExpr2), outAggGroupExpression0) : outAggGroupExpression0;
        Buffer projectsEnsureGroupKeyTypes = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(transformed.fields()).patch(windowExprIdx2, (GenSeq)new .colon.colon((Object)outAggGroupExpression, (List)Nil$.MODULE$), 0, Buffer$.MODULE$.canBuildFrom());
        Buffer projectsEnsureAggCallTypes = (Buffer)((TraversableLike)projectsEnsureGroupKeyTypes.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                RexNode aggCall = (RexNode)tuple2._1();
                int index = tuple2._2$mcI$sp();
                int aggCallIndex = index - agg.getGroupCount();
                if (JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)indexAndTypes).containsKey(BoxesRunTime.boxToInteger((int)aggCallIndex))) {
                    return rexBuilder.makeCast(agg$1.getAggCallList().get((int)aggCallIndex).type, aggCall, true, false);
                }
                return aggCall;
            }
            throw new MatchError((Object)tuple2);
        }, Buffer$.MODULE$.canBuildFrom());
        transformed.project(JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(projectsEnsureAggCallTypes));
        RelNode result = transformed.build();
        call.transformTo(result);
    }

    private RelNode trimHep(RelNode node) {
        RelNode relNode = node;
        if (relNode instanceof HepRelVertex) {
            HepRelVertex hepRelVertex = (HepRelVertex)relNode;
            return hepRelVertex.getCurrentRel();
        }
        return node;
    }

    private LogicalProject rewriteProctimeWindows(LogicalProject project, RelBuilder relBuilder) {
        RelNode projectInput = this.trimHep(project.getInput());
        BooleanRef hasWindowOnProctimeCall = BooleanRef.create((boolean)false);
        Buffer newProjectExprs = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RexCall rexCall;
            RexNode rexNode = x0$1;
            if (rexNode instanceof RexCall && this.isWindowCall(rexCall = (RexCall)rexNode) && this.isProctimeCall((RexNode)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).head())) {
                hasWindowOnProctimeCall$1.elem = true;
                return rexCall.accept(new RexShuttle(this, relBuilder, projectInput){
                    private final /* synthetic */ LogicalWindowAggregateRuleBase $outer;
                    private final RelBuilder relBuilder$1;
                    private final RelNode projectInput$1;

                    public RexNode visitCall(RexCall call) {
                        if (this.$outer.isProctimeCall(call)) {
                            return this.relBuilder$1.getRexBuilder().makeInputRef(call.getType(), this.projectInput$1.getRowType().getFieldCount());
                        }
                        return super.visitCall(call);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.relBuilder$1 = relBuilder$1;
                        this.projectInput$1 = projectInput$1;
                    }
                });
            }
            if (rexNode != null) {
                RexNode rexNode2 = rexNode;
                return rexNode2;
            }
            throw new MatchError((Object)rexNode);
        }, Buffer$.MODULE$.canBuildFrom());
        if (hasWindowOnProctimeCall.elem) {
            RelNode newInput = relBuilder.push(projectInput).projectPlus(relBuilder.call((SqlOperator)FlinkSqlOperatorTable.PROCTIME, new RexNode[0])).build();
            return (LogicalProject)RelFactories.DEFAULT_PROJECT_FACTORY.createProject(newInput, Collections.emptyList(), JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(newProjectExprs), project.getRowType().getFieldNames());
        }
        return project;
    }

    public boolean isProctimeCall(RexNode rexNode) {
        RexNode rexNode2 = rexNode;
        if (rexNode2 instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode2;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlFunction sqlFunction = FlinkSqlOperatorTable.PROCTIME;
            return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null);
        }
        return false;
    }

    public boolean isWindowCall(RexCall call) {
        boolean bl;
        SqlOperator sqlOperator = call.getOperator();
        SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.SESSION_OLD;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
            bl = true;
        } else {
            SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                bl = true;
            } else {
                SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.TUMBLE_OLD;
                SqlOperator sqlOperator4 = sqlOperator;
                bl = !(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null);
            }
        }
        return bl;
    }

    private Buffer<AggregateCall> adjustTypes(LogicalAggregate agg, scala.collection.immutable.Map<Object, RelDataType> indexAndTypes) {
        return (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                AggregateCall aggCall = (AggregateCall)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (JavaConversions$.MODULE$.deprecated$u0020mapAsJavaMap((Map)indexAndTypes).containsKey(BoxesRunTime.boxToInteger((int)index))) {
                    return AggregateCall.create(aggCall.getAggregation(), aggCall.isDistinct(), aggCall.isApproximate(), aggCall.ignoreNulls(), aggCall.getArgList(), aggCall.filterArg, aggCall.distinctKeys, aggCall.collation, agg.getGroupCount(), agg.getInput(), (RelDataType)indexAndTypes.apply((Object)BoxesRunTime.boxToInteger((int)index)), aggCall.name);
                }
                return aggCall;
            }
            throw new MatchError((Object)tuple2);
        }, Buffer$.MODULE$.canBuildFrom());
    }

    private scala.collection.immutable.Map<Object, RelDataType> getIndexAndInferredTypesIfChanged(LogicalAggregate agg) {
        return ((TraversableOnce)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(agg.getAggCallList()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                AggregateCall aggCall = (AggregateCall)tuple2._1();
                int index = tuple2._2$mcI$sp();
                RelDataType origType = aggCall.type;
                Aggregate.AggCallBinding aggCallBinding = new Aggregate.AggCallBinding(agg.getCluster().getTypeFactory(), aggCall.getAggregation(), SqlTypeUtil.projectTypes(agg.getInput().getRowType(), aggCall.getArgList()), 0, aggCall.hasFilter());
                RelDataType inferredType = aggCall.getAggregation().inferReturnType(aggCallBinding);
                RelDataType relDataType = origType;
                RelDataType relDataType2 = inferredType;
                if ((relDataType == null ? relDataType2 != null : !relDataType.equals(relDataType2)) && agg.getGroupCount() == 1) {
                    return Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)inferredType)));
                }
                return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            throw new MatchError((Object)tuple2);
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Seq<Tuple2<RexCall, Object>> getWindowExpressions(LogicalAggregate agg, LogicalProject project) {
        ImmutableBitSet groupKeys = agg.getGroupSet();
        Buffer groupExpr = (Buffer)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(project.getProjects()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)groupKeys.get(p._2$mcI$sp())));
        return (Seq)((TraversableLike)groupExpr.filter((Function1 & Serializable & scala.Serializable)g2 -> BoxesRunTime.boxToBoolean((boolean)LogicalWindowAggregateRuleBase.$anonfun$getWindowExpressions$2(g2)))).map((Function1 & Serializable & scala.Serializable)w -> new Tuple2((Object)((RexCall)w._1()), (Object)BoxesRunTime.boxToInteger((int)w._2$mcI$sp())), Buffer$.MODULE$.canBuildFrom());
    }

    public abstract RexNode getInAggregateGroupExpression(RexBuilder var1, RexCall var2);

    private RexNode getOutAggregateGroupExpression(RexBuilder rexBuilder, RexCall windowExpression) {
        RexLiteral zeroLiteral = rexBuilder.makeZeroLiteral(windowExpression.getType());
        if (FlinkTypeFactory$.MODULE$.isTimeIndicatorType(windowExpression.getType())) {
            return rexBuilder.makeAbstractCast(windowExpression.getType(), zeroLiteral);
        }
        return zeroLiteral;
    }

    public LogicalWindow translateWindow(RexCall windowExpr, int windowExprIdx, RelDataType rowType) {
        FieldReferenceExpression timeField = this.getTimeFieldReference(windowExpr.getOperands().get(0), windowExprIdx, rowType);
        LogicalType resultType = LogicalTypeDataTypeConverter.fromDataTypeToLogicalType((DataType)timeField.getOutputDataType());
        WindowReference windowRef = new WindowReference("w$", resultType);
        SqlOperator sqlOperator = windowExpr.getOperator();
        SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_OLD;
        SqlOperator sqlOperator2 = sqlOperator;
        if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
            long interval = this.getOperandAsLong(windowExpr, 1);
            return new TumblingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis((long)interval));
        }
        SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
        SqlOperator sqlOperator3 = sqlOperator;
        if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(this.getOperandAsLong(windowExpr, 1), this.getOperandAsLong(windowExpr, 2));
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            long slide = sp2._1$mcJ$sp();
            long size = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(slide, size);
            long slide2 = sp3._1$mcJ$sp();
            long size2 = sp3._2$mcJ$sp();
            return new SlidingGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis((long)size2), ApiExpressionUtils.intervalOfMillis((long)slide2));
        }
        SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_OLD;
        SqlOperator sqlOperator4 = sqlOperator;
        if (!(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null)) {
            long gap = this.getOperandAsLong(windowExpr, 1);
            return new SessionGroupWindow(windowRef, timeField, ApiExpressionUtils.intervalOfMillis((long)gap));
        }
        throw new MatchError((Object)sqlOperator);
    }

    public abstract FieldReferenceExpression getTimeFieldReference(RexNode var1, int var2, RelDataType var3);

    public abstract long getOperandAsLong(RexCall var1, int var2);

    public static final /* synthetic */ boolean $anonfun$getWindowExpressions$2(Tuple2 g2) {
        RexNode rexNode = (RexNode)g2._1();
        if (rexNode instanceof RexCall) {
            RexCall rexCall = (RexCall)rexNode;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlGroupedWindowFunction sqlGroupedWindowFunction = FlinkSqlOperatorTable.TUMBLE_OLD;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlGroupedWindowFunction != null ? !((Object)sqlGroupedWindowFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                if (rexCall.getOperands().size() == 2) {
                    return true;
                }
                throw new TableException("TUMBLE window with alignment is not supported yet.");
            }
            SqlGroupedWindowFunction sqlGroupedWindowFunction2 = FlinkSqlOperatorTable.HOP_OLD;
            SqlOperator sqlOperator3 = sqlOperator;
            if (!(sqlGroupedWindowFunction2 != null ? !((Object)sqlGroupedWindowFunction2).equals(sqlOperator3) : sqlOperator3 != null)) {
                if (rexCall.getOperands().size() == 3) {
                    return true;
                }
                throw new TableException("HOP window with alignment is not supported yet.");
            }
            SqlGroupedWindowFunction sqlGroupedWindowFunction3 = FlinkSqlOperatorTable.SESSION_OLD;
            SqlOperator sqlOperator4 = sqlOperator;
            if (!(sqlGroupedWindowFunction3 != null ? !((Object)sqlGroupedWindowFunction3).equals(sqlOperator4) : sqlOperator4 != null)) {
                if (rexCall.getOperands().size() == 2) {
                    return true;
                }
                throw new TableException("SESSION window with alignment is not supported yet.");
            }
            return false;
        }
        return false;
    }

    public LogicalWindowAggregateRuleBase(String description) {
        super(RelOptRule.operand(LogicalAggregate.class, RelOptRule.operand(LogicalProject.class, RelOptRule.none()), new RelOptRuleOperand[0]), description);
    }
}

