/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableReplaceMinusWithAntiJoinRule;
import org.apache.flink.table.planner.plan.utils.SetOpRewriteUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class ReplaceMinusWithAntiJoinRule
extends RelRule<ReplaceMinusWithAntiJoinRuleConfig> {
    public static final ReplaceMinusWithAntiJoinRule INSTANCE = ReplaceMinusWithAntiJoinRuleConfig.DEFAULT.toRule();

    private ReplaceMinusWithAntiJoinRule(ReplaceMinusWithAntiJoinRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Minus minus = (Minus)call.rel(0);
        return !minus.all && minus.getInputs().size() == 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Minus minus = (Minus)call.rel(0);
        RelNode left = minus.getInput(0);
        RelNode right = minus.getInput(1);
        RelBuilder relBuilder = call.builder();
        List<Integer> keys = Util.range(left.getRowType().getFieldCount());
        List<RexNode> conditions = SetOpRewriteUtil.generateEqualsCondition(relBuilder, left, right, keys);
        relBuilder.push(left);
        relBuilder.push(right);
        relBuilder.join(JoinRelType.ANTI, conditions).aggregate(relBuilder.groupKey(keys.stream().mapToInt(Integer::intValue).toArray()), new RelBuilder.AggCall[0]);
        RelNode rel = relBuilder.build();
        call.transformTo(rel);
    }

    @Value.Immutable(singleton=false)
    public static interface ReplaceMinusWithAntiJoinRuleConfig
    extends RelRule.Config {
        public static final ReplaceMinusWithAntiJoinRuleConfig DEFAULT = ImmutableReplaceMinusWithAntiJoinRule.ReplaceMinusWithAntiJoinRuleConfig.builder().build().withOperandSupplier(b0 -> b0.operand(Minus.class).anyInputs()).withRelBuilderFactory(RelFactories.LOGICAL_BUILDER).withDescription("ReplaceMinusWithAntiJoinRule");

        @Override
        default public ReplaceMinusWithAntiJoinRule toRule() {
            return new ReplaceMinusWithAntiJoinRule(this);
        }
    }
}

