/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.logical;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.plan.rules.logical.ImmutableRewriteIntersectAllRule;
import org.apache.flink.table.planner.plan.utils.SetOpRewriteUtil;
import org.immutables.value.Value;

@Value.Enclosing
public class RewriteIntersectAllRule
extends RelRule<RewriteIntersectAllRuleConfig> {
    public static final RewriteIntersectAllRule INSTANCE = RewriteIntersectAllRuleConfig.DEFAULT.toRule();

    protected RewriteIntersectAllRule(RewriteIntersectAllRuleConfig config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Intersect intersect = (Intersect)call.rel(0);
        return intersect.all && intersect.getInputs().size() == 2;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object intersect = call.rel(0);
        RelNode left = intersect.getInput(0);
        RelNode right = intersect.getInput(1);
        List<Integer> fields = Util.range(intersect.getRowType().getFieldCount());
        FlinkRelBuilder flinkRelBuilder = FlinkRelBuilder.of(call.rel(0).getCluster(), null);
        RelBuilder leftBuilder = flinkRelBuilder.transform(u -> u.withConvertCorrelateToJoin(false));
        RelDataType boolType = leftBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
        RelNode leftWithMarker = leftBuilder.push(left).project(Stream.concat(fields.stream().map(leftBuilder::field), Stream.of(leftBuilder.alias(leftBuilder.literal(true), "vcol_left_marker"), leftBuilder.alias(leftBuilder.getRexBuilder().makeNullLiteral(boolType), "vcol_right_marker"))).collect(Collectors.toList())).build();
        RelBuilder rightBuilder = flinkRelBuilder.transform(u -> u.withConvertCorrelateToJoin(false));
        RelNode rightWithMarker = rightBuilder.push(right).project(Stream.concat(fields.stream().map(rightBuilder::field), Stream.of(rightBuilder.alias(rightBuilder.getRexBuilder().makeNullLiteral(boolType), "vcol_left_marker"), rightBuilder.alias(rightBuilder.literal(true), "vcol_right_marker"))).collect(Collectors.toList())).build();
        RelBuilder builder = flinkRelBuilder.transform(u -> u.withConvertCorrelateToJoin(false));
        builder.push(leftWithMarker).push(rightWithMarker).union(true).aggregate(builder.groupKey(builder.fields(fields)), builder.count(false, "vcol_left_cnt", builder.field("vcol_left_marker")), builder.count(false, "vcol_right_cnt", builder.field("vcol_right_marker"))).filter(builder.and(builder.call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, builder.field("vcol_left_cnt"), builder.literal(1)), builder.call(FlinkSqlOperatorTable.GREATER_THAN_OR_EQUAL, builder.field("vcol_right_cnt"), builder.literal(1)))).project(Stream.concat(Stream.of(builder.call((SqlOperator)FlinkSqlOperatorTable.IF, builder.call(FlinkSqlOperatorTable.GREATER_THAN, builder.field("vcol_left_cnt"), builder.field("vcol_right_cnt")), builder.field("vcol_right_cnt"), builder.field("vcol_left_cnt"))), builder.fields(fields).stream()).collect(Collectors.toList()));
        RelNode output = SetOpRewriteUtil.replicateRows(builder, intersect.getRowType(), fields);
        call.transformTo(output);
    }

    @Value.Immutable(singleton=false)
    public static interface RewriteIntersectAllRuleConfig
    extends RelRule.Config {
        public static final RewriteIntersectAllRuleConfig DEFAULT = ImmutableRewriteIntersectAllRule.RewriteIntersectAllRuleConfig.builder().operandSupplier(b0 -> b0.operand(Intersect.class).anyInputs()).relBuilderFactory(RelFactories.LOGICAL_BUILDER).description("RewriteIntersectAllRule").build();

        @Override
        default public RewriteIntersectAllRule toRule() {
            return new RewriteIntersectAllRule(this);
        }
    }
}

