/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.stream;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.functions.FunctionKind;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCalc;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalCorrelate;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalTableFunctionScan;
import org.apache.flink.table.planner.plan.nodes.physical.stream.StreamPhysicalAsyncCorrelate;
import org.apache.flink.table.planner.plan.rules.physical.stream.StreamPhysicalCorrelateRule;
import org.apache.flink.table.planner.plan.utils.AsyncUtil;

public class StreamPhysicalAsyncCorrelateRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new StreamPhysicalAsyncCorrelateRule(ConverterRule.Config.INSTANCE.withConversion(FlinkLogicalCorrelate.class, FlinkConventions.LOGICAL(), FlinkConventions.STREAM_PHYSICAL(), "StreamPhysicalAsyncCorrelateRule"));

    protected StreamPhysicalAsyncCorrelateRule(ConverterRule.Config config) {
        super(config);
    }

    private boolean findAsyncTableFunction(RelNode node) {
        if (node instanceof FlinkLogicalTableFunctionScan) {
            FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)node;
            return AsyncUtil.isAsyncCall(scan.getCall(), FunctionKind.ASYNC_TABLE);
        }
        if (node instanceof FlinkLogicalCalc) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)node;
            RelNode child = ((RelSubset)calc.getInput()).getOriginal();
            return this.findAsyncTableFunction(child);
        }
        return false;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)call.rel(0);
        RelNode right = ((RelSubset)correlate.getRight()).getOriginal();
        return this.findAsyncTableFunction(right);
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalCorrelate correlate = (FlinkLogicalCorrelate)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions.STREAM_PHYSICAL());
        RelNode convInput = RelOptRule.convert(correlate.getInput(0), FlinkConventions.STREAM_PHYSICAL());
        RelNode right = correlate.getInput(1);
        return this.convertToCorrelate(right, correlate, traitSet, convInput, Optional.empty(), Optional.empty());
    }

    public RelNode convertToCorrelate(RelNode relNode, FlinkLogicalCorrelate correlate, RelTraitSet traitSet, RelNode convInput, Optional<List<RexNode>> projections, Optional<RexNode> condition) {
        if (relNode instanceof RelSubset) {
            RelSubset rel = (RelSubset)relNode;
            return this.convertToCorrelate(rel.getRelList().get(0), correlate, traitSet, convInput, projections, condition);
        }
        if (relNode instanceof FlinkLogicalCalc) {
            FlinkLogicalCalc calc = (FlinkLogicalCalc)relNode;
            FlinkLogicalTableFunctionScan tableScan = StreamPhysicalCorrelateRule.getTableScan(calc);
            FlinkLogicalCalc newCalc = StreamPhysicalCorrelateRule.getMergedCalc(calc);
            return this.convertToCorrelate(tableScan, correlate, traitSet, convInput, Optional.ofNullable(newCalc.getProgram().getProjectList() == null ? null : newCalc.getProgram().getProjectList().stream().map(newCalc.getProgram()::expandLocalRef).collect(Collectors.toList())), Optional.ofNullable(newCalc.getProgram().getCondition() == null ? null : newCalc.getProgram().expandLocalRef(newCalc.getProgram().getCondition())));
        }
        FlinkLogicalTableFunctionScan scan = (FlinkLogicalTableFunctionScan)relNode;
        return new StreamPhysicalAsyncCorrelate(correlate.getCluster(), traitSet, convInput, scan, projections, condition, correlate.getRowType(), correlate.getJoinType());
    }
}

