/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.utils.RelExplainUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public abstract class FunctionCallUtil {
    private static final String CONFIG_ERROR_MESSAGE = "Config parameter should be a MAP data type consisting of String literals.";

    public static <T> T coalesce(T t1, T t2) {
        return t1 != null ? t1 : t2;
    }

    public static AsyncDataStream.OutputMode convert(ChangelogMode inputChangelogMode, ExecutionConfigOptions.AsyncOutputMode asyncOutputMode) {
        if (inputChangelogMode.containsOnly(RowKind.INSERT) && asyncOutputMode == ExecutionConfigOptions.AsyncOutputMode.ALLOW_UNORDERED) {
            return AsyncDataStream.OutputMode.UNORDERED;
        }
        return AsyncDataStream.OutputMode.ORDERED;
    }

    public static Map<String, String> convert(RexCall mapConstructor) {
        Preconditions.checkArgument((mapConstructor.getOperator().getKind() == SqlKind.MAP_VALUE_CONSTRUCTOR ? 1 : 0) != 0, (Object)"Input must be map constructor.");
        HashMap<String, String> reducedConfig = new HashMap<String, String>();
        Preconditions.checkArgument((mapConstructor.getOperands().size() % 2 == 0 ? 1 : 0) != 0, (Object)"Map constructor input must be even.");
        for (int i = 0; i < mapConstructor.getOperands().size(); i += 2) {
            RexNode keyNode = mapConstructor.getOperands().get(i);
            RexNode valueNode = mapConstructor.getOperands().get(i + 1);
            String key = FunctionCallUtil.getStringLiteral(keyNode);
            String value = FunctionCallUtil.getStringLiteral(valueNode);
            reducedConfig.put(key, value);
        }
        return reducedConfig;
    }

    private static String getStringLiteral(RexNode node) {
        if (node instanceof RexCall && node.getKind() == SqlKind.CAST) {
            RexCall castCall = (RexCall)node;
            RexNode castOperand = castCall.getOperands().get(0);
            if (!(castOperand instanceof RexLiteral)) {
                throw new ValidationException(CONFIG_ERROR_MESSAGE);
            }
            RelDataType operandType = castOperand.getType();
            if (!FlinkTypeFactory.toLogicalType(operandType).is(LogicalTypeFamily.CHARACTER_STRING)) {
                throw new ValidationException(CONFIG_ERROR_MESSAGE);
            }
            RelDataType castType = castCall.getType();
            if (!FlinkTypeFactory.toLogicalType(castType).is(LogicalTypeFamily.CHARACTER_STRING)) {
                throw new ValidationException(CONFIG_ERROR_MESSAGE);
            }
            return RexLiteral.stringValue(castOperand);
        }
        if (!(node instanceof RexLiteral)) {
            throw new ValidationException(CONFIG_ERROR_MESSAGE);
        }
        return RexLiteral.stringValue(node);
    }

    public static String explainFunctionParam(FunctionParam param, List<String> fieldNames) {
        if (param instanceof Constant) {
            return RelExplainUtil.literalToString(((Constant)param).literal);
        }
        if (param instanceof FieldRef) {
            return fieldNames.get(((FieldRef)param).index);
        }
        throw new TableException("Unknown parameter type: " + param.getClass().getName());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="AsyncOptions")
    public static class AsyncOptions {
        public static final String FIELD_NAME_CAPACITY = "capacity ";
        public static final String FIELD_NAME_TIMEOUT = "timeout";
        public static final String FIELD_NAME_OUTPUT_MODE = "output-mode";
        public static final String FIELD_NAME_IS_KEY_ORDERED = "is-key-ordered";
        @JsonProperty(value="capacity ")
        public final int asyncBufferCapacity;
        @JsonProperty(value="timeout")
        public final long asyncTimeout;
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        @JsonProperty(value="is-key-ordered")
        public final boolean keyOrdered;
        @JsonProperty(value="output-mode")
        public final AsyncDataStream.OutputMode asyncOutputMode;

        @JsonCreator
        public AsyncOptions(@JsonProperty(value="capacity ") int asyncBufferCapacity, @JsonProperty(value="timeout") long asyncTimeout, @JsonProperty(value="is-key-ordered") boolean keyOrdered, @JsonProperty(value="output-mode") AsyncDataStream.OutputMode asyncOutputMode) {
            this.asyncBufferCapacity = asyncBufferCapacity;
            this.asyncTimeout = asyncTimeout;
            this.keyOrdered = keyOrdered;
            this.asyncOutputMode = asyncOutputMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AsyncOptions that = (AsyncOptions)o;
            return this.asyncBufferCapacity == that.asyncBufferCapacity && this.asyncTimeout == that.asyncTimeout && this.keyOrdered == that.keyOrdered && this.asyncOutputMode == that.asyncOutputMode;
        }

        public int hashCode() {
            return Objects.hash(this.asyncBufferCapacity, this.asyncTimeout, this.keyOrdered, this.asyncOutputMode);
        }

        public String toString() {
            return String.valueOf(this.asyncOutputMode) + ", KEY_ORDERED: " + this.keyOrdered + ", " + this.asyncTimeout + "ms, " + this.asyncBufferCapacity;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="FieldRef")
    public static class FieldRef
    extends FunctionParam {
        public static final String FIELD_NAME_INDEX = "index";
        @JsonProperty(value="index")
        public final int index;

        @JsonCreator
        public FieldRef(@JsonProperty(value="index") int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldRef that = (FieldRef)o;
            return this.index == that.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="Constant")
    public static class Constant
    extends FunctionParam {
        public static final String FIELD_NAME_SOURCE_TYPE = "sourceType";
        public static final String FIELD_NAME_LITERAL = "literal";
        @JsonProperty(value="sourceType")
        public final LogicalType sourceType;
        @JsonProperty(value="literal")
        public final RexLiteral literal;

        @JsonCreator
        public Constant(@JsonProperty(value="sourceType") LogicalType sourceType, @JsonProperty(value="literal") RexLiteral literal) {
            this.sourceType = sourceType;
            this.literal = literal;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constant that = (Constant)o;
            return Objects.equals(this.sourceType, that.sourceType) && Objects.equals(this.literal, that.literal);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.literal);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=Constant.class), @JsonSubTypes.Type(value=FieldRef.class)})
    public static class FunctionParam {
        private FunctionParam() {
        }
    }
}

