/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.functions.util.ListCollector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.ConstantCodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.utils.TableConfigUtils;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.utils.DateTimeUtils;
import scala.Array$;
import scala.Boolean$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PartitionPruner$ {
    public static PartitionPruner$ MODULE$;
    private final LogicalTypeRoot[] supportedPartitionFieldTypes;

    static {
        new PartitionPruner$();
    }

    public LogicalTypeRoot[] supportedPartitionFieldTypes() {
        return this.supportedPartitionFieldTypes;
    }

    public List<Map<String, String>> prunePartitions(TableConfig tableConfig, ClassLoader classLoader, String[] partitionFieldNames, LogicalType[] partitionFieldTypes, List<Map<String, String>> allPartitions, RexNode partitionPredicate) {
        String x$14;
        Option<String> x$13;
        Option<LogicalType> x$12;
        if (allPartitions.isEmpty() || partitionPredicate.isAlwaysTrue()) {
            return allPartitions;
        }
        RowType inputType = InternalTypeInfo.ofFields((LogicalType[])partitionFieldTypes, (String[])partitionFieldNames).toRowType();
        BooleanType returnType = new BooleanType(false);
        ConstantCodeGeneratorContext ctx = new ConstantCodeGeneratorContext((ReadableConfig)tableConfig, classLoader);
        String collectorTerm = CodeGenUtils$.MODULE$.DEFAULT_COLLECTOR_TERM();
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$15 = inputType;
        String x$2 = qual$1.bindInput$default$2();
        Option<int[]> x$3 = qual$1.bindInput$default$3();
        ExprCodeGenerator exprGenerator = qual$1.bindInput((LogicalType)x$15, x$2, x$3);
        GeneratedExpression filterExpression = exprGenerator.generateExpression(partitionPredicate);
        String filterFunctionBody = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(filterExpression.code()).append("\n         |return ").append(filterExpression.resultTerm()).append(";\n         |").toString())).stripMargin();
        ConstantCodeGeneratorContext x$4 = ctx;
        String x$5 = "PartitionPruner";
        Class<MapFunction> x$6 = MapFunction.class;
        String x$7 = filterFunctionBody;
        BooleanType x$8 = returnType;
        RowType x$9 = inputType;
        String x$10 = collectorTerm;
        String x$11 = FunctionCodeGenerator$.MODULE$.generateFunction$default$7();
        GeneratedFunction<MapFunction> genFunction = FunctionCodeGenerator$.MODULE$.generateFunction(x$4, x$5, x$6, x$7, (LogicalType)x$8, (LogicalType)x$9, x$11, x$12 = FunctionCodeGenerator$.MODULE$.generateFunction$default$8(), x$13 = FunctionCodeGenerator$.MODULE$.generateFunction$default$9(), x$10, x$14 = FunctionCodeGenerator$.MODULE$.generateFunction$default$11());
        MapFunction function = (MapFunction)genFunction.newInstance(classLoader);
        MapFunction mapFunction = function;
        if (!(mapFunction instanceof RichMapFunction)) {
            throw new TableException("RichMapFunction[GenericRowData, Boolean] required here");
        }
        RichMapFunction richMapFunction = (RichMapFunction)mapFunction;
        RichMapFunction richMapFunction2 = richMapFunction;
        ArrayList results = new ArrayList(allPartitions.size());
        ListCollector collector = new ListCollector(results);
        try {
            richMapFunction2.open(DefaultOpenContext.INSTANCE);
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions).foreach((Function1 & Serializable & scala.Serializable)partition -> {
                PartitionPruner$.$anonfun$prunePartitions$1(tableConfig, partitionFieldNames, partitionFieldTypes, collector, richMapFunction2, partition);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            richMapFunction2.close();
        }
        return JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)((TraversableLike)((TraversableLike)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(allPartitions).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)PartitionPruner$.$anonfun$prunePartitions$2(results, x0$2)))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Map)x$1._1(), Buffer$.MODULE$.canBuildFrom()));
    }

    private GenericRowData convertPartitionToRow(ZoneId timeZone, String[] partitionFieldNames, LogicalType[] partitionFieldTypes, Map<String, String> partition) {
        GenericRowData row = new GenericRowData(partitionFieldNames.length);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionFieldNames)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])partitionFieldTypes), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            PartitionPruner$.$anonfun$convertPartitionToRow$1(timeZone, partition, row, x0$1);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    private Object convertPartitionFieldValue(ZoneId timeZone, String v, LogicalType t) {
        if (v == null) {
            return null;
        }
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) {
            return StringData.fromString((String)v);
        }
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            return Boolean$.MODULE$;
        }
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString(v)).toByte());
        }
        if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString(v)).toShort());
        }
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(v)).toInt());
        }
        if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString(v)).toLong());
        }
        if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(v)).toFloat());
        }
        if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            return BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString(v)).toDouble());
        }
        if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            DecimalType decimalType = (DecimalType)t;
            return DecimalDataUtils.castFrom((String)v, (int)decimalType.getPrecision(), (int)decimalType.getScale());
        }
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            return DateTimeUtils.parseDate((String)v);
        }
        if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return DateTimeUtils.parseTime((String)v);
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return DateTimeUtils.parseTimestampData((String)v, (int)LogicalTypeChecks.getPrecision((LogicalType)t));
        }
        if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot)) {
            return TimestampData.fromInstant((Instant)DateTimeUtils.parseTimestampData((String)v, (int)LogicalTypeChecks.getPrecision((LogicalType)t)).toLocalDateTime().atZone(timeZone).toInstant());
        }
        throw new TableException(new StringBuilder(36).append(t).append(" is not supported in PartitionPruner").toString());
    }

    public static final /* synthetic */ void $anonfun$prunePartitions$1(TableConfig tableConfig$1, String[] partitionFieldNames$1, LogicalType[] partitionFieldTypes$1, ListCollector collector$1, RichMapFunction richMapFunction$1, Map partition) {
        GenericRowData row = MODULE$.convertPartitionToRow(TableConfigUtils.getLocalTimeZone((ReadableConfig)tableConfig$1), partitionFieldNames$1, partitionFieldTypes$1, partition);
        collector$1.collect(richMapFunction$1.map((Object)row));
    }

    public static final /* synthetic */ boolean $anonfun$prunePartitions$2(List results$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int index = tuple2._2$mcI$sp();
            return BoxesRunTime.unboxToBoolean(results$1.get(index));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$convertPartitionToRow$1(ZoneId timeZone$1, Map partition$1, GenericRowData row$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                String fieldName = (String)tuple22._1();
                LogicalType fieldType = (LogicalType)tuple22._2();
                Object value = MODULE$.convertPartitionFieldValue(timeZone$1, (String)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(partition$1).apply((Object)fieldName), fieldType);
                row$1.setField(index, value);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private PartitionPruner$() {
        MODULE$ = this;
        this.supportedPartitionFieldTypes = (LogicalTypeRoot[])((Object[])new LogicalTypeRoot[]{LogicalTypeRoot.VARCHAR, LogicalTypeRoot.CHAR, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE, LogicalTypeRoot.DECIMAL, LogicalTypeRoot.DATE, LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE});
    }
}

