/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.utils.TimestampStringUtils;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;

@Internal
public class RexLiteralUtil {
    private RexLiteralUtil() {
    }

    public static Tuple2<Object, LogicalType> toFlinkInternalValue(RexLiteral literal) {
        LogicalType targetType = FlinkTypeFactory.toLogicalType(literal.getType());
        return Tuple2.of((Object)RexLiteralUtil.toFlinkInternalValue(literal.getValueAs(Comparable.class), targetType), (Object)targetType);
    }

    public static Object toFlinkInternalValue(Comparable<?> value, LogicalType valueType) {
        if (value == null) {
            return null;
        }
        switch (valueType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                if (value instanceof NlsString) {
                    return BinaryStringData.fromString((String)((NlsString)value).getValue());
                }
                if (!(value instanceof String)) break;
                return BinaryStringData.fromString((String)((String)((Object)value)));
            }
            case BOOLEAN: {
                if (!(value instanceof Boolean)) break;
                return value;
            }
            case BINARY: 
            case VARBINARY: {
                if (!(value instanceof ByteString)) break;
                return ((ByteString)value).getBytes();
            }
            case DECIMAL: {
                if (!(value instanceof BigDecimal)) break;
                return DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)value), (int)LogicalTypeChecks.getPrecision((LogicalType)valueType), (int)LogicalTypeChecks.getScale((LogicalType)valueType));
            }
            case TINYINT: {
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).byteValue();
            }
            case SMALLINT: {
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).shortValue();
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).intValue();
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).longValue();
            }
            case FLOAT: {
                if (!(value instanceof Number)) break;
                return Float.valueOf(((Number)((Object)value)).floatValue());
            }
            case DOUBLE: {
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).doubleValue();
            }
            case DATE: {
                if (value instanceof DateString) {
                    return ((DateString)value).getDaysSinceEpoch();
                }
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).intValue();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                if (value instanceof TimeString) {
                    return ((TimeString)value).getMillisOfDay();
                }
                if (!(value instanceof Number)) break;
                return ((Number)((Object)value)).intValue();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                if (!(value instanceof TimestampString)) break;
                return TimestampData.fromLocalDateTime((LocalDateTime)TimestampStringUtils.toLocalDateTime((TimestampString)value));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (!(value instanceof TimestampString)) break;
                return TimestampData.fromInstant((Instant)TimestampStringUtils.toLocalDateTime((TimestampString)value).atOffset(ZoneOffset.UTC).toInstant());
            }
            case DISTINCT_TYPE: {
                return RexLiteralUtil.toFlinkInternalValue(value, ((DistinctType)valueType).getSourceType());
            }
            case SYMBOL: {
                if (!(value instanceof Enum)) break;
                return value;
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case ARRAY: 
            case MULTISET: 
            case MAP: 
            case ROW: 
            case STRUCTURED_TYPE: 
            case NULL: 
            case UNRESOLVED: 
            case DESCRIPTOR: {
                throw new CodeGenException("Type not supported: " + String.valueOf(valueType));
            }
        }
        throw new IllegalStateException("Unexpected class " + String.valueOf(value.getClass()) + " for value of type " + String.valueOf(valueType));
    }
}

