/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.io.Serializable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.JoinSpec;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.planner.plan.utils.InputRefVisitor;
import org.apache.flink.table.planner.plan.utils.TemporalTableJoinUtil;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TemporalJoinUtil$ {
    public static TemporalJoinUtil$ MODULE$;
    private final SqlFunction TEMPORAL_JOIN_CONDITION;
    private final SqlFunction INITIAL_TEMPORAL_JOIN_CONDITION;
    private final SqlFunction TEMPORAL_JOIN_LEFT_KEY;
    private final SqlFunction TEMPORAL_JOIN_RIGHT_KEY;
    private final SqlFunction TEMPORAL_JOIN_CONDITION_PRIMARY_KEY;

    static {
        new TemporalJoinUtil$();
    }

    public SqlFunction TEMPORAL_JOIN_CONDITION() {
        return this.TEMPORAL_JOIN_CONDITION;
    }

    public SqlFunction INITIAL_TEMPORAL_JOIN_CONDITION() {
        return this.INITIAL_TEMPORAL_JOIN_CONDITION;
    }

    public SqlFunction TEMPORAL_JOIN_LEFT_KEY() {
        return this.TEMPORAL_JOIN_LEFT_KEY;
    }

    public SqlFunction TEMPORAL_JOIN_RIGHT_KEY() {
        return this.TEMPORAL_JOIN_RIGHT_KEY;
    }

    public SqlFunction TEMPORAL_JOIN_CONDITION_PRIMARY_KEY() {
        return this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY;
    }

    private RexNode makePrimaryKeyCall(RexBuilder rexBuilder, Seq<RexNode> rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(rightPrimaryKeyExpression));
    }

    private RexNode makeLeftJoinKeyCall(RexBuilder rexBuilder, Seq<RexNode> keyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_LEFT_KEY(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(keyExpression));
    }

    private RexNode makeRightJoinKeyCall(RexBuilder rexBuilder, Seq<RexNode> keyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_RIGHT_KEY(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(keyExpression));
    }

    public RexNode makeProcTimeTemporalFunctionJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makePrimaryKeyCall(rexBuilder, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{rightPrimaryKeyExpression})));
    }

    public RexNode makeRowTimeTemporalFunctionJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, RexNode rightPrimaryKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makePrimaryKeyCall(rexBuilder, (Seq<RexNode>)Predef$.MODULE$.wrapRefArray((Object[])new RexNode[]{rightPrimaryKeyExpression})));
    }

    public RexNode makeInitialRowTimeTemporalTableJoinCondCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.INITIAL_TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeRowTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, RexNode rightTimeAttribute, Seq<RexNode> rightPrimaryKeyExpression, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, rightTimeAttribute, this.makePrimaryKeyCall(rexBuilder, rightPrimaryKeyExpression), this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeInitialProcTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.INITIAL_TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public RexNode makeProcTimeTemporalTableJoinConCall(RexBuilder rexBuilder, RexNode leftTimeAttribute, Seq<RexNode> rightPrimaryKeyExpression, Seq<RexNode> leftJoinKeyExpression, Seq<RexNode> rightJoinKeyExpression) {
        return rexBuilder.makeCall((SqlOperator)this.TEMPORAL_JOIN_CONDITION(), leftTimeAttribute, this.makePrimaryKeyCall(rexBuilder, rightPrimaryKeyExpression), this.makeLeftJoinKeyCall(rexBuilder, leftJoinKeyExpression), this.makeRightJoinKeyCall(rexBuilder, rightJoinKeyExpression));
    }

    public boolean isInitialRowTimeTemporalTableJoin(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.INITIAL_TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).length() == 4;
    }

    public boolean isInitialProcTimeTemporalTableJoin(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.INITIAL_TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).length() == 3;
    }

    private boolean containsTemporalJoinCondition(RexNode condition) {
        BooleanRef hasTemporalJoinCondition = BooleanRef.create((boolean)false);
        condition.accept(new RexVisitorImpl<Void>(hasTemporalJoinCondition){
            private final BooleanRef hasTemporalJoinCondition$1;

            public Void visitCall(RexCall call) {
                SqlOperator sqlOperator = call.getOperator();
                SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.TEMPORAL_JOIN_CONDITION();
                if (sqlOperator == null ? sqlFunction != null : !((Object)sqlOperator).equals(sqlFunction)) {
                    SqlOperator sqlOperator2 = call.getOperator();
                    SqlFunction sqlFunction2 = TemporalJoinUtil$.MODULE$.INITIAL_TEMPORAL_JOIN_CONDITION();
                    if (sqlOperator2 == null ? sqlFunction2 != null : !((Object)sqlOperator2).equals(sqlFunction2)) {
                        return (Void)super.visitCall(call);
                    }
                }
                this.hasTemporalJoinCondition$1.elem = true;
                return null;
            }
            {
                this.hasTemporalJoinCondition$1 = hasTemporalJoinCondition$1;
                super(true);
            }
        });
        return hasTemporalJoinCondition.elem;
    }

    public boolean containsInitialTemporalJoinCondition(RexNode condition) {
        BooleanRef hasTemporalJoinCondition = BooleanRef.create((boolean)false);
        condition.accept(new RexVisitorImpl<Void>(hasTemporalJoinCondition){
            private final BooleanRef hasTemporalJoinCondition$2;

            public Void visitCall(RexCall call) {
                SqlOperator sqlOperator = call.getOperator();
                SqlFunction sqlFunction = TemporalJoinUtil$.MODULE$.INITIAL_TEMPORAL_JOIN_CONDITION();
                if (sqlOperator == null ? sqlFunction != null : !((Object)sqlOperator).equals(sqlFunction)) {
                    return (Void)super.visitCall(call);
                }
                this.hasTemporalJoinCondition$2.elem = true;
                return null;
            }
            {
                this.hasTemporalJoinCondition$2 = hasTemporalJoinCondition$2;
                super(true);
            }
        });
        return hasTemporalJoinCondition.elem;
    }

    public boolean isRowTimeJoin(JoinSpec joinSpec) {
        RexNode nonEquiJoinRex = joinSpec.getNonEquiCondition().orElse(null);
        BooleanRef rowtimeJoin = BooleanRef.create((boolean)false);
        RexVisitorImpl<BoxedUnit> visitor = new RexVisitorImpl<BoxedUnit>(rowtimeJoin){
            private final BooleanRef rowtimeJoin$1;

            public void visitCall(RexCall call) {
                if (TemporalTableJoinUtil.isRowTimeTemporalTableJoinCondition(call) || TemporalJoinUtil$.MODULE$.isRowTimeTemporalFunctionJoinCon(call)) {
                    this.rowtimeJoin$1.elem = true;
                    return;
                }
                super.visitCall(call);
            }
            {
                this.rowtimeJoin$1 = rowtimeJoin$1;
                super(true);
            }
        };
        nonEquiJoinRex.accept(visitor);
        return rowtimeJoin.elem;
    }

    public boolean isRowTimeTemporalFunctionJoinCon(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        return !(sqlOperator != null ? !((Object)sqlOperator).equals(sqlFunction) : sqlFunction != null) && JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).length() == 3;
    }

    public boolean isTemporalFunctionJoin(RexBuilder rexBuilder, JoinInfo joinInfo) {
        RexNode nonEquiJoinRex = joinInfo.getRemaining(rexBuilder);
        BooleanRef isTemporalFunctionJoin = BooleanRef.create((boolean)false);
        RexVisitorImpl<BoxedUnit> visitor = new RexVisitorImpl<BoxedUnit>(isTemporalFunctionJoin){
            private final BooleanRef isTemporalFunctionJoin$1;

            public void visitCall(RexCall call) {
                if (TemporalJoinUtil$.MODULE$.isTemporalFunctionCon(call)) {
                    this.isTemporalFunctionJoin$1.elem = true;
                    return;
                }
                super.visitCall(call);
            }
            {
                this.isTemporalFunctionJoin$1 = isTemporalFunctionJoin$1;
                super(true);
            }
        };
        nonEquiJoinRex.accept(visitor);
        return isTemporalFunctionJoin.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTemporalFunctionCon(RexCall rexCall) {
        SqlOperator sqlOperator = rexCall.getOperator();
        SqlFunction sqlFunction = this.TEMPORAL_JOIN_CONDITION();
        if (sqlOperator == null) {
            if (sqlFunction != null) {
                return false;
            }
        } else if (!((Object)sqlOperator).equals(sqlFunction)) return false;
        if (JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).length() == 2) return true;
        if (JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.operands).length() != 3) return false;
        return true;
    }

    public void validateTemporalFunctionCondition(RexCall call, RexNode leftTimeAttribute, Option<RexNode> rightTimeAttribute, Option<RexNode[]> rightPrimaryKey, int rightKeysStartingOffset, JoinSpec joinSpec, String textualRepresentation) {
        if (this.isRowTimeTemporalFunctionJoinCon(call)) {
            this.validateTemporalFunctionPrimaryKey(rightKeysStartingOffset, rightPrimaryKey, joinSpec, textualRepresentation);
            if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(((RexNode)rightTimeAttribute.get()).getType())) {
                throw new ValidationException(new StringBuilder(65).append("Non rowtime timeAttribute [").append(((RexNode)rightTimeAttribute.get()).getType()).append("] ").append("used to create TemporalTableFunction").toString());
            }
            if (!FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(leftTimeAttribute.getType())) {
                throw new ValidationException(new StringBuilder(76).append("Non rowtime timeAttribute [").append(leftTimeAttribute.getType()).append("] ").append("passed as the argument to TemporalTableFunction").toString());
            }
            return;
        }
        this.validateTemporalFunctionPrimaryKey(rightKeysStartingOffset, rightPrimaryKey, joinSpec, textualRepresentation);
        if (!FlinkTypeFactory$.MODULE$.isProctimeIndicatorType(leftTimeAttribute.getType())) {
            throw new ValidationException(new StringBuilder(79).append("Non processing timeAttribute [").append(leftTimeAttribute.getType()).append("] ").append("passed as the argument to TemporalTableFunction").toString());
        }
    }

    private void validateTemporalFunctionPrimaryKey(int rightKeysStartingOffset, Option<RexNode[]> rightPrimaryKey, JoinSpec joinInfo, String textualRepresentation) {
        if (joinInfo.getRightKeys().length != 1) {
            throw new ValidationException(new StringBuilder(54).append("Only single column join key is supported. ").append("Found ").append(joinInfo.getRightKeys()).append(" in [").append(textualRepresentation).append("]").toString());
        }
        if (rightPrimaryKey.isEmpty() || ((RexNode[])rightPrimaryKey.get()).length != 1) {
            throw new ValidationException(new StringBuilder(50).append("Only single primary key is supported. ").append("Found ").append(rightPrimaryKey).append(" in [").append(textualRepresentation).append("]").toString());
        }
        RexNode pk = ((RexNode[])rightPrimaryKey.get())[0];
        int rightJoinKeyInputReference = joinInfo.getRightKeys()[0] + rightKeysStartingOffset;
        int rightPrimaryKeyInputReference = this.extractInputRef(pk, textualRepresentation);
        if (rightPrimaryKeyInputReference != rightJoinKeyInputReference) {
            throw new ValidationException(new StringBuilder(69).append("Join key [").append(rightJoinKeyInputReference).append("] must be the same as ").append("temporal table's primary key [").append(pk).append("] ").append("in [").append(textualRepresentation).append("]").toString());
        }
    }

    public IntPair[] getTemporalTableJoinKeyPairs(JoinInfo joinInfo, Option<RexProgram> calcOnTemporalTable) {
        return this.getTemporalTableJoinKeyPairs((IntPair[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(joinInfo.pairs()).asScala()).toArray(ClassTag$.MODULE$.apply(IntPair.class)), calcOnTemporalTable);
    }

    public IntPair[] getTemporalTableJoinKeyPairs(IntPair[] joinPairs, Option<RexProgram> calcOnTemporalTable) {
        Option<RexProgram> option = calcOnTemporalTable;
        if (option instanceof Some) {
            Some some = (Some)option;
            RexProgram program = (RexProgram)some.value();
            ArrayBuffer keyPairs = new ArrayBuffer();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])joinPairs)).map((Function1 & Serializable & scala.Serializable)p -> {
                int calcSrcIdx = MODULE$.getIdenticalSourceField(program, p.target);
                if (calcSrcIdx != -1) {
                    return keyPairs.$plus$eq((Object)new IntPair(p.source, calcSrcIdx));
                }
                return BoxedUnit.UNIT;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            return (IntPair[])keyPairs.toArray(ClassTag$.MODULE$.apply(IntPair.class));
        }
        if (None$.MODULE$.equals(option)) {
            return joinPairs;
        }
        throw new MatchError(option);
    }

    /*
     * Unable to fully structure code
     */
    private int getIdenticalSourceField(RexProgram rexProgram, int outputOrdinal) {
        Predef$.MODULE$.assert(outputOrdinal >= 0 && outputOrdinal < rexProgram.getProjectList().size());
        project = rexProgram.getProjectList().get(outputOrdinal);
        index = project.getIndex();
        while (true) {
            expr = rexProgram.getExprList().get(index);
            var8_6 = false;
            var9_7 = null;
            var10_8 = expr;
            if (!(var10_8 instanceof RexCall)) ** GOTO lbl-1000
            var8_6 = true;
            var9_7 = (RexCall)var10_8;
            v0 = var9_7.getOperator();
            var11_9 = SqlStdOperatorTable.IN_FENNEL;
            if (!(v0 != null ? v0.equals(var11_9) == false : var11_9 != null)) {
                expr = var9_7.getOperands().get(0);
            } else if (var8_6) {
                v1 = var9_7.getOperator();
                var12_10 = SqlStdOperatorTable.CAST;
                if (!(v1 != null ? v1.equals(var12_10) == false : var12_10 != null)) {
                    outputType = var9_7.getType();
                    inputType = var9_7.getOperands().get(0).getType();
                    isCompatible = PlannerTypeUtils.isInteroperable((LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(outputType), (LogicalType)FlinkTypeFactory$.MODULE$.toLogicalType(inputType));
                    expr = isCompatible != false ? var9_7.getOperands().get(0) : expr;
                }
            }
            var16_14 = expr;
            if (!(var16_14 instanceof RexLocalRef)) break;
            var17_15 = (RexLocalRef)var16_14;
            index = var17_15.getIndex();
        }
        if (var16_14 instanceof RexInputRef) {
            var18_16 = (RexInputRef)var16_14;
            return var18_16.getIndex();
        }
        return -1;
    }

    public int extractInputRef(RexNode rexNode, String textualRepresentation) {
        InputRefVisitor inputReferenceVisitor = new InputRefVisitor();
        rexNode.accept(inputReferenceVisitor);
        Preconditions.checkState((inputReferenceVisitor.getFields().length == 1 ? 1 : 0) != 0, (String)"Failed to find input reference in [%s]", (Object[])new Object[]{textualRepresentation});
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(inputReferenceVisitor.getFields())).head());
    }

    public boolean satisfyTemporalJoin(FlinkLogicalJoin join) {
        return this.satisfyTemporalJoin(join, join.getLeft(), join.getRight());
    }

    public boolean satisfyTemporalJoin(FlinkLogicalJoin join, RelNode newLeft, RelNode newRight) {
        if (!this.containsTemporalJoinCondition(join.getCondition())) {
            return false;
        }
        JoinInfo joinInfo = JoinInfo.of(newLeft, newRight, join.getCondition());
        if (this.isTemporalFunctionJoin(join.getCluster().getRexBuilder(), joinInfo)) {
            JoinRelType joinRelType = join.getJoinType();
            return ((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType);
        }
        JoinRelType joinRelType = join.getJoinType();
        return ((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType) ? true : ((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType);
    }

    private TemporalJoinUtil$() {
        MODULE$ = this;
        this.TEMPORAL_JOIN_CONDITION = new SqlFunction("__TEMPORAL_JOIN_CONDITION", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.or(OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, PRIMARY_KEY, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, PRIMARY_KEY, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, PRIMARY_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.SYSTEM);
        this.INITIAL_TEMPORAL_JOIN_CONDITION = new SqlFunction("__INITIAL_TEMPORAL_JOIN_CONDITION", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.or(OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, RIGHT_TIME_ATTRIBUTE, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY), OperandTypes.sequence("'(LEFT_TIME_ATTRIBUTE, LEFT_KEY, RIGHT_KEY)'", OperandTypes.DATETIME, OperandTypes.ANY, OperandTypes.ANY)), SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_LEFT_KEY = new SqlFunction("__TEMPORAL_JOIN_LEFT_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_RIGHT_KEY = new SqlFunction("__TEMPORAL_JOIN_RIGHT_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
        this.TEMPORAL_JOIN_CONDITION_PRIMARY_KEY = new SqlFunction("__TEMPORAL_JOIN_CONDITION_PRIMARY_KEY", SqlKind.OTHER_FUNCTION, ReturnTypes.BOOLEAN_NOT_NULL, null, OperandTypes.ARRAY, SqlFunctionCategory.SYSTEM);
    }
}

