/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.datastream.AsyncDataStream;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.VectorSearchRuntimeConfigOptions;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.VectorSearchTableSource;
import org.apache.flink.table.connector.source.search.AsyncVectorSearchFunctionProvider;
import org.apache.flink.table.connector.source.search.VectorSearchFunctionProvider;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.utils.FunctionCallUtil;

public class VectorSearchUtil
extends FunctionCallUtil {
    public static boolean isAsyncVectorSearch(TableSourceTable searchTable, Map<String, String> runtimeConfig, Collection<Integer> searchColumns) {
        Configuration queryConf = Configuration.fromMap(runtimeConfig);
        boolean syncFound = false;
        boolean asyncFound = false;
        VectorSearchTableSource.VectorSearchRuntimeProvider provider = VectorSearchUtil.createVectorSearchRuntimeProvider(searchTable, searchColumns, (ReadableConfig)queryConf);
        if (provider instanceof AsyncVectorSearchFunctionProvider) {
            asyncFound = true;
        }
        if (provider instanceof VectorSearchFunctionProvider) {
            syncFound = true;
        }
        if (!asyncFound && !syncFound) {
            throw new TableException(String.format("Can not find valid implementation for search function for table %s.", searchTable.contextResolvedTable().getIdentifier().asSummaryString()));
        }
        Optional requiredMode = queryConf.getOptional(VectorSearchRuntimeConfigOptions.ASYNC);
        if (!requiredMode.isPresent()) {
            return asyncFound;
        }
        if (((Boolean)requiredMode.get()).booleanValue()) {
            if (!asyncFound) {
                throw new TableException(String.format("Require async mode, but vector search provider %s doesn't support async mode.", provider.getClass().getName()));
            }
            return true;
        }
        if (!syncFound) {
            throw new TableException(String.format("Require sync mode, but vector search provider %s doesn't support sync mode.", provider.getClass().getName()));
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static VectorSearchTableSource.VectorSearchRuntimeProvider createVectorSearchRuntimeProvider(TableSourceTable searchTable, Collection<Integer> searchColumns, ReadableConfig runtimeConfig) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static FunctionCallUtil.AsyncOptions getMergedVectorSearchAsyncOptions(Map<String, String> runtimeConfig, TableConfig config, ChangelogMode inputChangelogMode) {
        Configuration queryConf = Configuration.fromMap(runtimeConfig);
        int asyncBufferCapacity = VectorSearchUtil.coalesce((Integer)queryConf.get(VectorSearchRuntimeConfigOptions.ASYNC_MAX_CONCURRENT_OPERATIONS), (Integer)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_VECTOR_SEARCH_MAX_CONCURRENT_OPERATIONS));
        long asyncTimeout = VectorSearchUtil.coalesce((Duration)queryConf.get(VectorSearchRuntimeConfigOptions.ASYNC_TIMEOUT), (Duration)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_VECTOR_SEARCH_TIMEOUT)).toMillis();
        AsyncDataStream.OutputMode asyncOutputMode = VectorSearchUtil.convert(inputChangelogMode, VectorSearchUtil.coalesce((ExecutionConfigOptions.AsyncOutputMode)queryConf.get(VectorSearchRuntimeConfigOptions.ASYNC_OUTPUT_MODE), (ExecutionConfigOptions.AsyncOutputMode)config.get(ExecutionConfigOptions.TABLE_EXEC_ASYNC_VECTOR_SEARCH_OUTPUT_MODE)));
        return new FunctionCallUtil.AsyncOptions(asyncBufferCapacity, asyncTimeout, false, asyncOutputMode);
    }

    private static /* synthetic */ int[][] lambda$createVectorSearchRuntimeProvider$1(int x$0) {
        return new int[x$0][];
    }
}

