/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.utils;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.BatchShuffleMode;
import org.apache.flink.configuration.ExecutionOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.graph.GlobalStreamExchangeMode;
import org.apache.flink.streaming.api.transformations.StreamExchangeMode;

@Internal
public class StreamExchangeModeUtils {
    static final String ALL_EDGES_BLOCKING_LEGACY = "batch";
    static final String ALL_EDGES_PIPELINED_LEGACY = "pipelined";

    public static StreamExchangeMode getBatchStreamExchangeMode(ReadableConfig config, StreamExchangeMode requiredExchangeMode) {
        if (requiredExchangeMode == StreamExchangeMode.BATCH) {
            return StreamExchangeMode.BATCH;
        }
        BatchShuffleMode shuffleMode = (BatchShuffleMode)config.get(ExecutionOptions.BATCH_SHUFFLE_MODE);
        if (shuffleMode == BatchShuffleMode.ALL_EXCHANGES_BLOCKING) {
            return StreamExchangeMode.BATCH;
        }
        if (shuffleMode == BatchShuffleMode.ALL_EXCHANGES_HYBRID_FULL) {
            return StreamExchangeMode.HYBRID_FULL;
        }
        if (shuffleMode == BatchShuffleMode.ALL_EXCHANGES_HYBRID_SELECTIVE) {
            return StreamExchangeMode.HYBRID_SELECTIVE;
        }
        return StreamExchangeMode.UNDEFINED;
    }

    private static String convertLegacyShuffleMode(String shuffleMode) {
        switch (shuffleMode.toLowerCase()) {
            case "batch": {
                return GlobalStreamExchangeMode.ALL_EDGES_BLOCKING.toString();
            }
            case "pipelined": {
                return GlobalStreamExchangeMode.ALL_EDGES_PIPELINED.toString();
            }
        }
        return shuffleMode;
    }
}

