/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.sink.writer;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.sink.writer.Batch;
import org.apache.flink.connector.base.sink.writer.BatchCreator;
import org.apache.flink.connector.base.sink.writer.RequestBuffer;
import org.apache.flink.connector.base.sink.writer.RequestEntryWrapper;
import org.apache.flink.connector.base.sink.writer.strategy.RequestInfo;
import org.apache.flink.util.Preconditions;

@Internal
public class SimpleBatchCreator<RequestEntryT extends Serializable>
implements BatchCreator<RequestEntryT> {
    private final long maxBatchSizeInBytes;

    public SimpleBatchCreator(long maxBatchSizeInBytes) {
        Preconditions.checkArgument((maxBatchSizeInBytes > 0L ? 1 : 0) != 0);
        this.maxBatchSizeInBytes = maxBatchSizeInBytes;
    }

    @Override
    public Batch<RequestEntryT> createNextBatch(RequestInfo requestInfo, RequestBuffer<RequestEntryT> bufferedRequestEntries) {
        RequestEntryWrapper<RequestEntryT> peekedEntry;
        long requestEntrySize;
        ArrayList<Serializable> batch = new ArrayList<Serializable>(requestInfo.getBatchSize());
        long batchSizeBytes = 0L;
        for (int i = 0; i < requestInfo.getBatchSize() && !bufferedRequestEntries.isEmpty() && batchSizeBytes + (requestEntrySize = (peekedEntry = bufferedRequestEntries.peek()).getSize()) <= this.maxBatchSizeInBytes; ++i) {
            RequestEntryWrapper<RequestEntryT> elem = bufferedRequestEntries.poll();
            batch.add((Serializable)elem.getRequestEntry());
            batchSizeBytes += requestEntrySize;
        }
        return new Batch(batch, batchSizeBytes);
    }
}

