/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.Sample;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.SampledStatistic;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.StatisticType;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.statistics.ValueStatistic;

public class SampledStatisticAdapter<T extends Serializable>
implements SampledStatistic<T> {
    private final LongSupplier timeSource;
    private final ValueStatistic<T> statistic;

    private SampledStatisticAdapter(ValueStatistic<T> statistic, LongSupplier timeSource) {
        this.statistic = Objects.requireNonNull(statistic);
        this.timeSource = Objects.requireNonNull(timeSource);
    }

    @Override
    public T value() {
        return this.statistic.value();
    }

    @Override
    public List<Sample<T>> history() {
        return Collections.singletonList(new Sample<T>(this.timeSource.getAsLong(), this.statistic.value()));
    }

    @Override
    public List<Sample<T>> history(long since) {
        long now = this.timeSource.getAsLong();
        return since <= now ? Collections.singletonList(new Sample<T>(now, this.statistic.value())) : Collections.emptyList();
    }

    @Override
    public StatisticType type() {
        return this.statistic.type();
    }

    public static <T extends Serializable> SampledStatistic<T> sample(ValueStatistic<T> accessor, LongSupplier timeSource) {
        return new SampledStatisticAdapter<T>(accessor, timeSource);
    }
}

